<?php
if (!function_exists('savalog_typography_customizer_register')) {
    function savalog_typography_customizer_register($wp_customize)
    {
        get_template_part('/inc/customize/class/customizer');
        $customizer = new BHR_Customizer($wp_customize);

        $customizer->AddSection('savalog_typography', __('Typography', 'savalog'), 'savalog_settings_pannel');

        $customizer->AddSetting(
            array(
                'id' => 'savalog_google_font_url',
                'title' => __('Google Font URL', 'savalog'),
                'description' => sprintf(
                    '%1$s <a href="%2$s" target="_blank">%3$s</a> %4$s The url will be like "https://fonts.googleapis.com/css2?family=Josefin+Sans:ital,wght@0,100..700;1,100..700&display=swap". Copy url from google and past it in here.',
                    __('Insert', 'savalog'),
                    esc_url('https://www.google.com/fonts'),
                    __('Google Font URL', 'savalog'),
                    __('for embed fonts.', 'savalog')
                ),
                'section_id' => 'savalog_typography'
            ),
            BHR_Customizer::$TEXT
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_google_font_family',
                'title' => __('Font Family', 'savalog'),
                'description' => __('Insert Google font family. The font family should be like <strong>Lato, sans-serif</strong> without \' or ".', 'savalog'),
                'section_id' => 'savalog_typography'
            ),
            BHR_Customizer::$TEXT
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_google_font_size',
                'default' => '14',
                'title' => __('Font Size', 'savalog'),
                'description' => __('Change font size of the content text to increase better user experience.', 'savalog'),
                'section_id' => 'savalog_typography'
            ),
            BHR_Customizer::$NUMBER
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_google_font_header_url',
                'title' => __('Google Font Header URL', 'savalog'),
                'description' => sprintf(
                '%1$s <a href="%2$s" target="_blank">%3$s</a> %4$s The url will be like "https://fonts.googleapis.com/css2?family=Josefin+Sans:ital,wght@0,100..700;1,100..700&display=swap". Copy url from google and past it in here.',
                __('Insert', 'savalog'),
                esc_url('https://www.google.com/fonts'),
                __('Google Font URL', 'savalog'),
                __('for header (content titles) fonts.', 'savalog')
            ),
                'section_id' => 'savalog_typography'
            ),
            BHR_Customizer::$TEXT
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_google_font_header_family',
                'title' => __('Font Family', 'savalog'),
                'description' => __('Insert Google font family for headers. The font family should be like <strong>Courgette, cursive</strong> without \' or ".', 'savalog'),
                'section_id' => 'savalog_typography'
            ),
            BHR_Customizer::$TEXT
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_text_font_size',
                'default' => '16',
                'title' => __('Text Font Size (px)', 'savalog'),
                'description' => __('Change body text font size of the content.', 'savalog'),
                'section_id' => 'savalog_typography'
            ),
            BHR_Customizer::$NUMBER
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_h1_font_size',
                'default' => '36',
                'title' => __('H1 Font Size (px)', 'savalog'),
                'description' => __('Change H1 font size of the content.', 'savalog'),
                'section_id' => 'savalog_typography'
            ),
            BHR_Customizer::$NUMBER
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_h2_font_size',
                'default' => '32',
                'title' => __('H2 Font Size (px)', 'savalog'),
                'description' => __('Change H2 font size of the content.', 'savalog'),
                'section_id' => 'savalog_typography'
            ),
            BHR_Customizer::$NUMBER
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_h3_font_size',
                'default' => '28',
                'title' => __('H3 Font Size (px)', 'savalog'),
                'description' => __('Change H3 font size of the content.', 'savalog'),
                'section_id' => 'savalog_typography'
            ),
            BHR_Customizer::$NUMBER
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_h4_font_size',
                'default' => '25',
                'title' => __('H4 Font Size (px)', 'savalog'),
                'description' => __('Change H4 font size of the content.', 'savalog'),
                'section_id' => 'savalog_typography'
            ),
            BHR_Customizer::$NUMBER
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_h5_font_size',
                'default' => '21',
                'title' => __('H5 Font Size (px)', 'savalog'),
                'description' => __('Change H5 font size of the content.', 'savalog'),
                'section_id' => 'savalog_typography'
            ),
            BHR_Customizer::$NUMBER
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_h6_font_size',
                'default' => '17',
                'title' => __('H6 Font Size (px)', 'savalog'),
                'description' => __('Change H6 font size of the content.', 'savalog'),
                'section_id' => 'savalog_typography'
            ),
            BHR_Customizer::$NUMBER
        );
    }

    add_action('customize_register', 'savalog_typography_customizer_register');
}

if (!function_exists('savalog_typography_customizer_css')) {
    function savalog_typography_customizer_css()
    {
        $text_font_family = get_theme_mod('savalog_google_font_family', 'Roboto, sans-serif');
        if (empty($text_font_family)) {
            $text_font_family = 'Roboto, sans-serif';
        }
        $header_font_family = get_theme_mod('savalog_google_font_header_family', 'Roboto, sans-serif');
        if (empty($header_font_family)) {
            $header_font_family = 'Roboto, cursive';
        }
?>
        <style type="text/css">
            :root {
                --savalog-text-font-family: <?php echo esc_attr($text_font_family); ?>;
                --savalog-header-font-family: <?php echo esc_attr($header_font_family); ?>;
                --savalog-text-font-size: <?php echo esc_attr(get_theme_mod('savalog_text_font_size', '16')); ?>px;
                --savalog-h1-font-size: <?php echo esc_attr(get_theme_mod('savalog_h1_font_size', '36')); ?>px;
                --savalog-h2-font-size: <?php echo esc_attr(get_theme_mod('savalog_h2_font_size', '32')); ?>px;
                --savalog-h3-font-size: <?php echo esc_attr(get_theme_mod('savalog_h3_font_size', '28')); ?>px;
                --savalog-h4-font-size: <?php echo esc_attr(get_theme_mod('savalog_h4_font_size', '25')); ?>px;
                --savalog-h5-font-size: <?php echo esc_attr(get_theme_mod('savalog_h5_font_size', '21')); ?>px;
                --savalog-h6-font-size: <?php echo esc_attr(get_theme_mod('savalog_h6_font_size', '17')); ?>px;
            }

            body{
                font-size: <?php echo esc_attr(get_theme_mod('savalog_text_font_size', '16')); ?>px;
            }

            h1{
                font-size: <?php echo esc_attr(get_theme_mod('savalog_h1_font_size', '36')); ?>px;
            }

            h2{
                font-size: <?php echo esc_attr(get_theme_mod('savalog_h2_font_size', '32')); ?>px;
            }

            h3{
                font-size: <?php echo esc_attr(get_theme_mod('savalog_h3_font_size', '28')); ?>px;
            }

            h4{
                font-size: <?php echo esc_attr(get_theme_mod('savalog_h4_font_size', '25')); ?>px;
            }

            h5{
                font-size: <?php echo esc_attr(get_theme_mod('savalog_h5_font_size', '21')); ?>px;
            }

            h6{
                font-size: <?php echo esc_attr(get_theme_mod('savalog_h6_font_size', '17')); ?>px;
            }
        </style>
<?php
    }

    add_action('wp_head', 'savalog_typography_customizer_css');
}
