<?php
if (!function_exists('savalog_sidebar_customizer_register')) {
    function savalog_sidebar_customizer_register($wp_customize)
    {
        get_template_part('/inc/customize/class/customizer');
        $customizer = new BHR_Customizer($wp_customize);

        $customizer->AddSection('savalog_sidebar', __('Sidebar', 'savalog'), 'savalog_settings_pannel');

        $customizer->AddSetting(
            array(
                'id' => 'savalog_sticky_sidebar',
                'default' => 'yes',
                'title' => __('Sticky Sidebar', 'savalog'),
                'section_id' => 'savalog_sidebar',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_right_sidebar_display',
                'default' => 'yes',
                'title' => __('Right Sidebar', 'savalog'),
                'section_id' => 'savalog_sidebar',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_left_sidebar_display',
                'default' => 'yes',
                'title' => __('Left Sidebar', 'savalog'),
                'section_id' => 'savalog_sidebar',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_post_right_sidebar_display',
                'default' => 'yes',
                'title' => __('Post Right Sidebar', 'savalog'),
                'section_id' => 'savalog_sidebar',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_post_left_sidebar_display',
                'default' => 'yes',
                'title' => __('Post Left Sidebar', 'savalog'),
                'section_id' => 'savalog_sidebar',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_page_right_sidebar_display',
                'default' => 'yes',
                'title' => __('Page Right Sidebar', 'savalog'),
                'section_id' => 'savalog_sidebar',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_page_left_sidebar_display',
                'default' => 'yes',
                'title' => __('Page Left Sidebar', 'savalog'),
                'section_id' => 'savalog_sidebar',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );
    }

    add_action('customize_register', 'savalog_sidebar_customizer_register');
}

if (!function_exists('savalog_sidebar_customizer_css')) {
    function savalog_sidebar_customizer_css()
    {
?>
        <style type="text/css">
            <?php if (esc_attr(get_theme_mod('savalog_sticky_sidebar', 'yes') == 'yes')) : ?>@media (min-width: 768px) {
                .honrix-content .sidebar {
                    --offset: 2rem;
                    flex-grow: 1;
                    flex-basis: 300px;
                    align-self: start;
                    position: sticky;
                    top: var(--offset);
                }
            }

            <?php endif; ?>
        </style>
<?php
    }

    add_action('wp_head', 'savalog_sidebar_customizer_css');
}
