<?php
if (!function_exists('savalog_copy_right_customizer_register')) {
    function savalog_copy_right_customizer_register($wp_customize)
    {
        get_template_part('/inc/customize/class/customizer');
        $customizer = new BHR_Customizer($wp_customize);

        $customizer->AddSection('savalog_copy_right', __('Copyright', 'savalog'), 'savalog_settings_pannel');

        $customizer->AddSetting(
            array(
                'id' => 'savalog_copy_right_display',
                'default' => 'yes',
                'title' => __('Copyright', 'savalog'),
                'description' => __('Hide or display website copy right section.', 'savalog'),
                'section_id' => 'savalog_copy_right',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_copy_right_bg_color',
                'default' => '#333333',
                'title' => __('Background Color', 'savalog'),
                'description' => __('Change footer background color.', 'savalog'),
                'section_id' => 'savalog_copy_right'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_copy_right_text_color',
                'default' => '#cccccc',
                'title' => __('Text Color', 'savalog'),
                'section_id' => 'savalog_copy_right'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_copy_right_link_color',
                'default' => '#ffffff',
                'title' => __('Link Color', 'savalog'),
                'description' => __('Change copy right section links color.', 'savalog'),
                'section_id' => 'savalog_copy_right'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_copy_right_link_hover_color',
                'default' => '#cccccc',
                'title' => __('Link Hover Color', 'savalog'),
                'section_id' => 'savalog_copy_right'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_copyright_text',
                'default' => '© {year} {site_name}',
                'title' => __('Copyright Text', 'savalog'),
                'description' => __( 'Add text and HTML code to display in Copyright section. Add "{site_name}" to display website name, "{description}" to display website description or "{year}" to display current year.', 'savalog' ),
                'section_id' => 'savalog_copy_right'
            ),
            BHR_Customizer::$TEXTAREA
        );
    }

    add_action('customize_register', 'savalog_copy_right_customizer_register');
}

if (!function_exists('savalog_copy_right_customizer_css')) {
    function savalog_copy_right_customizer_css()
    {
?>
        <style type="text/css">
            .site-copyright {
                background: <?php echo esc_attr(get_theme_mod('savalog_copy_right_bg_color', '#333333')); ?> !important;
                color:<?php echo esc_attr(get_theme_mod('savalog_copy_right_text_color', '#cccccc')); ?> !important;
            }

            .site-copyright a{
                color:<?php echo esc_attr(get_theme_mod('savalog_copy_right_link_color', '#ffffff')); ?> !important;
            }

            .site-copyright a:hover{
                color:<?php echo esc_attr(get_theme_mod('savalog_copy_right_link_hover_color', '#cccccc')); ?> !important;
            }
        </style>
<?php
    }

    add_action('wp_head', 'savalog_copy_right_customizer_css');
}
