<?php

/**
 * The template for displaying the footer
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package savalog
 */
?>

</main>
<?php
$is_footer_active = false;
for ($counter = 1; $counter <= get_theme_mod('savalog_footer_columns', '3'); $counter++) {
    if (is_active_sidebar('footer' . $counter)) {
        $is_footer_active = true;
    }
} ?>
<?php if (esc_attr(get_theme_mod('savalog_footer_display', 'yes') == 'yes')) : ?>
    <footer class="site-footer">
        <?php
        if ($is_footer_active) : ?>
            <div class="inner-footer <?php echo esc_attr(get_theme_mod('savalog_boxed', 'boxed')) == 'boxed' ? 'container' : 'container-fluid'; ?> column-<?php echo esc_attr(get_theme_mod('savalog_footer_columns', '3')); ?> py-5">

                <?php for ($counter = 1; $counter <= get_theme_mod('savalog_footer_columns', '3'); $counter++) : ?>
                    <div class="footer w-100 pb-3">
                        <?php if (is_active_sidebar('footer' . $counter)) : ?>
                            <?php dynamic_sidebar('footer' . $counter); ?>
                        <?php endif; ?>
                    </div>
                <?php endfor; ?>

            </div>
        <?php endif; ?>
    </footer>
<?php endif; ?>
<?php if (esc_attr(get_theme_mod('savalog_copy_right_display', 'yes') == 'yes')) : ?>
    <div class="site-copyright py-2">
        <div class="<?php echo esc_attr(get_theme_mod('savalog_boxed', 'boxed')) == 'boxed' ? 'container' : 'container-fluid'; ?>">
            <div class="row inner-copyright savalog-flex flex-2 savalog-center">
                <?php
                $copyright = get_theme_mod('savalog_copyright_text', '© {year} {site_name}');
                if (!empty($copyright)) :
                ?>
                    <div class="copyright col-6">
                        <?php
                        $copyright = str_replace("{year}", date("Y"), $copyright);
                        $copyright = str_replace("{site_name}", get_bloginfo('name'), $copyright);
                        $copyright = str_replace("{description}", get_bloginfo('description'), $copyright);

                        echo wp_kses_post($copyright);
                        ?>
                    </div>
                <?php endif; ?>

                <?php if (is_active_sidebar('copyright_widgets')) : ?>
                    <div class="col-6 d-flex justify-content-center justify-content-md-end">
                        <?php dynamic_sidebar('copyright_widgets'); ?>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
<?php endif; ?>

<?php if (get_theme_mod('savalog_to_top', 'yes') == 'yes') : ?>
    <button class='to-top savalog-arrow savalog-is-pc' onclick='window.scrollTo({top: 0, behavior: "smooth"});'>
        <span class='fas fa-arrow-up'></span>
    </button>
<?php endif; ?>
</div>
<?php wp_footer(); ?>

</body>

</html>