<?php
/*
 * Template for displaying comments for posts
 *
 * package savalog
 */

if (!defined('ABSPATH')) {
    exit;
}
?>
<?php
if (post_password_required()) {
    return;
}
?>

<div id="comments" class="comments-area">
    <?php
    $comment_args = array(
        'title_reply' => esc_html__('Leave a reply', 'savalog'),
        'fields' => apply_filters('comment_form_default_fields', array(
            'author' => '<div class="comment-form-info"><p class="comment-form-author">' .
                '<input id="author" name="author" class="border p-2 w-100" placeholder="' . esc_html__('Name', 'savalog') . ($req ? ' *' : '') . '" type="text" value="' . esc_attr($commenter['comment_author']) . '" size="30" /></p>',
            'email' => '<p class="comment-form-email">' .
                '<input id="email" name="email" class="border p-2 w-100" placeholder="' . esc_html__('Email', 'savalog') . ($req ? ' *' : '') . '" type="text" value="' . esc_attr($commenter['comment_author_email']) . '" size="30" />' . '</p></div>',
            'url' => ''
        )),
        'comment_field' => '<p class="comment-form-comment">' .
            '<textarea id="comment" placeholder="' . esc_html__('Write a Comment', 'savalog') . ' *" name="comment" cols="45" aria-required="true" class="border p-2 w-100"></textarea>' .
            '</p>',
        'comment_notes_after' => '',
        'comment_notes_before' => '',
    );
    comment_form($comment_args);
    ?>
    <?php if (have_comments()) { ?>
        <h3 class="comments-title position-relative text-capitalize d-flex text-center align-items-center m-0 mb-3 mt-5 fs-5">
            <?php esc_html_e("Comments", 'savalog') ?>
        </h3>

        <ul class="comment-list list-unstyled p-0">
            <?php
            wp_list_comments(
                array(
                    'short_ping' => true,
                    'avatar_size' => 50,
                    'callback' => 'savalog_custom_comment_list'
                )
            );
            ?>
        </ul>

        <?php if (get_comment_pages_count() > 1): ?>
            <div class="comment-pagination">
                <?php paginate_comments_links(array('prev_text' => __('<i class="fas fa-angle-left"></i>', 'savalog'), 'next_text' => __('<i class="fas fa-angle-right"></i>', 'savalog'))); ?>
            </div>
        <?php endif; ?>
    <?php }
    ?>

</div>