(function ($) {
  "use strict";

  // Spinner
  var spinner = function () {
    setTimeout(function () {
      if ($("#spinner").length > 0) {
        $("#spinner").removeClass("show");
      }
    }, 1);
  };
  spinner();

  $(".honrix-gallery-slider").addClass("owl-carousel owl-theme");
  $(".honrix-gallery-slider").owlCarousel({
    autoplay: 4000,
    autoplayTimeout: 4000,
    smartSpeed: 250,
    nav: true,
    navText: [
      '<i class="fas fa-chevron-left"></i>',
      '<i class="fas fa-chevron-right"></i>',
    ],
    dots: false,
    loop: true,
    lazyLoad: true,
    center: true,
    responsive: {
      0: {
        items: 1,
      },
      576: {
        items: 1,
      },
      768: {
        items: 1,
      },
      992: {
        items: 1,
      },
    },
  });

  $(".honrix-gallery-slider").trigger("refresh.owl.carousel");

  // if ($(".honrix-entries.posts").hasClass("savalog-masonry")) {
  //   var msnry = new Masonry(".honrix-entries.posts");
  //   msnry.layout();
  // }

  $(".hrix-navbar-toggler").on("click", function (e) {
    if ($(".hrix-mobile-navigation-menu").hasClass("show-menu")) {
      $(".hrix-mobile-navigation-menu").removeClass("show-menu");
    } else {
      $(".hrix-mobile-navigation-menu").addClass("show-menu");
    }
  });

  //mobile menu & category section close
  $(".hrix-mobile-navigation-menu span.close").on("click", function (e) {
    $(".hrix-mobile-navigation-menu").removeClass("show-menu");
  });

  $(".hrix-mobile-navigation-menu span.close").on("keyup", function (e) {
    if (e.key === "Enter" || e.keyCode === 13) {
      $(".hrix-mobile-navigation-menu").removeClass("show-menu");
    }
  });

  //search box
  $(".hrix-header-search-select").on("click", function (e) {
    if ($(".hrix-header-search-form .search-box").hasClass("show")) {
      $(".hrix-header-search-form .search-box").removeClass("show");
    } else {
      $(".hrix-header-search-form .search-box").addClass("show");
    }
  });

  $(".hrix-header-search-select").on("keyup", function (e) {
    if (e.key === "Enter" || e.keyCode === 13) {
      if ($(".hrix-header-search-form .search-box").hasClass("show")) {
        $(".hrix-header-search-form .search-box").removeClass("show");
      } else {
        $(".hrix-header-search-form .search-box").addClass("show");
      }
    }
  });

  $(".hrix-header-search-form .search-box span.close").on(
    "click",
    function (e) {
      $(".hrix-header-search-form .search-box").removeClass("show");
    }
  );

  $(".hrix-header-search-form .search-box span.close").on(
    "keyup",
    function (e) {
      if (e.key === "Enter" || e.keyCode === 13) {
        $(".hrix-header-search-form .search-box").removeClass("show");
      }
    }
  );

  $(".hrix-header-popup-search-icon").click(function () {
    $(".hrix-header-popup-search-form").addClass("show");
  });

  $(".hrix-header-popup-search-icon").on("keyup", function (e) {
    if (e.key === "Enter" || e.keyCode === 13) {
      $(".hrix-header-popup-search-form").addClass("show");
    }
  });

  $(".hrix-header-popup-search-form .close").click(function () {
    $(".hrix-header-popup-search-form").removeClass("show");
  });

  $(".hrix-header-popup-search-form .close").on("keyup", function (e) {
    if (e.key === "Enter" || e.keyCode === 13) {
      $(".hrix-header-popup-search-form").removeClass("show");
    }
  });

  // Dropdown on mouse hover
  const $dropdown = $(".dropdown");
  const $dropdownToggle = $(".dropdown-toggle");
  const $dropdownMenu = $(".dropdown-menu");
  const showClass = "show";
  $(window).on("load resize", function () {
    if (this.matchMedia("(min-width: 992px)").matches) {
      $dropdown.hover(
        function () {
          const $this = $(this);
          $this.addClass(showClass);
          $this.find($dropdownToggle).first().attr("aria-expanded", "true");
          $this.find($dropdownMenu).first().addClass(showClass);
        },
        function () {
          const $this = $(this);
          $this.removeClass(showClass);
          $this.find($dropdownToggle).first().attr("aria-expanded", "false");
          $this.find($dropdownMenu).first().removeClass(showClass);
        }
      );
    } else if (this.matchMedia("(max-width: 991px)").matches) {
      $dropdownToggle.click(function (event) {
        event.preventDefault();
        const $this = $(this).parent();
        if ($this.find($dropdownMenu).first().hasClass(showClass)) {
          $this.removeClass(showClass);
          $this.find($dropdownToggle).first().attr("aria-expanded", "false");
          $this.find($dropdownMenu).first().removeClass(showClass);
        } else {
          $this.addClass(showClass);
          $this.find($dropdownToggle).first().attr("aria-expanded", "true");
          $this.find($dropdownMenu).first().addClass(showClass);
        }
      });
    } else {
      $dropdown.off("mouseenter mouseleave");
    }
  });
})(jQuery);

if (window.innerWidth < 1300) {
  window.onscroll = function (ev) {
    var to_top = document.querySelector(".to-top");
    if (to_top) {
      if (window.innerHeight + window.scrollY >= document.body.offsetHeight) {
        document.querySelector(".to-top").style.bottom =
          document.querySelector(".site-copyright").offsetHeight + 5 + "px";
      } else {
        document.querySelector(".to-top").style.bottom = "15px";
      }
    }
  };
}

var savalog_node = document.querySelector(".hrix-header-search-form .search-box");
if (savalog_node) {
  savalog_node.addEventListener("keydown", function (e) {
    var savalog_element = document.querySelector(".hrix-header-search-form .search-box");
    var savalog_focusableEls = savalog_element.querySelectorAll(
      'a[href]:not([disabled]), button:not([disabled]), textarea:not([disabled]), input[type="text"]:not([disabled]), input[type="radio"]:not([disabled]), input[type="checkbox"]:not([disabled]), select:not([disabled]), [tabindex]:not([tabindex="-1"]'
    );

    var savalog_firstFocusableEl = savalog_focusableEls[0];
    var savalog_lastFocusableEl =
      savalog_focusableEls[savalog_focusableEls.length - 1];
    if (e.key === "tap" || e.keyCode === 9) {
      if (e.shiftKey) {
        /* shift + tab */ if (
          document.activeElement === savalog_firstFocusableEl
        ) {
          savalog_lastFocusableEl.focus();
          e.preventDefault();
        }
      } /* tab */ else {
        if (document.activeElement === savalog_lastFocusableEl) {
          savalog_firstFocusableEl.focus();
          e.preventDefault();
        }
      }
    }
  });
}

var savalog_menu_node = document.querySelector(".hrix-mobile-navigation-menu");
if(savalog_menu_node){
  savalog_menu_node
  .addEventListener("keydown", function (e) {
    var focusableElsAll = savalog_menu_node.querySelectorAll(
      'a[href]:not([disabled]), button:not([disabled]), textarea:not([disabled]), input[type="text"]:not([disabled]), input[type="radio"]:not([disabled]), input[type="checkbox"]:not([disabled]), select:not([disabled]), [tabindex]:not([tabindex="-1"]'
    );

    var focusableEls = [];
    focusableElsAll.forEach(function (item) {
      if (
        savalog_menu_node.currentStyle
          ? savalog_menu_node.currentStyle.display !== "none"
          : getComputedStyle(item, null).display !== "none"
      ) {
        focusableEls = [...focusableEls, item];
      }
    });

    var firstFocusableEl = focusableEls[0];
    var lastFocusableEl = focusableEls[focusableEls.length - 1];
    if (e.key === "tap" || e.keyCode === 9) {
      if (e.shiftKey) {
        /* shift + tab */ if (document.activeElement === firstFocusableEl) {
          lastFocusableEl.focus();
          e.preventDefault();
        }
      } /* tab */ else {
        if (document.activeElement === lastFocusableEl) {
          firstFocusableEl.focus();
          e.preventDefault();
        }
      }
    }
  });
}
