<?php
/**
 * Rehab Center Theme Customizer
 *
 * @package Rehab Center
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function rehab_center_customize_register( $wp_customize ) {

	function rehab_center_sanitize_dropdown_pages( $page_id, $setting ) {
  		$page_id = absint( $page_id );
  		return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
	}

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

	wp_enqueue_style('rehab-center-customize-controls', trailingslashit(esc_url(get_template_directory_uri())).'/css/customize-controls.css');

	// Enable / Disable Logo
	$wp_customize->add_setting('rehab_center_logo_enable',array(
		'default' => true,
		'sanitize_callback' => 'rehab_center_sanitize_checkbox',
	));
	$wp_customize->add_control( 'rehab_center_logo_enable', array(
		'settings' => 'rehab_center_logo_enable',
		'section'   => 'title_tagline',
		'label'     => __('Enable Logo','rehab-center'),
		'type'      => 'checkbox'
	));

	//Logo
    $wp_customize->add_setting('rehab_center_logo_width', array(
        'default' => 200,
        'transport' => 'refresh',
        'sanitize_callback' => 'rehab_center_sanitize_integer'
    ));
    $wp_customize->add_control(new Rehab_Center_Slider_Custom_Control($wp_customize, 'rehab_center_logo_width', array(
    	'label'          => __( 'Logo Width', 'rehab-center'),
        'section' => 'title_tagline',
        'settings' => 'rehab_center_logo_width',
        'input_attrs' => array(
            'step' => 1,
            'min' => 0,
            'max' => 300,
        ),
    )));

	// color site title
	$wp_customize->add_setting('rehab_center_sitetitle_color',array(
		'default' => '',
		'sanitize_callback' => 'rehab_center_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));

	$wp_customize->add_control( 'rehab_center_sitetitle_color', array(
	   'settings' => 'rehab_center_sitetitle_color',
	   'section'   => 'title_tagline',
	   'label' => __('Site Title Color', 'rehab-center'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('rehab_center_title_enable',array(
		'default' => false,
		'sanitize_callback' => 'rehab_center_sanitize_checkbox',
	));
	$wp_customize->add_control( 'rehab_center_title_enable', array(
	   'settings' => 'rehab_center_title_enable',
	   'section'   => 'title_tagline',
	   'label'     => __('Enable Site Title','rehab-center'),
	   'type'      => 'checkbox'
	));

	// color site tagline
	$wp_customize->add_setting('rehab_center_sitetagline_color',array(
		'default' => '',
		'sanitize_callback' => 'rehab_center_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_sitetagline_color', array(
	   'settings' => 'rehab_center_sitetagline_color',
	   'section'   => 'title_tagline',
	   'label' => __('Site Tagline Color', 'rehab-center'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('rehab_center_tagline_enable',array(
		'default' => false,
		'sanitize_callback' => 'rehab_center_sanitize_checkbox',
	));
	$wp_customize->add_control( 'rehab_center_tagline_enable', array(
	   'settings' => 'rehab_center_tagline_enable',
	   'section'   => 'title_tagline',
	   'label'     => __('Enable Site Tagline','rehab-center'),
	   'type'      => 'checkbox'
	));

	// woocommerce section
	$wp_customize->add_section('rehab_center_woocommerce_page_settings', array(
		'title'    => __('WooCommerce Page Settings', 'rehab-center'),
		'priority' => null,
		'panel'    => 'woocommerce',
	));

	$wp_customize->add_setting('rehab_center_shop_page_sidebar',array(
		'default' => false,
		'sanitize_callback'	=> 'rehab_center_sanitize_checkbox'
	 ));
	 $wp_customize->add_control('rehab_center_shop_page_sidebar',array(
		'type' => 'checkbox',
		'label' => __(' Check To Enable Shop page sidebar','rehab-center'),
		'section' => 'rehab_center_woocommerce_page_settings',
	 ));

    // shop page sidebar alignment
    $wp_customize->add_setting('rehab_center_shop_page_sidebar_position', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'rehab_center_sanitize_choices',
	));
	$wp_customize->add_control('rehab_center_shop_page_sidebar_position',array(
		'type'           => 'radio',
		'label'          => __('Shop Page Sidebar', 'rehab-center'),
		'section'        => 'rehab_center_woocommerce_page_settings',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'rehab-center'),
			'Right Sidebar' => __('Right Sidebar', 'rehab-center'),
		),
	));	 

	$wp_customize->add_setting('rehab_center_wooproducts_nav',array(
		'default' => 'Yes',
		'sanitize_callback'	=> 'rehab_center_sanitize_choices'
	 ));
	 $wp_customize->add_control('rehab_center_wooproducts_nav',array(
		'type' => 'select',
		'label' => __('Shop Page Products Navigation','rehab-center'),
		'choices' => array(
			 'Yes' => __('Yes','rehab-center'),
			 'No' => __('No','rehab-center'),
		 ),
		'section' => 'rehab_center_woocommerce_page_settings',
	 ));

	 $wp_customize->add_setting( 'rehab_center_single_page_sidebar',array(
		'default' => false,
		'sanitize_callback'	=> 'rehab_center_sanitize_checkbox'
    ) );
    $wp_customize->add_control('rehab_center_single_page_sidebar',array(
    	'type' => 'checkbox',
       	'label' => __('Check To Enable Single Product Page Sidebar','rehab-center'),
		'section' => 'rehab_center_woocommerce_page_settings'
    ));

	// single product page sidebar alignment
    $wp_customize->add_setting('rehab_center_single_product_page_layout', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'rehab_center_sanitize_choices',
	));
	$wp_customize->add_control('rehab_center_single_product_page_layout',array(
		'type'           => 'radio',
		'label'          => __('Single product Page Sidebar', 'rehab-center'),
		'section'        => 'rehab_center_woocommerce_page_settings',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'rehab-center'),
			'Right Sidebar' => __('Right Sidebar', 'rehab-center'),
		),
	));

	$wp_customize->add_setting('rehab_center_related_product_enable',array(
		'default' => true,
		'sanitize_callback'	=> 'rehab_center_sanitize_checkbox'
	));
	$wp_customize->add_control('rehab_center_related_product_enable',array(
		'type' => 'checkbox',
		'label' => __('Check To Enable Related product','rehab-center'),
		'section' => 'rehab_center_woocommerce_page_settings',
	));

	$wp_customize->add_setting( 'rehab_center_woo_product_img_border_radius', array(
        'default'              => '0',
        'transport'            => 'refresh',
        'sanitize_callback'    => 'rehab_center_sanitize_integer'
    ) );
    $wp_customize->add_control(new Rehab_Center_Slider_Custom_Control( $wp_customize, 'rehab_center_woo_product_img_border_radius',array(
		'label'	=> esc_html__('Woo Product Img Border Radius','rehab-center'),
		'section'=> 'rehab_center_woocommerce_page_settings',
		'settings'=>'rehab_center_woo_product_img_border_radius',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 100,
        ),
	)));

	// Add a setting for number of products per row
    $wp_customize->add_setting('rehab_center_products_per_row', array(
	    'default'   => '4',
	    'transport' => 'refresh',
	    'sanitize_callback' => 'rehab_center_sanitize_integer'  
    ));

   	$wp_customize->add_control('rehab_center_products_per_row', array(
	   'label'    => __('Products Per Row', 'rehab-center'),
	   'section'  => 'rehab_center_woocommerce_page_settings',
	   'settings' => 'rehab_center_products_per_row',
	   'type'     => 'select',
	   'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
	  ),
   	) );
   
   	// Add a setting for the number of products per page
	$wp_customize->add_setting('rehab_center_products_per_page', array(
		'default'   => '8',
		'transport' => 'refresh',
		'sanitize_callback' => 'rehab_center_sanitize_integer'
	));

	$wp_customize->add_control('rehab_center_products_per_page', array(
		'label'    => __('Products Per Page', 'rehab-center'),
		'section'  => 'rehab_center_woocommerce_page_settings',
		'settings' => 'rehab_center_products_per_page',
		'type'     => 'number',
		'input_attrs' => array(
			'min'  => 1,
			'step' => 1,
		),
	));

	//Theme Options
	$wp_customize->add_panel( 'rehab_center_panel_area', array(
		'priority' => 10,
		'capability' => 'edit_theme_options',
		'title' => __( 'Theme Options Panel', 'rehab-center' ),
	) );

	//Site Layout Section
	$wp_customize->add_section('rehab_center_site_layoutsec',array(
		'title'	=> __('Manage Site Layout Section ','rehab-center'),
		'description' => __('<p class="sec-title">Manage Site Layout Section</p>','rehab-center'),
		'priority'	=> 1,
		'panel' => 'rehab_center_panel_area',
	));

	$wp_customize->add_setting('rehab_center_preloader',array(
		'default' => false,
		'sanitize_callback' => 'rehab_center_sanitize_checkbox',
	));
	$wp_customize->add_control( 'rehab_center_preloader', array(
	   'section'   => 'rehab_center_site_layoutsec',
	   'label'	=> __('Check to Show preloader','rehab-center'),
	   'type'      => 'checkbox'
 	));	

	$wp_customize->add_setting('rehab_center_preloader_bg_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'rehab_center_preloader_bg_image',array(
        'section' => 'rehab_center_site_layoutsec',
		'label' => __('Preloader Background Image','rehab-center'),
	)));

	$wp_customize->add_setting( 'rehab_center_theme_page_breadcrumb',array(
		'default' => false,
        'sanitize_callback'	=> 'rehab_center_sanitize_checkbox',
	) );
	$wp_customize->add_control('rehab_center_theme_page_breadcrumb',array(
       'section' => 'rehab_center_site_layoutsec',
	   'label' => __( 'Check To Enable Theme Page Breadcrumb','rehab-center' ),
	   'type' => 'checkbox'
    ));		

	$wp_customize->add_setting('rehab_center_box_layout',array(
		'default' => false,
		'sanitize_callback' => 'rehab_center_sanitize_checkbox',
	));
	$wp_customize->add_control( 'rehab_center_box_layout', array(
	   'section'   => 'rehab_center_site_layoutsec',
	   'label'	=> __('Check to Show Box Layout','rehab-center'),
	   'type'      => 'checkbox'
 	));

	// Add Settings and Controls for Page Layout
    $wp_customize->add_setting('rehab_center_sidebar_page_layout',array(
		'default' => 'full',
	 	'sanitize_callback' => 'rehab_center_sanitize_choices'
	));
	$wp_customize->add_control('rehab_center_sidebar_page_layout',array(
		'type' => 'radio',
		'label'     => __('Theme Page Sidebar Position', 'rehab-center'),
		'section' => 'rehab_center_site_layoutsec',
		'choices' => array(
			'full' => __('Full','rehab-center'),
			'left' => __('Left','rehab-center'),
			'right' => __('Right','rehab-center'),
		),
	));
	
	$wp_customize->add_setting( 'rehab_center_layout_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('rehab_center_layout_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(REHAB_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'rehab_center_site_layoutsec'
	));

	//Global Color
	$wp_customize->add_section('rehab_center_global_color', array(
		'title'    => __('Manage Global Color Section', 'rehab-center'),
		'panel'    => 'rehab_center_panel_area',
	));

	$wp_customize->add_setting('rehab_center_first_color', array(
		'default'           => '#9B562F',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'rehab_center_first_color', array(
		'label'    => __('Theme Color', 'rehab-center'),
		'section'  => 'rehab_center_global_color',
		'settings' => 'rehab_center_first_color',
	)));

	$wp_customize->add_setting('rehab_center_second_color', array(
		'default'           => '#6D4A4A',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'rehab_center_second_color', array(
		'label'    => __('Theme Color', 'rehab-center'),
		'section'  => 'rehab_center_global_color',
		'settings' => 'rehab_center_second_color',
	)));

	$wp_customize->add_setting( 'rehab_center_global_color_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('rehab_center_global_color_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(REHAB_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'rehab_center_global_color'
	));

	// Header Section
	$wp_customize->add_section('rehab_center_topbar_section',array(
	    'title' => __('Manage Header Section','rehab-center'),
	    'description' => __('<p class="sec-title">Manage Header Section</p>', 'rehab-center'),
	    'priority'  => null,
	    'panel' => 'rehab_center_panel_area',
	));	

	$wp_customize->add_setting('rehab_center_stickyheader',array(
		'default' => false,
		'sanitize_callback' => 'rehab_center_sanitize_checkbox',
	));
	$wp_customize->add_control( 'rehab_center_stickyheader', array(
	   'section'   => 'rehab_center_topbar_section',
	   'label'	=> __('Check To Show Sticky Header','rehab-center'),
	   'type'      => 'checkbox'
 	));

	$wp_customize->add_setting( 'rehab_center_topbar_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('rehab_center_topbar_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(REHAB_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'rehab_center_topbar_section'
	));

	// Banner Section
	$wp_customize->add_section('rehab_center_banner_section',array(
	    'title' => __('Manage Banner Section','rehab-center'),
	    'priority'  => null,
	    'description'	=> __('<p class="sec-title">Manage Banner Section</p> Select Page from the Dropdowns for banner, Also use the given image dimension (300 x 300).','rehab-center'),
	    'panel' => 'rehab_center_panel_area',
	));	

	$wp_customize->add_setting('rehab_center_banner',array(
		'default' => false,
		'sanitize_callback' => 'rehab_center_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_banner', array(
	   'settings' => 'rehab_center_banner',
	   'section'   => 'rehab_center_banner_section',
	   'label'     => __('Check To Enable This Section','rehab-center'),
	   'type'      => 'checkbox'
	));

	$wp_customize->add_setting('rehab_center_banner_posts', array(
        'default' => false,
        'sanitize_callback' => 'rehab_center_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'rehab_center_banner_posts',array(
        'label'          => __( 'Check To Show Posts', 'rehab-center' ),
        'section'        => 'rehab_center_banner_section',
        'settings'       => 'rehab_center_banner_posts',
        'type'           => 'checkbox',
    )));

	$rehab_center_categories = get_categories();
	$rehab_center_cat_post = array();
	$rehab_center_cat_post['0'] = 'Select';

	foreach ($rehab_center_categories as $rehab_center_category) {
	    $rehab_center_cat_post[$rehab_center_category->slug] = $rehab_center_category->name;
	}

	$wp_customize->add_setting('rehab_center_select_banner_post_category', array(
	    'default' => '0',
	    'sanitize_callback' => 'rehab_center_sanitize_choices',
	));
	$wp_customize->add_control('rehab_center_select_banner_post_category', array(
	    'type'    => 'select',
	    'choices' => $rehab_center_cat_post,
	    'label'   => __('Select Category to display Latest Post', 'rehab-center'),
	    'section' => 'rehab_center_banner_section',
	));
	
	$wp_customize->add_setting('rehab_center_banner_title', array(
	    'default'           => '',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('rehab_center_banner_title', array(
	    'settings' => 'rehab_center_banner_title',
	    'section'  => 'rehab_center_banner_section',
	    'label'    => __('Add Banner Title', 'rehab-center'),
	    'type'     => 'text',
	));
	
	$wp_customize->add_setting('rehab_center_banner_description', array(
	    'default'           => '',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('rehab_center_banner_description', array(
	    'settings' => 'rehab_center_banner_description',
	    'section'  => 'rehab_center_banner_section',
	    'label'    => __('Add Banner Text', 'rehab-center'),
	    'type'     => 'text',
	));

	$wp_customize->add_setting('rehab_center_banner_btn_text',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_banner_btn_text', array(
	   'settings' => 'rehab_center_banner_btn_text',
	   'section'   => 'rehab_center_banner_section',
	   'label' => __('Add Button Text', 'rehab-center'),
	   'type'      => 'text'
	));

	$wp_customize->add_setting('rehab_center_banner_btn_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_banner_btn_url', array(
	   'settings' => 'rehab_center_banner_btn_url',
	   'section'   => 'rehab_center_banner_section',
	   'label' => __('Add Button URL', 'rehab-center'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('rehab_center_banner_bottom_text', array(
	    'default'           => '',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('rehab_center_banner_bottom_text', array(
	    'settings' => 'rehab_center_banner_bottom_text',
	    'section'  => 'rehab_center_banner_section',
	    'label'    => __('Add Banner Bottom Text', 'rehab-center'),
	    'type'     => 'text',
	));

	$wp_customize->add_setting('rehab_center_linkedin_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_linkedin_url', array(
	   'settings' => 'rehab_center_linkedin_url',
	   'section'   => 'rehab_center_banner_section',
	   'label' => __('Add Linkedin URL', 'rehab-center'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('rehab_center_instagram_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_instagram_url', array(
	   'settings' => 'rehab_center_instagram_url',
	   'section'   => 'rehab_center_banner_section',
	   'label' => __('Add Instagram URL', 'rehab-center'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('rehab_center_facebook_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_facebook_url', array(
	   'settings' => 'rehab_center_facebook_url',
	   'section'   => 'rehab_center_banner_section',
	   'label' => __('Add Facebook URL', 'rehab-center'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('rehab_center_twitter_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_twitter_url', array(
	   'settings' => 'rehab_center_twitter_url',
	   'section'   => 'rehab_center_banner_section',
	   'label' => __('Add Twitter URL', 'rehab-center'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting( 'rehab_center_banner_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('rehab_center_banner_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(REHAB_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'rehab_center_banner_section'
	));

	// Treatment Programs Section
	$wp_customize->add_section('rehab_center_treatment_program_section', array(
	    'title'       => __('Manage Treatment Programs Section', 'rehab-center'),
	    'description' => __('<p class="sec-title">Manage Treatment Programs Section</p>', 'rehab-center'),
	    'priority'    => null,
	    'panel'       => 'rehab_center_panel_area',
	));

	$wp_customize->add_setting('rehab_center_disabled_treatment_program_section', array(
	    'default'           => false,
	    'sanitize_callback' => 'rehab_center_sanitize_checkbox',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('rehab_center_disabled_treatment_program_section', array(
	    'settings' => 'rehab_center_disabled_treatment_program_section',
	    'section'  => 'rehab_center_treatment_program_section',
	    'label'    => __('Check To Enable Section', 'rehab-center'),
	    'type'     => 'checkbox',
	));

	$wp_customize->add_setting('rehab_center_treatment_program_img',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'rehab_center_treatment_program_img',array(
	    'label' => __('Select Background Image','rehab-center'),
	    'description'	=> __('Use the given image dimension (1200px × 250px).','rehab-center'),
	    'section' => 'rehab_center_treatment_program_section'
	)));

	$wp_customize->add_setting('rehab_center_treatment_program_title', array(
	    'default'           => '',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('rehab_center_treatment_program_title', array(
	    'settings' => 'rehab_center_treatment_program_title',
	    'section'  => 'rehab_center_treatment_program_section',
	    'label'    => __('Add Section Title', 'rehab-center'),
	    'type'     => 'text',
	));

	for ($rehab_center_i = 1; $rehab_center_i <= 4; $rehab_center_i++) {
		
		$wp_customize->add_setting('rehab_center_treatment_program_icon'.$rehab_center_i,array(
	        'default'=> '',
	        'sanitize_callback' => 'sanitize_text_field'
	    ));
	    $wp_customize->add_control('rehab_center_treatment_program_icon'.$rehab_center_i,array(
	        'label' => __('Add Icon','rehab-center'),
	        'description' => __('Fontawesome Icon (e.g., fa-solid fa-people-arrows)','rehab-center'),
	        'section'=> 'rehab_center_treatment_program_section',
	        'type'=> 'text'
	    ));

		$wp_customize->add_setting('rehab_center_treatment_program_name'.$rehab_center_i, array(
		    'default'           => '',
		    'sanitize_callback' => 'sanitize_text_field',
		    'capability'        => 'edit_theme_options',
		));
		$wp_customize->add_control('rehab_center_treatment_program_name'.$rehab_center_i, array(
		    'settings' => 'rehab_center_treatment_program_name'.$rehab_center_i,
		    'section'  => 'rehab_center_treatment_program_section',
		    'label'    => __('Add Title', 'rehab-center'),
		    'type'     => 'text',
		));

		$wp_customize->add_setting('rehab_center_treatment_program_text'.$rehab_center_i, array(
		    'default'           => '',
		    'sanitize_callback' => 'sanitize_text_field',
		    'capability'        => 'edit_theme_options',
		));
		$wp_customize->add_control('rehab_center_treatment_program_text'.$rehab_center_i, array(
		    'settings' => 'rehab_center_treatment_program_text'.$rehab_center_i,
		    'section'  => 'rehab_center_treatment_program_section',
		    'label'    => __('Add Text', 'rehab-center'),
		    'type'     => 'text',
		));

		$wp_customize->add_setting('rehab_center_treatment_program_name_url'.$rehab_center_i,array(
			'default' => '',
			'sanitize_callback' => 'esc_url_raw',
			'capability' => 'edit_theme_options',
		));
		$wp_customize->add_control( 'rehab_center_treatment_program_name_url'.$rehab_center_i, array(
		   'settings' => 'rehab_center_treatment_program_name_url'.$rehab_center_i,
		   'section'   => 'rehab_center_treatment_program_section',
		   'label' => __('Add Link', 'rehab-center'),
		   'type'      => 'url'
		));
	}

	$wp_customize->add_setting( 'rehab_center_program_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('rehab_center_program_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(REHAB_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'rehab_center_treatment_program_section'
	));

	//Blog post
	$wp_customize->add_section('rehab_center_blog_post_settings',array(
        'title' => __('Manage Post Section', 'rehab-center'),
        'priority' => null,
        'panel' => 'rehab_center_panel_area'
    ) );

	$wp_customize->add_setting('rehab_center_metafields_date', array(
	    'default' => true,
	    'sanitize_callback' => 'rehab_center_sanitize_checkbox',
	));
	$wp_customize->add_control('rehab_center_metafields_date', array(
	    'settings' => 'rehab_center_metafields_date', 
	    'section'   => 'rehab_center_blog_post_settings',
	    'label'     => __('Check to Enable Date', 'rehab-center'),
	    'type'      => 'checkbox',
	));

	$wp_customize->add_setting('rehab_center_metafields_comments', array(
		'default' => true,
		'sanitize_callback' => 'rehab_center_sanitize_checkbox',
	));	
	$wp_customize->add_control('rehab_center_metafields_comments', array(
		'settings' => 'rehab_center_metafields_comments',
		'section'  => 'rehab_center_blog_post_settings',
		'label'    => __('Check to Enable Comments', 'rehab-center'),
		'type'     => 'checkbox',
	));

	$wp_customize->add_setting('rehab_center_metafields_author', array(
		'default' => true,
		'sanitize_callback' => 'rehab_center_sanitize_checkbox',
	));
	$wp_customize->add_control('rehab_center_metafields_author', array(
		'settings' => 'rehab_center_metafields_author',
		'section'  => 'rehab_center_blog_post_settings',
		'label'    => __('Check to Enable Author', 'rehab-center'),
		'type'     => 'checkbox',
	));		

	$wp_customize->add_setting('rehab_center_metafields_time', array(
		'default' => true,
		'sanitize_callback' => 'rehab_center_sanitize_checkbox',
	));
	$wp_customize->add_control('rehab_center_metafields_time', array(
		'settings' => 'rehab_center_metafields_time',
		'section'  => 'rehab_center_blog_post_settings',
		'label'    => __('Check to Enable Time', 'rehab-center'),
		'type'     => 'checkbox',
	));	

	$wp_customize->add_setting('rehab_center_metabox_seperator',array(
		'default' => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('rehab_center_metabox_seperator',array(
		'type' => 'text',
		'label' => __('Metabox Seperator','rehab-center'),
		'description' => __('Ex: "/", "|", "-", ...','rehab-center'),
		'section' => 'rehab_center_blog_post_settings'
	)); 

    // Add Settings and Controls for Post Layout
	$wp_customize->add_setting('rehab_center_sidebar_post_layout',array(
		'default' => 'right',
		'sanitize_callback' => 'rehab_center_sanitize_choices'
	));
	$wp_customize->add_control('rehab_center_sidebar_post_layout',array(
		'type' => 'radio',
		'label'     => __('Theme Post Sidebar Position', 'rehab-center'),
		'description'   => __('This option work for blog page, archive page and search page.', 'rehab-center'),
		'section' => 'rehab_center_blog_post_settings',
		'choices' => array(
			'full' => __('Full','rehab-center'),
			'left' => __('Left','rehab-center'),
			'right' => __('Right','rehab-center'),
			'three-column' => __('Three Columns','rehab-center'),
			'four-column' => __('Four Columns','rehab-center'),
			'grid' => __('Grid Layout','rehab-center')
     ),
	) );

	$wp_customize->add_setting('rehab_center_blog_post_description_option',array(
    	'default'   => 'Excerpt Content', 
        'sanitize_callback' => 'rehab_center_sanitize_choices'
	));
	$wp_customize->add_control('rehab_center_blog_post_description_option',array(
        'type' => 'radio',
        'label' => __('Post Description Length','rehab-center'),
        'section' => 'rehab_center_blog_post_settings',
        'choices' => array(
            'No Content' => __('No Content','rehab-center'),
            'Excerpt Content' => __('Excerpt Content','rehab-center'),
            'Full Content' => __('Full Content','rehab-center'),
        ),
	) );

	$wp_customize->add_setting('rehab_center_blog_post_thumb',array(
        'sanitize_callback' => 'rehab_center_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('rehab_center_blog_post_thumb',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Show / Hide Blog Post Thumbnail', 'rehab-center'),
        'section'     => 'rehab_center_blog_post_settings',
    ));

    $wp_customize->add_setting( 'rehab_center_blog_post_page_image_box_shadow', array(
        'default'              => '0',
        'transport'            => 'refresh',
        'sanitize_callback'    => 'rehab_center_sanitize_integer'
    ) );
    $wp_customize->add_control(new Rehab_Center_Slider_Custom_Control( $wp_customize, 'rehab_center_blog_post_page_image_box_shadow',array(
		'label'	=> esc_html__('Blog Page Image Box Shadow','rehab-center'),
		'section'=> 'rehab_center_blog_post_settings',
		'settings'=>'rehab_center_blog_post_page_image_box_shadow',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 100,
        ),
	)));

	$wp_customize->add_setting( 'rehab_center_blog_post_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('rehab_center_blog_post_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(REHAB_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'rehab_center_blog_post_settings'
	));

	//Single Post Settings
	$wp_customize->add_section('rehab_center_single_post_settings',array(
		'title' => __('Manage Single Post Section', 'rehab-center'),
		'priority' => null,
		'panel' => 'rehab_center_panel_area'
	));

	$wp_customize->add_setting( 'rehab_center_single_page_breadcrumb',array(
		'default' => true,
        'sanitize_callback'	=> 'rehab_center_sanitize_checkbox',
	));
	$wp_customize->add_control('rehab_center_single_page_breadcrumb',array(
       'section' => 'rehab_center_single_post_settings',
	   'label' => __( 'Check To Enable Breadcrumb','rehab-center' ),
	   'type' => 'checkbox'
    ));	

	$wp_customize->add_setting('rehab_center_single_post_date',array(
		'default' => true,
		'sanitize_callback'	=> 'rehab_center_sanitize_checkbox'
	));
	$wp_customize->add_control('rehab_center_single_post_date',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Date ','rehab-center'),
		'section' => 'rehab_center_single_post_settings'
	));	

	$wp_customize->add_setting('rehab_center_single_post_author',array(
		'default' => true,
		'sanitize_callback'	=> 'rehab_center_sanitize_checkbox'
	));
	$wp_customize->add_control('rehab_center_single_post_author',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Author','rehab-center'),
		'section' => 'rehab_center_single_post_settings'
	));

	$wp_customize->add_setting('rehab_center_single_post_comment',array(
		'default' => true,
		'sanitize_callback'	=> 'rehab_center_sanitize_checkbox'
	));
	$wp_customize->add_control('rehab_center_single_post_comment',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Comments','rehab-center'),
		'section' => 'rehab_center_single_post_settings'
	));	

	$wp_customize->add_setting('rehab_center_single_post_time',array(
		'default' => true,
		'sanitize_callback'	=> 'rehab_center_sanitize_checkbox'
	));
	$wp_customize->add_control('rehab_center_single_post_time',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Time','rehab-center'),
		'section' => 'rehab_center_single_post_settings'
	));	

	$wp_customize->add_setting('rehab_center_single_post_metabox_seperator',array(
		'default' => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('rehab_center_single_post_metabox_seperator',array(
		'type' => 'text',
		'label' => __('Metabox Seperator','rehab-center'),
		'description' => __('Ex: "/", "|", "-", ...','rehab-center'),
		'section' => 'rehab_center_single_post_settings'
	)); 

	$wp_customize->add_setting('rehab_center_sidebar_single_post_layout',array(
    	'default' => 'right',
    	 'sanitize_callback' => 'rehab_center_sanitize_choices'
	));
	$wp_customize->add_control('rehab_center_sidebar_single_post_layout',array(
   		'type' => 'radio',
    	'label'     => __('Single post sidebar layout', 'rehab-center'),
     	'section' => 'rehab_center_single_post_settings',
     	'choices' => array(
			'full' => __('Full','rehab-center'),
			'left' => __('Left','rehab-center'),
			'right' => __('Right','rehab-center'),
     ),
	));

	$wp_customize->add_setting( 'rehab_center_single_post_page_image_box_shadow', array(
        'default'              => '0',
        'transport'            => 'refresh',
        'sanitize_callback'    => 'rehab_center_sanitize_integer'
    ) );
    $wp_customize->add_control(new Rehab_Center_Slider_Custom_Control( $wp_customize, 'rehab_center_single_post_page_image_box_shadow',array(
		'label'	=> esc_html__('Single Post Image Box Shadow','rehab-center'),
		'section'=> 'rehab_center_single_post_settings',
		'settings'=>'rehab_center_single_post_page_image_box_shadow',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 100,
        ),
	)));

	$wp_customize->add_setting( 'rehab_center_single_post_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('rehab_center_single_post_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(REHAB_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'rehab_center_single_post_settings'
	));

	// 404 Page Settings
	$wp_customize->add_section('rehab_center_page_not_found', array(
		'title'	=> __('Manage 404 Page Section','rehab-center'),
		'priority'	=> null,
		'panel' => 'rehab_center_panel_area',
	));
	
	$wp_customize->add_setting('rehab_center_page_not_found_heading',array(
		'default'=> __('404 Not Found','rehab-center'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('rehab_center_page_not_found_heading',array(
		'label'	=> __('404 Heading','rehab-center'),
		'section'=> 'rehab_center_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('rehab_center_page_not_found_content',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('rehab_center_page_not_found_content',array(
		'label'	=> __('404 Text','rehab-center'),
		'input_attrs' => array(
			'placeholder' => __( 'Looks like you have taken a wrong turn.....Don\'t worry... it happens to the best of us.', 'rehab-center' ),
		),
		'section'=> 'rehab_center_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'rehab_center_page_not_found_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('rehab_center_page_not_found_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(REHAB_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'rehab_center_page_not_found'
	));

	// Footer Section
	$wp_customize->add_section('rehab_center_footer', array(
		'title'	=> __('Manage Footer Section','rehab-center'),
		'description'	=> __('<p class="sec-title">Manage Footer Section</p>','rehab-center'),
		'priority'	=> null,
		'panel' => 'rehab_center_panel_area',
	));

	$wp_customize->add_setting('rehab_center_footer_widget', array(
	    'default' => true,
	    'sanitize_callback' => 'rehab_center_sanitize_checkbox',
	));
	$wp_customize->add_control('rehab_center_footer_widget', array(
	    'settings' => 'rehab_center_footer_widget',
	    'section'   => 'rehab_center_footer',
	    'label'     => __('Check to Enable Footer Widget', 'rehab-center'),
	    'type'      => 'checkbox',
	));

	//  footer bg color
	$wp_customize->add_setting('rehab_center_footerbg_color',array(
		'default' => '',
		'sanitize_callback' => 'rehab_center_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_footerbg_color', array(
		'settings' => 'rehab_center_footerbg_color',
		'section'   => 'rehab_center_footer',
		'label' => __('Footer Background Color', 'rehab-center'),
		'type'      => 'color'
	));

	$wp_customize->add_setting('rehab_center_footer_bg_image',array(
        'default'   => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'rehab_center_footer_bg_image',array(
        'label' => __('Footer Background Image','rehab-center'),
        'section' => 'rehab_center_footer',
    )));

	$wp_customize->add_setting('rehab_center_footer_img_position',array(
		'default' => 'center center',
		'transport' => 'refresh',
		'sanitize_callback' => 'rehab_center_sanitize_choices'
	));
	$wp_customize->add_control('rehab_center_footer_img_position',array(
		'type' => 'select',
		'label' => __('Footer Image Position','rehab-center'),
		'section' => 'rehab_center_footer',
		'choices' 	=> array(
			'center center'   => esc_html__( 'Center', 'rehab-center' ),
			'center top'   => esc_html__( 'Top', 'rehab-center' ),
			'left center'   => esc_html__( 'Left', 'rehab-center' ),
			'right center'   => esc_html__( 'Right', 'rehab-center' ),
			'center bottom'   => esc_html__( 'Bottom', 'rehab-center' ),
		),
	));	

	$wp_customize->add_setting('rehab_center_footer_widget_areas',array(
		'default'           => 4,
		'sanitize_callback' => 'rehab_center_sanitize_choices',
	));
	$wp_customize->add_control('rehab_center_footer_widget_areas',array(
		'type'        => 'radio',
		'section' => 'rehab_center_footer',
		'label'       => __('Footer widget area', 'rehab-center'),
		'choices' => array(
		   '1'     => __('One', 'rehab-center'),
		   '2'     => __('Two', 'rehab-center'),
		   '3'     => __('Three', 'rehab-center'),
		   '4'     => __('Four', 'rehab-center')
		),
	));

	$wp_customize->add_setting('rehab_center_copyright_line',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control( 'rehab_center_copyright_line', array(
	   'section' 	=> 'rehab_center_footer',
	   'label'	 	=> __('Copyright Line','rehab-center'),
	   'type'    	=> 'text',
	   'priority' 	=> null,
    ));

	$wp_customize->add_setting('rehab_center_copyright_link',array(
    	'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control( 'rehab_center_copyright_link', array(
	   'section' 	=> 'rehab_center_footer',
	   'label'	 	=> __('Copyright Link','rehab-center'),
	   'type'    	=> 'text',
	   'priority' 	=> null,
    ));

	//  footer coypright color
	$wp_customize->add_setting('rehab_center_footercoypright_color',array(
		'default' => '',
		'sanitize_callback' => 'rehab_center_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_footercoypright_color', array(
	   'settings' => 'rehab_center_footercoypright_color',
	   'section'   => 'rehab_center_footer',
	   'label' => __('Coypright Color', 'rehab-center'),
	   'type'      => 'color'
	));

	//  footer title color
	$wp_customize->add_setting('rehab_center_footertitle_color',array(
		'default' => '',
		'sanitize_callback' => 'rehab_center_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_footertitle_color', array(
	   'settings' => 'rehab_center_footertitle_color',
	   'section'   => 'rehab_center_footer',
	   'label' => __('Title Color', 'rehab-center'),
	   'type'      => 'color'
	));

	//  footer description color
	$wp_customize->add_setting('rehab_center_footerdescription_color',array(
		'default' => '',
		'sanitize_callback' => 'rehab_center_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_footerdescription_color', array(
	   'settings' => 'rehab_center_footerdescription_color',
	   'section'   => 'rehab_center_footer',
	   'label' => __('Description Color', 'rehab-center'),
	   'type'      => 'color'
	));

	//  footer list color
	$wp_customize->add_setting('rehab_center_footerlist_color',array(
		'default' => '',
		'sanitize_callback' => 'rehab_center_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_footerlist_color', array(
	   'settings' => 'rehab_center_footerlist_color',
	   'section'   => 'rehab_center_footer',
	   'label' => __('List Color', 'rehab-center'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('rehab_center_scroll_hide', array(
        'default' => true,
        'sanitize_callback' => 'rehab_center_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'rehab_center_scroll_hide',array(
        'label'          => __( 'Check To Show Scroll To Top', 'rehab-center' ),
        'section'        => 'rehab_center_footer',
        'settings'       => 'rehab_center_scroll_hide',
        'type'           => 'checkbox',
    )));

	$wp_customize->add_setting('rehab_center_scroll_position',array(
        'default' => 'Right',
        'sanitize_callback' => 'rehab_center_sanitize_choices'
    ));
    $wp_customize->add_control('rehab_center_scroll_position',array(
        'type' => 'radio',
        'section' => 'rehab_center_footer',
        'label'	 	=> __('Scroll To Top Positions','rehab-center'),
        'choices' => array(
            'Right' => __('Right','rehab-center'),
            'Left' => __('Left','rehab-center'),
            'Center' => __('Center','rehab-center')
        ),
    ) );

	$wp_customize->add_setting('rehab_center_scroll_text',array(
		'default'	=> __('TOP','rehab-center'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));	
	$wp_customize->add_control('rehab_center_scroll_text',array(
		'label'	=> __('Scroll To Top Button Text','rehab-center'),
		'section'	=> 'rehab_center_footer',
		'type'		=> 'text'
	));

	$wp_customize->add_setting( 'rehab_center_scroll_top_shape', array(
		'default'           => 'circle',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	
	$wp_customize->add_control( 'rehab_center_scroll_top_shape', array(
		'label'    => __( 'Scroll to Top Button Shape', 'rehab-center' ),
		'section'  => 'rehab_center_footer',
		'settings' => 'rehab_center_scroll_top_shape',
		'type'     => 'radio',
		'choices'  => array(
			'box'        => __( 'Box', 'rehab-center' ),
			'curved' => __( 'Curved', 'rehab-center'),
			'circle'     => __( 'Circle', 'rehab-center' ),
		),
	) );

	$wp_customize->add_setting( 'rehab_center_footer_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('rehab_center_footer_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(REHAB_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'rehab_center_footer'
	));
    
	// Footer Social Section
	$wp_customize->add_section('rehab_center_footer_social_icons', array(
		'title'	=> __('Manage Footer Social Section','rehab-center'),
		'description'	=> __('<p class="sec-title">Manage Footer Social Section</p>','rehab-center'),
		'priority'	=> null,
		'panel' => 'rehab_center_panel_area',
	));

	$wp_customize->add_setting('rehab_center_footer_facebook_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_footer_facebook_link', array(
		'settings' => 'rehab_center_footer_facebook_link',
		'section'   => 'rehab_center_footer_social_icons',
		'label' => __('Facebook Link', 'rehab-center'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('rehab_center_footer_instagram_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_footer_instagram_link', array(
		'settings' => 'rehab_center_footer_instagram_link',
		'section'   => 'rehab_center_footer_social_icons',
		'label' => __('Instagram Link', 'rehab-center'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('rehab_center_footer_pinterest_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_footer_pinterest_link', array(
		'settings' => 'rehab_center_footer_pinterest_link',
		'section'   => 'rehab_center_footer_social_icons',
		'label' => __('Pinterest Link', 'rehab-center'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('rehab_center_footer_twitter_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_footer_twitter_link', array(
		'settings' => 'rehab_center_footer_twitter_link',
		'section'   => 'rehab_center_footer_social_icons',
		'label' => __('Twitter Link', 'rehab-center'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('rehab_center_footer_youtube_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'rehab_center_footer_youtube_link', array(
		'settings' => 'rehab_center_footer_youtube_link',
		'section'   => 'rehab_center_footer_social_icons',
		'label' => __('Youtube Link', 'rehab-center'),
		'type'      => 'url'
	));

	$wp_customize->add_setting( 'rehab_center_footer_social_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('rehab_center_footer_social_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(REHAB_CENTER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'rehab_center_footer_social_icons'
	));

	// Google Fonts
	$wp_customize->add_section( 'rehab_center_google_fonts_section', array(
		'title'       => __( 'Google Fonts', 'rehab-center' ),
		'priority'    => 24,
	) );

	$font_choices = array(
		'Kaushan Script:' => 'Kaushan Script',
		'Emilys Candy:' => 'Emilys Candy',
		'Poppins:0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900' => 'Poppins',
		'Source Sans Pro:400,700,400italic,700italic' => 'Source Sans Pro',
		'Open Sans:400italic,700italic,400,700' => 'Open Sans',
		'Oswald:400,700' => 'Oswald',
		'Playfair Display:400,700,400italic' => 'Playfair Display',
		'Montserrat:400,700' => 'Montserrat',
		'Raleway:400,700' => 'Raleway',
		'Droid Sans:400,700' => 'Droid Sans',
		'Lato:400,700,400italic,700italic' => 'Lato',
		'Arvo:400,700,400italic,700italic' => 'Arvo',
		'Lora:400,700,400italic,700italic' => 'Lora',
		'Merriweather:400,300italic,300,400italic,700,700italic' => 'Merriweather',
		'Oxygen:400,300,700' => 'Oxygen',
		'PT Serif:400,700' => 'PT Serif',
		'PT Sans:400,700,400italic,700italic' => 'PT Sans',
		'PT Sans Narrow:400,700' => 'PT Sans Narrow',
		'Cabin:400,700,400italic' => 'Cabin',
		'Fjalla One:400' => 'Fjalla One',
		'Francois One:400' => 'Francois One',
		'Josefin Sans:400,300,600,700' => 'Josefin Sans',
		'Libre Baskerville:400,400italic,700' => 'Libre Baskerville',
		'Arimo:400,700,400italic,700italic' => 'Arimo',
		'Ubuntu:400,700,400italic,700italic' => 'Ubuntu',
		'Bitter:400,700,400italic' => 'Bitter',
		'Droid Serif:400,700,400italic,700italic' => 'Droid Serif',
		'Roboto:400,400italic,700,700italic' => 'Roboto',
		'Open Sans Condensed:700,300italic,300' => 'Open Sans Condensed',
		'Roboto Condensed:400italic,700italic,400,700' => 'Roboto Condensed',
		'Roboto Slab:400,700' => 'Roboto Slab',
		'Yanone Kaffeesatz:400,700' => 'Yanone Kaffeesatz',
		'Rokkitt:400' => 'Rokkitt',
	);

	$wp_customize->add_setting( 'rehab_center_headings_fonts', array(
		'sanitize_callback' => 'rehab_center_sanitize_fonts',
	));
	$wp_customize->add_control( 'rehab_center_headings_fonts', array(
		'type' => 'select',
		'description' => __('Select your desired font for the headings.', 'rehab-center'),
		'section' => 'rehab_center_google_fonts_section',
		'choices' => $font_choices
	));

	$wp_customize->add_setting( 'rehab_center_body_fonts', array(
		'sanitize_callback' => 'rehab_center_sanitize_fonts'
	));
	$wp_customize->add_control( 'rehab_center_body_fonts', array(
		'type' => 'select',
		'description' => __( 'Select your desired font for the body.', 'rehab-center' ),
		'section' => 'rehab_center_google_fonts_section',
		'choices' => $font_choices
	));

	$wp_customize->add_setting( 'rehab_center_small_headings_fonts', array(
		'sanitize_callback' => 'rehab_center_sanitize_fonts',
	));
	$wp_customize->add_control( 'rehab_center_small_headings_fonts', array(
		'type' => 'select',
		'description' => __('Select your desired font for the section headings.', 'rehab-center'),
		'section' => 'rehab_center_google_fonts_section',
		'choices' => $font_choices
	));
  
}
add_action( 'customize_register', 'rehab_center_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function rehab_center_customize_preview_js() {
	wp_enqueue_script( 'rehab_center_customizer', esc_url(get_template_directory_uri()) . '/js/customize-preview.js', array( 'customize-preview' ), '20161510', true );
}
add_action( 'customize_preview_init', 'rehab_center_customize_preview_js' );
