<?php
/*
 * @package Rehab Center
 */

function rehab_center_admin_enqueue_scripts() {
    wp_enqueue_style( 'rehab-center-admin-style', esc_url( get_template_directory_uri() ).'/css/addon.css' );
}
add_action( 'admin_enqueue_scripts', 'rehab_center_admin_enqueue_scripts' );

function rehab_center_theme_info_menu_link() {

    $rehab_center_theme = wp_get_theme();
    add_theme_page(
        /* translators: 1: Theme name, 2: Theme version */
        sprintf( esc_html__( 'Welcome to %1$s %2$s', 'rehab-center' ), $rehab_center_theme->get( 'Name' ), $rehab_center_theme->get( 'Version' ) ),
        esc_html__( 'Theme Info', 'rehab-center' ),'edit_theme_options','rehab-center','rehab_center_theme_info_page'
    );

    // Add "Theme Demo Import" page
    add_theme_page(
        esc_html__( 'Theme Demo Import', 'rehab-center' ),
        esc_html__( 'Theme Demo Import', 'rehab-center' ),
        'edit_theme_options',
        'rehab-center-demo',
        'rehab_center_demo_content_page'
    );

}
add_action( 'admin_menu', 'rehab_center_theme_info_menu_link' );

function rehab_center_theme_info_page() {

    $rehab_center_theme = wp_get_theme();
    ?>
<div class="wrap theme-info-wrap">
    <h1><?php printf( esc_html__( 'Welcome to %1$s %2$s', 'rehab-center' ), esc_html($rehab_center_theme->get( 'Name' )), esc_html($rehab_center_theme->get( 'Version' ))); ?>
    </h1>
    <p class="theme-description">
    <?php esc_html_e( 'Do you want to configure this theme? Look no further, our easy-to-follow theme documentation will walk you through it.', 'rehab-center' ); ?>
    </p>
    <div class="important-link">
        <p class="main-box columns-wrapper clearfix">
            <div class="themelink column column-half clearfix">
                <p><strong><?php esc_html_e( 'Pro version of our theme', 'rehab-center' ); ?></strong></p>
                <p><?php esc_html_e( 'Are you exited for our theme? Then we will proceed for pro version of theme.', 'rehab-center' ); ?></p>
                <a class="get-premium" href="<?php echo esc_url( REHAB_CENTER_PREMIUM_PAGE ); ?>" target="_blank"><?php esc_html_e( 'Go To Premium', 'rehab-center' ); ?></a>
                <p><strong><?php esc_html_e( 'Check all classic features', 'rehab-center' ); ?></strong></p>
                <p><?php esc_html_e( 'Explore all the premium features.', 'rehab-center' ); ?></p>
                <a href="<?php echo esc_url( REHAB_CENTER_THEME_PAGE ); ?>" target="_blank"><?php esc_html_e( 'Theme Page', 'rehab-center' ); ?></a>
            </div>
            <div class="themelink column column-half clearfix">
                <p><strong><?php esc_html_e( 'Need Help?', 'rehab-center' ); ?></strong></p>
                <p><?php esc_html_e( 'Go to our support forum to help you out in case of queries and doubts regarding our theme.', 'rehab-center' ); ?></p>
                <a href="<?php echo esc_url( REHAB_CENTER_SUPPORT ); ?>" target="_blank"><?php esc_html_e( 'Contact Us', 'rehab-center' ); ?></a>
                <p><strong><?php esc_html_e( 'Leave us a review', 'rehab-center' ); ?></strong></p>
                <p><?php esc_html_e( 'Are you enjoying our theme? We would love to hear your feedback.', 'rehab-center' ); ?></p>
                <a href="<?php echo esc_url( REHAB_CENTER_REVIEW ); ?>" target="_blank"><?php esc_html_e( 'Rate This Theme', 'rehab-center' ); ?></a>
            </div>
            <div class="themelink column column-half clearfix">
                <p><strong><?php esc_html_e( 'Check Our Demo', 'rehab-center' ); ?></strong></p>
                <p><?php esc_html_e( 'Here, you can view a live demonstration of our premium them.', 'rehab-center' ); ?></p>
                <a href="<?php echo esc_url( REHAB_CENTER_PRO_DEMO ); ?>" target="_blank"><?php esc_html_e( 'Premium Demo', 'rehab-center' ); ?></a>
                <p><strong><?php esc_html_e( 'Theme Documentation', 'rehab-center' ); ?></strong></p>
                <p><?php esc_html_e( 'Need more details? Please check our full documentation for detailed theme setup.', 'rehab-center' ); ?></p>
                <a href="<?php echo esc_url( REHAB_CENTER_THEME_DOCUMENTATION ); ?>" target="_blank"><?php esc_html_e( 'Documentation', 'rehab-center' ); ?></a>
            </div>
        </p>
    </div>
    <div id="getting-started">
        <h3><?php 
        /* translators: %s: Theme name */
        printf( esc_html__( 'Getting started with %s', 'rehab-center' ),
        esc_html($rehab_center_theme->get( 'Name' ))); ?></h3>
        <div class="columns-wrapper clearfix">
            <div class="column column-half clearfix">
                <div class="section">
                    <h4><?php esc_html_e( 'Theme Description', 'rehab-center' ); ?></h4>
                    <div class="theme-description-1"><?php echo esc_html($rehab_center_theme->get( 'Description' )); ?></div>
                </div>
            </div>
            <div class="column column-half clearfix">
                <img src="<?php echo esc_url( $rehab_center_theme->get_screenshot() ); ?>" alt="<?php echo esc_attr( 'screenshot', 'rehab-center'); ?>"/>
                <div class="section">
                    <h4><?php esc_html_e( 'Theme Options', 'rehab-center' ); ?></h4>
                    <p class="about">
                    <?php 
                    /* translators: %s: Theme name */
                    printf( esc_html__( '%s makes use of the Customizer for all theme settings. Click on "Customize Theme" to open the Customizer now.', 'rehab-center' ),esc_html($rehab_center_theme->get( 'Name' ))); ?></p>
                    <p>
                    <div class="themelink-1">
                        <a target="_blank" href="<?php echo esc_url( wp_customize_url() ); ?>"><?php esc_html_e( 'Customize Theme', 'rehab-center' ); ?></a>
                        <a class="get-premium" href="<?php echo esc_url( REHAB_CENTER_PREMIUM_PAGE ); ?>" target="_blank"><?php esc_html_e( 'Checkout Premium', 'rehab-center' ); ?></a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <hr>
    <div id="theme-author">
      <p><?php
      /* translators: 1: Theme name, 2: Developer name, 3: Call to action */
        printf( esc_html__( '%1$s is proudly brought to you by %2$s. If you like this theme, %3$s :)', 'rehab-center' ),
            esc_html($rehab_center_theme->get( 'Name' )),
            '<a target="_blank" href="' . esc_url( 'https://www.theclassictemplates.com/', 'rehab-center' ) . '">classictemplate</a>',
            '<a target="_blank" href="' . esc_url( REHAB_CENTER_REVIEW ) . '" title="' . esc_attr__( 'Rate it', 'rehab-center' ) . '">' . esc_html_x( 'rate it', 'If you like this theme, rate it', 'rehab-center' ) . '</a>'
        );
        ?></p>
    </div>
</div>
<?php
}

function rehab_center_demo_content_page() {

    $rehab_center_theme = wp_get_theme();
    ?>
    <div class="container">
       <div class="start-box">
          <div class="columns-wrapper m-0"> 
             <div class="column column-half clearfix">
               <div class="wrapper-info"> 
                  <img src="<?php echo esc_url( get_template_directory_uri().'/images/Logo.png' ); ?>" />
                  <h2><?php esc_html_e( 'Welcome to Rehab Center', 'rehab-center' ); ?></h2>
                  <span class="version"><?php esc_html_e( 'Version', 'rehab-center' ); ?>: <?php echo esc_html( wp_get_theme()->get( 'Version' ) ); ?></span>	
                  <p><?php esc_html_e( 'To begin, locate the run importer button and click on it to initiate the importation of all the demo content.', 'rehab-center' ); ?></p>
                  <?php require get_parent_theme_file_path( '/inc/demo-content.php' ); ?>
               </div>
             </div>
             <div class="column column-half clearfix">
             <div class="get-screenshot">
               <img src="<?php echo esc_url( get_template_directory_uri().'/screenshot.png' ); ?>" />
             </div>   
             </div>
          </div>
       </div>
    </div>
<?php
}

?>
