<?php
/**
 * Rehab Center functions and definitions
 *
 * @package Rehab Center
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */

if ( ! function_exists( 'rehab_center_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function rehab_center_setup() {
	global $content_width;
	if ( ! isset( $content_width ) )
		$content_width = 680;
	
	load_theme_textdomain( 'rehab-center', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( "responsive-embeds" );
	add_theme_support( 'align-wide' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'wp-block-styles');
	add_theme_support( 'custom-header', array(
		'default-text-color' => false,
		'header-text' => false,
	) );
	add_theme_support( 'custom-logo', array(
		'height'      => 50,
		'width'       => 100,
		'flex-height' => true,
	) );
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'rehab-center' ),
	) );
	add_theme_support( 'custom-background', array(
		'default-color' => 'ffffff'
	) );
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 */
	add_theme_support( 'post-formats', array('image','video','gallery','audio',) );

	add_editor_style( 'editor-style.css' );

	global $pagenow;

    if ( is_admin() && 'themes.php' === $pagenow && isset( $_GET['activated'] ) && current_user_can( 'manage_options' ) ) {
        add_action('admin_notices', 'rehab_center_deprecated_hook_admin_notice');
    }
}
endif; // rehab_center_setup
add_action( 'after_setup_theme', 'rehab_center_setup' );

function rehab_center_the_breadcrumb() {
    echo '<div class="breadcrumb my-3">';

    if (!is_home()) {
        echo '<a class="home-main align-self-center" href="' . esc_url(home_url()) . '">';
        bloginfo('name');
        echo "</a> >> ";

        if (is_category() || is_single()) {
            the_category(' >> ');
            if (is_single()) {
                echo ' >> <span class="current-breadcrumb">' . esc_html(get_the_title()) . '</span>';
            }
        } elseif (is_page()) {
            echo '<span class="current-breadcrumb">' . esc_html(get_the_title()) . '</span>';
        }
    }

    echo '</div>';
}

function rehab_center_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'rehab-center' ),
		'description'   => __( 'Appears on blog page sidebar', 'rehab-center' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Page Sidebar', 'rehab-center' ),
		'id'            => 'sidebar-2',
		'description'   => __( 'Add widgets here to appear in your sidebar on pages.', 'rehab-center' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Sidebar 3', 'rehab-center' ),
		'id'            => 'sidebar-3',
		'description'   => __( 'Add widgets here to appear in your sidebar on blog posts and archive pages.', 'rehab-center' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar(array(
        'name'          => __('Shop Sidebar', 'rehab-center'),
        'description'   => __('Sidebar for WooCommerce shop pages', 'rehab-center'),
		'id'            => 'woocommerce-sidebar',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ));
	register_sidebar(array(
        'name'          => __('Single Product Sidebar', 'rehab-center'),
        'description'   => __('Sidebar for single product pages', 'rehab-center'),
		'id'            => 'woocommerce-single-sidebar',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ));		
	
	$rehab_center_widget_areas = get_theme_mod('rehab_center_footer_widget_areas', '4');
	for ($rehab_center_i=1; $rehab_center_i<=$rehab_center_widget_areas; $rehab_center_i++) {
		register_sidebar( array(
			'name'          => __( 'Footer Widget ', 'rehab-center' ) . $rehab_center_i,
			'id'            => 'footer-' . $rehab_center_i,
			'description'   => '',
			'before_widget' => '<aside id="%1$s" class="ftr-4-box widget-column-4 %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
	}

}
add_action( 'widgets_init', 'rehab_center_widgets_init' );

// Change number of products per row to 4
add_filter('loop_shop_columns', 'rehab_center_loop_columns');
if (!function_exists('rehab_center_loop_columns')) {
    function rehab_center_loop_columns() {
        $colm = get_theme_mod('rehab_center_products_per_row', 4); // Default to 4 if not set
        return $colm;
    }
}

// Use the customizer setting to set the number of products per page
function rehab_center_products_per_page($cols) {
    $cols = get_theme_mod('rehab_center_products_per_page', 8); // Default to 8 if not set
    return $cols;
}
add_filter('loop_shop_per_page', 'rehab_center_products_per_page', 8);

function rehab_center_scripts() {
	
	wp_enqueue_style( 'bootstrap-css', esc_url(get_template_directory_uri())."/css/bootstrap.css" );
	wp_enqueue_style('rehab-center-style', get_stylesheet_uri(), array() );
		wp_style_add_data('rehab-center-style', 'rtl', 'replace');
	require get_parent_theme_file_path( '/inc/color-scheme/custom-color-control.php' );
	wp_add_inline_style( 'rehab-center-style',$rehab_center_color_scheme_css );
	wp_enqueue_style( 'slick-style', esc_url(get_template_directory_uri()).'/css/slick.css' );
	wp_enqueue_style( 'rehab-center-default', esc_url(get_template_directory_uri())."/css/default.css" );
	wp_enqueue_style( 'rehab-center-style', get_stylesheet_uri() );
	wp_enqueue_script( 'slick-js', esc_url(get_template_directory_uri()). '/js/slick.js', array('jquery') ,'',true);
	wp_enqueue_script( 'bootstrap-js', esc_url(get_template_directory_uri()). '/js/bootstrap.js', array('jquery') );
	wp_enqueue_script( 'rehab-center-theme', esc_url(get_template_directory_uri()) . '/js/theme.js' );
	wp_enqueue_style( 'font-awesome-css', esc_url(get_template_directory_uri())."/css/fontawesome-all.css" );
	wp_enqueue_style( 'rehab-center-block-style', esc_url( get_template_directory_uri() ).'/css/blocks.css' );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	// font-family
    $rehab_center_heading_font = esc_html(get_theme_mod('rehab_center_headings_fonts'));
    $rehab_center_body_font = esc_html(get_theme_mod('rehab_center_body_fonts'));
    $rehab_center_small_heading_font = esc_html(get_theme_mod('rehab_center_small_headings_fonts'));

    if ($rehab_center_body_font) {
        wp_enqueue_style('rehab-center-body-fonts', 'https://fonts.googleapis.com/css?family=' . urlencode($rehab_center_body_font));
    } else {
        wp_enqueue_style('Open Sans', 'https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300..800;1,300..800');
    }

    if ($rehab_center_heading_font) {
        wp_enqueue_style('rehab-center-heading-fonts', 'https://fonts.googleapis.com/css?family=' . urlencode($rehab_center_heading_font));
    } else {
        wp_enqueue_style('Roboto', 'https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100..900;1,100..900');
    }

    if ($rehab_center_small_heading_font) {
        wp_enqueue_style('rehab-center-small-heading-fonts', 'https://fonts.googleapis.com/css?family=' . urlencode($rehab_center_small_heading_font));
    } else {
        wp_enqueue_style('Lato', 'https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900');
    }
}
add_action( 'wp_enqueue_scripts', 'rehab_center_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Sanitization Callbacks.
 */
require get_template_directory() . '/inc/sanitization-callbacks.php';

/**
 * Webfont-Loader.
 */
require get_template_directory() . '/inc/wptt-webfont-loader.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/upgrade-to-pro.php';

/**
 * Google Fonts
 */
require get_template_directory() . '/inc/gfonts.php';

/**
 * select .
 */
require get_template_directory() . '/inc/select/category-dropdown-custom-control.php';

/**
 * Theme Info Page.
 */
require get_template_directory() . '/inc/addon.php';

/**
 * Load TGM.
 */
require get_template_directory() . '/inc/tgm/tgm.php';

function rehab_center_setup_theme() {
	if ( ! defined( 'REHAB_CENTER_PRO_NAME' ) ) {
		define( 'REHAB_CENTER_PRO_NAME', __( 'About Rehab Center', 'rehab-center' ));
	}
	if ( ! defined( 'REHAB_CENTER_PREMIUM_PAGE' ) ) {
		define('REHAB_CENTER_PREMIUM_PAGE',__('https://www.theclassictemplates.com/products/rehab-wordpress-theme','rehab-center'));
	}
	if ( ! defined( 'REHAB_CENTER_THEME_PAGE' ) ) {
		define('REHAB_CENTER_THEME_PAGE',__('https://www.theclassictemplates.com/collections/best-wordpress-templates','rehab-center'));
	}
	if ( ! defined( 'REHAB_CENTER_SUPPORT' ) ) {
		define('REHAB_CENTER_SUPPORT',__('https://wordpress.org/support/theme/rehab-center/','rehab-center'));
	}
	if ( ! defined( 'REHAB_CENTER_REVIEW' ) ) {
		define('REHAB_CENTER_REVIEW',__('https://wordpress.org/support/theme/rehab-center/reviews/','rehab-center'));
	}
	if ( ! defined( 'REHAB_CENTER_PRO_DEMO' ) ) {
		define('REHAB_CENTER_PRO_DEMO',__('https://live.theclassictemplates.com/rehab-center-pro/','rehab-center'));
	}
	if ( ! defined( 'REHAB_CENTER_THEME_DOCUMENTATION' ) ) {
		define('REHAB_CENTER_THEME_DOCUMENTATION',__('https://live.theclassictemplates.com/demo/docs/rehab-center-free/','rehab-center'));
	}
}
add_action('after_setup_theme', 'rehab_center_setup_theme');
    
// logo
if ( ! function_exists( 'rehab_center_the_custom_logo' ) ) :
/**
 * Displays the optional custom logo.
 *
 * Does nothing if the custom logo is not available.
 *
 */
function rehab_center_the_custom_logo() {
	if ( function_exists( 'the_custom_logo' ) ) {
		the_custom_logo();
	}
}
endif;


/* Activation Notice */
function rehab_center_deprecated_hook_admin_notice() {
    $rehab_center_theme = wp_get_theme();
    $rehab_center_dismissed = get_user_meta( get_current_user_id(), 'rehab_center_dismissable_notice', true );
    if ( !$rehab_center_dismissed) { ?>
        <div class="getstrat updated notice notice-success is-dismissible notice-get-started-class">
            <div class="admin-image">
                <img src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/screenshot.png'; ?>" />
            </div>
            <div class="admin-content" >
                <h1><?php printf( esc_html__( 'Welcome to %1$s %2$s', 'rehab-center' ), esc_html($rehab_center_theme->get( 'Name' )), esc_html($rehab_center_theme->get( 'Version' ))); ?>
                </h1>
                <p><?php _e('Get Started With Theme By Clicking On Getting Started.', 'rehab-center'); ?></p>
                <div style="display: grid;">
                    <a class="admin-notice-btn button button-hero upgrade-pro" target="_blank" href="<?php echo esc_url( REHAB_CENTER_PREMIUM_PAGE ); ?>"><?php esc_html_e('Upgrade Pro', 'rehab-center') ?><i class="dashicons dashicons-cart"></i></a>
                    <a class="admin-notice-btn button button-hero" href="<?php echo esc_url( admin_url( 'themes.php?page=rehab-center' )); ?>"><?php esc_html_e( 'Get started', 'rehab-center' ) ?><i class="dashicons dashicons-backup"></i></a>
                    <a class="admin-notice-btn button button-hero" target="_blank" href="<?php echo esc_url( REHAB_CENTER_THEME_DOCUMENTATION ); ?>"><?php esc_html_e('Free Doc', 'rehab-center') ?><i class="dashicons dashicons-visibility"></i></a>
                    <a  class="admin-notice-btn button button-hero" target="_blank" href="<?php echo esc_url( REHAB_CENTER_PRO_DEMO ); ?>"><?php esc_html_e('View Demo', 'rehab-center') ?><i class="dashicons dashicons-awards"></i></a>
                </div>
            </div>
        </div>
    <?php }
}