<?php
/**
 * Displays main header
 *
 * @package Recipe Maker
 */
?>

<div class="main-header text-center text-md-start">
    <div class="container">
        <div class="row nav-box">
            <div class="col-xl-3 col-lg-3 col-md-4 col-sm-12 logo-box align-self-center">
                <div class="navbar-brand ">
                    <?php if ( has_custom_logo() ) : ?>
                        <div class="site-logo"><?php the_custom_logo(); ?></div>
                    <?php endif; ?>
                    <?php $recipe_maker_blog_info = get_bloginfo( 'name' ); ?>
                        <?php if ( ! empty( $recipe_maker_blog_info ) ) : ?>
                            <?php if ( is_front_page() && is_home() ) : ?>
                                <?php if( get_theme_mod('recipe_maker_logo_title_text',true) != ''){ ?>
                                    <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                                <?php } ?>
                            <?php else : ?>
                                <?php if( get_theme_mod('recipe_maker_logo_title_text',true) != ''){ ?>
                                    <p class="site-title "><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                                <?php } ?>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php
                            $recipe_maker_description = get_bloginfo( 'description', 'display' );
                            if ( $recipe_maker_description || is_customize_preview() ) :
                        ?>
                        <?php if( get_theme_mod('recipe_maker_theme_description',false) != ''){ ?>
                            <p class="site-description pb-2"><?php echo esc_html($recipe_maker_description); ?></p>
                        <?php } ?>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-xl-7 col-lg-6 col-md-5 col-sm-5 col-12 align-self-center header-box">
                <?php get_template_part('template-parts/navigation/nav'); ?>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-3 col-sm-7 col-12 align-self-center meta-main-box">
                <div class="header-right-box">
                    <?php if(class_exists('woocommerce')){ ?>
                        <span class="user-btn me-3">
                            <?php if ( is_user_logged_in() ) { ?>
                                <a class="account-btn" href="<?php echo esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ); ?>" title="<?php esc_attr_e('My Account','recipe-maker'); ?>"><i class="far fa-user"></i></a>
                            <?php } 
                            else { ?>
                                <a class="account-btn" href="<?php echo esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ); ?>" title="<?php esc_attr_e('My Account','recipe-maker'); ?>"></a>
                            <?php } ?>
                        </span>
                    <?php }?>
                    <?php if ( get_theme_mod('recipe_maker_topbar1_wishlist_url') != "" ) {?>
                        <span class="wish-btn ">
                            <a href="<?php echo esc_url(get_theme_mod('recipe_maker_topbar1_wishlist_url')); ?>"><i class="far fa-heart"></i></a>
                        </span>
                    <?php }?>
                </div>
            </div>
        </div>
    </div>
</div>
