<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Recipe Maker
 */
?>

<footer id="colophon" class="site-footer border-top">
    <div class="container">
    	<div class="footer-column">
	      	<div class="row">
		        <div class="col-lg-3 col-md-3 col-sm-6 col-12">
		          	<?php if (is_active_sidebar('recipe-maker-footer1')) : ?>
                        <?php dynamic_sidebar('recipe-maker-footer1'); ?>
                    <?php else : ?>
                        <aside id="search" class="widget" role="complementary" aria-label="firstsidebar">
                            <h5 class="widget-title"><?php esc_html_e( 'About Us', 'recipe-maker' ); ?></h5>
                            <div class="textwidget">
                            	<p><?php esc_html_e( 'Nam malesuada nulla nisi, ut faucibus magna congue nec. Ut libero tortor, tempus at auctor in, molestie at nisi. In enim ligula, consequat eu feugiat a.', 'recipe-maker' ); ?></p>
                            </div>
                        </aside>
                    <?php endif; ?>
		        </div>
		        <div class="col-lg-3 col-md-3 col-sm-6 col-12">
		            <?php if (is_active_sidebar('recipe-maker-footer2')) : ?>
                        <?php dynamic_sidebar('recipe-maker-footer2'); ?>
                    <?php else : ?>
                        <aside id="pages" class="widget">
                            <h5 class="widget-title"><?php esc_html_e( 'Useful Links', 'recipe-maker' ); ?></h5>
                            <ul class="mt-4">
                            	<li><?php esc_html_e( 'Home', 'recipe-maker' ); ?></li>
                            	<li><?php esc_html_e( 'Tournaments', 'recipe-maker' ); ?></li>
                            	<li><?php esc_html_e( 'Reviews', 'recipe-maker' ); ?></li>
                            	<li><?php esc_html_e( 'About Us', 'recipe-maker' ); ?></li>
                            </ul>
                        </aside>
                    <?php endif; ?>
		        </div>
		        <div class="col-lg-3 col-md-3 col-sm-6 col-12">
		            <?php if (is_active_sidebar('recipe-maker-footer3')) : ?>
                        <?php dynamic_sidebar('recipe-maker-footer3'); ?>
                    <?php else : ?>
                        <aside id="pages" class="widget">
                            <h5 class="widget-title"><?php esc_html_e( 'Information', 'recipe-maker' ); ?></h5>
                            <ul class="mt-4">
                            	<li><?php esc_html_e( 'FAQ', 'recipe-maker' ); ?></li>
                            	<li><?php esc_html_e( 'Site Maps', 'recipe-maker' ); ?></li>
                            	<li><?php esc_html_e( 'Privacy Policy', 'recipe-maker' ); ?></li>
                            	<li><?php esc_html_e( 'Contact Us', 'recipe-maker' ); ?></li>
                            </ul>
                        </aside>
                    <?php endif; ?>
		        </div>
		        <div class="col-lg-3 col-md-3 col-sm-6 col-12">
		            <?php if (is_active_sidebar('recipe-maker-footer4')) : ?>
                        <?php dynamic_sidebar('recipe-maker-footer4'); ?>
                    <?php else : ?>
                        <aside id="pages" class="widget">
                            <h5 class="widget-title"><?php esc_html_e( 'Get In Touch', 'recipe-maker' ); ?></h5>
                            <ul class="mt-4">
                            	<li><?php esc_html_e( 'Via Carlo Montù 78', 'recipe-maker' ); ?><br><?php esc_html_e( '22021 Bellagio CO, Italy', 'recipe-maker' ); ?></li>
                            	<li><?php esc_html_e( '+11 6254 7855', 'recipe-maker' ); ?></li>
                            	<li><?php esc_html_e( 'support@example.com', 'recipe-maker' ); ?></li>
                            </ul>
                        </aside>
                    <?php endif; ?>
		        </div>
	      	</div>
		</div>
    	<?php if (get_theme_mod('recipe_maker_show_hide_copyright', true)) {?>
	        <div class="site-info">
	            <div class="footer-menu-left text-center">
	            	<?php  if( ! get_theme_mod('recipe_maker_footer_text_setting') ){ ?>
					    <a target="_blank" href="<?php echo esc_url('https://wordpress.org/', 'recipe-maker' ); ?>">
							<?php
							/* translators: %s: CMS name, i.e. WordPress. */
							printf( esc_html__( 'Proudly powered by %s', 'recipe-maker' ), 'WordPress' );
							?>
					    </a>
					    <span class="sep mr-1"> | </span>

					    <span>
                            <a href="https://www.themagnifico.net/products/free-recipe-wordpress-theme">
    			              	<?php
    			                /* translators: 1: Theme name,  */
    			                printf( esc_html__( ' %1$s ', 'recipe-maker' ),'Recipe WordPress Theme' );
    			              	?>
                            </a>
				          	<?php
				              /* translators: 1: Theme author. */
				              printf( esc_html__( 'by %1$s.', 'recipe-maker' ),'TheMagnifico'  );
				            ?>

	        			</span>
					<?php }?>
					<?php echo esc_html(get_theme_mod('recipe_maker_footer_text_setting')); ?>
	            </div>
	        </div>
		<?php } ?>
	    <?php if(get_theme_mod('recipe_maker_scroll_hide',true)){ ?>
	    	<a id="button"><?php esc_html_e('TOP','recipe-maker'); ?></a>
	    <?php } ?>
    </div>
</footer>
</div>

<?php wp_footer(); ?>

</body>
</html>