function recipe_maker_openNav() {
  jQuery(".sidenav").addClass('show');
}
function recipe_maker_closeNav() {
  jQuery(".sidenav").removeClass('show');
}

( function( window, document ) {
  function recipe_maker_keepFocusInMenu() {
    document.addEventListener( 'keydown', function( e ) {
      const recipe_maker_nav = document.querySelector( '.sidenav' );

      if ( ! recipe_maker_nav || ! recipe_maker_nav.classList.contains( 'show' ) ) {
        return;
      }
      const elements = [...recipe_maker_nav.querySelectorAll( 'input, a, button' )],
        recipe_maker_lastEl = elements[ elements.length - 1 ],
        recipe_maker_firstEl = elements[0],
        recipe_maker_activeEl = document.activeElement,
        tabKey = e.keyCode === 9,
        shiftKey = e.shiftKey;

      if ( ! shiftKey && tabKey && recipe_maker_lastEl === recipe_maker_activeEl ) {
        e.preventDefault();
        recipe_maker_firstEl.focus();
      }

      if ( shiftKey && tabKey && recipe_maker_firstEl === recipe_maker_activeEl ) {
        e.preventDefault();
        recipe_maker_lastEl.focus();
      }
    } );
  }
  recipe_maker_keepFocusInMenu();
} )( window, document );

var recipe_maker_btn = jQuery('#button');

jQuery(window).scroll(function() {
  if (jQuery(window).scrollTop() > 300) {
    recipe_maker_btn.addClass('show');
  } else {
    recipe_maker_btn.removeClass('show');
  }
});

recipe_maker_btn.on('click', function(e) {
  e.preventDefault();
  jQuery('html, body').animate({scrollTop:0}, '300');
});

jQuery(document).ready(function() {
    var owl = jQuery('#top-slider .owl-carousel');
    owl.owlCarousel({
    margin: 0,
    nav:true,
    autoplay : true,
    lazyLoad: true,
    autoplayTimeout: 5000,
    loop: false,
    dots: false,
    navText : ['<i class="fas fa-arrow-left" aria-hidden="true"></i>','<i class="fas fa-arrow-right" aria-hidden="true"></i>'],
    responsive: {
      0: {
        items: 1
      },
      576: {
        items: 1
      },
      768: {
        items: 1
      },
      1000: {
        items: 1
      },
      1200: {
        items: 1
      }
    },
    autoplayHoverPause : false,
    mouseDrag: true
  });
  var owl = jQuery('#top-categories .owl-carousel');
    owl.owlCarousel({
    margin: 30,
    nav:false,
    autoplay : true,
    lazyLoad: true,
    autoplayTimeout: 5000,
    loop: false,
    dots: false,
    navText : ['<i class="fas fa-arrow-left" aria-hidden="true"></i>','<i class="fas fa-arrow-right" aria-hidden="true"></i>'],
    responsive: {
      0: {
        items: 1
      },
      576: {
        items: 1
      },
      768: {
        items: 2
      },
      1000: {
        items: 3
      },
      1200: {
        items: 4
      }
    },
    autoplayHoverPause : false,
    mouseDrag: true,
  });
})

window.addEventListener('load', (event) => {
  jQuery(".loading").delay(2000).fadeOut("slow");
  jQuery(".loading2").delay(2000).fadeOut("slow");
});

function recipe_maker_dealscountdown($timer,mydate, mydatestart){
  // Set the date we're counting down to
  var countDownDate = new Date(mydate).getTime();
  var startingTime = new Date(mydatestart).getTime();
  var totalTime = countDownDate - startingTime
  // Update the count down every 1 second
  var x = setInterval(function() {
    // Get todays date and time
    var now = new Date().getTime();
    // Find the distance between now an the count down date
    var distance = countDownDate - now;
    // Time calculations for days, hours, minutes and seconds
    var days = Math.floor(distance / (1000 * 60 * 60 * 24));
    var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
    var seconds = Math.floor((distance % (1000 * 60)) / 1000);
    // Output the result in an element with id="timer"
    $timer.html(
      "<div class='numbers'>" + days + "</div>  :" +
      "<div class='numbers'>" + hours + "</div> :" +
      "<div class='numbers'>" + minutes + "</div> :" +
      "<div class='numbers'>" + seconds + "</div> "
    );
    
    // If the count down is over, write some text 
    if (distance < 0) {
        clearInterval(x);
        $timer.html("Timer Up -EVENT EXPIRED");
    }

    var per = 100 - ((( now - startingTime ) / totalTime) * 100);

    jQuery('#progress-bar').css('width', `${(per).toFixed(4)}%`)

  }, 1000);
}

jQuery('document').ready(function(){
  jQuery('.count').each(function () {
    jQuery(this).prop('Counter',0).animate({
        Counter: jQuery(this).text()
    }, {
        duration: 8000,
        easing: 'swing',
        step: function (now) {
           jQuery(this).text(Math.ceil(now));
        }
    });
  });   
  var mydate =jQuery('.date').val();
  var mydatestart =jQuery('.date-start').val();
  jQuery(".countdown").each(function(){
    recipe_maker_dealscountdown(jQuery(this),mydate, mydatestart);
  });
});
