jQuery(function($) {

  /* -----------------------------------------
  rtl
  ----------------------------------------- */
    var isRTL = $("html").attr("dir") === "rtl";

    /* -----------------------------------------
    Flash Articles
    ----------------------------------------- */
    $(".flash-article").slick({
        dots: false,
        autoplaySpeed: 3000,
        slidesToShow: 1,
        slidesToScroll: 1,
        rtl: isRTL,
        fade: true,
        arrows: true,
        autoplay: true,
        prevArrow: "<button class='fa fa-angle-left'</button>",
        nextArrow: "<button class='fa fa-angle-right'</button>",
        appendArrows : ".flash-article-section .trend-navigation",
        infinite: true,
        responsive: [
        {
            breakpoint: 701,
            settings: {
                arrows: false,
            },
        },
        ],
    });

    /* -----------------------------------------
  Banner Section
  ----------------------------------------- */
    $(".banner-style-1 .banner-slider").slick({
        dots: false,
        speed: 300,
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false,
        autoplay: false,
        fade: true,
        rtl: isRTL,
        cssEase: "linear",
        infinite: false,
        asNavFor: '.banner-content',
        responsive: [
        {
            breakpoint: 601,
            settings: {
                asNavFor: false,
                appendDots: ".banner-section .banner-image-dots",
                dots: true,
            },
        },
        ],
    });
    $('.banner-content').slick({
        slidesToShow: 3,
        slidesToScroll: 1,
        asNavFor: '.banner-slider',
        dots: false,
        focusOnSelect: true,
        prevArrow: "<button class='fa fa-angle-up'</button>",
        nextArrow: "<button class='fa fa-angle-down'</button>",
        arrows: true,
        vertical: true,
        verticalSwiping: true,
        centerMode: true,
        centerPadding: '0',
    });
    
/* -----------------------------------------
  sticky header
  ----------------------------------------- */
    if ($(".dazzling-blog-navigation").hasClass("sticky-nav")) {
        const header = document.querySelector(".sticky-nav");
        window.onscroll = function () {
            if (window.pageYOffset > 200) {
                header.classList.add("sticky-header");
            } else {
                header.classList.remove("sticky-header");
            }
        };
        $(document).ready(function () {
            var divHeight = $(".dazzling-blog-navigation").height();
            $(".navigation-outer-wrapper").css("min-height", divHeight + "px");
        });
    }


});