<?php 
add_action( 'wp_enqueue_scripts', 'pink_personal_blogily_enqueue_styles' );
function pink_personal_blogily_enqueue_styles() {
	wp_enqueue_style( 'pink_personal_blogily-style', get_template_directory_uri() . '/style.css' ); 
} 
function pink_personal_blogily_customize_register( $wp_customize ) {
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_copyright_control', array(
		'section'     => 'footer_control',
		'settings'    => 'footer_copyright_control',
		) ) );
	$wp_customize->add_setting( 'navigation_border_textcolor', array(
		'default'           => '#F7A9B8',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
		) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'header_background_color', array(
		'label'       => __( 'Navigation Color', 'pink-personal-blogily' ),
		'section'     => 'navigation_settings',
		'priority'   => 1, 
		'settings'    => 'header_background_color',
		) ) );
}
add_action( 'customize_register', 'pink_personal_blogily_customize_register', 999 );

