<?php
/**
 * Theme configuration.
 *
 * @package Pen
 */

defined( 'ABSPATH' ) || die();

if ( ! function_exists( 'pen_configuration' ) ) {
	/**
	 * A list of the theme settings, default values, and sanitizing functions.
	 *
	 * @since Pen 1.0.0
	 * @return array
	 */
	function pen_configuration() {
		return array(
			/* phpcs:disable */
			'pen_preset_color' => array(
				'default' => 'preset_1',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_preset_font' => array(
				'default' => 'preset_1',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_shortcut_menus_back_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_shortcut_menus_front_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_sidebar_header_primary_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_header_primary_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_header_secondary_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_header_secondary_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_search_top_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_search_top_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_search_left_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_search_left_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_search_right_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_search_right_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_search_bottom_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_search_bottom_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_top_animation_reveal' => array(
				'default' => 'slideInDown',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_top_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_left_animation_reveal' => array(
				'default' => 'slideInLeft',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_left_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_content_top_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_content_top_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_content_bottom_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_content_bottom_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_right_animation_reveal' => array(
				'default' => 'slideInRight',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_right_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_bottom_animation_reveal' => array(
				'default' => 'slideInUp',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_bottom_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_footer_top_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_footer_top_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_footer_left_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_footer_left_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_footer_right_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_footer_right_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_footer_bottom_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_footer_bottom_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_mobile_menu_top_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_mobile_menu_top_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_sidebar_mobile_menu_bottom_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_sidebar_mobile_menu_bottom_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_slack_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_site_width' => array(
				'default'  => 'standard',
				'sanitize' => 'pen_sanitize_site_width',
			),
			'pen_sidebar_left_width' => array(
				'default'  => '20%',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_sidebar_right_width' => array(
				'default'  => '20%',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_sidebar_left_sticky' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_sidebar_right_sticky' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_round_corners' => array(
				'default' => array(
					'preset_1' => true,
					'preset_2' => true,
					'preset_3' => true,
					'preset_4' => true,
					'preset_5' => true,
					'preset_6' => true,
					'preset_7' => true,
					'preset_8' => true,
					'preset_9' => true,
					'preset_10' => true,
					'preset_11' => true,
					'preset_12' => true,
					'preset_13' => true,
					'preset_14' => true,
					'preset_15' => true,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_container_position' => array(
				'default' => 'center',
				'sanitize' => 'pen_sanitize_alignment',
			),
			'pen_loading_spinner_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_loading_spinner_style' => array(
				'default' => 1,
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_loading_spinner_text' => array(
				'default' => 'loading',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_list_page_header_animation_reveal' => array(
				'default' => 'fadeInUp',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_list_page_header_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_list_animation_reveal' => array(
				'default' => 'flipInY',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_list_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_list_effect' => array(
				'default' => 'none',
				'sanitize' => 'pen_sanitize_list_effect',
			),
			'pen_list_type' => array(
				'default' => 'masonry',
				'sanitize' => 'pen_sanitize_list_type',
			),
			'pen_list_infinite_scrolling' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_infinite_scrolling_allow_stop' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_tile_columns' => array(
				'default' => 4,
				'sanitize' => 'pen_sanitize_tile_columns',
			),
			'pen_list_tile_thumbnail_effect' => array(
				'default' => 'none',
				'sanitize' => 'pen_sanitize_tile_thumbnail_effect',
			),
			'pen_list_tile_thumbnail_style' => array(
				'default' => array(
					'preset_1' => 1,
					'preset_2' => 1,
					'preset_3' => 1,
					'preset_4' => 1,
					'preset_5' => 1,
					'preset_6' => 1,
					'preset_7' => 1,
					'preset_8' => 1,
					'preset_9' => 1,
					'preset_10' => 1,
					'preset_11' => 1,
					'preset_12' => 1,
					'preset_13' => 1,
					'preset_14' => 1,
					'preset_15' => 1,
					'preset_16' => 0,
					'preset_17' => 0,
					'preset_18' => 0,
					'preset_19' => 0,
					'preset_20' => 0,
				),
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_list_masonry_columns' => array(
				'default' => 4,
				'sanitize' => 'pen_sanitize_masonry_columns',
			),
			'pen_list_masonry_thumbnail_effect' => array(
				'default' => 'none',
				'sanitize' => 'pen_sanitize_masonry_thumbnail_effect',
			),
			'pen_list_masonry_thumbnail_style' => array(
				'default' => array(
					'preset_1' => 1,
					'preset_2' => 1,
					'preset_3' => 1,
					'preset_4' => 1,
					'preset_5' => 1,
					'preset_6' => 1,
					'preset_7' => 1,
					'preset_8' => 1,
					'preset_9' => 1,
					'preset_10' => 1,
					'preset_11' => 1,
					'preset_12' => 1,
					'preset_13' => 1,
					'preset_14' => 1,
					'preset_15' => 1,
					'preset_16' => 0,
					'preset_17' => 0,
					'preset_18' => 0,
					'preset_19' => 0,
					'preset_20' => 0,
				),
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_list_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_header_alignment' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_header_icon' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_title_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_list_title_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_list_title_alignment' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_title_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_author_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_author_avatar_style' => array(
				'default' => 1,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_list_author_name_link' => array(
				'default' => PEN_THEME_PREVIEW ? 'archive' : 'website',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_list_author_avatar_link' => array(
				'default' => 'website',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_list_author_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_list_author_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_list_date_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_date_updated_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_category_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_category_only_first' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_thumbnail_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_thumbnail_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_list_thumbnail_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_list_thumbnail_rotate' => array(
				'default' => array(
					'preset_1' => true,
					'preset_2' => true,
					'preset_3' => true,
					'preset_4' => true,
					'preset_5' => true,
					'preset_6' => true,
					'preset_7' => true,
					'preset_8' => true,
					'preset_9' => true,
					'preset_10' => true,
					'preset_11' => true,
					'preset_12' => true,
					'preset_13' => true,
					'preset_14' => true,
					'preset_15' => true,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_thumbnail_alignment' => array(
				'default' => 'right',
				'sanitize' => 'pen_sanitize_alignment',
			),
			'pen_list_thumbnail_frame' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_thumbnail_resize' => array(
				'default' => 'large',
				'sanitize' => 'pen_sanitize_thumbnail_resize',
			),
			'pen_list_summary_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_excerpt' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_profile_display' => array(
				'default' => PEN_THEME_PREVIEW ? true : false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_footer_display' => array(
				'default' => PEN_THEME_PREVIEW ? true : false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_tags_display' => array(
				'default' => PEN_THEME_PREVIEW ? true : false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_button_comment_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_button_edit_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_button_read_more_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_list_button_read_more_type' => array(
				'default' => 'button',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_list_button_read_more_text' => array(
				'default' => 'continue_reading',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_list_button_read_more_icon' => array(
				'default' => 'arrow_double',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_list_author_location' => array(
				'default' => 'header',
				'sanitize' => 'pen_sanitize_location',
			),
			'pen_list_date_location' => array(
				'default' => 'header',
				'sanitize' => 'pen_sanitize_location',
			),
			'pen_list_category_location' => array(
				'default' => 'header',
				'sanitize' => 'pen_sanitize_location',
			),
			'pen_list_pager_animation_reveal' => array(
				'default' => 'fadeInDown',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_list_pager_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_content_animation_reveal' => array(
				'default' => 'fadeInDown',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_content_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_content_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_header_alignment' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_title_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_content_title_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_content_title_alignment' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_title_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_author_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_author_avatar_style' => array(
				'default' => 1,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_content_author_name_link' => array(
				'default' => 'archive',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_content_author_avatar_link' => array(
				'default' => 'archive',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_content_author_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_content_author_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_content_date_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_date_updated_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_category_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_category_only_first' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_details_separator' => array(
				'default' => 1,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_content_thumbnail_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_thumbnail_animation_reveal' => array(
				'default' => 'swing',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_content_thumbnail_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_content_thumbnail_rotate' => array(
				'default' => array(
					'preset_1' => true,
					'preset_2' => true,
					'preset_3' => true,
					'preset_4' => true,
					'preset_5' => true,
					'preset_6' => true,
					'preset_7' => true,
					'preset_8' => true,
					'preset_9' => true,
					'preset_10' => true,
					'preset_11' => true,
					'preset_12' => true,
					'preset_13' => true,
					'preset_14' => true,
					'preset_15' => true,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_thumbnail_alignment' => array(
				'default' => 'right',
				'sanitize' => 'pen_sanitize_alignment',
			),
			'pen_content_thumbnail_frame' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_thumbnail_resize' => array(
				'default' => 'medium',
				'sanitize' => 'pen_sanitize_thumbnail_resize',
			),
			'pen_content_profile_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_tags_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_share_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_button_edit_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_author_location' => array(
				'default' => 'header',
				'sanitize' => 'pen_sanitize_location',
			),
			'pen_content_date_location' => array(
				'default' => 'header',
				'sanitize' => 'pen_sanitize_location',
			),
			'pen_content_category_location' => array(
				'default' => 'header',
				'sanitize' => 'pen_sanitize_location',
			),
			'pen_content_share_location' => array(
				'default' => 'content',
				'sanitize' => 'pen_sanitize_location',
			),
			'pen_content_settings_overview_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_pager_animation_reveal' => array(
				'default' => 'fadeInDown',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_content_pager_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_content_previous_display' => array(
				'default' => PEN_THEME_PREVIEW ? true : false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_next_display' => array(
				'default' => PEN_THEME_PREVIEW ? true : false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_next_previous_only_similar' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_content_next_previous_type' => array(
				'default' => PEN_THEME_PREVIEW ? 'link' : 'button',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_content_next_previous_icon' => array(
				'default' => 'arrow',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_content_next_text' => array(
				'default' => PEN_THEME_PREVIEW ? 'next_and_title' : 'next',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_content_previous_text' => array(
				'default' => PEN_THEME_PREVIEW ? 'previous_and_title' : 'previous',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_content_next_previous_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_content_next_previous_animation_delay_reveal' => array(
				'default' => 1,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_content_previous_animation_reveal' => array(
				'default' => 'fadeInRight',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_content_previous_animation_delay_reveal' => array(
				'default' => 1,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_content_next_animation_reveal' => array(
				'default' => 'fadeInLeft',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_content_next_animation_delay_reveal' => array(
				'default' => 1,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_comments_animation_reveal' => array(
				'default' => 'fadeInUp',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_comments_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_cart_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_cart_header_animation_reveal' => array(
				'default' => 'slideInRight',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_cart_header_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_cart_navigation_include' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_cart_footer_menu_include' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_cart_products_related_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_cart_upsells_per_product' => array(
				'default' => 4,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_cart_upsells_columns' => array(
				'default' => 4,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_content_per_page_products' => array(
				'default' => 12,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_front_sidebar_header_primary_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_header_secondary_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_search_top_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_search_left_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_search_right_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_search_bottom_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_top_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_left_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_right_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_content_top_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_content_bottom_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_bottom_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_footer_top_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_footer_left_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_footer_right_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_footer_bottom_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_mobile_menu_top_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_front_sidebar_mobile_menu_bottom_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_dark_mode' => array(
				'default' => 'none',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_dark_mode_allow_switch' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_dark_mode_switch_location' => array(
				'default' => 'right',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_text' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#ffffff',
					'preset_3' => '#ffffff',
					'preset_4' => '#ffffff',
					'preset_5' => '#ffffff',
					'preset_6' => '#ffffff',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffffff',
					'preset_9' => '#ffffff',
					'preset_10' => '#ffffff',
					'preset_11' => '#ffffff',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#ffffff',
					'preset_16' => '#333333',
					'preset_17' => '#eeeeee',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_shadow' => array(
				'default' => array(
					'preset_1' => '#000000',
					'preset_2' => '#000000',
					'preset_3' => '#000000',
					'preset_4' => '#000000',
					'preset_5' => '#000000',
					'preset_6' => '#000000',
					'preset_7' => '#000000',
					'preset_8' => '#000000',
					'preset_9' => '#000000',
					'preset_10' => '#000000',
					'preset_11' => '#000000',
					'preset_12' => '#000000',
					'preset_13' => '#000000',
					'preset_14' => '#000000',
					'preset_15' => '#000000',
					'preset_16' => '#000000',
					'preset_17' => '#ffffff',
					'preset_18' => '#000000',
					'preset_19' => '#000000',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_site_shadow_display' => array(
				'default' => array(
					'preset_1' => true,
					'preset_2' => true,
					'preset_3' => true,
					'preset_4' => true,
					'preset_5' => true,
					'preset_6' => true,
					'preset_7' => true,
					'preset_8' => true,
					'preset_9' => true,
					'preset_10' => true,
					'preset_11' => false,
					'preset_12' => false,
					'preset_13' => false,
					'preset_14' => false,
					'preset_15' => false,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_color_site_background' => array(
				'default' => array(
					'preset_1' => '#333333',
					'preset_2' => '#222222',
					'preset_3' => '#000b0d',
					'preset_4' => '#03000a',
					'preset_5' => '#001b3b',
					'preset_6' => '#4a004a',
					'preset_7' => '#111111',
					'preset_8' => '#f2def1',
					'preset_9' => '#0c0e00',
					'preset_10' => '#777777',
					'preset_11' => '#0d1f1c',
					'preset_12' => '#000000',
					'preset_13' => '#444444',
					'preset_14' => '#00050a',
					'preset_15' => '#001f4a',
					'preset_16' => '#efefef',
					'preset_17' => '#333333',
					'preset_18' => '#325d79',
					'preset_19' => '#521e39',
					'preset_20' => '#1e0c31',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_site_background_effect' => array(
				'default' => array(
					'preset_1' => ( PEN_THEME_PREVIEW && gmdate( 'i' ) % 2 ) ? 'shards' : 'trianglify',
					'preset_2' => 'shards',
					'preset_3' => 'trianglify',
					'preset_4' => 'shards',
					'preset_5' => 'trianglify',
					'preset_6' => 'shards',
					'preset_7' => 'trianglify',
					'preset_8' => 'shards',
					'preset_9' => 'trianglify',
					'preset_10' => 'shards',
					'preset_11' => 'trianglify',
					'preset_12' => 'shards',
					'preset_13' => 'trianglify',
					'preset_14' => 'shards',
					'preset_15' => 'trianglify',
					'preset_16' => 'none',
					'preset_17' => 'none',
					'preset_18' => 'none',
					'preset_19' => 'none',
					'preset_20' => 'none',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_link' => array(
				'default' => array(
					'preset_1' => '#005ce4',
					'preset_2' => '#de5e00',
					'preset_3' => '#007773',
					'preset_4' => '#7100e2',
					'preset_5' => '#0071c7',
					'preset_6' => '#8c538c',
					'preset_7' => '#ff404a',
					'preset_8' => '#ca43c2',
					'preset_9' => '#729800',
					'preset_10' => '#d29d00',
					'preset_11' => '#005b54',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ec712a',
					'preset_14' => '#278eff',
					'preset_15' => '#00a9ff',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_link_hover' => array(
				'default' => array(
					'preset_1' => '#800080',
					'preset_2' => '#b74d00',
					'preset_3' => '#00aba5',
					'preset_4' => '#8d1cff',
					'preset_5' => '#007fe0',
					'preset_6' => '#7f447f',
					'preset_7' => '#ff404a',
					'preset_8' => '#d22dc9',
					'preset_9' => '#a0c11d',
					'preset_10' => '#ffaa00',
					'preset_11' => '#009f92',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ec712a',
					'preset_14' => '#008af0',
					'preset_15' => '#093a89',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#f9a26c',
					'preset_19' => '#f99e4c',
					'preset_20' => '#f67280',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_button_text' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#ffffff',
					'preset_3' => '#ffffff',
					'preset_4' => '#ffffff',
					'preset_5' => '#ffffff',
					'preset_6' => '#ffffff',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffffff',
					'preset_9' => '#ffffff',
					'preset_10' => '#ffffff',
					'preset_11' => '#142d29',
					'preset_12' => '#000000',
					'preset_13' => '#000000',
					'preset_14' => '#000000',
					'preset_15' => '#ffffff',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_button_background_primary' => array(
				'default' => array(
					'preset_1' => '#00a9ff',
					'preset_2' => '#ff5100',
					'preset_3' => '#007385',
					'preset_4' => '#34004c',
					'preset_5' => '#1a74c7',
					'preset_6' => '#a800a8',
					'preset_7' => '#ff404a',
					'preset_8' => '#d437ca',
					'preset_9' => '#7c9b04',
					'preset_10' => '#222222',
					'preset_11' => '#00d3cf',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ec712a',
					'preset_14' => '#ffca00',
					'preset_15' => '#1a74cc',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_button_background_secondary' => array(
				'default' => array(
					'preset_1' => '#093a89',
					'preset_2' => '#8c2a00',
					'preset_3' => '#00252b',
					'preset_4' => '#200027',
					'preset_5' => '#000e4f',
					'preset_6' => '#4a004a',
					'preset_7' => '#700000',
					'preset_8' => '#a71b9f',
					'preset_9' => '#0c0f02',
					'preset_10' => '#000000',
					'preset_11' => '#00d3cf',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ec712a',
					'preset_14' => '#ffca00',
					'preset_15' => '#1a74cc',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_button_background_angle' => array(
				'default' => array(
					'preset_1' => 'to bottom',
					'preset_2' => 'to bottom',
					'preset_3' => 'to bottom',
					'preset_4' => 'to bottom',
					'preset_5' => 'to bottom',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => 'to bottom',
					'preset_10' => 'to bottom',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_button_border' => array(
				'default' => array(
					'preset_1' => '#093a89',
					'preset_2' => '#000000',
					'preset_3' => '#00252b',
					'preset_4' => '#000000',
					'preset_5' => '#000e4f',
					'preset_6' => '#333333',
					'preset_7' => '#300000',
					'preset_8' => '#a71b9f',
					'preset_9' => '#0c0f02',
					'preset_10' => '#000000',
					'preset_11' => '#00d3cf',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ec712a',
					'preset_14' => '#ffca00',
					'preset_15' => '#1a74cc',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_loading_spinner_text' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#ffffff',
					'preset_3' => '#ffffff',
					'preset_4' => '#ffffff',
					'preset_5' => '#ffffff',
					'preset_6' => '#ffffff',
					'preset_7' => '#ffffff',
					'preset_8' => '#ca43c2',
					'preset_9' => '#ffffff',
					'preset_10' => '#ffffff',
					'preset_11' => '#ffffff',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#ffffff',
					'preset_16' => '#333333',
					'preset_17' => '#ffffff',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffffff',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_loading_spinner_primary' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#de5e00',
					'preset_3' => '#007773',
					'preset_4' => '#7100e2',
					'preset_5' => '#0071c7',
					'preset_6' => '#8c538c',
					'preset_7' => '#f00000',
					'preset_8' => '#ca43c2',
					'preset_9' => '#729800',
					'preset_10' => '#d29d00',
					'preset_11' => '#00d3cf',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ec712a',
					'preset_14' => '#278eff',
					'preset_15' => '#00a9ff',
					'preset_16' => '#005ce4',
					'preset_17' => '#ffffff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_loading_spinner_secondary' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#de5e00',
					'preset_3' => '#007773',
					'preset_4' => '#7100e2',
					'preset_5' => '#0071c7',
					'preset_6' => '#8c538c',
					'preset_7' => '#ff404a',
					'preset_8' => '#ca43c2',
					'preset_9' => '#729800',
					'preset_10' => '#d29d00',
					'preset_11' => '#005b54',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ec712a',
					'preset_14' => '#278eff',
					'preset_15' => '#00a9ff',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#0b3d5f',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_loading_spinner_background_primary' => array(
				'default' => array(
					'preset_1' => '#000000',
					'preset_2' => '#222222',
					'preset_3' => '#000b0d',
					'preset_4' => '#03000a',
					'preset_5' => '#001b3b',
					'preset_6' => '#4a004a',
					'preset_7' => '#111111',
					'preset_8' => '#f2def1',
					'preset_9' => '#0c0e00',
					'preset_10' => '#000000',
					'preset_11' => '#0d1f1c',
					'preset_12' => '#000000',
					'preset_13' => '#444444',
					'preset_14' => '#00050a',
					'preset_15' => '#001f4a',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#0b3d5f',
					'preset_19' => '#582841',
					'preset_20' => '#43008c',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_loading_spinner_background_secondary' => array(
				'default' => array(
					'preset_1' => '#000000',
					'preset_2' => '#222222',
					'preset_3' => '#000b0d',
					'preset_4' => '#03000a',
					'preset_5' => '#001b3b',
					'preset_6' => '#4a004a',
					'preset_7' => '#111111',
					'preset_8' => '#f2def1',
					'preset_9' => '#0c0e00',
					'preset_10' => '#777777',
					'preset_11' => '#0d1f1c',
					'preset_12' => '#000000',
					'preset_13' => '#444444',
					'preset_14' => '#00050a',
					'preset_15' => '#001f4a',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#0b3d5f',
					'preset_19' => '#582841',
					'preset_20' => '#43008c',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_loading_spinner_background_angle' => array(
				'default' => array(
					'preset_1' => '125deg',
					'preset_2' => '125deg',
					'preset_3' => '125deg',
					'preset_4' => '125deg',
					'preset_5' => '125deg',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => '125deg',
					'preset_10' => '125deg',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_header_background_transparent' => array(
				'default' => array(
					'preset_1' => false,
					'preset_2' => false,
					'preset_3' => false,
					'preset_4' => false,
					'preset_5' => false,
					'preset_6' => false,
					'preset_7' => false,
					'preset_8' => false,
					'preset_9' => false,
					'preset_10' => false,
					'preset_11' => false,
					'preset_12' => false,
					'preset_13' => false,
					'preset_14' => false,
					'preset_15' => false,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_color_header_background_primary' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#101010',
					'preset_3' => '#001f24',
					'preset_4' => '#080019',
					'preset_5' => '#001a42',
					'preset_6' => '#fff2ff',
					'preset_7' => '#000000',
					'preset_8' => '#ffddfd',
					'preset_9' => '#000000',
					'preset_10' => '#ffe400',
					'preset_11' => '#00d3cf',
					'preset_12' => '#000000',
					'preset_13' => '#cc4a00',
					'preset_14' => '#000000',
					'preset_15' => '#001a4a',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#0b3d5f',
					'preset_19' => '#582841',
					'preset_20' => '#43008c',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_background_secondary' => array(
				'default' => array(
					'preset_1' => '#dddddd',
					'preset_2' => '#000000',
					'preset_3' => '#00121a',
					'preset_4' => '#0c001c',
					'preset_5' => '#003078',
					'preset_6' => '#eacaea',
					'preset_7' => '#111111',
					'preset_8' => '#fff5fe',
					'preset_9' => '#3b4d11',
					'preset_10' => '#ffe400',
					'preset_11' => '#00d3cf',
					'preset_12' => '#000000',
					'preset_13' => '#cc4a00',
					'preset_14' => '#000000',
					'preset_15' => '#001a4a',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#0b3d5f',
					'preset_19' => '#582841',
					'preset_20' => '#43008c',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_background_angle' => array(
				'default' => array(
					'preset_1' => '125deg',
					'preset_2' => '125deg',
					'preset_3' => '125deg',
					'preset_4' => '125deg',
					'preset_5' => '125deg',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => '125deg',
					'preset_10' => '125deg',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_header_text' => array(
				'default' => array(
					'preset_1' => '#333333',
					'preset_2' => '#eeeeee',
					'preset_3' => '#b0f4ff',
					'preset_4' => '#deb8f9',
					'preset_5' => '#b0f4ff',
					'preset_6' => '#5f2d5f',
					'preset_7' => '#dddddd',
					'preset_8' => '#d437ca',
					'preset_9' => '#ffffff',
					'preset_10' => '#444444',
					'preset_11' => '#004f4b',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#333333',
					'preset_16' => '#333333',
					'preset_17' => '#eeeeee',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_link' => array(
				'default' => array(
					'preset_1' => '#555555',
					'preset_2' => '#de7e00',
					'preset_3' => '#b0f4ff',
					'preset_4' => '#deb8f9',
					'preset_5' => '#ffe000',
					'preset_6' => '#5f2d5f',
					'preset_7' => '#ffffff',
					'preset_8' => '#a71b9f',
					'preset_9' => '#f5ff83',
					'preset_10' => '#000000',
					'preset_11' => '#004f4b',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ffffff',
					'preset_14' => '#278eff',
					'preset_15' => '#00a9ff',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#9bd7d1',
					'preset_19' => '#ef4648',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_link_hover' => array(
				'default' => array(
					'preset_1' => '#333333',
					'preset_2' => '#de5e00',
					'preset_3' => '#ffffff',
					'preset_4' => '#ffffff',
					'preset_5' => '#fffc00',
					'preset_6' => '#5f2d5f',
					'preset_7' => '#ff404a',
					'preset_8' => '#ca43c2',
					'preset_9' => '#edff25',
					'preset_10' => '#444444',
					'preset_11' => '#004f4b',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ffffff',
					'preset_14' => '#008af0',
					'preset_15' => '#00a9ff',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#efeeee',
					'preset_19' => '#f36f38',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_sitetitle' => array(
				'default' => array(
					'preset_1' => '#555555',
					'preset_2' => '#dddddd',
					'preset_3' => '#b0f4ff',
					'preset_4' => '#c8bcff',
					'preset_5' => '#b0daff',
					'preset_6' => '#5f2d5f',
					'preset_7' => '#dddddd',
					'preset_8' => '#a71b9f',
					'preset_9' => '#a0c11d',
					'preset_10' => '#333333',
					'preset_11' => '#ffffff',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#ffffff',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_sitetitle_hover' => array(
				'default' => array(
					'preset_1' => '#333333',
					'preset_2' => '#ffffff',
					'preset_3' => '#ffffff',
					'preset_4' => '#ffffff',
					'preset_5' => '#b0daff',
					'preset_6' => '#7b407b',
					'preset_7' => '#ffffff',
					'preset_8' => '#ca43c2',
					'preset_9' => '#caed3c',
					'preset_10' => '#444444',
					'preset_11' => '#ffffff',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#ffffff',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_sitedescription' => array(
				'default' => array(
					'preset_1' => '#555555',
					'preset_2' => '#de7e00',
					'preset_3' => '#b0f4ff',
					'preset_4' => '#deb8f9',
					'preset_5' => '#7b9cce',
					'preset_6' => '#5f2d5f',
					'preset_7' => '#aaaaaa',
					'preset_8' => '#a71b9f',
					'preset_9' => '#a0c11d',
					'preset_10' => '#555555',
					'preset_11' => '#004f4b',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#ffffff',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_sitedescription_hover' => array(
				'default' => array(
					'preset_1' => '#333333',
					'preset_2' => '#de9b00',
					'preset_3' => '#ffffff',
					'preset_4' => '#ffffff',
					'preset_5' => '#7b9cce',
					'preset_6' => '#5f2d5f',
					'preset_7' => '#ff404a',
					'preset_8' => '#ca43c2',
					'preset_9' => '#caed3c',
					'preset_10' => '#000000',
					'preset_11' => '#004f4b',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#ffffff',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_phone' => array(
				'default' => array(
					'preset_1' => '#555555',
					'preset_2' => '#de7e00',
					'preset_3' => '#b0f4ff',
					'preset_4' => '#deb8f9',
					'preset_5' => '#96d5ff',
					'preset_6' => '#5f2d5f',
					'preset_7' => '#aaaaaa',
					'preset_8' => '#a71b9f',
					'preset_9' => '#caed3c',
					'preset_10' => '#444444',
					'preset_11' => '#004f4b',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#ffffff',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_phone_hover' => array(
				'default' => array(
					'preset_1' => '#333333',
					'preset_2' => '#de5e00',
					'preset_3' => '#ffffff',
					'preset_4' => '#ffffff',
					'preset_5' => '#ffffff',
					'preset_6' => '#5f2d5f',
					'preset_7' => '#ffffff',
					'preset_8' => '#ca43c2',
					'preset_9' => '#a0c11d',
					'preset_10' => '#000000',
					'preset_11' => '#004f4b',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#ffffff',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_text_shadow' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#000000',
					'preset_3' => '#000000',
					'preset_4' => '#000000',
					'preset_5' => '#000000',
					'preset_6' => '#000000',
					'preset_7' => '#000000',
					'preset_8' => '#000000',
					'preset_9' => '#000000',
					'preset_10' => '#000000',
					'preset_11' => '#ffffff',
					'preset_12' => '#000000',
					'preset_13' => '#000000',
					'preset_14' => '#000000',
					'preset_15' => '#000000',
					'preset_16' => '#000000',
					'preset_17' => '#ffffff',
					'preset_18' => '#000000',
					'preset_19' => '#000000',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_text_shadow_display' => array(
				'default' => array(
					'preset_1' => true,
					'preset_2' => true,
					'preset_3' => true,
					'preset_4' => true,
					'preset_5' => true,
					'preset_6' => false,
					'preset_7' => true,
					'preset_8' => false,
					'preset_9' => true,
					'preset_10' => false,
					'preset_11' => false,
					'preset_12' => false,
					'preset_13' => false,
					'preset_14' => false,
					'preset_15' => false,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_color_header_field_background_primary' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#303030',
					'preset_3' => '#a7f4ff',
					'preset_4' => '#1f1b58',
					'preset_5' => '#031c4f',
					'preset_6' => '#753775',
					'preset_7' => '#303030',
					'preset_8' => '#ffe0fd',
					'preset_9' => '#020300',
					'preset_10' => '#fff283',
					'preset_11' => '#009f92',
					'preset_12' => '#333333',
					'preset_13' => '#ffffff',
					'preset_14' => '#333333',
					'preset_15' => '#000000',
					'preset_16' => '#ffffff',
					'preset_17' => '#111111',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_field_background_secondary' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#333333',
					'preset_3' => '#c8f7ff',
					'preset_4' => '#311a8c',
					'preset_5' => '#031c4f',
					'preset_6' => '#753775',
					'preset_7' => '#3f3f3f',
					'preset_8' => '#ffe0fd',
					'preset_9' => '#1e2b00',
					'preset_10' => '#fff283',
					'preset_11' => '#009f92',
					'preset_12' => '#333333',
					'preset_13' => '#ffffff',
					'preset_14' => '#333333',
					'preset_15' => '#000000',
					'preset_16' => '#ffffff',
					'preset_17' => '#111111',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_field_background_angle' => array(
				'default' => array(
					'preset_1' => 'to bottom',
					'preset_2' => 'to bottom',
					'preset_3' => 'to bottom',
					'preset_4' => 'to bottom',
					'preset_5' => 'to bottom',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => 'to bottom',
					'preset_10' => 'to bottom',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_header_field_text' => array(
				'default' => array(
					'preset_1' => '#333333',
					'preset_2' => '#eeeeee',
					'preset_3' => '#333333',
					'preset_4' => '#d5ccff',
					'preset_5' => '#a1d3ec',
					'preset_6' => '#f3dbf3',
					'preset_7' => '#aaaaaa',
					'preset_8' => '#b422ab',
					'preset_9' => '#e8fabe',
					'preset_10' => '#333333',
					'preset_11' => '#ffffff',
					'preset_12' => '#aaaaaa',
					'preset_13' => '#555555',
					'preset_14' => '#aaaaaa',
					'preset_15' => '#ffffff',
					'preset_16' => '#000000',
					'preset_17' => '#ffffff',
					'preset_18' => '#000000',
					'preset_19' => '#000000',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_search_background_primary' => array(
				'default' => array(
					'preset_1' => '#00a9ff',
					'preset_2' => '#ff2700',
					'preset_3' => '#007385',
					'preset_4' => '#1e0057',
					'preset_5' => '#003694',
					'preset_6' => '#a800a8',
					'preset_7' => '#1f1f1f',
					'preset_8' => '#d024c8',
					'preset_9' => '#5f7800',
					'preset_10' => '#333333',
					'preset_11' => '#005e5c',
					'preset_12' => '#00b7ff',
					'preset_13' => '#000000',
					'preset_14' => '#285d9d',
					'preset_15' => '#1a74cc',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_search_background_secondary' => array(
				'default' => array(
					'preset_1' => '#093a89',
					'preset_2' => '#3c0c00',
					'preset_3' => '#00252b',
					'preset_4' => '#060021',
					'preset_5' => '#001936',
					'preset_6' => '#333333',
					'preset_7' => '#0f0f0f',
					'preset_8' => '#a71b9f',
					'preset_9' => '#5f7800',
					'preset_10' => '#000000',
					'preset_11' => '#005e5c',
					'preset_12' => '#00b7ff',
					'preset_13' => '#000000',
					'preset_14' => '#285d9d',
					'preset_15' => '#1a74cc',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_search_background_angle' => array(
				'default' => array(
					'preset_1' => 'to bottom',
					'preset_2' => 'to bottom',
					'preset_3' => 'to bottom',
					'preset_4' => 'to bottom',
					'preset_5' => 'to bottom',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => 'to bottom',
					'preset_10' => 'to bottom',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_header_search_text' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#ffffff',
					'preset_3' => '#ffffff',
					'preset_4' => '#ffffff',
					'preset_5' => '#ffffff',
					'preset_6' => '#ffffff',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffffff',
					'preset_9' => '#ffffff',
					'preset_10' => '#ffffff',
					'preset_11' => '#ffffff',
					'preset_12' => '#000000',
					'preset_13' => '#ffffff',
					'preset_14' => '#d1deec',
					'preset_15' => '#ffffff',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_cart_header_button_background_primary' => array(
				'default' => array(
					'preset_1' => '#00a9ff',
					'preset_2' => '#ff2700',
					'preset_3' => '#007385',
					'preset_4' => '#1e0057',
					'preset_5' => '#003694',
					'preset_6' => '#a800a8',
					'preset_7' => '#1f1f1f',
					'preset_8' => '#d024c8',
					'preset_9' => '#5f7800',
					'preset_10' => '#333333',
					'preset_11' => '#005e5c',
					'preset_12' => '#00b7ff',
					'preset_13' => '#000000',
					'preset_14' => '#285d9d',
					'preset_15' => '#1a74cc',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_cart_header_button_background_secondary' => array(
				'default' => array(
					'preset_1' => '#093a89',
					'preset_2' => '#3c0c00',
					'preset_3' => '#00252b',
					'preset_4' => '#060021',
					'preset_5' => '#001936',
					'preset_6' => '#333333',
					'preset_7' => '#0f0f0f',
					'preset_8' => '#a71b9f',
					'preset_9' => '#5f7800',
					'preset_10' => '#000000',
					'preset_11' => '#005e5c',
					'preset_12' => '#00b7ff',
					'preset_13' => '#000000',
					'preset_14' => '#285d9d',
					'preset_15' => '#1a74cc',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_cart_header_button_background_angle' => array(
				'default' => array(
					'preset_1' => 'to bottom',
					'preset_2' => 'to bottom',
					'preset_3' => 'to bottom',
					'preset_4' => 'to bottom',
					'preset_5' => 'to bottom',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => 'to bottom',
					'preset_10' => 'to bottom',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_cart_header_button_text' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#ffffff',
					'preset_3' => '#ffffff',
					'preset_4' => '#ffffff',
					'preset_5' => '#ffffff',
					'preset_6' => '#ffffff',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffffff',
					'preset_9' => '#ffffff',
					'preset_10' => '#ffffff',
					'preset_11' => '#ffffff',
					'preset_12' => '#000000',
					'preset_13' => '#ffffff',
					'preset_14' => '#d1deec',
					'preset_15' => '#ffffff',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_cart_header_content_background_primary' => array(
				'default' => array(
					'preset_1' => '#004d98',
					'preset_2' => '#1c1c1c',
					'preset_3' => '#001a21',
					'preset_4' => '#17002f',
					'preset_5' => '#ffbc00',
					'preset_6' => '#f7e7f7',
					'preset_7' => '#a00000',
					'preset_8' => '#a71b9f',
					'preset_9' => '#a0c11d',
					'preset_10' => '#333333',
					'preset_11' => '#005e5c',
					'preset_12' => '#303030',
					'preset_13' => '#000000',
					'preset_14' => '#007cbf',
					'preset_15' => '#000b29',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#000000',
					'preset_19' => '#ffd7df',
					'preset_20' => '#2e055a',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_cart_header_content_background_secondary' => array(
				'default' => array(
					'preset_1' => '#004d98',
					'preset_2' => '#1c1c1c',
					'preset_3' => '#001a21',
					'preset_4' => '#221158',
					'preset_5' => '#ffbc00',
					'preset_6' => '#f7e7f7',
					'preset_7' => '#ff404a',
					'preset_8' => '#a71b9f',
					'preset_9' => '#a0c11d',
					'preset_10' => '#222222',
					'preset_11' => '#005e5c',
					'preset_12' => '#303030',
					'preset_13' => '#000000',
					'preset_14' => '#007cbf',
					'preset_15' => '#001a4a',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#000000',
					'preset_19' => '#ffd7df',
					'preset_20' => '#2e055a',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_cart_header_content_background_angle' => array(
				'default' => array(
					'preset_1' => '125deg',
					'preset_2' => 'to bottom',
					'preset_3' => '125deg',
					'preset_4' => '125deg',
					'preset_5' => '125deg',
					'preset_6' => '125deg',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => '125deg',
					'preset_10' => '125deg',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_cart_header_content_text' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#eeeeee',
					'preset_3' => '#ffffff',
					'preset_4' => '#e2d8ff',
					'preset_5' => '#ffffff',
					'preset_6' => '#841c84',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffffff',
					'preset_9' => '#ffffff',
					'preset_10' => '#aaaaaa',
					'preset_11' => '#aadada',
					'preset_12' => '#eeeeee',
					'preset_13' => '#ffffff',
					'preset_14' => '#333333',
					'preset_15' => '#ffffff',
					'preset_16' => '#333333',
					'preset_17' => '#ffffff',
					'preset_18' => '#ffffff',
					'preset_19' => '#333333',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_cart_header_content_link' => array(
				'default' => array(
					'preset_1' => '#deeeff',
					'preset_2' => '#de7e00',
					'preset_3' => '#b0f4ff',
					'preset_4' => '#bbaaf7',
					'preset_5' => '#005d9e',
					'preset_6' => '#8c448c',
					'preset_7' => '#f3dddd',
					'preset_8' => '#ffffff',
					'preset_9' => '#212e02',
					'preset_10' => '#ffcc00',
					'preset_11' => '#ffffff',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#333333',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff7412',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_cart_header_content_link_hover' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#d98d00',
					'preset_3' => '#ffffff',
					'preset_4' => '#f3edff',
					'preset_5' => '#ffffff',
					'preset_6' => '#ab55ab',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffd800',
					'preset_9' => '#415d00',
					'preset_10' => '#ffee00',
					'preset_11' => '#ffffff',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ec712a',
					'preset_14' => '#ffffff',
					'preset_15' => '#000000',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff7412',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_button_users_background_primary' => array(
				'default' => array(
					'preset_1' => '#00a9ff',
					'preset_2' => '#ff2700',
					'preset_3' => '#007385',
					'preset_4' => '#1e0057',
					'preset_5' => '#003694',
					'preset_6' => '#a800a8',
					'preset_7' => '#1f1f1f',
					'preset_8' => '#d024c8',
					'preset_9' => '#7c9b00',
					'preset_10' => '#333333',
					'preset_11' => '#005e5c',
					'preset_12' => '#00b7ff',
					'preset_13' => '#000000',
					'preset_14' => '#285d9d',
					'preset_15' => '#1a74cc',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_button_users_background_secondary' => array(
				'default' => array(
					'preset_1' => '#093a89',
					'preset_2' => '#3c0c00',
					'preset_3' => '#00252b',
					'preset_4' => '#060021',
					'preset_5' => '#001936',
					'preset_6' => '#333333',
					'preset_7' => '#0f0f0f',
					'preset_8' => '#a71b9f',
					'preset_9' => '#5f7800',
					'preset_10' => '#000000',
					'preset_11' => '#005e5c',
					'preset_12' => '#00b7ff',
					'preset_13' => '#000000',
					'preset_14' => '#285d9d',
					'preset_15' => '#1a74cc',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_header_button_users_background_angle' => array(
				'default' => array(
					'preset_1' => 'to bottom',
					'preset_2' => 'to bottom',
					'preset_3' => 'to bottom',
					'preset_4' => 'to bottom',
					'preset_5' => 'to bottom',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => 'to bottom',
					'preset_10' => 'to bottom',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_header_button_users_text' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#ffffff',
					'preset_3' => '#ffffff',
					'preset_4' => '#ffffff',
					'preset_5' => '#ffffff',
					'preset_6' => '#ffffff',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffffff',
					'preset_9' => '#ffffff',
					'preset_10' => '#ffffff',
					'preset_11' => '#ffffff',
					'preset_12' => '#000000',
					'preset_13' => '#ffffff',
					'preset_14' => '#d1deec',
					'preset_15' => '#ffffff',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffffff',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_navigation_background_transparent' => array(
				'default' => array(
					'preset_1' => false,
					'preset_2' => false,
					'preset_3' => false,
					'preset_4' => false,
					'preset_5' => false,
					'preset_6' => false,
					'preset_7' => false,
					'preset_8' => false,
					'preset_9' => false,
					'preset_10' => false,
					'preset_11' => false,
					'preset_12' => false,
					'preset_13' => false,
					'preset_14' => false,
					'preset_15' => false,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_color_navigation_background_primary' => array(
				'default' => array(
					'preset_1' => '#008df0',
					'preset_2' => '#141414',
					'preset_3' => '#00121a',
					'preset_4' => '#1e003f',
					'preset_5' => '#ffe000',
					'preset_6' => '#f7e7f7',
					'preset_7' => '#df0000',
					'preset_8' => '#a71b9f',
					'preset_9' => '#a0c11d',
					'preset_10' => '#303030',
					'preset_11' => '#005e5c',
					'preset_12' => '#555555',
					'preset_13' => '#ec712a',
					'preset_14' => '#007cbf',
					'preset_15' => '#ffed00',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#7200cf',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_navigation_background_secondary' => array(
				'default' => array(
					'preset_1' => '#002e77',
					'preset_2' => '#404040',
					'preset_3' => '#001f24',
					'preset_4' => '#1f1c59',
					'preset_5' => '#ffbc00',
					'preset_6' => '#ead4ea',
					'preset_7' => '#b00000',
					'preset_8' => '#a71b9f',
					'preset_9' => '#7b9b00',
					'preset_10' => '#000000',
					'preset_11' => '#005e5c',
					'preset_12' => '#555555',
					'preset_13' => '#ec712a',
					'preset_14' => '#007cbf',
					'preset_15' => '#ffed00',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#7200cf',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_navigation_background_angle' => array(
				'default' => array(
					'preset_1' => '125deg',
					'preset_2' => '125deg',
					'preset_3' => '125deg',
					'preset_4' => '125deg',
					'preset_5' => '125deg',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => '125deg',
					'preset_9' => '125deg',
					'preset_10' => '125deg',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_navigation_background_submenu_primary' => array(
				'default' => array(
					'preset_1' => '#004d98',
					'preset_2' => '#1c1c1c',
					'preset_3' => '#001a21',
					'preset_4' => '#17002f',
					'preset_5' => '#ffbc00',
					'preset_6' => '#f7e7f7',
					'preset_7' => '#a00000',
					'preset_8' => '#a71b9f',
					'preset_9' => '#a0c11d',
					'preset_10' => '#333333',
					'preset_11' => '#005e5c',
					'preset_12' => '#303030',
					'preset_13' => '#000000',
					'preset_14' => '#007cbf',
					'preset_15' => '#ffed00',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#7200cf',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_navigation_background_submenu_secondary' => array(
				'default' => array(
					'preset_1' => '#004d98',
					'preset_2' => '#1c1c1c',
					'preset_3' => '#001a21',
					'preset_4' => '#221158',
					'preset_5' => '#ffbc00',
					'preset_6' => '#f7e7f7',
					'preset_7' => '#ff404a',
					'preset_8' => '#a71b9f',
					'preset_9' => '#a0c11d',
					'preset_10' => '#222222',
					'preset_11' => '#005e5c',
					'preset_12' => '#303030',
					'preset_13' => '#000000',
					'preset_14' => '#007cbf',
					'preset_15' => '#ffed00',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#7200cf',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_navigation_background_submenu_angle' => array(
				'default' => array(
					'preset_1' => '125deg',
					'preset_2' => 'to bottom',
					'preset_3' => '125deg',
					'preset_4' => '125deg',
					'preset_5' => '125deg',
					'preset_6' => '125deg',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => '125deg',
					'preset_10' => '125deg',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_navigation_link' => array(
				'default' => array(
					'preset_1' => '#c5e2ff',
					'preset_2' => '#ffffff',
					'preset_3' => '#b0f4ff',
					'preset_4' => '#bbaaf7',
					'preset_5' => '#003d87',
					'preset_6' => '#aa23aa',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffffff',
					'preset_9' => '#212d04',
					'preset_10' => '#ffffff',
					'preset_11' => '#ffffff',
					'preset_12' => '#ffffff',
					'preset_13' => '#2a2a2a',
					'preset_14' => '#ffffff',
					'preset_15' => '#333333',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_navigation_link_hover' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#de5e00',
					'preset_3' => '#ffffff',
					'preset_4' => '#f3edff',
					'preset_5' => '#005d9e',
					'preset_6' => '#aa23aa',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffd800',
					'preset_9' => '#212d04',
					'preset_10' => '#ffcc00',
					'preset_11' => '#ffffff',
					'preset_12' => '#00b7ff',
					'preset_13' => '#000000',
					'preset_14' => '#ffffff',
					'preset_15' => '#444444',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_navigation_text_shadow' => array(
				'default' => array(
					'preset_1' => '#000000',
					'preset_2' => '#000000',
					'preset_3' => '#000000',
					'preset_4' => '#000000',
					'preset_5' => '#000000',
					'preset_6' => '#000000',
					'preset_7' => '#000000',
					'preset_8' => '#000000',
					'preset_9' => '#000000',
					'preset_10' => '#000000',
					'preset_11' => '#000000',
					'preset_12' => '#000000',
					'preset_13' => '#000000',
					'preset_14' => '#000000',
					'preset_15' => '#000000',
					'preset_16' => '#000000',
					'preset_17' => '#ffffff',
					'preset_18' => '#000000',
					'preset_19' => '#000000',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_navigation_text_shadow_display' => array(
				'default' => array(
					'preset_1' => true,
					'preset_2' => true,
					'preset_3' => true,
					'preset_4' => true,
					'preset_5' => false,
					'preset_6' => false,
					'preset_7' => true,
					'preset_8' => false,
					'preset_9' => false,
					'preset_10' => true,
					'preset_11' => false,
					'preset_12' => false,
					'preset_13' => false,
					'preset_14' => false,
					'preset_15' => false,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_color_navigation_link_submenu' => array(
				'default' => array(
					'preset_1' => '#c5e2ff',
					'preset_2' => '#de7e00',
					'preset_3' => '#b0f4ff',
					'preset_4' => '#bbaaf7',
					'preset_5' => '#005d9e',
					'preset_6' => '#8c448c',
					'preset_7' => '#f3dddd',
					'preset_8' => '#ffffff',
					'preset_9' => '#212e02',
					'preset_10' => '#ffcc00',
					'preset_11' => '#ffffff',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#333333',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_navigation_link_hover_submenu' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#d98d00',
					'preset_3' => '#ffffff',
					'preset_4' => '#f3edff',
					'preset_5' => '#ffffff',
					'preset_6' => '#ab55ab',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffd800',
					'preset_9' => '#415d00',
					'preset_10' => '#ffee00',
					'preset_11' => '#ffffff',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ec712a',
					'preset_14' => '#ffffff',
					'preset_15' => '#000000',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_navigation_text_shadow_submenu' => array(
				'default' => array(
					'preset_1' => '#000000',
					'preset_2' => '#000000',
					'preset_3' => '#000000',
					'preset_4' => '#000000',
					'preset_5' => '#000000',
					'preset_6' => '#000000',
					'preset_7' => '#000000',
					'preset_8' => '#000000',
					'preset_9' => '#000000',
					'preset_10' => '#000000',
					'preset_11' => '#000000',
					'preset_12' => '#000000',
					'preset_13' => '#000000',
					'preset_14' => '#000000',
					'preset_15' => '#000000',
					'preset_16' => '#000000',
					'preset_17' => '#ffffff',
					'preset_18' => '#000000',
					'preset_19' => '#000000',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_navigation_text_shadow_display_submenu' => array(
				'default' => array(
					'preset_1' => true,
					'preset_2' => true,
					'preset_3' => true,
					'preset_4' => true,
					'preset_5' => false,
					'preset_6' => false,
					'preset_7' => true,
					'preset_8' => true,
					'preset_9' => false,
					'preset_10' => true,
					'preset_11' => false,
					'preset_12' => false,
					'preset_13' => false,
					'preset_14' => false,
					'preset_15' => false,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_color_button_navigation_mobile_background_primary' => array(
				'default' => array(
					'preset_1' => '#000000',
					'preset_2' => '#000000',
					'preset_3' => '#000000',
					'preset_4' => '#000000',
					'preset_5' => '#000000',
					'preset_6' => '#000000',
					'preset_7' => '#000000',
					'preset_8' => '#000000',
					'preset_9' => '#000000',
					'preset_10' => '#000000',
					'preset_11' => '#000000',
					'preset_12' => '#000000',
					'preset_13' => '#000000',
					'preset_14' => '#000000',
					'preset_15' => '#000000',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_button_navigation_mobile_background_secondary' => array(
				'default' => array(
					'preset_1' => '#000000',
					'preset_2' => '#000000',
					'preset_3' => '#000000',
					'preset_4' => '#000000',
					'preset_5' => '#000000',
					'preset_6' => '#000000',
					'preset_7' => '#000000',
					'preset_8' => '#000000',
					'preset_9' => '#000000',
					'preset_10' => '#000000',
					'preset_11' => '#000000',
					'preset_12' => '#000000',
					'preset_13' => '#000000',
					'preset_14' => '#000000',
					'preset_15' => '#000000',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_button_navigation_mobile_background_angle' => array(
				'default' => array(
					'preset_1' => 'to bottom',
					'preset_2' => 'to bottom',
					'preset_3' => 'to bottom',
					'preset_4' => 'to bottom',
					'preset_5' => 'to bottom',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => 'to bottom',
					'preset_10' => 'to bottom',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_button_navigation_mobile_text' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#ffffff',
					'preset_3' => '#ffffff',
					'preset_4' => '#ffffff',
					'preset_5' => '#ffffff',
					'preset_6' => '#ffffff',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffffff',
					'preset_9' => '#ffffff',
					'preset_10' => '#ffffff',
					'preset_11' => '#ffffff',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#ffffff',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_search_background_transparent' => array(
				'default' => array(
					'preset_1' => false,
					'preset_2' => false,
					'preset_3' => false,
					'preset_4' => false,
					'preset_5' => false,
					'preset_6' => false,
					'preset_7' => false,
					'preset_8' => false,
					'preset_9' => false,
					'preset_10' => false,
					'preset_11' => false,
					'preset_12' => false,
					'preset_13' => false,
					'preset_14' => false,
					'preset_15' => false,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_color_search_background_primary' => array(
				'default' => array(
					'preset_1' => '#3f3f3f',
					'preset_2' => '#000000',
					'preset_3' => '#00171a',
					'preset_4' => '#1f1c59',
					'preset_5' => '#003078',
					'preset_6' => '#eacaea',
					'preset_7' => '#333333',
					'preset_8' => '#ffffff',
					'preset_9' => '#3b4d11',
					'preset_10' => '#ffd800',
					'preset_11' => '#003e3c',
					'preset_12' => '#333333',
					'preset_13' => '#000000',
					'preset_14' => '#005fad',
					'preset_15' => '#e5d500',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#0b3d5f',
					'preset_19' => '#582841',
					'preset_20' => '#43008c',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_search_background_secondary' => array(
				'default' => array(
					'preset_1' => '#0f0f0f',
					'preset_2' => '#121212',
					'preset_3' => '#000b0f',
					'preset_4' => '#1e003f',
					'preset_5' => '#001a42',
					'preset_6' => '#fff2ff',
					'preset_7' => '#111111',
					'preset_8' => '#ffddfd',
					'preset_9' => '#648404',
					'preset_10' => '#ffd800',
					'preset_11' => '#003e3c',
					'preset_12' => '#333333',
					'preset_13' => '#000000',
					'preset_14' => '#005fad',
					'preset_15' => '#e5d500',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#0b3d5f',
					'preset_19' => '#582841',
					'preset_20' => '#43008c',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_search_background_angle' => array(
				'default' => array(
					'preset_1' => '125deg',
					'preset_2' => '125deg',
					'preset_3' => '125deg',
					'preset_4' => '125deg',
					'preset_5' => '125deg',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => '125deg',
					'preset_9' => '125deg',
					'preset_10' => '125deg',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_search_field_background_primary' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#ffffff',
					'preset_3' => '#ffffff',
					'preset_4' => '#0b000c',
					'preset_5' => '#e1f1ff',
					'preset_6' => '#fff2ff',
					'preset_7' => '#000000',
					'preset_8' => '#ffddfd',
					'preset_9' => '#f0f8dd',
					'preset_10' => '#ffffff',
					'preset_11' => '#ffffff',
					'preset_12' => '#111111',
					'preset_13' => '#ffffff',
					'preset_14' => '#0c1b2c',
					'preset_15' => '#ffffff',
					'preset_16' => '#eeeeee',
					'preset_17' => '#333333',
					'preset_18' => '#000000',
					'preset_19' => '#000000',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_search_field_background_secondary' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#ffffff',
					'preset_3' => '#ffffff',
					'preset_4' => '#0b0020',
					'preset_5' => '#f8fcff',
					'preset_6' => '#ffffff',
					'preset_7' => '#111111',
					'preset_8' => '#ffffff',
					'preset_9' => '#f0f8dd',
					'preset_10' => '#ffffff',
					'preset_11' => '#ffffff',
					'preset_12' => '#111111',
					'preset_13' => '#ffffff',
					'preset_14' => '#0c1b2c',
					'preset_15' => '#ffffff',
					'preset_16' => '#eeeeee',
					'preset_17' => '#333333',
					'preset_18' => '#000000',
					'preset_19' => '#000000',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_search_field_background_angle' => array(
				'default' => array(
					'preset_1' => 'to bottom',
					'preset_2' => 'to bottom',
					'preset_3' => 'to bottom',
					'preset_4' => 'to bottom',
					'preset_5' => 'to bottom',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => 'to bottom',
					'preset_10' => 'to bottom',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_search_field_text' => array(
				'default' => array(
					'preset_1' => '#333333',
					'preset_2' => '#333333',
					'preset_3' => '#333333',
					'preset_4' => '#ffffff',
					'preset_5' => '#333333',
					'preset_6' => '#5f2d5f',
					'preset_7' => '#aaaaaa',
					'preset_8' => '#333333',
					'preset_9' => '#445e08',
					'preset_10' => '#333333',
					'preset_11' => '#555555',
					'preset_12' => '#ffffff',
					'preset_13' => '#333333',
					'preset_14' => '#ffffff',
					'preset_15' => '#333333',
					'preset_16' => '#333333',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_search_button_background_primary' => array(
				'default' => array(
					'preset_1' => '#00a9ff',
					'preset_2' => '#ff5100',
					'preset_3' => '#007385',
					'preset_4' => '#4400c4',
					'preset_5' => '#3697ff',
					'preset_6' => '#80437f',
					'preset_7' => '#222222',
					'preset_8' => '#cc1ac2',
					'preset_9' => '#709000',
					'preset_10' => '#333333',
					'preset_11' => '#00d3cf',
					'preset_12' => '#00b7ff',
					'preset_13' => '#333333',
					'preset_14' => '#ffca00',
					'preset_15' => '#1a74cc',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_search_button_background_secondary' => array(
				'default' => array(
					'preset_1' => '#093a89',
					'preset_2' => '#3c0c00',
					'preset_3' => '#00252b',
					'preset_4' => '#12003f',
					'preset_5' => '#0022aa',
					'preset_6' => '#5f2d5f',
					'preset_7' => '#111111',
					'preset_8' => '#a71b9f',
					'preset_9' => '#3b4d11',
					'preset_10' => '#000000',
					'preset_11' => '#00d3cf',
					'preset_12' => '#00b7ff',
					'preset_13' => '#333333',
					'preset_14' => '#ffca00',
					'preset_15' => '#1a74cc',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_search_button_background_angle' => array(
				'default' => array(
					'preset_1' => 'to bottom',
					'preset_2' => 'to bottom',
					'preset_3' => 'to bottom',
					'preset_4' => 'to bottom',
					'preset_5' => 'to bottom',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => 'to bottom',
					'preset_10' => 'to bottom',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_search_button_text' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#ffffff',
					'preset_3' => '#ffffff',
					'preset_4' => '#ffffff',
					'preset_5' => '#ffffff',
					'preset_6' => '#ffffff',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffffff',
					'preset_9' => '#ffffff',
					'preset_10' => '#ffffff',
					'preset_11' => '#000000',
					'preset_12' => '#000000',
					'preset_13' => '#ffffff',
					'preset_14' => '#000000',
					'preset_15' => '#ffffff',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_search_text' => array(
				'default' => array(
					'preset_1' => '#777777',
					'preset_2' => '#eeeeee',
					'preset_3' => '#ffffff',
					'preset_4' => '#ffffff',
					'preset_5' => '#b0f4ff',
					'preset_6' => '#5f2d5f',
					'preset_7' => '#dddddd',
					'preset_8' => '#8c0e84',
					'preset_9' => '#ffffff',
					'preset_10' => '#444444',
					'preset_11' => '#ffffff',
					'preset_12' => '#ffffff',
					'preset_13' => '#aaaaaa',
					'preset_14' => '#ffffff',
					'preset_15' => '#333333',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_search_link' => array(
				'default' => array(
					'preset_1' => '#80ddff',
					'preset_2' => '#de7e00',
					'preset_3' => '#b0f4ff',
					'preset_4' => '#deb8f9',
					'preset_5' => '#ffe000',
					'preset_6' => '#7f447f',
					'preset_7' => '#ff404a',
					'preset_8' => '#8c0e84',
					'preset_9' => '#ffffff',
					'preset_10' => '#555555',
					'preset_11' => '#ffffff',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ff3300',
					'preset_14' => '#ffffff',
					'preset_15' => '#000000',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_search_link_hover' => array(
				'default' => array(
					'preset_1' => '#cdf1ff',
					'preset_2' => '#de5e00',
					'preset_3' => '#ffffff',
					'preset_4' => '#ffffff',
					'preset_5' => '#fffc00',
					'preset_6' => '#aa73aa',
					'preset_7' => '#ff404a',
					'preset_8' => '#8c0e84',
					'preset_9' => '#ffffff',
					'preset_10' => '#444444',
					'preset_11' => '#ffffff',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ff3300',
					'preset_14' => '#ffffff',
					'preset_15' => '#1a74cc',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_search_text_shadow' => array(
				'default' => array(
					'preset_1' => '#000000',
					'preset_2' => '#000000',
					'preset_3' => '#000000',
					'preset_4' => '#000000',
					'preset_5' => '#000000',
					'preset_6' => '#000000',
					'preset_7' => '#000000',
					'preset_8' => '#000000',
					'preset_9' => '#000000',
					'preset_10' => '#000000',
					'preset_11' => '#000000',
					'preset_12' => '#000000',
					'preset_13' => '#000000',
					'preset_14' => '#000000',
					'preset_15' => '#000000',
					'preset_16' => '#000000',
					'preset_17' => '#ffffff',
					'preset_18' => '#000000',
					'preset_19' => '#000000',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_search_text_shadow_display' => array(
				'default' => array(
					'preset_1' => true,
					'preset_2' => true,
					'preset_3' => true,
					'preset_4' => true,
					'preset_5' => true,
					'preset_6' => false,
					'preset_7' => true,
					'preset_8' => false,
					'preset_9' => true,
					'preset_10' => false,
					'preset_11' => false,
					'preset_12' => false,
					'preset_13' => false,
					'preset_14' => false,
					'preset_15' => false,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_color_content_title_background_primary' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#1f1f1f',
					'preset_3' => '#002526',
					'preset_4' => '#1f0048',
					'preset_5' => '#ffffff',
					'preset_6' => '#f7e7f7',
					'preset_7' => '#0f0f0f',
					'preset_8' => '#84007c',
					'preset_9' => '#5f7800',
					'preset_10' => '#000000',
					'preset_11' => '#ffffff',
					'preset_12' => '#444444',
					'preset_13' => '#333333',
					'preset_14' => '#ffffff',
					'preset_15' => '#001a4a',
					'preset_16' => '#ffffff',
					'preset_17' => '#111111',
					'preset_18' => '#0b3d5f',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#43008c',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_title_background_secondary' => array(
				'default' => array(
					'preset_1' => '#dddddd',
					'preset_2' => '#000000',
					'preset_3' => '#000000',
					'preset_4' => '#34004c',
					'preset_5' => '#ffffff',
					'preset_6' => '#f7e7f7',
					'preset_7' => '#000000',
					'preset_8' => '#a71b9f',
					'preset_9' => '#5f7800',
					'preset_10' => '#101010',
					'preset_11' => '#ffffff',
					'preset_12' => '#444444',
					'preset_13' => '#333333',
					'preset_14' => '#ffffff',
					'preset_15' => '#001a4a',
					'preset_16' => '#ffffff',
					'preset_17' => '#111111',
					'preset_18' => '#0b3d5f',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#43008c',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_title_background_angle' => array(
				'default' => array(
					'preset_1' => '125deg',
					'preset_2' => '125deg',
					'preset_3' => '125deg',
					'preset_4' => '125deg',
					'preset_5' => '125deg',
					'preset_6' => '125deg',
					'preset_7' => 'to bottom',
					'preset_8' => '125deg',
					'preset_9' => '125deg',
					'preset_10' => '125deg',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_content_title_text' => array(
				'default' => array(
					'preset_1' => '#333333',
					'preset_2' => '#eeeeee',
					'preset_3' => '#ffffff',
					'preset_4' => '#e2d8ff',
					'preset_5' => '#333333',
					'preset_6' => '#841c84',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffffff',
					'preset_9' => '#ffffff',
					'preset_10' => '#ffff00',
					'preset_11' => '#333333',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#333333',
					'preset_15' => '#ffffff',
					'preset_16' => '#333333',
					'preset_17' => '#eeeeee',
					'preset_18' => '#cee0ec',
					'preset_19' => '#333333',
					'preset_20' => '#f2e1ff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_title_text_shadow' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#000000',
					'preset_3' => '#000000',
					'preset_4' => '#000000',
					'preset_5' => '#000000',
					'preset_6' => '#000000',
					'preset_7' => '#000000',
					'preset_8' => '#000000',
					'preset_9' => '#000000',
					'preset_10' => '#000000',
					'preset_11' => '#000000',
					'preset_12' => '#000000',
					'preset_13' => '#000000',
					'preset_14' => '#000000',
					'preset_15' => '#000000',
					'preset_16' => '#000000',
					'preset_17' => '#ffffff',
					'preset_18' => '#000000',
					'preset_19' => '#000000',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_title_text_shadow_display' => array(
				'default' => array(
					'preset_1' => true,
					'preset_2' => true,
					'preset_3' => true,
					'preset_4' => true,
					'preset_5' => false,
					'preset_6' => false,
					'preset_7' => true,
					'preset_8' => true,
					'preset_9' => true,
					'preset_10' => true,
					'preset_11' => false,
					'preset_12' => false,
					'preset_13' => false,
					'preset_14' => false,
					'preset_15' => false,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_color_content_title_link' => array(
				'default' => array(
					'preset_1' => '#000000',
					'preset_2' => '#ffffff',
					'preset_3' => '#aaf0e9',
					'preset_4' => '#d5ccff',
					'preset_5' => '#004cd1',
					'preset_6' => '#a42ca4',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffd1fc',
					'preset_9' => '#ffffff',
					'preset_10' => '#ffcc00',
					'preset_11' => '#007b72',
					'preset_12' => '#1bbfff',
					'preset_13' => '#ff7b2f',
					'preset_14' => '#007cbf',
					'preset_15' => '#ffed00',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ffffff',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_title_link_hover' => array(
				'default' => array(
					'preset_1' => '#005ce4',
					'preset_2' => '#ffab19',
					'preset_3' => '#82bfbd',
					'preset_4' => '#beb3fc',
					'preset_5' => '#004cd1',
					'preset_6' => '#a42ca4',
					'preset_7' => '#e00000',
					'preset_8' => '#ffffff',
					'preset_9' => '#e9ff83',
					'preset_10' => '#fff800',
					'preset_11' => '#007b72',
					'preset_12' => '#1bbfff',
					'preset_13' => '#ff7b2f',
					'preset_14' => '#007cbf',
					'preset_15' => '#ffed00',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ffffff',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_background_primary' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#efefef',
					'preset_3' => '#001012',
					'preset_4' => '#0f001c',
					'preset_5' => '#00123a',
					'preset_6' => '#ead4ea',
					'preset_7' => '#101010',
					'preset_8' => '#fff7ff',
					'preset_9' => '#000000',
					'preset_10' => '#ffd800',
					'preset_11' => '#f5f5f5',
					'preset_12' => '#333333',
					'preset_13' => '#000000',
					'preset_14' => '#f0f0f0',
					'preset_15' => '#000b29',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffd7df',
					'preset_20' => '#2e055a',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_background_secondary' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#efefef',
					'preset_3' => '#001012',
					'preset_4' => '#0f001c',
					'preset_5' => '#00123a',
					'preset_6' => '#ead4ea',
					'preset_7' => '#101010',
					'preset_8' => '#fff7ff',
					'preset_9' => '#000000',
					'preset_10' => '#ffd800',
					'preset_11' => '#f5f5f5',
					'preset_12' => '#333333',
					'preset_13' => '#000000',
					'preset_14' => '#f0f0f0',
					'preset_15' => '#000b29',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffd7df',
					'preset_20' => '#2e055a',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_background_angle' => array(
				'default' => array(
					'preset_1' => 'to bottom',
					'preset_2' => 'to bottom',
					'preset_3' => 'to bottom',
					'preset_4' => 'to bottom',
					'preset_5' => 'to bottom',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => 'to bottom',
					'preset_10' => 'to bottom',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_content_footer_background_primary' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#efefef',
					'preset_3' => '#001012',
					'preset_4' => '#0f001c',
					'preset_5' => '#00123a',
					'preset_6' => '#ead4ea',
					'preset_7' => '#101010',
					'preset_8' => '#fff7ff',
					'preset_9' => '#000000',
					'preset_10' => '#ffd800',
					'preset_11' => '#f5f5f5',
					'preset_12' => '#333333',
					'preset_13' => '#000000',
					'preset_14' => '#f0f0f0',
					'preset_15' => '#000b29',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffd7df',
					'preset_20' => '#2e055a',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_footer_background_secondary' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#efefef',
					'preset_3' => '#001012',
					'preset_4' => '#0f001c',
					'preset_5' => '#00123a',
					'preset_6' => '#ead4ea',
					'preset_7' => '#101010',
					'preset_8' => '#fff7ff',
					'preset_9' => '#000000',
					'preset_10' => '#ffd800',
					'preset_11' => '#f5f5f5',
					'preset_12' => '#333333',
					'preset_13' => '#000000',
					'preset_14' => '#f0f0f0',
					'preset_15' => '#000b29',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffd7df',
					'preset_20' => '#2e055a',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_footer_background_angle' => array(
				'default' => array(
					'preset_1' => 'to bottom',
					'preset_2' => 'to bottom',
					'preset_3' => 'to bottom',
					'preset_4' => 'to bottom',
					'preset_5' => 'to bottom',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => 'to bottom',
					'preset_10' => 'to bottom',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_content_thumbnail_frame' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#ffffff',
					'preset_3' => '#ffffff',
					'preset_4' => '#000000',
					'preset_5' => '#ffffff',
					'preset_6' => '#ffffff',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffffff',
					'preset_9' => '#ffffff',
					'preset_10' => '#ffffff',
					'preset_11' => '#ffffff',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#ffffff',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#9bd7d1',
					'preset_19' => '#ef4648',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_list_thumbnail_frame' => array( /* Plain lists only */
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#ffffff',
					'preset_3' => '#ffffff',
					'preset_4' => '#000000',
					'preset_5' => '#ffffff',
					'preset_6' => '#ffffff',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffffff',
					'preset_9' => '#ffffff',
					'preset_10' => '#ffffff',
					'preset_11' => '#ffffff',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#ffffff',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#9bd7d1',
					'preset_19' => '#ef4648',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_list_thumbnail_background_primary' => array( /* Only for the Tile & jQuery Masonry layouts. */
				'default' => array(
					'preset_1' => '#ff8800',
					'preset_2' => '#ff8800',
					'preset_3' => '#00b084',
					'preset_4' => '#3c0080',
					'preset_5' => '#ff8800',
					'preset_6' => '#c27abd',
					'preset_7' => '#555555',
					'preset_8' => '#950d8d',
					'preset_9' => '#71890e',
					'preset_10' => '#ff8800',
					'preset_11' => '#5cd4d0',
					'preset_12' => '#52b8ff',
					'preset_13' => '#ec712a',
					'preset_14' => '#2d77b3',
					'preset_15' => '#ffed00',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_list_thumbnail_background_secondary' => array( /* Only for the Tile & jQuery Masonry layouts. */
				'default' => array(
					'preset_1' => '#ffd800',
					'preset_2' => '#ffd800',
					'preset_3' => '#00ffc9',
					'preset_4' => '#5e00e3',
					'preset_5' => '#ffd800',
					'preset_6' => '#ffdfff',
					'preset_7' => '#aaaaaa',
					'preset_8' => '#e3a0df',
					'preset_9' => '#b1e700',
					'preset_10' => '#ff8800',
					'preset_11' => '#5cd4d0',
					'preset_12' => '#52b8ff',
					'preset_13' => '#ec712a',
					'preset_14' => '#2d77b3',
					'preset_15' => '#ffed00',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_field_background_primary' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#000000',
					'preset_3' => '#00333a',
					'preset_4' => '#1b014c',
					'preset_5' => '#0f1e38',
					'preset_6' => '#fff2ff',
					'preset_7' => '#333333',
					'preset_8' => '#ffdffd',
					'preset_9' => '#333333',
					'preset_10' => '#333333',
					'preset_11' => '#ffffff',
					'preset_12' => '#555555',
					'preset_13' => '#aaaaaa',
					'preset_14' => '#123a5f',
					'preset_15' => '#071d44',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_field_background_secondary' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#101010',
					'preset_3' => '#00545f',
					'preset_4' => '#1b003a',
					'preset_5' => '#031024',
					'preset_6' => '#ffffff',
					'preset_7' => '#444444',
					'preset_8' => '#fff9ff',
					'preset_9' => '#333333',
					'preset_10' => '#444444',
					'preset_11' => '#ffffff',
					'preset_12' => '#555555',
					'preset_13' => '#aaaaaa',
					'preset_14' => '#123a5f',
					'preset_15' => '#071d44',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_field_background_angle' => array(
				'default' => array(
					'preset_1' => 'to bottom',
					'preset_2' => 'to bottom',
					'preset_3' => 'to bottom',
					'preset_4' => 'to bottom',
					'preset_5' => 'to bottom',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => 'to bottom',
					'preset_10' => 'to bottom',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_content_field_text' => array(
				'default' => array(
					'preset_1' => '#333333',
					'preset_2' => '#ffffff',
					'preset_3' => '#c7e8ec',
					'preset_4' => '#dfcaff',
					'preset_5' => '#cee0f5',
					'preset_6' => '#5f2d5f',
					'preset_7' => '#bbbbbb',
					'preset_8' => '#b70ead',
					'preset_9' => '#a3ca5b',
					'preset_10' => '#ffffff',
					'preset_11' => '#333333',
					'preset_12' => '#cccccc',
					'preset_13' => '#333333',
					'preset_14' => '#ffffff',
					'preset_15' => '#ffffff',
					'preset_16' => '#333333',
					'preset_17' => '#eeeeee',
					'preset_18' => '#333333',
					'preset_19' => '#333333',
					'preset_20' => '#333333',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_text' => array(
				'default' => array(
					'preset_1' => '#333333',
					'preset_2' => '#333333',
					'preset_3' => '#d0eaed',
					'preset_4' => '#d7ceea',
					'preset_5' => '#70cdff',
					'preset_6' => '#2f152f',
					'preset_7' => '#eeeeee',
					'preset_8' => '#2c042a',
					'preset_9' => '#ffffff',
					'preset_10' => '#000000',
					'preset_11' => '#333333',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#333333',
					'preset_15' => '#ffffff',
					'preset_16' => '#333333',
					'preset_17' => '#eeeeee',
					'preset_18' => '#333333',
					'preset_19' => '#333333',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_link' => array(
				'default' => array(
					'preset_1' => '#005ce4',
					'preset_2' => '#ca1f00',
					'preset_3' => '#51eddd',
					'preset_4' => '#998ace',
					'preset_5' => '#ffdd00',
					'preset_6' => '#a200a2',
					'preset_7' => '#ff404a',
					'preset_8' => '#a71b9f',
					'preset_9' => '#a0c11d',
					'preset_10' => '#a43400',
					'preset_11' => '#005b54',
					'preset_12' => '#1bbfff',
					'preset_13' => '#ec712a',
					'preset_14' => '#004c98',
					'preset_15' => '#00a9ff',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_content_link_hover' => array(
				'default' => array(
					'preset_1' => '#005ce4',
					'preset_2' => '#ca1f00',
					'preset_3' => '#32b3a6',
					'preset_4' => '#4d3a90',
					'preset_5' => '#ffb700',
					'preset_6' => '#a200a2',
					'preset_7' => '#ff404a',
					'preset_8' => '#a71b9f',
					'preset_9' => '#a0c11d',
					'preset_10' => '#000000',
					'preset_11' => '#007e74',
					'preset_12' => '#1bbfff',
					'preset_13' => '#ec712a',
					'preset_14' => '#123a5f',
					'preset_15' => '#1f7ed4',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_bottom_background_transparent' => array(
				'default' => array(
					'preset_1' => false,
					'preset_2' => false,
					'preset_3' => false,
					'preset_4' => false,
					'preset_5' => false,
					'preset_6' => false,
					'preset_7' => false,
					'preset_8' => false,
					'preset_9' => false,
					'preset_10' => false,
					'preset_11' => false,
					'preset_12' => false,
					'preset_13' => false,
					'preset_14' => false,
					'preset_15' => false,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_color_bottom_background_primary' => array(
				'default' => array(
					'preset_1' => '#1f1f1f',
					'preset_2' => '#222222',
					'preset_3' => '#001f24',
					'preset_4' => '#1f0030',
					'preset_5' => '#003078',
					'preset_6' => '#ecddec',
					'preset_7' => '#101010',
					'preset_8' => '#5b0055',
					'preset_9' => '#000000',
					'preset_10' => '#333333',
					'preset_11' => '#000000',
					'preset_12' => '#333333',
					'preset_13' => '#333333',
					'preset_14' => '#001a42',
					'preset_15' => '#072b5f',
					'preset_16' => '#dfdfdf',
					'preset_17' => '#111111',
					'preset_18' => '#ffffff',
					'preset_19' => '#cc2a49',
					'preset_20' => '#7200cf',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_bottom_background_secondary' => array(
				'default' => array(
					'preset_1' => '#1f1f1f',
					'preset_2' => '#121212',
					'preset_3' => '#00121a',
					'preset_4' => '#170021',
					'preset_5' => '#001a42',
					'preset_6' => '#ead4ea',
					'preset_7' => '#070707',
					'preset_8' => '#0a0009',
					'preset_9' => '#0e1100',
					'preset_10' => '#0f0f0f',
					'preset_11' => '#000000',
					'preset_12' => '#333333',
					'preset_13' => '#333333',
					'preset_14' => '#001a42',
					'preset_15' => '#072b5f',
					'preset_16' => '#dfdfdf',
					'preset_17' => '#111111',
					'preset_18' => '#ffffff',
					'preset_19' => '#cc2a49',
					'preset_20' => '#7200cf',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_bottom_background_angle' => array(
				'default' => array(
					'preset_1' => '125deg',
					'preset_2' => '125deg',
					'preset_3' => '125deg',
					'preset_4' => '125deg',
					'preset_5' => '125deg',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => '125deg',
					'preset_9' => '125deg',
					'preset_10' => '125deg',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_bottom_text' => array(
				'default' => array(
					'preset_1' => '#fefefe',
					'preset_2' => '#9c9c9c',
					'preset_3' => '#67adb8',
					'preset_4' => '#7661ad',
					'preset_5' => '#fefefe',
					'preset_6' => '#5f2a5f',
					'preset_7' => '#eeeeee',
					'preset_8' => '#ffffff',
					'preset_9' => '#ffffff',
					'preset_10' => '#ffffff',
					'preset_11' => '#e3fffa',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#ffffff',
					'preset_16' => '#333333',
					'preset_17' => '#eeeeee',
					'preset_18' => '#333333',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#f2e1ff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_bottom_link' => array(
				'default' => array(
					'preset_1' => '#005ce4',
					'preset_2' => '#8d5b20',
					'preset_3' => '#189490',
					'preset_4' => '#a59ad6',
					'preset_5' => '#0087cc',
					'preset_6' => '#843d84',
					'preset_7' => '#aaaaaa',
					'preset_8' => '#ca43c2',
					'preset_9' => '#caed3c',
					'preset_10' => '#ffcc00',
					'preset_11' => '#00d3cf',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#ffffff',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#ffbecb',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_bottom_link_hover' => array(
				'default' => array(
					'preset_1' => '#005ce4',
					'preset_2' => '#e34f04',
					'preset_3' => '#19e6d8',
					'preset_4' => '#aa71e2',
					'preset_5' => '#ffd800',
					'preset_6' => '#843d84',
					'preset_7' => '#e00000',
					'preset_8' => '#a71b9f',
					'preset_9' => '#a0c11d',
					'preset_10' => '#ffff00',
					'preset_11' => '#00d3cf',
					'preset_12' => '#eeeeee',
					'preset_13' => '#ec712a',
					'preset_14' => '#ffca00',
					'preset_15' => '#eeeeee',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_bottom_text_shadow' => array(
				'default' => array(
					'preset_1' => '#000000',
					'preset_2' => '#000000',
					'preset_3' => '#000000',
					'preset_4' => '#000000',
					'preset_5' => '#000000',
					'preset_6' => '#000000',
					'preset_7' => '#000000',
					'preset_8' => '#000000',
					'preset_9' => '#000000',
					'preset_10' => '#000000',
					'preset_11' => '#000000',
					'preset_12' => '#000000',
					'preset_13' => '#000000',
					'preset_14' => '#000000',
					'preset_15' => '#000000',
					'preset_16' => '#000000',
					'preset_17' => '#ffffff',
					'preset_18' => '#000000',
					'preset_19' => '#000000',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_bottom_text_shadow_display' => array(
				'default' => array(
					'preset_1' => true,
					'preset_2' => true,
					'preset_3' => true,
					'preset_4' => true,
					'preset_5' => true,
					'preset_6' => false,
					'preset_7' => true,
					'preset_8' => true,
					'preset_9' => true,
					'preset_10' => true,
					'preset_11' => false,
					'preset_12' => false,
					'preset_13' => false,
					'preset_14' => false,
					'preset_15' => false,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_color_bottom_headings' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#e8a200',
					'preset_3' => '#bdfcff',
					'preset_4' => '#b797fc',
					'preset_5' => '#ffffff',
					'preset_6' => '#5f2d5f',
					'preset_7' => '#ffffff',
					'preset_8' => '#ffffff',
					'preset_9' => '#ffffff',
					'preset_10' => '#ffffff',
					'preset_11' => '#ffffff',
					'preset_12' => '#ffffff',
					'preset_13' => '#ffffff',
					'preset_14' => '#ffffff',
					'preset_15' => '#ffffff',
					'preset_16' => '#000000',
					'preset_17' => '#ffffff',
					'preset_18' => '#000000',
					'preset_19' => '#000000',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_bottom_headings_text_shadow' => array(
				'default' => array(
					'preset_1' => '#000000',
					'preset_2' => '#000000',
					'preset_3' => '#000000',
					'preset_4' => '#000000',
					'preset_5' => '#000000',
					'preset_6' => '#000000',
					'preset_7' => '#000000',
					'preset_8' => '#000000',
					'preset_9' => '#000000',
					'preset_10' => '#000000',
					'preset_11' => '#000000',
					'preset_12' => '#000000',
					'preset_13' => '#000000',
					'preset_14' => '#000000',
					'preset_15' => '#000000',
					'preset_16' => '#000000',
					'preset_17' => '#ffffff',
					'preset_18' => '#000000',
					'preset_19' => '#000000',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_bottom_headings_text_shadow_display' => array(
				'default' => array(
					'preset_1' => true,
					'preset_2' => true,
					'preset_3' => true,
					'preset_4' => true,
					'preset_5' => true,
					'preset_6' => false,
					'preset_7' => true,
					'preset_8' => true,
					'preset_9' => true,
					'preset_10' => true,
					'preset_11' => false,
					'preset_12' => false,
					'preset_13' => false,
					'preset_14' => false,
					'preset_15' => false,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_color_bottom_field_background_primary' => array(
				'default' => array(
					'preset_1' => '#1f1f1f',
					'preset_2' => '#333333',
					'preset_3' => '#002f40',
					'preset_4' => '#32034c',
					'preset_5' => '#000000',
					'preset_6' => '#ffe2ff',
					'preset_7' => '#1f1f1f',
					'preset_8' => '#000000',
					'preset_9' => '#1f1f1f',
					'preset_10' => '#333333',
					'preset_11' => '#f5fffe',
					'preset_12' => '#555555',
					'preset_13' => '#555555',
					'preset_14' => '#1f4d94',
					'preset_15' => '#081b3e',
					'preset_16' => '#000000',
					'preset_17' => '#ffffff',
					'preset_18' => '#000000',
					'preset_19' => '#000000',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_bottom_field_background_secondary' => array(
				'default' => array(
					'preset_1' => '#2f2f2f',
					'preset_2' => '#444444',
					'preset_3' => '#00475d',
					'preset_4' => '#32034c',
					'preset_5' => '#000000',
					'preset_6' => '#ffeaff',
					'preset_7' => '#222222',
					'preset_8' => '#150014',
					'preset_9' => '#2f2f2f',
					'preset_10' => '#444444',
					'preset_11' => '#f5fffe',
					'preset_12' => '#555555',
					'preset_13' => '#555555',
					'preset_14' => '#1f4d94',
					'preset_15' => '#081b3e',
					'preset_16' => '#000000',
					'preset_17' => '#ffffff',
					'preset_18' => '#000000',
					'preset_19' => '#000000',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_bottom_field_background_angle' => array(
				'default' => array(
					'preset_1' => 'to bottom',
					'preset_2' => 'to bottom',
					'preset_3' => 'to bottom',
					'preset_4' => 'to bottom',
					'preset_5' => 'to bottom',
					'preset_6' => 'to bottom',
					'preset_7' => 'to bottom',
					'preset_8' => 'to bottom',
					'preset_9' => 'to bottom',
					'preset_10' => 'to bottom',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_bottom_field_text' => array(
				'default' => array(
					'preset_1' => '#aaaaaa',
					'preset_2' => '#dddddd',
					'preset_3' => '#67adb8',
					'preset_4' => '#aa71e2',
					'preset_5' => '#ffffff',
					'preset_6' => '#5f2d5f',
					'preset_7' => '#af55a9',
					'preset_8' => '#ffffff',
					'preset_9' => '#709500',
					'preset_10' => '#ffcd00',
					'preset_11' => '#333333',
					'preset_12' => '#dddddd',
					'preset_13' => '#cccccc',
					'preset_14' => '#eeeeee',
					'preset_15' => '#ffffff',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_footer_background_transparent' => array(
				'default' => array(
					'preset_1' => false,
					'preset_2' => false,
					'preset_3' => false,
					'preset_4' => false,
					'preset_5' => false,
					'preset_6' => false,
					'preset_7' => false,
					'preset_8' => false,
					'preset_9' => false,
					'preset_10' => false,
					'preset_11' => false,
					'preset_12' => false,
					'preset_13' => false,
					'preset_14' => false,
					'preset_15' => false,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_color_footer_background_primary' => array(
				'default' => array(
					'preset_1' => '#000000',
					'preset_2' => '#000000',
					'preset_3' => '#00090d',
					'preset_4' => '#0c001e',
					'preset_5' => '#001a42',
					'preset_6' => '#ecddec',
					'preset_7' => '#000000',
					'preset_8' => '#ffffff',
					'preset_9' => '#212d04',
					'preset_10' => '#000000',
					'preset_11' => '#255d5b',
					'preset_12' => '#000000',
					'preset_13' => '#000000',
					'preset_14' => '#004c98',
					'preset_15' => '#000000',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#325d79',
					'preset_19' => '#ad0747',
					'preset_20' => '#43008c',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_footer_background_secondary' => array(
				'default' => array(
					'preset_1' => '#000000',
					'preset_2' => '#0a0a0a',
					'preset_3' => '#00090a',
					'preset_4' => '#0a000a',
					'preset_5' => '#00030a',
					'preset_6' => '#ecddec',
					'preset_7' => '#0a0a0a',
					'preset_8' => '#ffffff',
					'preset_9' => '#000000',
					'preset_10' => '#000000',
					'preset_11' => '#255d5b',
					'preset_12' => '#000000',
					'preset_13' => '#000000',
					'preset_14' => '#004c98',
					'preset_15' => '#000000',
					'preset_16' => '#ffffff',
					'preset_17' => '#000000',
					'preset_18' => '#325d79',
					'preset_19' => '#ad0747',
					'preset_20' => '#43008c',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_footer_background_angle' => array(
				'default' => array(
					'preset_1' => '125deg',
					'preset_2' => '125deg',
					'preset_3' => '125deg',
					'preset_4' => '125deg',
					'preset_5' => '125deg',
					'preset_6' => '125deg',
					'preset_7' => 'to bottom',
					'preset_8' => '125deg',
					'preset_9' => '125deg',
					'preset_10' => '125deg',
					'preset_11' => 'to bottom',
					'preset_12' => 'to bottom',
					'preset_13' => 'to bottom',
					'preset_14' => 'to bottom',
					'preset_15' => 'to bottom',
					'preset_16' => 'to bottom',
					'preset_17' => 'to bottom',
					'preset_18' => 'to bottom',
					'preset_19' => 'to bottom',
					'preset_20' => 'to bottom',
				),
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_color_footer_text' => array(
				'default' => array(
					'preset_1' => '#808080',
					'preset_2' => '#aaaaaa',
					'preset_3' => '#54a0aa',
					'preset_4' => '#ac5bff',
					'preset_5' => '#ebf2ff',
					'preset_6' => '#555555',
					'preset_7' => '#aaaaaa',
					'preset_8' => '#7e0f78',
					'preset_9' => '#f0f8dd',
					'preset_10' => '#777777',
					'preset_11' => '#ffffff',
					'preset_12' => '#aaaaaa',
					'preset_13' => '#777777',
					'preset_14' => '#ffffff',
					'preset_15' => '#aaaaaa',
					'preset_16' => '#000000',
					'preset_17' => '#ffffff',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_footer_link' => array(
				'default' => array(
					'preset_1' => '#dddddd',
					'preset_2' => '#de5e00',
					'preset_3' => '#54a0aa',
					'preset_4' => '#ac5bff',
					'preset_5' => '#bddbff',
					'preset_6' => '#8c448c',
					'preset_7' => '#aaaaaa',
					'preset_8' => '#a71b9f',
					'preset_9' => '#a0c11d',
					'preset_10' => '#ffd800',
					'preset_11' => '#e3fffa',
					'preset_12' => '#dddddd',
					'preset_13' => '#dddddd',
					'preset_14' => '#93c9ff',
					'preset_15' => '#dddddd',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffffff',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_footer_link_hover' => array(
				'default' => array(
					'preset_1' => '#ffffff',
					'preset_2' => '#b74d00',
					'preset_3' => '#54a0aa',
					'preset_4' => '#ac5bff',
					'preset_5' => '#ffbf00',
					'preset_6' => '#8c448c',
					'preset_7' => '#ff404a',
					'preset_8' => '#ca43c2',
					'preset_9' => '#caed3c',
					'preset_10' => '#ffff00',
					'preset_11' => '#ffffff',
					'preset_12' => '#00b7ff',
					'preset_13' => '#ec712a',
					'preset_14' => '#ffffff',
					'preset_15' => '#eeeeee',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ffffff',
					'preset_19' => '#ffe8ed',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_footer_text_shadow' => array(
				'default' => array(
					'preset_1' => '#000000',
					'preset_2' => '#000000',
					'preset_3' => '#000000',
					'preset_4' => '#000000',
					'preset_5' => '#000000',
					'preset_6' => '#000000',
					'preset_7' => '#000000',
					'preset_8' => '#000000',
					'preset_9' => '#000000',
					'preset_10' => '#000000',
					'preset_11' => '#000000',
					'preset_12' => '#000000',
					'preset_13' => '#000000',
					'preset_14' => '#000000',
					'preset_15' => '#000000',
					'preset_16' => '#000000',
					'preset_17' => '#ffffff',
					'preset_18' => '#000000',
					'preset_19' => '#000000',
					'preset_20' => '#000000',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_footer_text_shadow_display' => array(
				'default' => array(
					'preset_1' => true,
					'preset_2' => true,
					'preset_3' => true,
					'preset_4' => true,
					'preset_5' => true,
					'preset_6' => false,
					'preset_7' => true,
					'preset_8' => false,
					'preset_9' => false,
					'preset_10' => false,
					'preset_11' => false,
					'preset_12' => false,
					'preset_13' => false,
					'preset_14' => false,
					'preset_15' => false,
					'preset_16' => false,
					'preset_17' => false,
					'preset_18' => false,
					'preset_19' => false,
					'preset_20' => false,
				),
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_color_cart_badge_sale_background_primary' => array(
				'default' => array(
					'preset_1' => '#ff3300',
					'preset_2' => '#ff3300',
					'preset_3' => '#00525e',
					'preset_4' => '#72009e',
					'preset_5' => '#ffb200',
					'preset_6' => '#9c009c',
					'preset_7' => '#b30000',
					'preset_8' => '#c42dbb',
					'preset_9' => '#84b100',
					'preset_10' => '#ff8700',
					'preset_11' => '#005e5c',
					'preset_12' => '#d00000',
					'preset_13' => '#ff4400',
					'preset_14' => '#ce2a2a',
					'preset_15' => '#3474cc',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_color_cart_badge_sale_background_secondary' => array(
				'default' => array(
					'preset_1' => '#ff0000',
					'preset_2' => '#ff3300',
					'preset_3' => '#00525e',
					'preset_4' => '#72009e',
					'preset_5' => '#ffb200',
					'preset_6' => '#9c009c',
					'preset_7' => '#b30000',
					'preset_8' => '#c42dbb',
					'preset_9' => '#84b100',
					'preset_10' => '#ff8700',
					'preset_11' => '#005e5c',
					'preset_12' => '#d00000',
					'preset_13' => '#ff4400',
					'preset_14' => '#ce2a2a',
					'preset_15' => '#3474cc',
					'preset_16' => '#005ce4',
					'preset_17' => '#00a1ff',
					'preset_18' => '#ff5a10',
					'preset_19' => '#cc2a49',
					'preset_20' => '#ffeb00',
				),
				'sanitize' => 'pen_sanitize_color',
			),
			'pen_font_family_site' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_headings' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_sitetitle' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_sitedescription' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_phone_header' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_phone_footer' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_navigation' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_navigation_submenu' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_forms' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_buttons' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_title_list' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_title_content' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_widget_title_top' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_widget_title_left' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_widget_title_right' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_widget_title_bottom' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_family_copyright' => array(
				'default' => array(
					'preset_1' => 'g:Roboto',
					'preset_2' => 'g:Cinzel',
					'preset_3' => 'g:Exo 2',
					'preset_4' => 'g:Noto Sans',
					'preset_5' => 'g:Montserrat',
					'preset_6' => 'g:Roboto',
					'preset_7' => 'g:Roboto Slab',
					'preset_8' => 'g:Ubuntu',
					'preset_9' => 'g:Cabin',
					'preset_10' => 'g:Raleway',
				),
				'sanitize' => 'pen_sanitize_font_family',
			),
			'pen_font_size_sitetitle' => array(
				'default' => 'default',
				'sanitize' => 'pen_sanitize_font_size',
			),
			'pen_font_resize_sitetitle' => array(
				'default' => 'dynamic',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_font_size_sitedescription' => array(
				'default' => 'default',
				'sanitize' => 'pen_sanitize_font_size',
			),
			'pen_font_size_social_header' => array(
				'default' => 'default',
				'sanitize' => 'pen_sanitize_font_size',
			),
			'pen_font_size_social_footer' => array(
				'default' => 'default',
				'sanitize' => 'pen_sanitize_font_size',
			),
			'pen_font_size_phone_header' => array(
				'default' => 'default',
				'sanitize' => 'pen_sanitize_font_size',
			),
			'pen_font_size_phone_footer' => array(
				'default' => 'default',
				'sanitize' => 'pen_sanitize_font_size',
			),
			'pen_font_size_navigation' => array(
				'default' => 'default',
				'sanitize' => 'pen_sanitize_font_size',
			),
			'pen_font_size_title_list' => array(
				'default' => 'default',
				'sanitize' => 'pen_sanitize_font_size',
			),
			'pen_font_size_title_content' => array(
				'default' => 'default',
				'sanitize' => 'pen_sanitize_font_size',
			),
			'pen_font_size_widget_title_top' => array(
				'default' => 'default',
				'sanitize' => 'pen_sanitize_font_size',
			),
			'pen_font_size_widget_title_left' => array(
				'default' => 'default',
				'sanitize' => 'pen_sanitize_font_size',
			),
			'pen_font_size_widget_title_right' => array(
				'default' => 'default',
				'sanitize' => 'pen_sanitize_font_size',
			),
			'pen_font_size_widget_title_bottom' => array(
				'default' => 'default',
				'sanitize' => 'pen_sanitize_font_size',
			),
			'pen_font_size_copyright' => array(
				'default' => 'default',
				'sanitize' => 'pen_sanitize_font_size',
			),
			'pen_transform_text_sitetitle' => array(
				'default' => 'disable',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_transform_text_sitedescription' => array(
				'default' => 'disable',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_transform_text_navigation' => array(
				'default' => 'disable',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_transform_text_navigation_mobile' => array(
				'default' => 'disable',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_transform_text_navigation_submenu' => array(
				'default' => 'disable',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_transform_text_navigation_submenu_mobile' => array(
				'default' => 'disable',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_transform_text_buttons' => array(
				'default' => 'capitalize',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_transform_text_footer_menu' => array(
				'default' => 'uppercase',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_background_image_site_dynamic' => array(
				'default' => 'featured_image',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_background_lights_dim' => array(
				'default' =>  true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_background_image_header_dynamic' => array(
				'default' => 'none',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_background_image_navigation' => array(
				'default' => '',
				'sanitize' => 'esc_url_raw',
			),
			'pen_background_image_navigation_dynamic' => array(
				'default' => 'none',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_background_image_navigation_submenu' => array(
				'default' => '',
				'sanitize' => 'esc_url_raw',
			),
			'pen_background_image_navigation_submenu_dynamic' => array(
				'default' => 'none',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_background_image_search' => array(
				'default' => '',
				'sanitize' => 'esc_url_raw',
			),
			'pen_background_image_search_dynamic' => array(
				'default' => 'none',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_background_image_content_title' => array(
				'default' => '',
				'sanitize' => 'esc_url_raw',
			),
			'pen_background_image_content_title_dynamic' => array(
				'default' => 'none',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_background_image_bottom' => array(
				'default' => '',
				'sanitize' => 'esc_url_raw',
			),
			'pen_background_image_bottom_dynamic' => array(
				'default' => 'none',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_background_image_footer' => array(
				'default' => '',
				'sanitize' => 'esc_url_raw',
			),
			'pen_background_image_footer_dynamic' => array(
				'default' => 'none',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_site_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_header_animation_reveal' => array(
				'default' => 'slideInDown',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_header_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_header_sticky' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_header_sticky_minimize' => array(
				'default'  => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_header_alignment' => array(
				'default' => 'left',
				'sanitize' => 'pen_sanitize_alignment',
			),
			'pen_social_header_animation_reveal' => array(
				'default' => 'slideInLeft',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_social_header_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_header_logo_light' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_header_logo_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_header_logo_animation_reveal' => array(
				'default' => 'fadeInLeft',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_header_logo_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_header_logo_size' => array(
				'default' => 'height',
				'sanitize' => 'pen_sanitize_logo_size',
			),
			'pen_header_sitetitle_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_header_sitetitle_animation_reveal' => array(
				'default' => 'fadeInRight',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_header_sitetitle_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_header_sitedescription_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_header_sitedescription_animation_reveal' => array(
				'default' => 'fadeInLeft',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_header_sitedescription_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_button_users_header_display' => array(
				'default' => PEN_THEME_HAS_WOOCOMMERCE ? 'always' : 'never',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_encourage_register' => array(
				'default' => PEN_THEME_HAS_WOOCOMMERCE ? true : false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_button_users_header_text_register' => array(
				'default' => 'login_register',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_button_users_header_url' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_button_users_header_animation_reveal' => array(
				'default' => 'slideInRight',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_button_users_header_animation_delay_reveal' => array(
				'default' => 1,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_padding_header' => array(
				'default' => 'none',
				'sanitize' => 'pen_sanitize_padding',
			),
			'pen_navigation_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_navigation_mobile_display' => array(
				'default' => 'mobile_tablet',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_navigation_mobile_parents_include' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_navigation_pointer_event' => array(
				'default' => 'hover',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_navigation_mobile_sticky' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_navigation_mobile_text' => array(
				'default' => 'menu',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_navigation_bar_animation_reveal' => array(
				'default' => 'none',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_navigation_bar_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_navigation_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_navigation_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_navigation_separator' => array(
				'default' => 1,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_navigation_separator_submenu' => array(
				'default' => 1,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_navigation_hover' => array(
				'default' => 1,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_navigation_arrows' => array(
				'default' => 1,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_navigation_easing' => array(
				'default' => 'swing',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_navigation_animation_speed' => array(
				'default' => 250,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_navigation_alignment' => array(
				'default' => 'left',
				'sanitize' => 'pen_sanitize_alignment',
			),
			'pen_padding_navigation' => array(
				'default' => 'none',
				'sanitize' => 'pen_sanitize_padding',
			),
			'pen_search_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_search_location' => array(
				'default' => 'header',
				'sanitize' => 'pen_sanitize_location',
			),
			'pen_search_header_animation_reveal' => array(
				'default' => 'slideInRight',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_search_header_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_search_bar_animation_reveal' => array(
				'default' => 'slideInDown',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_search_bar_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_site_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_footer_animation_reveal' => array(
				'default' => 'fadeIn',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_footer_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_footer_alignment' => array(
				'default' => 'left',
				'sanitize' => 'pen_sanitize_alignment',
			),
			'pen_social_footer_animation_reveal' => array(
				'default' => 'slideInLeft',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_social_footer_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_footer_menu_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_footer_menu_animation_reveal' => array(
				'default' => 'slideInRight',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_footer_menu_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_footer_menu_separator' => array(
				'default' => 1,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_footer_back_to_top_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_footer_copyright_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_footer_copyright_text' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_no_animation' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_500px' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_500px_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_500px_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_amazon' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_amazon_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_amazon_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_bandcamp' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_bandcamp_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_bandcamp_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_behance' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_behance_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_behance_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_bitcoin' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_bitcoin_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_bitcoin_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_bitbucket' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_bitbucket_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_bitbucket_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_bluesky' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_bluesky_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_bluesky_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_discord' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_discord_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_discord_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_coffee' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_coffee_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_coffee_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_email' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_email_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_email_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_etsy' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_etsy_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_etsy_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_facebook' => array(
				'default' => PEN_THEME_PREVIEW ? '#' : '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_facebook_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_facebook_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_flickr' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_flickr_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_flickr_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_foursquare' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_foursquare_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_foursquare_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_github' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_github_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_github_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_gitlab' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_gitlab_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_gitlab_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_goodreads' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_goodreads_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_goodreads_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_imdb' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_imdb_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_imdb_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_instagram' => array(
				'default' => PEN_THEME_PREVIEW ? '#' : '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_instagram_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_instagram_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_lastfm' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_lastfm_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_lastfm_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_linkedin' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_linkedin_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_linkedin_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_mastodon' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_mastodon_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_mastodon_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_medium' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_medium_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_medium_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_mewe' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_mewe_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_mewe_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_paypal' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_paypal_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_paypal_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_phone' => array(
				'default' => '123-456-789',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_phone_secondary' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_phone_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_phone_header_animation_reveal' => array(
				'default' => 'slideInLeft',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_phone_header_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_phone_header_label_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_phone_header_label_text' => array(
				'default' => 'tel',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_phone_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_phone_footer_animation_reveal' => array(
				'default' => 'slideInLeft',
				'sanitize' => 'pen_sanitize_animation',
			),
			'pen_phone_footer_animation_delay_reveal' => array(
				'default' => 0,
				'sanitize' => 'pen_sanitize_integer',
			),
			'pen_phone_footer_label_display' => array(
				'default' => false,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_phone_footer_label_text' => array(
				'default' => 'tel',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_pinterest' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_pinterest_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_pinterest_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_podcast' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_podcast_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_podcast_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_producthunt' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_producthunt_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_producthunt_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_reddit' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_reddit_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_reddit_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_rss' => array(
				'default' => get_bloginfo( 'rss2_url' ),
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_rss_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_rss_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_rumble' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_rumble_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_rumble_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_shop' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_shop_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_shop_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_skype' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_skype_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_skype_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_slack' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_slack_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_snapchat' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_snapchat_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_snapchat_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_soundcloud' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_soundcloud_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_soundcloud_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_spotify' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_spotify_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_spotify_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_stack_exchange' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_stack_exchange_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_stack_exchange_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_stack_overflow' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_stack_overflow_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_stack_overflow_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_steam' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_steam_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_steam_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_telegram' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_telegram_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_telegram_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_tiktok' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_tiktok_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_tiktok_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_tumblr' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_tumblr_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_tumblr_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_twitch' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_twitch_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_twitch_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_twitter' => array(
				'default' => PEN_THEME_PREVIEW ? '#' : '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_twitter_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_twitter_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_vcard' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_vcard_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_vcard_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_vimeo' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_vimeo_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_vimeo_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_vk' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_vk_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_vk_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_wechat' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_wechat_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_wechat_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_whatsapp' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_whatsapp_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_whatsapp_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_wordpress' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_wordpress_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_wordpress_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_xing' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_url',
			),
			'pen_xing_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_xing_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_youtube' => array(
				'default' => '',
				'sanitize' => 'pen_sanitize_string',
			),
			'pen_youtube_header_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			),
			'pen_youtube_footer_display' => array(
				'default' => true,
				'sanitize' => 'pen_sanitize_boolean',
			)
			/* phpcs:enable */
		);
	}
}

if ( ! function_exists( 'pen_option_default' ) ) {
	/**
	 * Returns the default value for the specified settings.
	 *
	 * @param string $option The unique ID of the theme setting.
	 * @since Pen 1.0.0
	 * @return mixed
	 */
	function pen_option_default( $option ) {
		if ( 'pen_' !== substr( $option, 0, 4 ) ) {
			$option = 'pen_' . $option;
		}
		$preset_color = pen_preset_get( 'color' );
		if ( false === strpos( $option, '[' ) ) {
			$preset = ( 'pen_color' !== substr( $option, 0, 9 ) ) ? pen_preset_get( $option ) : $preset_color;
		} elseif ( preg_match( '/(.*)\[(.*)\]/', $option, $match ) ) {
			$option = $match[1];
			$preset = $match[2];
		}
		// These options may have different default values based on the color schemes.
		$per_color_scheme = array(
			'pen_content_thumbnail_rotate',
			'pen_list_masonry_thumbnail_style',
			'pen_list_tile_thumbnail_style',
			'pen_list_thumbnail_rotate',
			'pen_round_corners',
		);
		if ( in_array( $option, $per_color_scheme, true ) ) {
			$preset = $preset_color;
		}
		$configuration = pen_configuration();
		if ( isset( $configuration[ $option ] ) ) {
			if ( is_array( $configuration[ $option ]['default'] ) ) {
				if ( isset( $configuration[ $option ]['default'][ $preset ] ) ) {
					return $configuration[ $option ]['default'][ $preset ];
				} else {
					return null;
				}
			} else {
				return $configuration[ $option ]['default'];
			}
		} else {
			return null;
		}
	}
}

if ( ! function_exists( 'pen_option_sanitize' ) ) {
	/**
	 * Sanitizes theme settings.
	 *
	 * @param string $option    The unique ID of the theme setting.
	 * @param mixed  $raw_data  Raw data.
	 *
	 * @since Pen 1.0.0
	 * @return array
	 */
	function pen_option_sanitize( $option, $raw_data = null ) {
		$options = pen_configuration();
		if ( preg_match( '/(.*)\[(.*)\]/', $option, $match ) ) {
			$option = $match[1];
		}
		if ( isset( $options[ $option ] ) ) {
			$sanitizing_function = $options[ $option ]['sanitize'];
			if ( is_null( $raw_data ) ) {
				return $sanitizing_function;
			}
			if ( function_exists( $sanitizing_function ) ) {
				return $sanitizing_function( $raw_data );
			}
		}
		return null;
	}
}

if ( ! function_exists( 'pen_option_get' ) ) {
	/**
	 * A wrapper for the get_theme_mod()
	 *
	 * @param string $option The unique ID of the theme option.
	 *
	 * @since Pen 1.0.0
	 * @return mixed
	 */
	function pen_option_get( $option ) {
		if ( ! is_string( $option ) ) {
			return null;
		}
		if ( 'pen_' !== substr( $option, 0, 4 ) ) {
			$option = 'pen_' . $option;
		}

		if ( get_theme_mod( 'pen_no_animation', false ) ) {
			if ( false !== strpos( $option, '_animation_reveal' ) ) {
				return null;
			}
		}

		$default = pen_option_default( $option );
		if ( is_null( $default ) ) {
			if ( defined( 'WP_DEBUG' ) && WP_DEBUG ) {
				error_log( /* phpcs:ignore */
					esc_html(
						sprintf(
							'[%1$s] %2$s',
							sprintf(
								/* Translators: Theme name. */
								__( '%s Theme', 'pen' ),
								__( 'Pen', 'pen' )
							),
							sprintf(
								/* Translators: a machine-readable setting ID. */
								__( 'Unknown Setting: %s', 'pen' ),
								$option
							)
						)
					),
					0
				);
			}
			return null;
		}
		$value = get_theme_mod( $option, $default );
		if ( is_array( $value ) ) {
			$preset = pen_preset_get( $option );
			if ( isset( $value[ $preset ] ) ) {
				return $value[ $preset ];
			}
			return $default;
		} else {
			return $value;
		}
	}
}

if ( ! function_exists( 'pen_preset_get' ) ) {
	/**
	 * Returns the current preset.
	 *
	 * @param string $option     The option ID.
	 * @param int    $content_id The content ID.
	 *
	 * @since Pen 1.0.3
	 * @return string
	 */
	function pen_preset_get( $option, $content_id = null ) {

		if ( is_null( $content_id ) ) {
			$content_id = pen_post_id();
		}

		if ( 'pen_' === substr( $option, 0, 4 ) ) {
			$option = ltrim( $option, 'pen_' );
		}

		if ( 'color' === substr( $option, 0, 5 ) ) {
			$preview = (int) pen_filter_input( 'GET', 'pen_preview_color' );
			if ( ! $preview ) {
				$preview = (int) pen_filter_input( 'POST', 'pen_preview_color' );
				if ( $preview > 0 && $preview <= PEN_THEME_NUMBER_COLOR_SCHEMES && defined( 'DOING_AJAX' ) && DOING_AJAX ) {
					if ( check_ajax_referer( 'save-customize_' . get_stylesheet(), 'nonce', false ) ) {
						set_theme_mod( 'pen_preset_color', 'preset_' . $preview );
					}
				}
			}
			if ( $preview && $preview <= PEN_THEME_NUMBER_COLOR_SCHEMES ) {
				return 'preset_' . $preview;
			}
			if ( ! is_customize_preview() ) {
				$custom_preset = get_post_meta( $content_id, 'pen_content_custom_preset_color_override', true );
				if ( $custom_preset && 'default' !== $custom_preset ) {
					$custom_preset = (int) str_replace( 'preset_', '', $custom_preset );
					if ( $custom_preset && $custom_preset <= PEN_THEME_NUMBER_COLOR_SCHEMES ) {
						return 'preset_' . $custom_preset;
					}
				}
			}
			return PEN_THEME_PRESET_COLOR;
		} elseif ( 'font_family' === substr( $option, 0, 11 ) ) {
			$preview = (int) pen_filter_input( 'GET', 'pen_preview_font' );
			if ( ! $preview ) {
				$preview = (int) pen_filter_input( 'POST', 'pen_preview_font' );
				if ( $preview && $preview <= PEN_THEME_NUMBER_FONT_PAIRS && defined( 'DOING_AJAX' ) && DOING_AJAX ) {
					if ( check_ajax_referer( 'save-customize_' . get_stylesheet(), 'nonce', false ) ) {
						set_theme_mod( 'pen_preset_font', 'preset_' . $preview );
					}
				}
			}
			if ( $preview && $preview <= PEN_THEME_NUMBER_FONT_PAIRS ) {
				return 'preset_' . $preview;
			}
			if ( ! is_customize_preview() ) {
				$custom_preset = get_post_meta( $content_id, 'pen_content_custom_preset_font_override', true );
				if ( $custom_preset && 'default' !== $custom_preset ) {
					$custom_preset = (int) str_replace( 'preset_', '', $custom_preset );
					if ( $custom_preset && $custom_preset <= PEN_THEME_NUMBER_FONT_PAIRS ) {
						return 'preset_' . $custom_preset;
					}
				}
			}
			return PEN_THEME_PRESET_FONT;
		}
		return 'preset_1';
	}
}

if ( ! function_exists( 'pen_configuration_update' ) ) {
	/**
	 * Updates legacy options.
	 *
	 * @since Pen 1.3.0
	 * @return void
	 */
	function pen_configuration_update() {
		$theme_version = get_theme_mod( 'pen_version', 1 );
		if ( version_compare( $theme_version, '1.3.6', '<' ) || pen_filter_input( 'GET', 'pen_update' ) ) {
			$options = array(
				'pen_encourage_register_url'      => 'pen_button_users_header_url',
				'pen_button_users_header_display' => 'pen_button_users_header_display',
				'pen_background_image_content_title_dynamic' => 'pen_background_image_content_title_dynamic',
				'pen_navigation_mobile_display'   => 'pen_navigation_mobile_display',
			);
			foreach ( $options as $old => $new ) {
				$option_old = get_theme_mod( $old, array() );
				if ( $option_old ) {
					// Variable type was changed from boolean to string.
					if ( 'pen_background_image_content_title_dynamic' === $old ) {
						foreach ( $option_old as $preset => $value ) {
							if ( is_bool( $value ) ) {
								$option_old[ $preset ] = $value ? 'featured_image' : 'none';
							}
						}
					} elseif ( 'pen_button_users_header_display' === $old ) {
						foreach ( $option_old as $preset => $value ) {
							if ( is_bool( $value ) ) {
								$option_old[ $preset ] = $value ? 'always' : 'never';
							}
						}
					} elseif ( 'pen_navigation_mobile_display' === $old ) {
						foreach ( $option_old as $preset => $value ) {
							if ( is_bool( $value ) ) {
								$option_old[ $preset ] = $value ? 'mobile_tablet' : 'never';
							}
						}
					}
					$option_new = get_theme_mod( $new, array() );
					if ( $option_old !== $option_new ) {
						$option_new = $option_old;
						set_theme_mod( $new, $option_new );
						remove_theme_mod( $old );
					}
				}
			}
		}
		set_theme_mod( 'pen_version', wp_get_theme( 'Pen' )->get( 'Version' ) );
	}
}
