<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="profile" href="https://gmpg.org/xfn/11">
  <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

  <?php wp_body_open();?>

  <a class="screen-reader-text skip-link" href="#content"><?php esc_html_e('Skip to content', 'pedro'); ?></a>
  <div id="home"></div>

  <nav class="pedro-navbar">
  <div class="pedro-container">
    <div class="pedro-navflex">
      
      <div class="pedro-brand">
        <?php if (has_custom_logo()) : ?>
          <div class="site-logo"><?php the_custom_logo(); ?></div>
        <?php else : ?>
          <div class="site-title">
            <a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a>
          </div>
        <?php endif; ?>
      </div>

      <button class="pedro-toggler" id="pedroToggle" aria-label="Toggle navigation">
        <span></span>
        <span></span>
        <span></span>
      </button>

      <div class="pedro-nav" id="pedroNav">
        <?php wp_nav_menu([
          'theme_location' => 'primary_menu',
          'pedro-container' => false,
          'menu_class' => 'pedro-nav-list'
        ]); ?>
      </div>

    </div>
  </div>
</nav>
