<?php
/**
* Widget Functions.
*
* @package Outdoor Adventure
*/

function outdoor_adventure_widgets_init(){

	register_sidebar(array(
	    'name' => esc_html__('Main Sidebar', 'outdoor-adventure'),
	    'id' => 'sidebar-1',
	    'description' => esc_html__('Add widgets here.', 'outdoor-adventure'),
	    'before_widget' => '<div id="%1$s" class="widget %2$s">',
	    'after_widget' => '</div>',
	    'before_title' => '<h3 class="widget-title"><span>',
	    'after_title' => '</span></h3>',
	));


    $outdoor_adventure_default = outdoor_adventure_get_default_theme_options();
    $outdoor_adventure_footer_column_layout = absint( get_theme_mod( 'outdoor_adventure_footer_column_layout',$outdoor_adventure_default['outdoor_adventure_footer_column_layout'] ) );

    for( $i = 0; $i < $outdoor_adventure_footer_column_layout; $i++ ){
    	
    	if( $i == 0 ){ $count = esc_html__('One','outdoor-adventure'); }
    	if( $i == 1 ){ $count = esc_html__('Two','outdoor-adventure'); }
    	if( $i == 2 ){ $count = esc_html__('Three','outdoor-adventure'); }

	    register_sidebar( array(
	        'name' => esc_html__('Footer Widget ', 'outdoor-adventure').$count,
	        'id' => 'outdoor-adventure-footer-widget-'.$i,
	        'description' => esc_html__('Add widgets here.', 'outdoor-adventure'),
	        'before_widget' => '<div id="%1$s" class="widget %2$s">',
	        'after_widget' => '</div>',
	        'before_title' => '<h2 class="widget-title">',
	        'after_title' => '</h2>',
	    ));
	}

}

add_action('widgets_init', 'outdoor_adventure_widgets_init');