<?php
/**
 * Settings for demo import
 *
 */

/**
 * Define constants
 **/
if ( ! defined( 'WHIZZIE_DIR' ) ) {
	define( 'WHIZZIE_DIR', dirname( __FILE__ ) );
}
require trailingslashit( WHIZZIE_DIR ) . 'homepage-setup-contents.php';
$outdoor_adventure_current_theme = wp_get_theme();
$outdoor_adventure_theme_title = $outdoor_adventure_current_theme->get( 'Name' );


/**
 * Make changes below
 **/

// Change the title and slug of your wizard page
$config['outdoor_adventure_page_slug'] 	= 'outdoor-adventure';
$config['outdoor_adventure_page_title']	= 'Homepage Setup';

$config['steps'] = array(
	'widgets' => array(
		'id'			=> 'widgets',
		'title'			=> __( 'Setup Home Page', 'outdoor-adventure' ),
		'icon'			=> 'welcome-widgets-menus',
		'button_text'	=> __( 'Start Home Page Setup', 'outdoor-adventure' ),
		'can_skip'		=> true
	),
	'done' => array(
		'id'			=> 'done',
		'title'			=> __( 'Customize Your Site', 'outdoor-adventure' ),
		'icon'			=> 'yes',
	)
);

/**
 * This kicks off the wizard
 **/
if( class_exists( 'Outdoor_Adventure_Whizzie' ) ) {
	$Outdoor_Adventure_Whizzie = new Outdoor_Adventure_Whizzie( $config );
}