<?php
/**
 * Wizard
 *
 * @package Outdoor_Adventure_Whizzie
 * @author Catapult Themes
 * @since 1.0.0
 */

class Outdoor_Adventure_Whizzie {
	
	protected $version = '1.1.0';
	
	/** @var string Current theme name, used as namespace in actions. */
	protected $outdoor_adventure_theme_name = '';
	protected $outdoor_adventure_theme_title = '';
	
	/** @var string Wizard page slug and title. */
	protected $outdoor_adventure_page_slug = '';
	protected $outdoor_adventure_page_title = '';
	
	/** @var array Wizard steps set by user. */
	protected $config_steps = array();
	
	public $parent_slug;
	
	/**
	 * Constructor
	 *
	 * @param $config	Our config parameters
	 */
	public function __construct( $config ) {
		$this->set_vars( $config );
		$this->init();
	}
	
	/**
	 * Set some settings
	 * @since 1.0.0
	 * @param $config	Our config parameters
	 */
	public function set_vars( $config ) {

		if( isset( $config['outdoor_adventure_page_slug'] ) ) {
			$this->outdoor_adventure_page_slug = esc_attr( $config['outdoor_adventure_page_slug'] );
		}
		if( isset( $config['outdoor_adventure_page_title'] ) ) {
			$this->outdoor_adventure_page_title = esc_attr( $config['outdoor_adventure_page_title'] );
		}
		if( isset( $config['steps'] ) ) {
			$this->config_steps = $config['steps'];
		}

		$outdoor_adventure_current_theme = wp_get_theme();
		$this->outdoor_adventure_theme_title = $outdoor_adventure_current_theme->get( 'Name' );
		$this->outdoor_adventure_theme_name = strtolower( preg_replace( '#[^a-zA-Z]#', '', $outdoor_adventure_current_theme->get( 'Name' ) ) );
		$this->outdoor_adventure_page_slug = apply_filters( $this->outdoor_adventure_theme_name . '_theme_setup_wizard_outdoor_adventure_page_slug', $this->outdoor_adventure_theme_name . '-wizard' );
		$this->parent_slug = apply_filters( $this->outdoor_adventure_theme_name . '_theme_setup_wizard_parent_slug', '' );

	}
	
	/**
	 * Hooks and filters
	 * @since 1.0.0
	 */	
	public function init() {

		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'admin_menu', array( $this, 'menu_page' ) );
		add_action( 'wp_ajax_outdoor_adventure_setup_widgets', array( $this, 'outdoor_adventure_setup_widgets' ) );
		
	}
	
	public function enqueue_scripts() {
		wp_enqueue_style( 'outdoor-adventure-homepage-setup-style', get_template_directory_uri() . '/inc/homepage-setup/assets/css/homepage-setup-style.css');
		wp_register_script( 'outdoor-adventure-homepage-setup-script', get_template_directory_uri() . '/inc/homepage-setup/assets/js/homepage-setup-script.js', array( 'jquery' ), time() );
		wp_localize_script( 
			'outdoor-adventure-homepage-setup-script',
			'whizzie_params',
			array(
				'ajaxurl' 		=> admin_url( 'admin-ajax.php' ),
				'wpnonce' 		=> wp_create_nonce( 'whizzie_nonce' ),
				'verify_text'	=> esc_html( 'verifying', 'outdoor-adventure' )
			)
		);
		wp_enqueue_script( 'outdoor-adventure-homepage-setup-script' );
	}
	
	public static function get_instance() {
		if ( ! self::$instance ) {
			self::$instance = new self;
		}
		return self::$instance;
	}
	
	/**
	 * Make a modal screen for the wizard
	 */
	public function menu_page() {
		add_theme_page( esc_html( $this->outdoor_adventure_page_title ), esc_html( $this->outdoor_adventure_page_title ), 'manage_options', $this->outdoor_adventure_page_slug, array( $this, 'wizard_page' ) );
	}
	
	/**
	 * Make an interface for the wizard
	 */
	public function wizard_page() {

		$url = wp_nonce_url( add_query_arg( array( 'plugins' => 'go' ) ), 'whizzie-setup' );
		$method = '';
		$fields = array_keys( $_POST );

		if ( false === ( $creds = request_filesystem_credentials( esc_url_raw( $url ), $method, false, false, $fields ) ) ) {
			return true;
		}

		if ( ! WP_Filesystem( $creds ) ) {
			request_filesystem_credentials( esc_url_raw( $url ), $method, true, false, $fields );
			return true;
		}

		$outdoor_adventure_theme = wp_get_theme();
		$outdoor_adventure_theme_title = $outdoor_adventure_theme->get( 'Name' );
		$outdoor_adventure_theme_version = $outdoor_adventure_theme->get( 'Version' );

		?>
		<div class="wrap">
			<?php
				printf( '<h1>%s %s</h1>', esc_html( $outdoor_adventure_theme_title ), esc_html( '(Version :- ' . $outdoor_adventure_theme_version . ')' ) );
			?>
			<div class="homepage-setup">
				<div class="homepage-setup-theme-bundle">
					<div class="homepage-setup-theme-bundle-one">
						<h1><?php echo esc_html__( 'WP Theme Bundle', 'outdoor-adventure' ); ?></h1>
						<p><?php echo wp_kses_post( 'Get <span>15% OFF</span> on all WordPress themes! Use code <span>"BNDL15OFF"</span> at checkout. Limited time offer!' ); ?></p>
					</div>
					<div class="homepage-setup-theme-bundle-two">
						<p><?php echo wp_kses_post( 'Extra <span>15%</span> OFF' ); ?></p>
					</div>
					<div class="homepage-setup-theme-bundle-three">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/homepage-setup/assets/homepage-setup-images/bundle-banner.png' ); ?>" alt="<?php echo esc_attr__( 'Theme Bundle Image', 'outdoor-adventure' ); ?>">
					</div>
					<div class="homepage-setup-theme-bundle-four">
						<p><?php echo wp_kses_post( '<span>$2795</span>$69' ); ?></p>
						<a target="_blank" href="<?php echo esc_url( OUTDOOR_ADVENTURE_BUNDLE_BUTTON ); ?>"><?php echo esc_html__( 'SHOP NOW', 'outdoor-adventure' ); ?> <span class="dashicons dashicons-arrow-right-alt2"></span></a>
					</div>
				</div>
			</div>
			
			<div class="card whizzie-wrap">
				<div class="demo_content_image">
					<div class="demo_content">
						<?php
							$outdoor_adventure_steps = $this->get_steps();
							echo '<ul class="whizzie-menu">';
							foreach ( $outdoor_adventure_steps as $outdoor_adventure_step ) {
								$class = 'step step-' . esc_attr( $outdoor_adventure_step['id'] );
								echo '<li data-step="' . esc_attr( $outdoor_adventure_step['id'] ) . '" class="' . esc_attr( $class ) . '">';
								printf( '<h2>%s</h2>', esc_html( $outdoor_adventure_step['title'] ) );

								$content = call_user_func( array( $this, $outdoor_adventure_step['view'] ) );
								if ( isset( $content['summary'] ) ) {
									printf(
										'<div class="summary">%s</div>',
										wp_kses_post( $content['summary'] )
									);
								}
								if ( isset( $content['detail'] ) ) {
									printf(
										'<div class="detail">%s</div>',
										wp_kses_post( $content['detail'] )
									);
								}
								if ( isset( $outdoor_adventure_step['button_text'] ) && $outdoor_adventure_step['button_text'] ) {
									printf( 
										'<div class="button-wrap"><a href="#" class="button button-primary do-it" data-callback="%s" data-step="%s">%s</a></div>',
										esc_attr( $outdoor_adventure_step['callback'] ),
										esc_attr( $outdoor_adventure_step['id'] ),
										esc_html( $outdoor_adventure_step['button_text'] )
									);
								}
								echo '</li>';
							}
							echo '</ul>';
						?>
						
						<ul class="whizzie-nav">
							<?php
							$step_number = 1;	
							foreach ( $outdoor_adventure_steps as $outdoor_adventure_step ) {
								echo '<li class="nav-step-' . esc_attr( $outdoor_adventure_step['id'] ) . '">';
								echo '<span class="step-number">' . esc_html( $step_number ) . '</span>';
								echo '</li>';
								$step_number++;
							}
							?>
							<div class="blank-border"></div>
						</ul>

						<div class="homepage-setup-links">
							<div class="homepage-setup-links buttons">
								<a href="<?php echo esc_url( OUTDOOR_ADVENTURE_LITE_DOCS_PRO ); ?>" target="_blank" class="button button-primary"><?php echo esc_html__( 'Free Documentation', 'outdoor-adventure' ); ?></a>
								<a href="<?php echo esc_url( OUTDOOR_ADVENTURE_BUY_NOW ); ?>" class="button button-primary" target="_blank"><?php echo esc_html__( 'Get Premium', 'outdoor-adventure' ); ?></a>
								<a href="<?php echo esc_url( OUTDOOR_ADVENTURE_DEMO_PRO ); ?>" class="button button-primary" target="_blank"><?php echo esc_html__( 'Premium Demo', 'outdoor-adventure' ); ?></a>
								<a href="<?php echo esc_url( OUTDOOR_ADVENTURE_SUPPORT_FREE ); ?>" target="_blank" class="button button-primary"><?php echo esc_html__( 'Support Forum', 'outdoor-adventure' ); ?></a>
							</div>
						</div> <!-- .demo_image -->

						<div class="step-loading"><span class="spinner"></span></div>
					</div> <!-- .demo_content -->

					<div class="homepage-setup-image">
						<div class="homepage-setup-theme-buynow">
							<div class="homepage-setup-theme-buynow-one">
								<h1><?php echo wp_kses_post( 'Outdoor Adventure<br>WordPress Theme' ); ?></h1>
								<p><?php echo wp_kses_post( '<span>25%<br>Off</span> SHOP NOW' ); ?></p>
							</div>
							<div class="homepage-setup-theme-buynow-two">
								<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/homepage-setup/assets/homepage-setup-images/outdoor-adventure.png' ); ?>" alt="<?php echo esc_attr__( 'Theme Bundle Image', 'outdoor-adventure' ); ?>">
							</div>
							<div class="homepage-setup-theme-buynow-three">
								<p><?php echo wp_kses_post( 'Get <span>25% OFF</span> on Premium Outdoor Adventure WordPress Theme Use code <span>"NYTHEMES25"</span> at checkout.' ); ?></p>
							</div>
							<div class="homepage-setup-theme-buynow-four">
								<a target="_blank" href="<?php echo esc_url( OUTDOOR_ADVENTURE_BUY_NOW ); ?>"><?php echo esc_html__( 'Upgrade To Pro With Just $40', 'outdoor-adventure' ); ?></a>
							</div>
						</div>
					</div> <!-- .demo_image -->

				</div> <!-- .demo_content_image -->
			</div> <!-- .whizzie-wrap -->
		</div> <!-- .wrap -->
		<?php
	}


	/**
	 * Set options for the steps
	 * Incorporate any options set by the theme dev
	 * Return the array for the steps
	 * @return Array
	 */
	public function get_steps() {
		$outdoor_adventure_dev_steps = $this->config_steps;
		$outdoor_adventure_steps = array(
			'widgets' => array(
				'id'			=> 'widgets',
				'title'			=> __( 'Setup Home Page', 'outdoor-adventure' ),
				'icon'			=> 'welcome-widgets-menus',
				'view'			=> 'get_step_widgets',
				'callback'		=> 'outdoor_adventure_install_widgets',
				'button_text'	=> __( 'Start Home Page Setup', 'outdoor-adventure' ),
				'can_skip'		=> false
			),
			'done' => array(
				'id'			=> 'done',
				'title'			=> __( 'Customize Your Site', 'outdoor-adventure' ),
				'icon'			=> 'yes',
				'view'			=> 'get_step_done',
				'callback'		=> ''
			)
		);
		
		// Iterate through each step and replace with dev config values
		if( $outdoor_adventure_dev_steps ) {
			// Configurable elements - these are the only ones the dev can update from homepage-setup-settings.php
			$can_config = array( 'title', 'icon', 'button_text', 'can_skip' );
			foreach( $outdoor_adventure_dev_steps as $outdoor_adventure_dev_step ) {
				// We can only proceed if an ID exists and matches one of our IDs
				if( isset( $outdoor_adventure_dev_step['id'] ) ) {
					$id = $outdoor_adventure_dev_step['id'];
					if( isset( $outdoor_adventure_steps[$id] ) ) {
						foreach( $can_config as $element ) {
							if( isset( $outdoor_adventure_dev_step[$element] ) ) {
								$outdoor_adventure_steps[$id][$element] = $outdoor_adventure_dev_step[$element];
							}
						}
					}
				}
			}
		}
		return $outdoor_adventure_steps;
	}
	
	/**
	 * Print the content for the widgets step
	 * @since 1.1.0
	 */
	public function get_step_widgets() { ?> <?php }
	
	/**
	 * Print the content for the final step
	 */
	public function get_step_done() { ?>
		<div id="outdoor-adventure-demo-setup-guid">
			<div class="customize_div">
				<div class="customize_div finish">
					<div class="customize_div finish btns">
						<h3><?php echo esc_html( 'Your Site Is Ready To View' ); ?></h3>
						<div class="btnsss">
							<a target="_blank" href="<?php echo esc_url( get_home_url() ); ?>" class="button button-primary">
								<?php esc_html_e( 'View Your Site', 'outdoor-adventure' ); ?>
							</a>
							<a target="_blank" href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>" class="button button-primary">
								<?php esc_html_e( 'Customize Your Site', 'outdoor-adventure' ); ?>
							</a>
							<a href="<?php echo esc_url(admin_url()); ?>" class="button button-primary">
								<?php esc_html_e( 'Finsh', 'outdoor-adventure' ); ?>
							</a>
						</div>
					</div>
					<div class="outdoor-adventure-setup-finish">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/screenshot.png' ); ?>"/>
					</div>
				</div>
			</div>
		</div>
	<?php }


	public function outdoor_adventure_customizer_nav_menu() {

		/* -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- Outdoor Adventure Primary Menu -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/

		$outdoor_adventure_themename = 'Outdoor Adventure';
		$outdoor_adventure_menuname = $outdoor_adventure_themename . ' Primary Menu';
		$outdoor_adventure_menulocation = 'outdoor-adventure-primary-menu';
		$outdoor_adventure_menu_exists = wp_get_nav_menu_object($outdoor_adventure_menuname);

		if (!$outdoor_adventure_menu_exists) {
			$outdoor_adventure_menu_id = wp_create_nav_menu($outdoor_adventure_menuname);

			// Home
			wp_update_nav_menu_item($outdoor_adventure_menu_id, 0, array(
				'menu-item-title' => __('Home', 'outdoor-adventure'),
				'menu-item-classes' => 'home',
				'menu-item-url' => home_url('/'),
				'menu-item-status' => 'publish'
			));

			// About
			$outdoor_adventure_page_about = get_page_by_path('about');
			if($outdoor_adventure_page_about){
				wp_update_nav_menu_item($outdoor_adventure_menu_id, 0, array(
					'menu-item-title' => __('About', 'outdoor-adventure'),
					'menu-item-classes' => 'about',
					'menu-item-url' => get_permalink($outdoor_adventure_page_about),
					'menu-item-status' => 'publish'
				));
			}

			// Services
			$outdoor_adventure_page_services = get_page_by_path('services');
			if($outdoor_adventure_page_services){
				wp_update_nav_menu_item($outdoor_adventure_menu_id, 0, array(
					'menu-item-title' => __('Services', 'outdoor-adventure'),
					'menu-item-classes' => 'services',
					'menu-item-url' => get_permalink($outdoor_adventure_page_services),
					'menu-item-status' => 'publish'
				));
			}

			// Shop Page (WooCommerce)
			if (class_exists('WooCommerce')) {
				$outdoor_adventure_shop_page_id = wc_get_page_id('shop');
				if ($outdoor_adventure_shop_page_id) {
					wp_update_nav_menu_item($outdoor_adventure_menu_id, 0, array(
						'menu-item-title' => __('Shop', 'outdoor-adventure'),
						'menu-item-classes' => 'shop',
						'menu-item-url' => get_permalink($outdoor_adventure_shop_page_id),
						'menu-item-status' => 'publish'
					));
				}
			}

			// Blog
			$outdoor_adventure_page_blog = get_page_by_path('blog');
			if($outdoor_adventure_page_blog){
				wp_update_nav_menu_item($outdoor_adventure_menu_id, 0, array(
					'menu-item-title' => __('Blog', 'outdoor-adventure'),
					'menu-item-classes' => 'blog',
					'menu-item-url' => get_permalink($outdoor_adventure_page_blog),
					'menu-item-status' => 'publish'
				));
			}

			// 404 Page
			$outdoor_adventure_notfound = get_page_by_path('404 Page');
			if($outdoor_adventure_notfound){
				wp_update_nav_menu_item($outdoor_adventure_menu_id, 0, array(
					'menu-item-title' => __('404 Page', 'outdoor-adventure'),
					'menu-item-classes' => '404',
					'menu-item-url' => get_permalink($outdoor_adventure_notfound),
					'menu-item-status' => 'publish'
				));
			}

			if (!has_nav_menu($outdoor_adventure_menulocation)) {
				$outdoor_adventure_locations = get_theme_mod('nav_menu_locations');
				$outdoor_adventure_locations[$outdoor_adventure_menulocation] = $outdoor_adventure_menu_id;
				set_theme_mod('nav_menu_locations', $outdoor_adventure_locations);
			}
		}
	}

	
	/**
	 * Imports the Demo Content
	 * @since 1.1.0
	 */
	public function outdoor_adventure_setup_widgets(){

		/* -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- MENUS PAGES -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/
		
			// Creation of home page //
			$outdoor_adventure_home_content = '';
			$outdoor_adventure_home_title = 'Home';
			$outdoor_adventure_home = array(
					'post_type' => 'page',
					'post_title' => $outdoor_adventure_home_title,
					'post_content'  => $outdoor_adventure_home_content,
					'post_status' => 'publish',
					'post_author' => 1,
					'post_slug' => 'home'
			);
			$outdoor_adventure_home_id = wp_insert_post($outdoor_adventure_home);

			add_post_meta( $outdoor_adventure_home_id, '_wp_page_template', 'frontpage.php' );

			$outdoor_adventure_home = get_page_by_path( 'Home' );
			update_option( 'page_on_front', $outdoor_adventure_home->ID );
			update_option( 'show_on_front', 'page' );

			// Creation of blog page //
			$outdoor_adventure_blog_title = 'Blog';
			$outdoor_adventure_blog_check = get_page_by_path('blog');
			if (!$outdoor_adventure_blog_check) {
				$outdoor_adventure_blog = array(
					'post_type'    => 'page',
					'post_title'   => $outdoor_adventure_blog_title,
					'post_status'  => 'publish',
					'post_author'  => 1,
					'post_name'    => 'blog'
				);
				$outdoor_adventure_blog_id = wp_insert_post($outdoor_adventure_blog);

				if (!is_wp_error($outdoor_adventure_blog_id)) {
					update_option('page_for_posts', $outdoor_adventure_blog_id);
				}
			}

			// Creation of about page //
			$outdoor_adventure_about_title = 'About';
			$outdoor_adventure_about_content = 'What is Lorem Ipsum?
														Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
			$outdoor_adventure_about_check = get_page_by_path('about');
			if (!$outdoor_adventure_about_check) {
				$outdoor_adventure_about = array(
					'post_type'    => 'page',
					'post_title'   => $outdoor_adventure_about_title,
					'post_content'   => $outdoor_adventure_about_content,
					'post_status'  => 'publish',
					'post_author'  => 1,
					'post_name'    => 'about'
				);
				wp_insert_post($outdoor_adventure_about);
			}

			// Creation of services page //
			$outdoor_adventure_services_title = 'Services';
			$outdoor_adventure_services_content = 'What is Lorem Ipsum?
														Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
			$outdoor_adventure_services_check = get_page_by_path('services');
			if (!$outdoor_adventure_services_check) {
				$outdoor_adventure_services = array(
					'post_type'    => 'page',
					'post_title'   => $outdoor_adventure_services_title,
					'post_content'   => $outdoor_adventure_services_content,
					'post_status'  => 'publish',
					'post_author'  => 1,
					'post_name'    => 'services'
				);
				wp_insert_post($outdoor_adventure_services);
			}

			// Creation of 404 page //
			$outdoor_adventure_notfound_title = '404 Page';
			$outdoor_adventure_notfound = array(
				'post_type'   => 'page',
				'post_title'  => $outdoor_adventure_notfound_title,
				'post_status' => 'publish',
				'post_author' => 1,
				'post_slug'   => '404'
			);
			$outdoor_adventure_notfound_id = wp_insert_post($outdoor_adventure_notfound);
			add_post_meta($outdoor_adventure_notfound_id, '_wp_page_template', '404.php');


		/* -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- SLIDER POST -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/

			$outdoor_adventure_slider_title = array('Would You Like To Join Our Paragliding Adventure?');
			for($outdoor_adventure_i=1;$outdoor_adventure_i<=1;$outdoor_adventure_i++){

				$outdoor_adventure_title = $outdoor_adventure_slider_title[$outdoor_adventure_i-1];
				$outdoor_adventure_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.';

				// Create post object
				$outdoor_adventure_my_post = array(
						'post_title'    => wp_strip_all_tags( $outdoor_adventure_title ),
						'post_content'  => $outdoor_adventure_content,
						'post_status'   => 'publish',
						'post_type'     => 'post',
				);
				// Insert the post into the database
				$outdoor_adventure_post_id = wp_insert_post( $outdoor_adventure_my_post );

				wp_set_object_terms($outdoor_adventure_post_id, 'Slider', 'category', true);

				wp_set_object_terms($outdoor_adventure_post_id, 'Slider', 'post_tag', true);

				$outdoor_adventure_image_url = get_template_directory_uri().'/inc/homepage-setup/assets/homepage-setup-images/slider-img'.$outdoor_adventure_i.'.png';

				$outdoor_adventure_image_name= 'slider-img'.$outdoor_adventure_i.'.png';
				$upload_dir       = wp_upload_dir();
				// Set upload folder
				$outdoor_adventure_image_data       = file_get_contents($outdoor_adventure_image_url);
				// Get image data
				$unique_file_name = wp_unique_filename( $upload_dir['path'], $outdoor_adventure_image_name );

				$outdoor_adventure_filename = basename( $unique_file_name ); 
				
				// Check folder permission and define file location
				if( wp_mkdir_p( $upload_dir['path'] ) ) {
						$outdoor_adventure_file = $upload_dir['path'] . '/' . $outdoor_adventure_filename;
				} else {
						$outdoor_adventure_file = $upload_dir['basedir'] . '/' . $outdoor_adventure_filename;
				}
				// Create the image  file on the server
				// Generate unique name
				if ( ! function_exists( 'WP_Filesystem' ) ) {
					require_once( ABSPATH . 'wp-admin/includes/file.php' );
				}
				
				WP_Filesystem();
				global $wp_filesystem;
				
				if ( ! $wp_filesystem->put_contents( $outdoor_adventure_file, $outdoor_adventure_image_data, FS_CHMOD_FILE ) ) {
					wp_die( 'Error saving file!' );
				}
				// Check image file type
				$wp_filetype = wp_check_filetype( $outdoor_adventure_filename, null );
				// Set attachment data
				$outdoor_adventure_attachment = array(
						'post_mime_type' => $wp_filetype['type'],
						'post_title'     => sanitize_file_name( $outdoor_adventure_filename ),
						'post_content'   => '',
						'post_type'     => 'post',
						'post_status'    => 'inherit'
				);
				// Create the attachment
				$outdoor_adventure_attach_id = wp_insert_attachment( $outdoor_adventure_attachment, $outdoor_adventure_file, $outdoor_adventure_post_id );
				// Include image.php
				require_once(ABSPATH . 'wp-admin/includes/image.php');
				// Define attachment metadata
				$outdoor_adventure_attach_data = wp_generate_attachment_metadata( $outdoor_adventure_attach_id, $outdoor_adventure_file );
				// Assign metadata to attachment
					wp_update_attachment_metadata( $outdoor_adventure_attach_id, $outdoor_adventure_attach_data );
				// And finally assign featured image to post
				set_post_thumbnail( $outdoor_adventure_post_id, $outdoor_adventure_attach_id );

			}
			

			/* -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- SECOND SECTION POST -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/

				$outdoor_adventure_second_section_title = array('Bap Tism','Training','Skydiving');
				for($outdoor_adventure_i=1;$outdoor_adventure_i<=3;$outdoor_adventure_i++){

					$outdoor_adventure_title = $outdoor_adventure_second_section_title[$outdoor_adventure_i-1];
					$outdoor_adventure_content = 'Lorem ipsum dolor sit met elit.';

					// Create post object
					$outdoor_adventure_my_post = array(
							'post_title'    => wp_strip_all_tags( $outdoor_adventure_title ),
							'post_content'  => $outdoor_adventure_content,
							'post_status'   => 'publish',
							'post_type'     => 'post',
					);
						// Insert the post into the database
					$outdoor_adventure_post_id = wp_insert_post( $outdoor_adventure_my_post );

					wp_set_object_terms($outdoor_adventure_post_id, 'Outdoor', 'category', false);

					wp_set_object_terms($outdoor_adventure_post_id, 'Outdoor', 'post_tag', true	);

					$outdoor_adventure_image_url = get_template_directory_uri().'/inc/homepage-setup/assets/homepage-setup-images/post-img'.$outdoor_adventure_i.'.png';

					$outdoor_adventure_image_name= 'post-img'.$outdoor_adventure_i.'.png';
					$upload_dir       = wp_upload_dir();
					// Set upload folder
					$outdoor_adventure_image_data       = file_get_contents($outdoor_adventure_image_url);
					// Get image data
					$unique_file_name = wp_unique_filename( $upload_dir['path'], $outdoor_adventure_image_name );

					$outdoor_adventure_filename = basename( $unique_file_name ); 
					
					// Check folder permission and define file location
					if( wp_mkdir_p( $upload_dir['path'] ) ) {
							$outdoor_adventure_file = $upload_dir['path'] . '/' . $outdoor_adventure_filename;
					} else {
							$outdoor_adventure_file = $upload_dir['basedir'] . '/' . $outdoor_adventure_filename;
					}
					// Create the image  file on the server
					// Generate unique name
					if ( ! function_exists( 'WP_Filesystem' ) ) {
						require_once( ABSPATH . 'wp-admin/includes/file.php' );
					}
					
					WP_Filesystem();
					global $wp_filesystem;
					
					if ( ! $wp_filesystem->put_contents( $outdoor_adventure_file, $outdoor_adventure_image_data, FS_CHMOD_FILE ) ) {
						wp_die( 'Error saving file!' );
					}
					// Check image file type
					$wp_filetype = wp_check_filetype( $outdoor_adventure_filename, null );
					// Set attachment data
					$outdoor_adventure_attachment = array(
							'post_mime_type' => $wp_filetype['type'],
							'post_title'     => sanitize_file_name( $outdoor_adventure_filename ),
							'post_content'   => '',
							'post_type'     => 'post',
							'post_status'    => 'inherit'
					);
					// Create the attachment
					$outdoor_adventure_attach_id = wp_insert_attachment( $outdoor_adventure_attachment, $outdoor_adventure_file, $outdoor_adventure_post_id );
					// Include image.php
					require_once(ABSPATH . 'wp-admin/includes/image.php');
					// Define attachment metadata
					$outdoor_adventure_attach_data = wp_generate_attachment_metadata( $outdoor_adventure_attach_id, $outdoor_adventure_file );
					// Assign metadata to attachment
						wp_update_attachment_metadata( $outdoor_adventure_attach_id, $outdoor_adventure_attach_data );
					// And finally assign featured image to post
					set_post_thumbnail( $outdoor_adventure_post_id, $outdoor_adventure_attach_id );

				}

        
        $this->outdoor_adventure_customizer_nav_menu();

	    exit;
	}
}