<?php

function outdoor_adventure_enqueue_fonts() {
    $outdoor_adventure_default_font_content = 'manrope';
    $outdoor_adventure_default_font_heading = 'manrope';

    $outdoor_adventure_font_content = esc_attr(get_theme_mod('outdoor_adventure_content_typography_font', $outdoor_adventure_default_font_content));
    $outdoor_adventure_font_heading = esc_attr(get_theme_mod('outdoor_adventure_heading_typography_font', $outdoor_adventure_default_font_heading));

    $outdoor_adventure_css = '';

    // Always enqueue main font
    $outdoor_adventure_css .= '
    :root {
        --font-main: ' . $outdoor_adventure_font_content . ', ' . (in_array($outdoor_adventure_font_content, ['bitter', 'charis-sil']) ? 'serif' : 'sans-serif') . '!important;
    }';
    wp_enqueue_style('outdoor-adventure-style-font-general', get_template_directory_uri() . '/fonts/' . $outdoor_adventure_font_content . '/font.css');

    // Always enqueue header font
    $outdoor_adventure_css .= '
    :root {
        --font-head: ' . $outdoor_adventure_font_heading . ', ' . (in_array($outdoor_adventure_font_heading, ['bitter', 'charis-sil']) ? 'serif' : 'sans-serif') . '!important;
    }';
    wp_enqueue_style('outdoor-adventure-style-font-h', get_template_directory_uri() . '/fonts/' . $outdoor_adventure_font_heading . '/font.css');

    // Add inline style
    wp_add_inline_style('outdoor-adventure-style-font-general', $outdoor_adventure_css);
}
add_action('wp_enqueue_scripts', 'outdoor_adventure_enqueue_fonts', 50);