<?php
/**
* Typography Settings.
*
* @package Outdoor Adventure
*/

$outdoor_adventure_default = outdoor_adventure_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'outdoor_adventure_typography_setting',
	array(
	'title'      => esc_html__( 'Typography Settings', 'outdoor-adventure' ),
	'priority'   => 21,
	'capability' => 'edit_theme_options',
	'panel'      => 'outdoor_adventure_theme_option_panel',
	)
);

// -----------------  Font array
$outdoor_adventure_fonts = array(
    'Select'           => __('Default Font', 'outdoor-adventure'),
    'bad-script' => 'Bad Script',
    'bitter'     => 'Bitter',
    'charis-sil' => 'Charis SIL',
    'cuprum'     => 'Cuprum',
    'exo-2'      => 'Exo 2',
    'jost'       => 'Jost',
    'open-sans'  => 'Open Sans',
    'oswald'     => 'Oswald',
    'play'       => 'Play',
    'roboto'     => 'Roboto',
    'outfit'     => 'Outfit',
    'ubuntu'     => 'Ubuntu',
    'manrope'    => 'Manrope',
    'satisfy'    => 'Satisfy',
);

 // -----------------  General text font
 $wp_customize->add_setting( 'outdoor_adventure_content_typography_font', array(
    'default'           => 'manrope',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_radio_sanitize',
) );
$wp_customize->add_control( 'outdoor_adventure_content_typography_font', array(
    'type'     => 'select',
    'label'    => esc_html__( 'General Content Font', 'outdoor-adventure' ),
    'section'  => 'outdoor_adventure_typography_setting',
    'settings' => 'outdoor_adventure_content_typography_font',
    'choices'  => $outdoor_adventure_fonts,
) );

 // -----------------  General Heading Font
$wp_customize->add_setting( 'outdoor_adventure_heading_typography_font', array(
    'default'           => 'manrope',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_radio_sanitize',
) );
$wp_customize->add_control( 'outdoor_adventure_heading_typography_font', array(
    'type'     => 'select',
    'label'    => esc_html__( 'General Heading Font', 'outdoor-adventure' ),
    'section'  => 'outdoor_adventure_typography_setting',
    'settings' => 'outdoor_adventure_heading_typography_font',
    'choices'  => $outdoor_adventure_fonts,
) );