<?php
/**
* Custom Functions.
*
* @package Outdoor Adventure
*/

if( !function_exists( 'outdoor_adventure_sanitize_sidebar_option' ) ) :

    // Sidebar Option Sanitize.
    function outdoor_adventure_sanitize_sidebar_option( $outdoor_adventure_input ){

        $outdoor_adventure_metabox_options = array( 'global-sidebar','left-sidebar','right-sidebar','no-sidebar' );
        if( in_array( $outdoor_adventure_input,$outdoor_adventure_metabox_options ) ){

            return $outdoor_adventure_input;

        }

        return;

    }

endif;

if ( ! function_exists( 'outdoor_adventure_sanitize_checkbox' ) ) :

	/**
	 * Sanitize checkbox.
	 */
	function outdoor_adventure_sanitize_checkbox( $outdoor_adventure_checked ) {

		return ( ( isset( $outdoor_adventure_checked ) && true === $outdoor_adventure_checked ) ? true : false );

	}

endif;


if ( ! function_exists( 'outdoor_adventure_sanitize_select' ) ) :

    /**
     * Sanitize select.
     */
    function outdoor_adventure_sanitize_select( $outdoor_adventure_input, $outdoor_adventure_setting ) {
        $outdoor_adventure_input = sanitize_text_field( $outdoor_adventure_input );
        $outdoor_adventure_choices = $outdoor_adventure_setting->manager->get_control( $outdoor_adventure_setting->id )->choices;
        return ( array_key_exists( $outdoor_adventure_input, $outdoor_adventure_choices ) ? $outdoor_adventure_input : $outdoor_adventure_setting->default );
    }

endif;