<?php
/**
* Customizer Custom Classes.
* @package Outdoor Adventure
*/

if ( ! function_exists( 'outdoor_adventure_sanitize_number_range' ) ) :
    function outdoor_adventure_sanitize_number_range( $outdoor_adventure_input, $outdoor_adventure_setting ) {
        $outdoor_adventure_input = absint( $outdoor_adventure_input );
        $outdoor_adventure_atts = $outdoor_adventure_setting->manager->get_control( $outdoor_adventure_setting->id )->input_attrs;
        $outdoor_adventure_min = ( isset( $outdoor_adventure_atts['min'] ) ? $outdoor_adventure_atts['min'] : $outdoor_adventure_input );
        $outdoor_adventure_max = ( isset( $outdoor_adventure_atts['max'] ) ? $outdoor_adventure_atts['max'] : $outdoor_adventure_input );
        $outdoor_adventure_step = ( isset( $outdoor_adventure_atts['step'] ) ? $outdoor_adventure_atts['step'] : 1 );
        return ( $outdoor_adventure_min <= $outdoor_adventure_input && $outdoor_adventure_input <= $outdoor_adventure_max && is_int( $outdoor_adventure_input / $outdoor_adventure_step ) ? $outdoor_adventure_input : $outdoor_adventure_setting->default );
    }
endif;

/**
 * Upsell customizer section.
 *
 * @since  1.0.0
 * @access public
 */
class Outdoor_Adventure_Customize_Section_Upsell extends WP_Customize_Section {

    /**
     * The type of customize section being rendered.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $type = 'upsell';

    /**
     * Custom button text to output.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $pro_text = '';

    /**
     * Custom pro button URL.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $pro_url = '';

    public $notice = '';
    public $nonotice = '';

    /**
     * Add custom parameters to pass to the JS via JSON.
     *
     * @since  1.0.0
     * @access public
     * @return void
     */
    public function json() {
        $json = parent::json();

        $json['pro_text'] = $this->pro_text;
        $json['pro_url']  = esc_url( $this->pro_url );
        $json['notice']  = esc_attr( $this->notice );
        $json['nonotice']  = esc_attr( $this->nonotice );

        return $json;
    }

    /**
     * Outputs the Underscore.js template.
     *
     * @since  1.0.0
     * @access public
     * @return void
     */
    protected function render_template() { ?>

        <li id="accordion-section-{{ data.id }}" class="accordion-section control-section control-section-{{ data.type }} cannot-expand">

            <# if ( data.notice ) { #>
                <h3 class="accordion-section-notice">
                    {{ data.title }}
                </h3>
            <# } #>

            <# if ( !data.notice ) { #>
                <h3 class="accordion-section-title">
                    {{ data.title }}

                    <# if ( data.pro_text && data.pro_url ) { #>
                        <a href="{{ data.pro_url }}" class="button button-secondary alignright" target="_blank">{{ data.pro_text }}</a>
                    <# } #>
                </h3>
            <# } #>
            
        </li>
    <?php }
}