<?php
/**
* Custom Addons.
*
* @package Outdoor Adventure
*/

$wp_customize->add_section( 'outdoor_adventure_theme_pagination_options',
    array(
    'title'      => esc_html__( 'Customizer Custom Settings', 'outdoor-adventure' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'outdoor_adventure_theme_addons_panel',
    )
);

$wp_customize->add_setting('outdoor_adventure_theme_loader',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_theme_loader'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_theme_loader',
    array(
        'label' => esc_html__('Enable Preloader', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_theme_pagination_options',
        'type' => 'checkbox',
    )
);

// Add Pagination Enable/Disable option to Customizer
$wp_customize->add_setting( 'outdoor_adventure_enable_pagination', 
    array(
        'default'           => true, // Default is enabled
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_enable_pagination', // Sanitize the input
    )
);

// Add the control to the Customizer
$wp_customize->add_control( 'outdoor_adventure_enable_pagination', 
    array(
        'label'    => esc_html__( 'Enable Pagination', 'outdoor-adventure' ),
        'section'  => 'outdoor_adventure_theme_pagination_options', // Add to the correct section
        'type'     => 'checkbox',
    )
);

$wp_customize->add_setting( 'outdoor_adventure_theme_pagination_type', 
    array(
        'default'           => 'numeric', // Set "numeric" as the default
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_pagination_type', // Use our sanitize function
    )
);

$wp_customize->add_control( 'outdoor_adventure_theme_pagination_type',
    array(
        'label'       => esc_html__( 'Pagination Style', 'outdoor-adventure' ),
        'section'     => 'outdoor_adventure_theme_pagination_options',
        'type'        => 'select',
        'choices'     => array(
            'numeric'      => esc_html__( 'Numeric (Page Numbers)', 'outdoor-adventure' ),
            'newer_older'  => esc_html__( 'Newer/Older (Previous/Next)', 'outdoor-adventure' ), // Renamed to "Newer/Older"
        ),
    )
);

$wp_customize->add_setting( 'outdoor_adventure_theme_pagination_options_alignment',
    array(
    'default' => $outdoor_adventure_default['outdoor_adventure_theme_pagination_options_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_pagination_meta',
    )
);
$wp_customize->add_control( 'outdoor_adventure_theme_pagination_options_alignment',
    array(
    'label'       => esc_html__( 'Pagination Alignment', 'outdoor-adventure' ),
    'section'     => 'outdoor_adventure_theme_pagination_options',
    'type'        => 'select',
    'choices'     => array(
        'Center'    => esc_html__( 'Center', 'outdoor-adventure' ),
        'Right' => esc_html__( 'Right', 'outdoor-adventure' ),
        'Left'  => esc_html__( 'Left', 'outdoor-adventure' ),
        ),
    )
);

$wp_customize->add_setting('outdoor_adventure_theme_breadcrumb_enable',
array(
    'default' => $outdoor_adventure_default['outdoor_adventure_theme_breadcrumb_enable'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
)
);
$wp_customize->add_control('outdoor_adventure_theme_breadcrumb_enable',
    array(
        'label' => esc_html__('Enable Breadcrumb', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_theme_pagination_options',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'outdoor_adventure_theme_breadcrumb_options_alignment',
    array(
    'default' => $outdoor_adventure_default['outdoor_adventure_theme_breadcrumb_options_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_pagination_meta',
    )
);
$wp_customize->add_control( 'outdoor_adventure_theme_breadcrumb_options_alignment',
    array(
    'label'       => esc_html__( 'Breadcrumb Alignment', 'outdoor-adventure' ),
    'section'     => 'outdoor_adventure_theme_pagination_options',
    'type'        => 'select',
    'choices'     => array(
        'Center'    => esc_html__( 'Center', 'outdoor-adventure' ),
        'Right' => esc_html__( 'Right', 'outdoor-adventure' ),
        'Left'  => esc_html__( 'Left', 'outdoor-adventure' ),
        ),
    )
);

$wp_customize->add_setting('outdoor_adventure_breadcrumb_font_size',
    array(
        'default'           => $outdoor_adventure_default['outdoor_adventure_breadcrumb_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_number_range',
    )
);
$wp_customize->add_control('outdoor_adventure_breadcrumb_font_size',
    array(
        'label'       => esc_html__('Breadcrumb Font Size', 'outdoor-adventure'),
        'section'     => 'outdoor_adventure_theme_pagination_options',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 45,
           'step'   => 1,
        ),
    )
);