<?php
/**
* Additional Woocommerce Settings.
*
* @package Outdoor Adventure
*/

$outdoor_adventure_default = outdoor_adventure_get_default_theme_options();

// Additional Woocommerce Section.
$wp_customize->add_section( 'outdoor_adventure_additional_woocommerce_options',
	array(
	'title'      => esc_html__( 'Additional Woocommerce Options', 'outdoor-adventure' ),
	'priority'   => 210,
	'capability' => 'edit_theme_options',
	'panel'      => 'outdoor_adventure_theme_option_panel',
	)
);

	$wp_customize->add_setting('outdoor_adventure_per_columns',
		array(
		'default'           => $outdoor_adventure_default['outdoor_adventure_per_columns'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'outdoor_adventure_sanitize_number_range',
		)
	);
	$wp_customize->add_control('outdoor_adventure_per_columns',
		array(
		'label'       => esc_html__('Products Per Column', 'outdoor-adventure'),
		'section'     => 'outdoor_adventure_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 6,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('outdoor_adventure_product_per_page',
		array(
		'default'           => $outdoor_adventure_default['outdoor_adventure_product_per_page'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'outdoor_adventure_sanitize_number_range',
		)
	);
	$wp_customize->add_control('outdoor_adventure_product_per_page',
		array(
		'label'       => esc_html__('Products Per Page', 'outdoor-adventure'),
		'section'     => 'outdoor_adventure_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 100,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('outdoor_adventure_show_hide_related_product',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_show_hide_related_product'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
	);
	$wp_customize->add_control('outdoor_adventure_show_hide_related_product',
	    array(
	        'label' => esc_html__('Enable Related Products', 'outdoor-adventure'),
	        'section' => 'outdoor_adventure_additional_woocommerce_options',
	        'type' => 'checkbox',
	    )
	);

	$wp_customize->add_setting('outdoor_adventure_custom_related_products_number',
		array(
		'default'           => $outdoor_adventure_default['outdoor_adventure_custom_related_products_number'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'outdoor_adventure_sanitize_number_range',
		)
	);
	$wp_customize->add_control('outdoor_adventure_custom_related_products_number',
		array(
		'label'       => esc_html__('Related Products Per Page', 'outdoor-adventure'),
		'section'     => 'outdoor_adventure_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 10,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('outdoor_adventure_custom_related_products_number_per_row',
		array(
		'default'           => $outdoor_adventure_default['outdoor_adventure_custom_related_products_number_per_row'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'outdoor_adventure_sanitize_number_range',
		)
	);
	$wp_customize->add_control('outdoor_adventure_custom_related_products_number_per_row',
		array(
		'label'       => esc_html__('Related Products Per Row', 'outdoor-adventure'),
		'section'     => 'outdoor_adventure_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 5,
		'step'   => 1,
		),
		)
	);