<?php
/**
* 404 Page Settings.
*
* @package Outdoor Adventure
*/

$outdoor_adventure_default = outdoor_adventure_get_default_theme_options();

$wp_customize->add_section( 'outdoor_adventure_404_page_settings',
    array(
        'title'      => esc_html__( '404 Page Settings', 'outdoor-adventure' ),
        'priority'   => 200,
        'capability' => 'edit_theme_options',
        'panel'      => 'outdoor_adventure_theme_addons_panel',
    )
);

$wp_customize->add_setting( 'outdoor_adventure_404_main_title',
    array(
        'default'           => $outdoor_adventure_default['outdoor_adventure_404_main_title'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'outdoor_adventure_404_main_title',
    array(
        'label'    => esc_html__( '404 Main Title', 'outdoor-adventure' ),
        'section'  => 'outdoor_adventure_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'outdoor_adventure_404_subtitle_one',
    array(
        'default'           => $outdoor_adventure_default['outdoor_adventure_404_subtitle_one'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'outdoor_adventure_404_subtitle_one',
    array(
        'label'    => esc_html__( '404 Sub Title One', 'outdoor-adventure' ),
        'section'  => 'outdoor_adventure_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'outdoor_adventure_404_para_one',
    array(
        'default'           => $outdoor_adventure_default['outdoor_adventure_404_para_one'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'outdoor_adventure_404_para_one',
    array(
        'label'    => esc_html__( '404 Para Text One', 'outdoor-adventure' ),
        'section'  => 'outdoor_adventure_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'outdoor_adventure_404_subtitle_two',
    array(
        'default'           => $outdoor_adventure_default['outdoor_adventure_404_subtitle_two'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'outdoor_adventure_404_subtitle_two',
    array(
        'label'    => esc_html__( '404 Sub Title Two', 'outdoor-adventure' ),
        'section'  => 'outdoor_adventure_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'outdoor_adventure_404_para_two',
    array(
        'default'           => $outdoor_adventure_default['outdoor_adventure_404_para_two'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'outdoor_adventure_404_para_two',
    array(
        'label'    => esc_html__( '404 Para Text Two', 'outdoor-adventure' ),
        'section'  => 'outdoor_adventure_404_page_settings',
        'type'     => 'text',
    )
);