<?php
/**
 * Custom Functions.
 *
 * @package Outdoor Adventure
 */

if( !function_exists( 'outdoor_adventure_fonts_url' ) ) :

    //Google Fonts URL
    function outdoor_adventure_fonts_url(){

        $outdoor_adventure_font_families = array(
            'Satisfy',
        );

        $outdoor_adventure_fonts_url = add_query_arg( array(
            'family' => implode( '&family=', $outdoor_adventure_font_families ),
            'display' => 'swap',
        ), 'https://fonts.googleapis.com/css2' );

        return esc_url_raw($outdoor_adventure_fonts_url);
    }

endif;

if ( ! function_exists( 'outdoor_adventure_sub_menu_toggle_button' ) ) :

    function outdoor_adventure_sub_menu_toggle_button( $outdoor_adventure_args, $outdoor_adventure_item, $depth ) {

        // Add sub menu toggles to the main menu with toggles
        if ( $outdoor_adventure_args->theme_location == 'outdoor-adventure-primary-menu' && isset( $outdoor_adventure_args->show_toggles ) ) {
            
            // Wrap the menu item link contents in a div, used for positioning
            $outdoor_adventure_args->before = '<div class="submenu-wrapper">';
            $outdoor_adventure_args->after  = '';

            // Add a toggle to items with children
            if ( in_array( 'menu-item-has-children', $outdoor_adventure_item->classes ) ) {

                $toggle_target_string = '.menu-item.menu-item-' . $outdoor_adventure_item->ID . ' > .sub-menu';

                // Add the sub menu toggle
                $outdoor_adventure_args->after .= '<button type="button" class="theme-aria-button submenu-toggle" data-toggle-target="' . $toggle_target_string . '" data-toggle-type="slidetoggle" data-toggle-duration="250" aria-expanded="false"><span class="btn__content" tabindex="-1"><span class="screen-reader-text">' . esc_html__( 'Show sub menu', 'outdoor-adventure' ) . '</span>' . outdoor_adventure_get_theme_svg( 'chevron-down' ) . '</span></button>';

            }

            // Close the wrapper
            $outdoor_adventure_args->after .= '</div><!-- .submenu-wrapper -->';
            // Add sub menu icons to the main menu without toggles (the fallback menu)

        }elseif( $outdoor_adventure_args->theme_location == 'outdoor-adventure-primary-menu' ) {

            if ( in_array( 'menu-item-has-children', $outdoor_adventure_item->classes ) ) {

                $outdoor_adventure_args->before = '<div class="link-icon-wrapper">';
                $outdoor_adventure_args->after  = outdoor_adventure_get_theme_svg( 'chevron-down' ) . '</div>';

            } else {

                $outdoor_adventure_args->before = '';
                $outdoor_adventure_args->after  = '';

            }

        }

        return $outdoor_adventure_args;

    }

endif;

add_filter( 'nav_menu_item_args', 'outdoor_adventure_sub_menu_toggle_button', 10, 3 );

if ( ! function_exists( 'outdoor_adventure_the_theme_svg' ) ):
    
    function outdoor_adventure_the_theme_svg( $outdoor_adventure_svg_name, $outdoor_adventure_return = false ) {

        if( $outdoor_adventure_return ){

            return outdoor_adventure_get_theme_svg( $outdoor_adventure_svg_name ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Escaped in outdoor_adventure_get_theme_svg();.

        }else{

            echo outdoor_adventure_get_theme_svg( $outdoor_adventure_svg_name ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Escaped in outdoor_adventure_get_theme_svg();.

        }
    }

endif;

if ( ! function_exists( 'outdoor_adventure_get_theme_svg' ) ):

    function outdoor_adventure_get_theme_svg( $outdoor_adventure_svg_name ) {

        // Make sure that only our allowed tags and attributes are included.
        $outdoor_adventure_svg = wp_kses(
            outdoor_adventure_SVG_Icons::get_svg( $outdoor_adventure_svg_name ),
            array(
                'svg'     => array(
                    'class'       => true,
                    'xmlns'       => true,
                    'width'       => true,
                    'height'      => true,
                    'viewbox'     => true,
                    'aria-hidden' => true,
                    'role'        => true,
                    'focusable'   => true,
                ),
                'path'    => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'd'         => true,
                    'transform' => true,
                ),
                'polygon' => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'points'    => true,
                    'transform' => true,
                    'focusable' => true,
                ),
                'polyline' => array(
                    'fill'      => true,
                    'points'    => true,
                ),
                'line' => array(
                    'fill'      => true,
                    'x1'      => true,
                    'x2' => true,
                    'y1'    => true,
                    'y2' => true,
                ),
            )
        );
        if ( ! $outdoor_adventure_svg ) {
            return false;
        }
        return $outdoor_adventure_svg;

    }

endif;

if( !function_exists( 'outdoor_adventure_post_category_list' ) ) :

    // Post Category List.
    function outdoor_adventure_post_category_list( $outdoor_adventure_select_cat = true ){

        $outdoor_adventure_post_cat_lists = get_categories(
            array(
                'hide_empty' => '0',
                'exclude' => '1',
            )
        );

        $outdoor_adventure_post_cat_cat_array = array();
        if( $outdoor_adventure_select_cat ){

            $outdoor_adventure_post_cat_cat_array[''] = esc_html__( '-- Select Category --','outdoor-adventure' );

        }

        foreach ( $outdoor_adventure_post_cat_lists as $outdoor_adventure_post_cat_list ) {

            $outdoor_adventure_post_cat_cat_array[$outdoor_adventure_post_cat_list->slug] = $outdoor_adventure_post_cat_list->name;

        }

        return $outdoor_adventure_post_cat_cat_array;
    }

endif;

if( !function_exists('outdoor_adventure_single_post_navigation') ):

    function outdoor_adventure_single_post_navigation(){

        $outdoor_adventure_default = outdoor_adventure_get_default_theme_options();
        $outdoor_adventure_twp_navigation_type = esc_attr( get_post_meta( get_the_ID(), 'twp_disable_ajax_load_next_post', true ) );
        $outdoor_adventure_current_id = '';
        $article_wrap_class = '';
        global $post;
        $outdoor_adventure_current_id = $post->ID;
        if( $outdoor_adventure_twp_navigation_type == '' || $outdoor_adventure_twp_navigation_type == 'global-layout' ){
            $outdoor_adventure_twp_navigation_type = get_theme_mod('twp_navigation_type', $outdoor_adventure_default['twp_navigation_type']);
        }

        if( $outdoor_adventure_twp_navigation_type != 'no-navigation' && 'post' === get_post_type() ){

            if( $outdoor_adventure_twp_navigation_type == 'theme-normal-navigation' ){ ?>

                <div class="navigation-wrapper">
                    <?php
                    // Previous/next post navigation.
                    the_post_navigation(array(
                        'prev_text' => '<span class="arrow" aria-hidden="true">' . outdoor_adventure_the_theme_svg('arrow-left',$outdoor_adventure_return = true ) . '</span><span class="screen-reader-text">' . esc_html__('Previous post:', 'outdoor-adventure') . '</span><span class="post-title">%title</span>',
                        'next_text' => '<span class="arrow" aria-hidden="true">' . outdoor_adventure_the_theme_svg('arrow-right',$outdoor_adventure_return = true ) . '</span><span class="screen-reader-text">' . esc_html__('Next post:', 'outdoor-adventure') . '</span><span class="post-title">%title</span>',
                    )); ?>
                </div>
                <?php

            }else{

                $outdoor_adventure_next_post = get_next_post();
                if( isset( $outdoor_adventure_next_post->ID ) ){

                    $outdoor_adventure_next_post_id = $outdoor_adventure_next_post->ID;
                    echo '<div loop-count="1" next-post="' . absint( $outdoor_adventure_next_post_id ) . '" class="twp-single-infinity"></div>';

                }
            }

        }

    }

endif;

add_action( 'outdoor_adventure_navigation_action','outdoor_adventure_single_post_navigation',30 );

if( !function_exists('outdoor_adventure_content_offcanvas') ):

    // Offcanvas Contents
    function outdoor_adventure_content_offcanvas(){ ?>

        <div id="offcanvas-menu">
            <div class="offcanvas-wraper">
                <div class="close-offcanvas-menu">
                    <div class="offcanvas-close">
                        <a href="javascript:void(0)" class="skip-link-menu-start"></a>
                        <button type="button" class="button-offcanvas-close">
                            <span class="offcanvas-close-label">
                                <?php echo esc_html__('Close', 'outdoor-adventure'); ?>
                            </span>
                        </button>
                    </div>
                </div>
                <div id="primary-nav-offcanvas" class="offcanvas-item offcanvas-main-navigation">
                    <nav class="primary-menu-wrapper" aria-label="<?php esc_attr_e('Horizontal', 'outdoor-adventure'); ?>" role="navigation">
                        <ul class="primary-menu theme-menu">
                            <?php
                            if (has_nav_menu('outdoor-adventure-primary-menu')) {
                                wp_nav_menu(
                                    array(
                                        'container' => '',
                                        'items_wrap' => '%3$s',
                                        'theme_location' => 'outdoor-adventure-primary-menu',
                                        'show_toggles' => true,
                                    )
                                );
                            }else{

                                wp_list_pages(
                                    array(
                                        'match_menu_classes' => true,
                                        'show_sub_menu_icons' => true,
                                        'title_li' => false,
                                        'show_toggles' => true,
                                        'walker' => new outdoor_adventure_Walker_Page(),
                                    )
                                );
                            }
                            ?>
                        </ul>
                    </nav><!-- .primary-menu-wrapper -->
                </div>
                <a href="javascript:void(0)" class="skip-link-menu-end"></a>
            </div>
        </div>

    <?php
    }

endif;

add_action( 'outdoor_adventure_before_footer_content_action','outdoor_adventure_content_offcanvas',30 );

if( !function_exists('outdoor_adventure_footer_content_widget') ):

    function outdoor_adventure_footer_content_widget(){
        
        $outdoor_adventure_default = outdoor_adventure_get_default_theme_options();
        
        $outdoor_adventure_footer_column_layout = absint(get_theme_mod('outdoor_adventure_footer_column_layout', $outdoor_adventure_default['outdoor_adventure_footer_column_layout']));
        $outdoor_adventure_footer_sidebar_class = 12;
        
        if($outdoor_adventure_footer_column_layout == 2) {
            $outdoor_adventure_footer_sidebar_class = 6;
        }
        
        if($outdoor_adventure_footer_column_layout == 3) {
            $outdoor_adventure_footer_sidebar_class = 4;
        }
        ?>
        
        <?php if ( get_theme_mod('outdoor_adventure_display_footer', true) == true ) : ?>
            <div class="footer-widgetarea">
                <div class="wrapper">
                    <div class="column-row">
                    
                        <?php for ($i = 0; $i < $outdoor_adventure_footer_column_layout; $i++) : ?>
                            
                            <div class="column <?php echo 'column-' . absint($outdoor_adventure_footer_sidebar_class); ?> column-sm-12">
                                
                                <?php 
                                // If no widgets are assigned, display default widgets
                                if ( ! is_active_sidebar( 'outdoor-adventure-footer-widget-' . $i ) ) : 

                                    if ($i === 0) : ?>
                                        <div id="media_image-3" class="widget widget_media_image">
                                            <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/logo.png'); ?>" alt="<?php echo esc_attr__( 'Footer Image', 'outdoor-adventure' ); ?>" style="max-width: 100%; height: auto;">
                                        </div>
                                        <div id="text-3" class="widget widget_text">
                                            <div class="textwidget">
                                                <p class="widget_text">
                                                    <?php esc_html_e('The Outdoor Adventure WordPress Theme is a visually stunning and feature-rich theme designed for adventurers, outdoor sports enthusiasts, and extreme sports businesses. Whether you’re a blogger sharing thrilling experiences, an adventure travel agency, or an outdoor gear retailer, this theme provides the perfect platform to showcase your passion. It is tailored for activities like rock climbing, skydiving, scuba diving, mountaineering, white water rafting, and off-road biking, ensuring a dynamic and immersive user experience.', 'outdoor-adventure'); ?>
                                                </p>
                                            </div>
                                        </div>

                                    <?php elseif ($i === 1) : ?>
                                        <div id="pages-2" class="widget widget_pages">
                                            <h2 class="widget-title"><?php esc_html_e('Calendar', 'outdoor-adventure'); ?></h2>
                                            <?php get_calendar(); ?>
                                        </div>

                                    <?php elseif ($i === 2) : ?>
                                        <div id="search-2" class="widget widget_search">
                                            <h2 class="widget-title"><?php esc_html_e('Enter Keywords Here', 'outdoor-adventure'); ?></h2>
                                            <?php get_search_form(); ?>
                                        </div>
                                    <?php endif; 
                                    
                                else :
                                    // Display dynamic sidebar widget if assigned
                                    dynamic_sidebar('outdoor-adventure-footer-widget-' . $i);
                                endif;
                                ?>
                                
                            </div>
                            
                        <?php endfor; ?>

                    </div>
                </div>
            </div>
        <?php endif; ?> 

    <?php
    }

endif;

add_action( 'outdoor_adventure_footer_content_action', 'outdoor_adventure_footer_content_widget', 10 );

if( !function_exists('outdoor_adventure_footer_content_info') ):

    /**
     * Footer Copyright Area
    **/
    function outdoor_adventure_footer_content_info(){

        $outdoor_adventure_default = outdoor_adventure_get_default_theme_options(); ?>
        <div class="site-info">
            <div class="wrapper">
                <div class="column-row">

                    <div class="column column-9">
                        <div class="footer-credits">

                            <div class="footer-copyright">

                                <?php
                                $outdoor_adventure_footer_copyright_text = wp_kses_post( get_theme_mod( 'outdoor_adventure_footer_copyright_text', $outdoor_adventure_default['outdoor_adventure_footer_copyright_text'] ) );
                                    echo esc_html( $outdoor_adventure_footer_copyright_text );
                                    echo '<br>';
                                    echo esc_html__('Theme: ', 'outdoor-adventure') . '<a href="' . esc_url('https://www.omegathemes.com/products/free-adventure-wordpress-theme') . '" title="' . esc_attr__('Outdoor Adventure', 'outdoor-adventure') . '" target="_blank"><span>' . esc_html__('Outdoor Adventure ', 'outdoor-adventure') . '</span></a>' . esc_html__(' By ', 'outdoor-adventure') . '  <span>' . esc_html__('OMEGA ', 'outdoor-adventure') . '</span>';

                                    echo esc_html__('Powered by ', 'outdoor-adventure') . '<a href="' . esc_url('https://wordpress.org') . '" title="' . esc_attr__('WordPress', 'outdoor-adventure') . '" target="_blank"><span>' . esc_html__('WordPress.', 'outdoor-adventure') . '</span></a>';
                                 ?>

                            </div>
                        </div>
                    </div>


                    <div class="column column-3 align-text-right">
                        <a class="to-the-top" href="#site-header">
                            <span class="to-the-top-long">
                                <?php if ( get_theme_mod('outdoor_adventure_enable_to_the_top', true) == true ) : ?>
                                    <?php
                                    $outdoor_adventure_to_the_top_text = get_theme_mod( 'outdoor_adventure_to_the_top_text', __( 'To the Top', 'outdoor-adventure' ) );
                                    printf( 
                                        wp_kses( 
                                            /* translators: %s is the arrow icon markup */
                                            '%s %s', 
                                            array( 'span' => array( 'class' => array(), 'aria-hidden' => array() ) ) 
                                        ), 
                                        esc_html( $outdoor_adventure_to_the_top_text ),
                                        '<span class="arrow" aria-hidden="true">&uarr;</span>' 
                                    );
                                    ?>
                                <?php endif; ?>
                            </span>
                        </a>

                    </div>
                </div>
            </div>
        </div>

    <?php
    }

endif;

add_action( 'outdoor_adventure_footer_content_action','outdoor_adventure_footer_content_info',20 );


if( !function_exists( 'outdoor_adventure_main_slider' ) ) :

    function outdoor_adventure_main_slider(){

        $outdoor_adventure_defaults = outdoor_adventure_get_default_theme_options();
        $outdoor_adventure_header_banner = get_theme_mod( 'outdoor_adventure_header_banner', $outdoor_adventure_defaults['outdoor_adventure_header_banner'] );
        $outdoor_adventure_header_banner_cat = get_theme_mod( 'outdoor_adventure_header_banner_cat' );

        if( $outdoor_adventure_header_banner ){

            $outdoor_adventure_rtl = '';
            if( is_rtl() ){
                $outdoor_adventure_rtl = 'dir="rtl"';
            }

            $outdoor_adventure_banner_query = new WP_Query( array('post_type' => 'post', 'posts_per_page' => 4,'post__not_in' => get_option("sticky_posts"), 'category_name' => esc_html( $outdoor_adventure_header_banner_cat ) ) );
            $outdoor_adventure_slider_section_short_title = get_theme_mod( 'outdoor_adventure_slider_section_short_title', 
            $outdoor_adventure_defaults['outdoor_adventure_slider_section_short_title'] );
            $outdoor_adventure_banner_background_image = get_theme_mod( 'outdoor_adventure_banner_background_image', 
            $outdoor_adventure_defaults['outdoor_adventure_banner_background_image'] );

          if( $outdoor_adventure_banner_query->have_posts() ): ?>

            <div class="theme-custom-block theme-banner-block" style="background: url(<?php echo esc_url( $outdoor_adventure_banner_background_image ); ?>);">
                <div class="slider-box">
                    <div class="wrapper">
                        <div class="swiper-container theme-main-carousel swiper-container" <?php echo $outdoor_adventure_rtl; ?>>
                            <div class="swiper-wrapper">
                              <?php
                              while( $outdoor_adventure_banner_query->have_posts() ):
                                $outdoor_adventure_banner_query->the_post();
                                $outdoor_adventure_featured_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'large');
                                $outdoor_adventure_default_image = get_template_directory_uri() . '/inc/homepage-setup/assets/homepage-setup-images/slider-img.png'; // Replace with the actual path to your default image
                                $outdoor_adventure_featured_image = isset( $outdoor_adventure_featured_image[0] ) ? $outdoor_adventure_featured_image[0] : $outdoor_adventure_default_image;?>

                                <div class="swiper-slide main-carousel-item">
                                    <div class="theme-article-post">
                                        <div class="main-carousel-caption">
                                            <div class="post-content ">
                                                <?php if( $outdoor_adventure_slider_section_short_title ){ ?>
                                                    <h6><?php echo esc_html( $outdoor_adventure_slider_section_short_title ); ?></h6>
                                                <?php } ?>
                                                <header class="entry-header">
                                                    <h2 class="entry-title entry-title-big">
                                                        <a href="<?php the_permalink(); ?>" rel="bookmark"><span><?php the_title(); ?></span></a>
                                                    </h2>
                                                </header>
                                                <div class="slider-btn">
                                                    <a href="<?php the_permalink(); ?>" class="btn-fancy btn-fancy-primary" tabindex="0">
                                                      <?php echo esc_html__('Get Started', 'outdoor-adventure'); ?><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 320 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path d="M285.5 273L91.1 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.7-22.7c-9.4-9.4-9.4-24.5 0-33.9L188.5 256 34.5 101.3c-9.3-9.4-9.3-24.5 0-33.9l22.7-22.7c9.4-9.4 24.6-9.4 33.9 0L285.5 239c9.4 9.4 9.4 24.6 0 33.9z"/></svg>
                                                    </a>
                                                    <?php if(get_theme_mod('outdoor_adventure_slider_video_button_url','#') != ''){ ?>
                                                        <span class="slide-btn">
                                                          <!-- Button to open the modal -->
                                                          <a id="openModalButton" data-modal-src="<?php echo esc_url(get_theme_mod('outdoor_adventure_slider_video_button_url','#')); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1.5em" viewBox="0 0 192 512"><!--!Font Awesome Free 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M0 384.7V127.3c0-17.8 21.5-26.7 34.1-14.1l128.7 128.7c7.8 7.8 7.8 20.5 0 28.3L34.1 398.8C21.5 411.4 0 402.5 0 384.7z"/></svg></a>
                                                          <?php esc_html_e('watch video','outdoor-adventure'); ?>
                                                          <!-- The modal -->
                                                          <div id="myModal" class="modal">
                                                            <!-- Modal content -->
                                                            <div class="modal-content">
                                                              <span id="closeModalButton" class="close">&times;</span>
                                                              <?php if( get_theme_mod('outdoor_adventure_slider_video_button_url','#') != ''){ ?>
                                                              <embed id="videoPlayer" height="369" src="<?php echo esc_url(get_theme_mod('outdoor_adventure_slider_video_button_url','#')); ?>"  allow="accelerometer; autoplay; classipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></embed>
                                                              <?php }else{ ?>
                                                                <h3><?php esc_html_e('Add Video Url In Customizer To Display Video Here','outdoor-adventure'); ?></h3>
                                                              <?php } ?>
                                                            </div>
                                                          </div> 
                                                        </span>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="entry-thumbnail">
                                            <div class="data-bg data-bg-large" data-background="<?php echo esc_url($outdoor_adventure_featured_image); ?>">
                                                <a href="<?php the_permalink(); ?>" class="theme-image-responsive" tabindex="0"></a>
                                            </div>
                                          <?php outdoor_adventure_post_format_icon(); ?>
                                        </div>
                                    </div>
                                </div>

                              <?php endwhile; ?>

                            </div>

                            <div class="swiper-pagination"></div>                  
                        </div>
                    </div>
                </div>
            </div>

          <?php
          wp_reset_postdata();
          endif;

        }

    }

endif;

if (!function_exists('outdoor_adventure_post_format_icon')):

    // Post Format Icon.
    function outdoor_adventure_post_format_icon() {

        $outdoor_adventure_format = get_post_format(get_the_ID()) ?: 'standard';
        $outdoor_adventure_icon = '';
        $outdoor_adventure_title = '';
        if( $outdoor_adventure_format == 'video' ){
            $outdoor_adventure_icon = outdoor_adventure_get_theme_svg( 'video' );
            $outdoor_adventure_title = esc_html__('Video','outdoor-adventure');
        }elseif( $outdoor_adventure_format == 'audio' ){
            $outdoor_adventure_icon = outdoor_adventure_get_theme_svg( 'audio' );
            $outdoor_adventure_title = esc_html__('Audio','outdoor-adventure');
        }elseif( $outdoor_adventure_format == 'gallery' ){
            $outdoor_adventure_icon = outdoor_adventure_get_theme_svg( 'gallery' );
            $outdoor_adventure_title = esc_html__('Gallery','outdoor-adventure');
        }elseif( $outdoor_adventure_format == 'quote' ){
            $outdoor_adventure_icon = outdoor_adventure_get_theme_svg( 'quote' );
            $outdoor_adventure_title = esc_html__('Quote','outdoor-adventure');
        }elseif( $outdoor_adventure_format == 'image' ){
            $outdoor_adventure_icon = outdoor_adventure_get_theme_svg( 'image' );
            $outdoor_adventure_title = esc_html__('Image','outdoor-adventure');
        } elseif( $outdoor_adventure_format == 'link' ){
            $outdoor_adventure_icon = outdoor_adventure_get_theme_svg( 'link' );
            $outdoor_adventure_title = esc_html__('Link','outdoor-adventure');
        } elseif( $outdoor_adventure_format == 'status' ){
            $outdoor_adventure_icon = outdoor_adventure_get_theme_svg( 'status' );
            $outdoor_adventure_title = esc_html__('Status','outdoor-adventure');
        } elseif( $outdoor_adventure_format == 'aside' ){
            $outdoor_adventure_icon = outdoor_adventure_get_theme_svg( 'aside' );
            $outdoor_adventure_title = esc_html__('Aside','outdoor-adventure');
        } elseif( $outdoor_adventure_format == 'chat' ){
            $outdoor_adventure_icon = outdoor_adventure_get_theme_svg( 'chat' );
            $outdoor_adventure_title = esc_html__('Chat','outdoor-adventure');
        }
        
        if (!empty($outdoor_adventure_icon)) { ?>
            <div class="theme-post-format">
                <span class="post-format-icom"><?php echo outdoor_adventure_svg_escape($outdoor_adventure_icon); ?></span>
                <?php if( $outdoor_adventure_title ){ echo '<span class="post-format-label">'.esc_html( $outdoor_adventure_title ).'</span>'; } ?>
            </div>
        <?php }
    }

endif;

if ( ! function_exists( 'outdoor_adventure_svg_escape' ) ):

    /**
     * Get information about the SVG icon.
     *
     * @param string $outdoor_adventure_svg_name The name of the icon.
     * @param string $group The group the icon belongs to.
     * @param string $color Color code.
     */
    function outdoor_adventure_svg_escape( $outdoor_adventure_input ) {

        // Make sure that only our allowed tags and attributes are included.
        $outdoor_adventure_svg = wp_kses(
            $outdoor_adventure_input,
            array(
                'svg'     => array(
                    'class'       => true,
                    'xmlns'       => true,
                    'width'       => true,
                    'height'      => true,
                    'viewbox'     => true,
                    'aria-hidden' => true,
                    'role'        => true,
                    'focusable'   => true,
                ),
                'path'    => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'd'         => true,
                    'transform' => true,
                ),
                'polygon' => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'points'    => true,
                    'transform' => true,
                    'focusable' => true,
                ),
            )
        );

        if ( ! $outdoor_adventure_svg ) {
            return false;
        }

        return $outdoor_adventure_svg;

    }

endif;

if( !function_exists( 'outdoor_adventure_sanitize_sidebar_option_meta' ) ) :

    // Sidebar Option Sanitize.
    function outdoor_adventure_sanitize_sidebar_option_meta( $outdoor_adventure_input ){

        $outdoor_adventure_metabox_options = array( 'global-sidebar','left-sidebar','right-sidebar','no-sidebar' );
        if( in_array( $outdoor_adventure_input,$outdoor_adventure_metabox_options ) ){

            return $outdoor_adventure_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'outdoor_adventure_sanitize_pagination_meta' ) ) :

    // Sidebar Option Sanitize.
    function outdoor_adventure_sanitize_pagination_meta( $outdoor_adventure_input ){

        $outdoor_adventure_metabox_options = array( 'Center','Right','Left');
        if( in_array( $outdoor_adventure_input,$outdoor_adventure_metabox_options ) ){

            return $outdoor_adventure_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'outdoor_adventure_aboutus_slider' ) ) :

    function outdoor_adventure_aboutus_slider(){

        $outdoor_adventure_defaults = outdoor_adventure_get_default_theme_options();
        $outdoor_adventure_services = get_theme_mod( 'outdoor_adventure_services', $outdoor_adventure_defaults['outdoor_adventure_services'] );
        $outdoor_adventure_video_section_left_post_cat = get_theme_mod( 'outdoor_adventure_video_section_left_post_cat' );

        $outdoor_adventure_services_section_title = get_theme_mod( 'outdoor_adventure_services_section_title', 
        $outdoor_adventure_defaults['outdoor_adventure_services_section_title'] );

        $outdoor_adventure_services_section_short_title = get_theme_mod( 'outdoor_adventure_services_section_short_title', 
        $outdoor_adventure_defaults['outdoor_adventure_services_section_short_title'] );        
        
        if( $outdoor_adventure_services ){ ?>

        <div class="theme-custom-block theme-services-block">
            <div class="wrapper">
                <div class="section-content">
                    <?php if( $outdoor_adventure_services_section_short_title ){ ?>
                        <h6><?php echo esc_html( $outdoor_adventure_services_section_short_title ); ?></h6>
                    <?php } ?>

                    <?php if( $outdoor_adventure_services_section_title ){ ?>
                        <h2><?php echo esc_html( $outdoor_adventure_services_section_title ); ?></h2>
                    <?php } ?>
                </div>
                <div class="adventure-packs">
                    <div class="owl-carousel" role="listbox">
                        <?php  $outdoor_adventure_locations_query = new WP_Query( array('post_type' => 'post', 'posts_per_page' => 6,'post__not_in' => get_option("sticky_posts"), 'category_name' => esc_html( $outdoor_adventure_video_section_left_post_cat ) ) );
                        if( $outdoor_adventure_locations_query->have_posts() ): ?>
                            <?php
                                $s=1;
                                while( $outdoor_adventure_locations_query->have_posts() ):
                                $outdoor_adventure_locations_query->the_post();
                                $outdoor_adventure_featured_packs_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'large');
                                $outdoor_adventure_featured_packs_image = isset( $outdoor_adventure_featured_packs_image[0] ) ? $outdoor_adventure_featured_packs_image[0] : '';

                                ?>                                
                                <div class="theme-article-post video-left-post-content">
                                    <div class="entry-thumbnail">
                                        <div class="data-bg featured-img" data-background="<?php echo esc_url($outdoor_adventure_featured_packs_image ? $outdoor_adventure_featured_packs_image : get_template_directory_uri() . '/assets/images/packs.png'); ?>">
                                        </div>
                                        <?php outdoor_adventure_post_format_icon(); ?>
                                    </div>
                                    <div class="main-video-caption">
                                        <header class="entry-header">
                                            <h2 class="entry-title entry-title-big">
                                                <a href="<?php the_permalink(); ?>" rel="bookmark"><span><?php the_title(); ?></span></a>
                                            </h2>
                                        </header>
                                        <div class="entry-content">
                                            <?php
                                                if (has_excerpt()) {

                                                    the_excerpt();

                                                } else {

                                                echo esc_html(wp_trim_words(get_the_content(), 25, '...'));

                                            } ?>
                                        </div>
                                    </div>
                                </div>
                            <?php $s++; endwhile; ?>
                        <?php wp_reset_postdata(); endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <?php } ?>
            
    <?php }


endif;

if( !function_exists( 'outdoor_adventure_sanitize_menu_transform' ) ) :

    // Sidebar Option Sanitize.
    function outdoor_adventure_sanitize_menu_transform( $outdoor_adventure_input ){

        $outdoor_adventure_metabox_options = array( 'capitalize','uppercase','lowercase');
        if( in_array( $outdoor_adventure_input,$outdoor_adventure_metabox_options ) ){

            return $outdoor_adventure_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'outdoor_adventure_sanitize_page_content_alignment' ) ) :

    // Sidebar Option Sanitize.
    function outdoor_adventure_sanitize_page_content_alignment( $outdoor_adventure_input ){

        $outdoor_adventure_metabox_options = array( 'left','center','right');
        if( in_array( $outdoor_adventure_input,$outdoor_adventure_metabox_options ) ){

            return $outdoor_adventure_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'outdoor_adventure_sanitize_footer_widget_title_alignment' ) ) :

    // Footer Option Sanitize.
    function outdoor_adventure_sanitize_footer_widget_title_alignment( $outdoor_adventure_input ){

        $outdoor_adventure_metabox_options = array( 'left','center','right');
        if( in_array( $outdoor_adventure_input,$outdoor_adventure_metabox_options ) ){

            return $outdoor_adventure_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'outdoor_adventure_sanitize_pagination_type' ) ) :

    /**
     * Sanitize the pagination type setting.
     *
     * @param string $outdoor_adventure_input The input value from the Customizer.
     * @return string The sanitized value.
     */
    function outdoor_adventure_sanitize_pagination_type( $outdoor_adventure_input ) {
        // Define valid options for the pagination type.
        $outdoor_adventure_valid_options = array( 'numeric', 'newer_older' ); // Update valid options to include 'newer_older'

        // If the input is one of the valid options, return it. Otherwise, return the default option ('numeric').
        if ( in_array( $outdoor_adventure_input, $outdoor_adventure_valid_options, true ) ) {
            return $outdoor_adventure_input;
        } else {
            // Return 'numeric' as the fallback if the input is invalid.
            return 'numeric';
        }
    }

endif;


// Sanitize the enable/disable setting for pagination
if( !function_exists('outdoor_adventure_sanitize_enable_pagination') ) :
    function outdoor_adventure_sanitize_enable_pagination( $outdoor_adventure_input ) {
        return (bool) $outdoor_adventure_input;
    }
endif;

if( !function_exists( 'outdoor_adventure_sanitize_copyright_alignment_meta' ) ) :

    // Sidebar Option Sanitize.
    function outdoor_adventure_sanitize_copyright_alignment_meta( $outdoor_adventure_input ){

        $outdoor_adventure_metabox_options = array( 'Default','Reverse','Center');
        if( in_array( $outdoor_adventure_input,$outdoor_adventure_metabox_options ) ){

            return $outdoor_adventure_input;

        }else{

            return '';

        }
    }

endif;

/**
 * Sidebar Layout Function
 */
function outdoor_adventure_get_final_sidebar_layout() {
	$outdoor_adventure_defaults       = outdoor_adventure_get_default_theme_options();
	$outdoor_adventure_global_layout  = get_theme_mod('outdoor_adventure_global_sidebar_layout', $outdoor_adventure_defaults['outdoor_adventure_global_sidebar_layout']);
	$outdoor_adventure_page_layout    = get_theme_mod('outdoor_adventure_page_sidebar_layout', $outdoor_adventure_global_layout);
	$outdoor_adventure_post_layout    = get_theme_mod('outdoor_adventure_post_sidebar_layout', $outdoor_adventure_global_layout);
	$outdoor_adventure_meta_layout    = get_post_meta(get_the_ID(), 'outdoor_adventure_post_sidebar_option', true);

	if (!empty($outdoor_adventure_meta_layout) && $outdoor_adventure_meta_layout !== 'default') {
		return $outdoor_adventure_meta_layout;
	}
	if (is_page() || (function_exists('is_shop') && is_shop())) {
		return $outdoor_adventure_page_layout;
	}
	if (is_single()) {
		return $outdoor_adventure_post_layout;
	}
	return $outdoor_adventure_global_layout;
}