<?php 
// Loads the header.php template.
get_header();
?>

<?php
// Dispay Loop Meta at top
olius_add_custom_title_content( 'pre', 'single.php' );
if ( olius_titlearea_top() ) {
	olius_pagehead_img( 'post', false );
	get_template_part( 'template-parts/loop-meta' ); // Loads the template-parts/loop-meta.php template to display Title Area with Meta Info (of the loop)
	olius_add_custom_title_content( 'post', 'single.php' );
} else {
	olius_pagehead_img( 'post', true );
}

// Template modification Hook
do_action( 'olius_before_content_grid', 'single.php' );
?>

<div class="hgrid main-content-grid">

	<main <?php hoot_attr( 'content' ); ?>>
		<div <?php hoot_attr( 'content-wrap', 'single' ); ?>>

			<?php
			// Template modification Hook
			do_action( 'olius_main_start', 'single.php' );

			// Checks if any posts were found.
			if ( have_posts() ) :

				// Dispay Loop Meta in content wrap
				if ( ! olius_titlearea_top() ) {
					olius_add_custom_title_content( 'post', 'single.php' );
					get_template_part( 'template-parts/loop-meta' ); // Loads the template-parts/loop-meta.php template to display Title Area with Meta Info (of the loop)
				}

				// Template modification Hook
				do_action( 'olius_loop_start', 'single.php' );

				// Display Featured Image if present
				if ( olius_featured_image_location('post') === 'content' ) {
					$img_size = apply_filters( 'olius_post_imgsize', '', 'content' );
					hoot_post_thumbnail( 'entry-content-featured-img', $img_size, true );
				}

				// Begins the loop through found posts, and load the post data.
				while ( have_posts() ) : the_post();

					// Loads the template-parts/content-{$post_type}.php template.
					hoot_get_content_template();

				// End found posts loop.
				endwhile;

				// Template modification Hook
				do_action( 'olius_loop_end', 'single.php' );

				// Loads the template-parts/loop-nav.php template.
				get_template_part( 'template-parts/loop-nav' );

				// Template modification Hook
				do_action( 'olius_after_content_wrap', 'single.php' );

				// Loads the comments.php template
				if ( !is_attachment() ) {
					comments_template( '', true );
				};

			// If no posts were found.
			else :

				// Loads the template-parts/error.php template.
				get_template_part( 'template-parts/error' );

			// End check for posts.
			endif;

			// Template modification Hook
			do_action( 'olius_main_end', 'single.php' );
			?>

		</div><!-- #content-wrap -->
	</main><!-- #content -->

	<?php hoot_get_sidebar(); // Loads the sidebar.php template. ?>

</div><!-- .main-content-grid -->

<?php get_footer(); // Loads the footer.php template. ?>