<?php
/**
 * Displays footer top area
 *
 * @package NotoMag
 */

$enable_footer_social_nav = notomag_get_option('enable_footer_social_nav');
$enable_footer_social_nav_border_radius = notomag_get_option('enable_footer_social_nav_border_radius');
$select_footer_social_menu_style = notomag_get_option('select_footer_social_menu_style');
?>
<div class="site-footer-area footer-area-top">
    <div class="wrapper">
        <div class="site-info-panel">
            <?php if ($enable_footer_social_nav) { ?>
                <nav aria-label="<?php esc_attr_e('Footer Social links', 'notomag'); ?>">
                    <ul class="social-menu reset-list-style social-icons <?php echo esc_attr($select_footer_social_menu_style); ?> <?php if ($enable_footer_social_nav_border_radius) {
                        echo "has-border-radius";
                    } ?>">
                        <?php
                        wp_nav_menu(
                            array(
                                'theme_location' => 'social',
                                'container' => '',
                                'container_class' => '',
                                'items_wrap' => '%3$s',
                                'menu_id' => '',
                                'menu_class' => '',
                                'depth' => 1,
                                'link_before' => '<span class="screen-reader-text">',
                                'link_after' => '</span>',
                                'fallback_cb' => '',
                            )
                        );
                        ?>
                    </ul>
                </nav>
            <?php } ?>


        </div>
    </div>
</div><!-- .site-info -->