<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package NotoMag
 */

/**
 * Update post meta and check if it was updated.
 *
 * @param int    $post_id    The post ID.
 * @param string $meta_key   The meta key.
 * @param mixed  $meta_value The meta value.
 * @return bool  True if updated, false otherwise.
 */
function notomag_update_post_meta_and_check( $post_id, $meta_key, $meta_value ) {
    $result = update_post_meta( $post_id, $meta_key, $meta_value );

    if ( $result === true || is_numeric( $result ) ) {
        return true; // Meta was updated or added.
    } elseif ( $result === false ) {
        return false; // Meta was not updated.
    }

    return false;
}

$enable_single_author_meta = notomag_get_option('enable_single_author_meta');
$select_single_author_meta = notomag_get_option('select_single_author_meta');
$single_author_meta_title = notomag_get_option('single_author_meta_title');

$enable_single_date_meta = notomag_get_option('enable_single_date_meta');
$select_single_date = notomag_get_option('select_single_date');
$single_date_meta_title = notomag_get_option('single_date_meta_title');
$select_single_date_format = notomag_get_option('select_single_date_format');

$enable_single_category_meta = notomag_get_option('enable_single_category_meta');
$single_category_label = notomag_get_option('single_category_label');
$select_single_category_color = notomag_get_option('select_single_category_color');
$enable_single_read_time_meta = notomag_get_option('enable_single_read_time_meta');
$enable_single_tag_meta = notomag_get_option('enable_single_tag_meta');

$show_sticky_article_navigation = notomag_get_option('show_sticky_article_navigation');
$show_related_posts = notomag_get_option('show_related_posts');
$show_author_posts = notomag_get_option('show_author_posts');
$show_author_info = notomag_get_option('show_author_info');

$notomag_post_navigation = get_post_meta($post->ID, 'notomag_single_post_navigation', true);
$notomag_single_category_meta = get_post_meta($post->ID, 'notomag_single_category_meta', true);
$notomag_single_date_meta = get_post_meta($post->ID, 'notomag_single_date_meta', true);
$notomag_single_author_meta = get_post_meta($post->ID, 'notomag_single_author_meta', true);
$notomag_single_related_post = get_post_meta($post->ID, 'notomag_single_related_post', true);
$notomag_single_author_post = get_post_meta($post->ID, 'notomag_single_author_post', true);
$notomag_single_post_author = get_post_meta($post->ID, 'notomag_single_post_author', true);
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('wpi-post wpi-post-default'); ?>>
    <?php notomag_get_breadcrumb(); ?>
    <?php notomag_post_thumbnail(); ?>
    <div class="entry-details">
        <header class="entry-header">
            <?php 
            if ($notomag_single_category_meta == 1) {
                notomag_post_category($select_single_category_color, $single_category_label);
            } elseif ($notomag_single_category_meta == '') {
                if ($enable_single_category_meta) {
                    notomag_post_category($select_single_category_color, $single_category_label);
                }
            } elseif ($notomag_single_category_meta == 0) {
            }

            ?>
            <?php
            if (! $enable_single_read_time_meta) {
                notomag_get_readtime();
            } ?>
            <?php
            the_title('<h1 class="entry-title entry-title-large">', '</h1>');

            if ('post' === get_post_type()) :
                ?>
                <div class="entry-meta-wrapper">
                    <?php
                    if ($notomag_single_date_meta == 1) {
                        notomag_posted_on($select_single_date_format, $single_date_meta_title ,$select_single_date);
                    } elseif ($notomag_single_date_meta == '') {
                        if ($enable_single_date_meta) {
                        notomag_posted_on($select_single_date_format, $single_date_meta_title ,$select_single_date);
                        }
                    } elseif ($notomag_single_date_meta == 0) {
                    }
                    ?>

                    <?php
                    if ($notomag_single_author_meta == 1) {
                        echo '<div class="entry-meta-separator"></div>';
                        notomag_posted_by($select_single_author_meta , $single_author_meta_title);
                    } elseif ($notomag_single_author_meta == '') {
                        if ($enable_single_author_meta) {
                            echo '<div class="entry-meta-separator"></div>';
                            notomag_posted_by($select_single_author_meta , $single_author_meta_title);
                        }
                    } elseif ($notomag_single_author_meta == 0) {
                    }
                    ?>
                </div><!-- .entry-meta -->
            <?php endif; ?>
        </header><!-- .entry-header -->

        <div class="entry-content">
            <?php
            the_content(
                sprintf(
                    wp_kses(
                    /* translators: %s: Name of current post. Only visible to screen readers */
                        __('Continue reading<span class="screen-reader-text"> "%s"</span>', 'notomag'),
                        array(
                            'span' => array(
                                'class' => array(),
                            ),
                        )
                    ),
                    wp_kses_post(get_the_title())
                )
            );

            wp_link_pages(
                array(
                    'before' => '<div class="page-links">' . esc_html__('Pages:', 'notomag'),
                    'after' => '</div>',
                )
            );
            ?>
        </div><!-- .entry-content -->

        <footer class="entry-footer">
            <?php notomag_entry_footer($enable_single_tag_meta); ?>
        </footer><!-- .entry-footer -->
    </div>
</article><!-- #post-<?php the_ID(); ?> -->

<?php
    if ('post' === get_post_type()) :
        
    if ($notomag_single_post_author == 1) {
        get_template_part('template-parts/single/single-author-info');
    } elseif ($notomag_single_post_author == '') {
        if ($show_author_info) {
        get_template_part('template-parts/single/single-author-info');
        }
    } elseif ($notomag_single_post_author == 0) {
    }


    if ( !$notomag_single_related_post ){
        if ($show_related_posts) {
        get_template_part('template-parts/single/single-related-posts');
        }
    }elseif($notomag_single_related_post == 1){
        get_template_part('template-parts/single/single-related-posts');
    }

    if ( !$notomag_single_author_post ){
        if ($show_author_posts) {
        get_template_part('template-parts/single/single-author-posts');
        }
    }elseif($notomag_single_author_post == 1){
        get_template_part('template-parts/single/single-author-posts');
    }

endif;
?>

<?php
if ($notomag_post_navigation == 1) {
    get_template_part( 'template-parts/single/sticky-article-nav' );
} elseif ($notomag_post_navigation == '') {
    if ($show_sticky_article_navigation) {
    get_template_part( 'template-parts/single/sticky-article-nav' );
    }
} elseif ($notomag_post_navigation == 0) {
}
?>