<?php
// Tags Posts Options.
$wp_customize->add_section(
	'home_page_tags_options',
	array(
		'title' => __( 'Tags Options', 'notomag' ),
		'panel' => 'header_options_panel',
	)
);

$wp_customize->add_setting(
    'notomag_options[enable_tags]',
    array(
        'default'           => $notomag_default['enable_tags'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_tags]',
    array(
		'label'    => __( 'Enable Tags Section', 'notomag' ),
        'section'     => 'home_page_tags_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_tags_only_on_frontpage]',
    array(
        'default' => $notomag_default['enable_tags_only_on_frontpage'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_tags_only_on_frontpage]',
    array(
        'label' => __('Display only on the Homepage', 'notomag'),
        'section' => 'home_page_tags_options',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_tags_label]',
    array(
        'default'           => $notomag_default['enable_tags_label'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);

$wp_customize->add_control(
    'notomag_options[enable_tags_label]',
    array(
        'label'           => __( 'Enable Tags Label', 'notomag' ),
        'section'     => 'home_page_tags_options',
        'type'        => 'checkbox',
    )
);

// Tags Label Style.
$wp_customize->add_setting(
    'notomag_options[tags_label_style]',
    array(
        'default'           => $notomag_default['tags_label_style'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[tags_label_style]',
    array(
        'label'           => __( 'Label Style', 'notomag' ),
        'section'         => 'home_page_tags_options',
        'type'            => 'select',
        'choices'         => array(
            'style_1' => __( 'Plain', 'notomag' ),
            'style_2' => __( 'With Icon', 'notomag' ),
        ),
    )
);


// Tags Label Text.
$wp_customize->add_setting(
    'notomag_options[tags_label_text]',
    array(
        'default'           => $notomag_default['tags_label_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[tags_label_text]',
    array(
        'label'           => __( 'Tags Label Text', 'notomag' ),
        'description'     => __( 'Leave empty if you want it blank', 'notomag' ),
        'section'         => 'home_page_tags_options',
        'type'            => 'text',
    )
);

// No of posts.
$wp_customize->add_setting(
    'notomag_options[no_of_tags]',
    array(
        'default'           => $notomag_default['no_of_tags'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[no_of_tags]',
    array(
		'label'           => __( 'Number of Tags', 'notomag' ),
		'section'         => 'home_page_tags_options',
		'type'            => 'number',
    )
);


// Posts Orderby.
$wp_customize->add_setting(
    'notomag_options[tags_orderby]',
    array(
        'default'           => $notomag_default['tags_orderby'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[tags_orderby]',
    array(
		'label'           => __( 'Orderby', 'notomag' ),
		'section'         => 'home_page_tags_options',
		'type'            => 'select',
		'choices'         => array(
			'date'  => __( 'Date', 'notomag' ),
			'id'    => __( 'ID', 'notomag' ),
			'title' => __( 'Title', 'notomag' ),
			'rand'  => __( 'Random', 'notomag' ),
		),
    )
);


// Posts Order.
$wp_customize->add_setting(
    'notomag_options[tags_order]',
    array(
        'default'           => $notomag_default['tags_order'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[tags_order]',
    array(
		'label'           => __( 'Orderby', 'notomag' ),
		'section'         => 'home_page_tags_options',
		'type'            => 'select',
		'choices'         => array(
			'asc'  => __( 'ASC', 'notomag' ),
			'desc' => __( 'DESC', 'notomag' ),
		),
    )
);


$wp_customize->add_setting(
    'notomag_options[hide_tags_label_responsive]',
    array(
        'default'           => $notomag_default['hide_tags_label_responsive'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[hide_tags_label_responsive]',
    array(
		'label'           => __( 'Hide Label on Responsive', 'notomag' ),
        'section'     => 'home_page_tags_options',
        'type'        => 'checkbox',
    )
);