<?php
$wp_customize->add_section(
    'single_related_options',
    array(
        'title' => esc_html__( 'Single Related Options', 'notomag' ),
        'panel' => 'single_options_panel',
    )
);
/*Show Related Posts
*-------------------------------*/
$wp_customize->add_setting(
    'notomag_options[show_related_posts]',
    array(
        'default'           => $notomag_default['show_related_posts'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[show_related_posts]',
    array(
        'label'    => __( 'Show Related Posts', 'notomag' ),
        'section'  => 'single_related_options',
        'type'     => 'checkbox',
    )
);

/*Related Posts Text.*/
$wp_customize->add_setting(
    'notomag_options[related_posts_text]',
    array(
        'default'           => $notomag_default['related_posts_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[related_posts_text]',
    array(
        'label'    => __( 'Related Posts Text', 'notomag' ),
        'section'  => 'single_related_options',
        'type'     => 'text',
    )
);

/* Number of Related Posts */
$wp_customize->add_setting(
    'notomag_options[no_of_related_posts]',
    array(
        'default'           => $notomag_default['no_of_related_posts'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[no_of_related_posts]',
    array(
        'label'       => __( 'Number of Related Posts', 'notomag' ),
        'section'     => 'single_related_options',
        'type'        => 'number',
    )
);

// No of posts offset.
$wp_customize->add_setting(
    'notomag_options[related_posts_number_of_post_offsets]',
    array(
        'default' => $notomag_default['related_posts_number_of_post_offsets'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[related_posts_number_of_post_offsets]',
    array(
        'label' => __('Post Offset Number', 'notomag'),
        'section' => 'single_related_options',
        'type' => 'number',
    )
);


/*Related Posts Orderby*/
$wp_customize->add_setting(
    'notomag_options[related_posts_orderby]',
    array(
        'default'           => $notomag_default['related_posts_orderby'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[related_posts_orderby]',
    array(
        'label'       => __( 'Orderby', 'notomag' ),
        'section'     => 'single_related_options',
        'type'        => 'select',
        'choices' => array(
            'date' => __('Date', 'notomag'),
            'id' => __('ID', 'notomag'),
            'title' => __('Title', 'notomag'),
            'rand' => __('Random', 'notomag'),
        ),
    )
);

/*Related Posts Order*/
$wp_customize->add_setting(
    'notomag_options[related_posts_order]',
    array(
        'default'           => $notomag_default['related_posts_order'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[related_posts_order]',
    array(
        'label'       => __( 'Order', 'notomag' ),
        'section'     => 'single_related_options',
        'type'        => 'select',
        'choices' => array(
            'asc' => __('ASC', 'notomag'),
            'desc' => __('DESC', 'notomag'),
        ),
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_related_posts_author_meta]',
    array(
        'default'           => $notomag_default['enable_related_posts_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_related_posts_author_meta]',
    array(
        'label'       => esc_html__( 'Show Author Meta', 'notomag' ),
        'section'     => 'single_related_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_related_posts_author_meta]',
    array(
        'default'           => $notomag_default['select_related_posts_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_related_posts_author_meta]',
    array(
        'label'         => esc_html__( 'Author Meta Display Options', 'notomag' ),
        'section'     => 'single_related_options',
        'type'        => 'select',
        'choices'       => notomag_author_meta(),


    )
);

$wp_customize->add_setting(
    'notomag_options[related_posts_author_meta_title]',
    array(
        'default'           => $notomag_default['related_posts_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[related_posts_author_meta_title]',
    array(
        'label'    => __( 'Author Meta Text', 'notomag' ),
        'section'  => 'single_related_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_related_posts_date_meta]',
    array(
        'default'           => $notomag_default['enable_related_posts_date_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_related_posts_date_meta]',
    array(
        'label'       => esc_html__( 'Display Published Date', 'notomag' ),
        'section'     => 'single_related_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_related_posts_date]',
    array(
        'default'           => $notomag_default['select_related_posts_date'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_related_posts_date]',
    array(
        'label'         => esc_html__( 'Select Date Meta', 'notomag' ),
        'section'     => 'single_related_options',
        'type'        => 'select',
        'choices'       => notomag_date_meta(),

    )
);

$wp_customize->add_setting(
    'notomag_options[single_related_post_date_meta_title]',
    array(
        'default'           => $notomag_default['single_related_post_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[single_related_post_date_meta_title]',
    array(
        'label'    => __( 'Date Meta Text', 'notomag' ),
        'section'  => 'single_related_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_related_posts_date_format]',
    array(
        'default'           => $notomag_default['select_related_posts_date_format'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_related_posts_date_format]',
    array(
        'label'         => esc_html__( 'Select Date Format', 'notomag' ),
        'section'     => 'single_related_options',
        'type'        => 'select',
        'choices'       => notomag_get_date_formats(),
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_related_posts_category_meta]',
    array(
        'default'           => $notomag_default['enable_related_posts_category_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_related_posts_category_meta]',
    array(
        'label'       => esc_html__( 'Enable Category Meta', 'notomag' ),
        'section'     => 'single_related_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_related_posts_number_of_category]',
    array(
        'default'           => $notomag_default['select_related_posts_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[select_related_posts_number_of_category]',
    array(
        'label'       => __( 'Number of Category', 'notomag' ),
        'section'     => 'single_related_options',
        'type'        => 'number',
    )
);

$wp_customize->add_setting(
    'notomag_options[related_posts_category_label]',
    array(
        'default'           => $notomag_default['related_posts_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[related_posts_category_label]',
    array(
        'label'    => __( 'Category Label', 'notomag' ),
        'section'  => 'single_related_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_related_posts_category_color]',
    array(
        'default'           => $notomag_default['select_related_posts_category_color'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_related_posts_category_color]',
    array(
        'label'         => esc_html__( 'Select Category Color', 'notomag' ),
        'section'     => 'single_related_options',
        'type'        => 'select',
        'choices'       => notomag_category_color(),

    )
);