<?php
$wp_customize->add_section(
	'sidebar_options',
	array(
		'title' => esc_html__( 'SideBar Options', 'notomag' ),
		'panel' => 'archive_options_panel',
	)
);

$wp_customize->add_setting(
    'notomag_options[sidebar_layout_option]',
    array(
        'default'           => $notomag_default['sidebar_layout_option'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'notomag_sanitize_radio'
    )
);

$wp_customize->add_control(
    new NotoMag_Custom_Radio_Image_Control(
        $wp_customize,
        'notomag_options[sidebar_layout_option]',
        array(
            'label'         => esc_html__( 'Select Sidebar Layout (archive)', 'notomag' ),
            'section'       => 'sidebar_options',
            'choices'       => notomag_get_sidebar_layouts(),
        )
    )
);


$wp_customize->add_setting(
    'notomag_options[single_sidebar_layout_option]',
    array(
        'default'           => $notomag_default['single_sidebar_layout_option'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'notomag_sanitize_radio'
    )
);

$wp_customize->add_control(
    new NotoMag_Custom_Radio_Image_Control(
        $wp_customize,
        'notomag_options[single_sidebar_layout_option]',
        array(
            'label'         => esc_html__( 'Select Sidebar Layout (Single)', 'notomag' ),
            'section'       => 'sidebar_options',
            'choices'       => notomag_get_sidebar_layouts(),
        )
    )
);


$wp_customize->add_setting(
    'notomag_options[enable_sidebar_fix_archive]',
    array(
        'default'           => $notomag_default['enable_sidebar_fix_archive'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_sidebar_fix_archive]',
    array(
        'label'    => __( 'Enable Sticky Sidebar', 'notomag' ),
        'section'     => 'sidebar_options',
        'type'        => 'checkbox',
    )
);
