<?php
// Popular Posts Options.
$wp_customize->add_section(
    'home_page_popular_post_options',
    array(
        'title' => __('Popular Options', 'notomag'),
        'panel' => 'header_options_panel',
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_popular_posts]',
    array(
        'default' => $notomag_default['enable_popular_posts'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_popular_posts]',
    array(
        'label' => __('Enable Popular Section', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_popular_only_on_frontpage]',
    array(
        'default' => $notomag_default['enable_popular_only_on_frontpage'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_popular_only_on_frontpage]',
    array(
        'label' => __('Display only on the Homepage', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
    )
);


$wp_customize->add_setting(
    'notomag_options[enable_popular_label]',
    array(
        'default'           => $notomag_default['enable_popular_label'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_popular_label]',
    array(
        'label'           => __( 'Enable Popular Label', 'notomag' ),
        'section'     => 'home_page_popular_post_options',
        'type'        => 'checkbox',
    )
);

// Popular Label Text.
$wp_customize->add_setting(
    'notomag_options[popular_label_text]',
    array(
        'default'           => $notomag_default['popular_label_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[popular_label_text]',
    array(
        'label'           => __( 'Popular Label', 'notomag' ),
        'description'     => __( 'Leave blank to use the default text "Latest".', 'notomag' ),
        'section'         => 'home_page_popular_post_options',
        'type'            => 'text',
    )
);


// Popular Posts Category.
$wp_customize->add_setting(
    'notomag_options[popular_post_cat]',
    array(
        'default' => $notomag_default['popular_post_cat'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new NotoMag_Dropdown_Taxonomies_Control(
        $wp_customize,
        'notomag_options[popular_post_cat]',
        array(
            'label' => __('Choose Category', 'notomag'),
            'section' => 'home_page_popular_post_options',
        )
    )
);
// No of posts.
$wp_customize->add_setting(
    'notomag_options[no_of_popular_posts]',
    array(
        'default' => $notomag_default['no_of_popular_posts'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[no_of_popular_posts]',
    array(
        'label' => __('Number of Posts', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'number',
    )
);

// No of posts offset.
$wp_customize->add_setting(
    'notomag_options[popular_posts_number_of_post_offsets]',
    array(
        'default' => $notomag_default['popular_posts_number_of_post_offsets'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[popular_posts_number_of_post_offsets]',
    array(
        'label' => __('Post Offset Number', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'number',
    )
);


// Posts Orderby.
$wp_customize->add_setting(
    'notomag_options[popular_post_orderby]',
    array(
        'default' => $notomag_default['popular_post_orderby'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[popular_post_orderby]',
    array(
        'label' => __('Orderby', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => array(
            'date' => __('Date', 'notomag'),
            'id' => __('ID', 'notomag'),
            'title' => __('Title', 'notomag'),
            'rand' => __('Random', 'notomag'),
        ),
    )
);
// Posts Order.
$wp_customize->add_setting(
    'notomag_options[popular_post_order]',
    array(
        'default' => $notomag_default['popular_post_order'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[popular_post_order]',
    array(
        'label' => __('Order', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => array(
            'asc' => __('ASC', 'notomag'),
            'desc' => __('DESC', 'notomag'),
        ),
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_popular_post_author_meta]',
    array(
        'default' => $notomag_default['enable_popular_post_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_popular_post_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_popular_post_author_meta]',
    array(
        'default' => $notomag_default['select_popular_post_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_popular_post_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => notomag_author_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[popular_post_author_meta_title]',
    array(
        'default' => $notomag_default['popular_post_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[popular_post_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_popular_post_date_meta]',
    array(
        'default' => $notomag_default['enable_popular_post_date_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_popular_post_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_popular_post_date]',
    array(
        'default' => $notomag_default['select_popular_post_date'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_popular_post_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => notomag_date_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[select_popular_post_date_meta_title]',
    array(
        'default' => $notomag_default['select_popular_post_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[select_popular_post_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_popular_post_date_format]',
    array(
        'default' => $notomag_default['select_popular_post_date_format'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_popular_post_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => notomag_get_date_formats(),
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_popular_category_meta]',
    array(
        'default' => $notomag_default['enable_popular_category_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_popular_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_popular_number_of_category]',
    array(
        'default' => $notomag_default['select_popular_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[select_popular_number_of_category]',
    array(
        'label' => __('Number of Category', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'notomag_options[popular_post_offset_number]',
    array(
        'default' => $notomag_default['popular_post_offset_number'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[popular_post_offset_number]',
    array(
        'label' => __('Post Offset', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'notomag_options[popular_category_label]',
    array(
        'default' => $notomag_default['popular_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[popular_category_label]',
    array(
        'label' => __('Category Label', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_popular_category_color]',
    array(
        'default' => $notomag_default['select_popular_category_color'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_popular_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => notomag_category_color(),
    )
);

// Enable  Autoplay.
$wp_customize->add_setting(
    'notomag_options[enable_popular_post_autoplay]',
    array(
        'default' => $notomag_default['enable_popular_post_autoplay'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_popular_post_autoplay]',
    array(
        'label' => __('Enable Autoplay', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
        'active_callback' => 'notomag_is_popular_post_enabled',
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_popular_post_arrows]',
    array(
        'default' => $notomag_default['enable_popular_post_arrows'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_popular_post_arrows]',
    array(
        'label' => __('Enable Arrows', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
        'active_callback' => 'notomag_is_popular_post_enabled',
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_popular_post_dots]',
    array(
        'default' => $notomag_default['enable_popular_post_dots'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_popular_post_dots]',
    array(
        'label' => __('Enable Dots', 'notomag'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
        'active_callback' => 'notomag_is_popular_post_enabled',
    )
);
