<?php
/**
 * All settings related to main banner post.
 *
 * @package NotoMag
 */
$wp_customize->add_section(
	'main_banner_post',
	array(
		'title' => esc_html__( 'Main Banner Section', 'notomag' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'notomag_options[enable_main_banner_section]',
    array(
        'default'           => $notomag_default['enable_main_banner_section'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_main_banner_section]',
    array(
        'label'       => esc_html__( 'Enable Main Banner', 'notomag' ),
        'section'     => 'main_banner_post',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'notomag_section_seperator_banner_column_1',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new NotoMag_Seperator_Control(
        $wp_customize,
        'notomag_section_seperator_banner_column_1',
        array(
            'label'         => esc_html__( 'Banner Column - 1', 'notomag' ),
            'settings' => 'notomag_section_seperator_banner_column_2',
            'section' => 'main_banner_post',
        )
    )
);


$wp_customize->add_setting(
    'notomag_options[banner_grid_first_category]',
    array(
        'default'           => $notomag_default['banner_grid_first_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new NotoMag_Dropdown_Taxonomies_Control(
        $wp_customize,
        'notomag_options[banner_grid_first_category]',
        array(
            'label'           => __( 'Choose Grid Category', 'notomag' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'notomag' ),
            'section'         => 'main_banner_post',
        )
    )
);


$wp_customize->add_setting(
    'notomag_options[banner_grid_first_category_offset]',
    array(
        'default' => $notomag_default['banner_grid_first_category_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[banner_grid_first_category_offset]',
    array(
        'label' => __('First Category Post Offset', 'notomag'),
        'section' => 'main_banner_post',
        'type' => 'number',
    )
);



$wp_customize->add_setting(
    'notomag_section_seperator_banner_column_3',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new NotoMag_Seperator_Control(
        $wp_customize,
        'notomag_section_seperator_banner_column_3',
        array(
            'label'         => esc_html__( 'Banner Column - 3', 'notomag' ),
            'settings' => 'notomag_section_seperator_banner_column_3',
            'section' => 'main_banner_post',
        )
    )
);

$wp_customize->add_setting(
    'notomag_options[banner_grid_third_category]',
    array(
        'default'           => $notomag_default['banner_grid_third_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new NotoMag_Dropdown_Taxonomies_Control(
        $wp_customize,
        'notomag_options[banner_grid_third_category]',
        array(
            'label'           => __( 'Choose List Post Category', 'notomag' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'notomag' ),
            'section'         => 'main_banner_post',
        )
    )
);

$wp_customize->add_setting(
    'notomag_options[banner_grid_third_column_category_offset]',
    array(
        'default' => $notomag_default['banner_grid_third_column_category_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[banner_grid_third_column_category_offset]',
    array(
        'label' => __('List Post Offset', 'notomag'),
        'section' => 'main_banner_post',
        'type' => 'number',
    )
);





$wp_customize->add_setting(
    'notomag_section_seperator_banner',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new NotoMag_Seperator_Control(
        $wp_customize,
        'notomag_section_seperator_banner',
        array(
            'label'         => esc_html__( 'Banner Section Meta', 'notomag' ),
            'settings' => 'notomag_section_seperator_banner',
            'section' => 'main_banner_post',
        )
    )
);


$wp_customize->add_setting(
    'notomag_options[enable_banner_author_meta]',
    array(
        'default' => $notomag_default['enable_banner_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_banner_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'notomag'),
        'section' => 'main_banner_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_banner_author_meta]',
    array(
        'default' => $notomag_default['select_banner_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_banner_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'notomag'),
        'section' => 'main_banner_post',
        'type' => 'select',
        'choices' => notomag_author_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[banner_author_meta_title]',
    array(
        'default' => $notomag_default['banner_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[banner_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'notomag'),
        'section' => 'main_banner_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_banner_date_meta]',
    array(
        'default' => $notomag_default['enable_banner_date_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_banner_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'notomag'),
        'section' => 'main_banner_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_banner_date]',
    array(
        'default' => $notomag_default['select_banner_date'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_banner_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'notomag'),
        'section' => 'main_banner_post',
        'type' => 'select',
        'choices' => notomag_date_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[select_banner_date_meta_title]',
    array(
        'default' => $notomag_default['select_banner_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[select_banner_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'notomag'),
        'section' => 'main_banner_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_banner_date_format]',
    array(
        'default' => $notomag_default['select_banner_date_format'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_banner_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'notomag'),
        'section' => 'main_banner_post',
        'type' => 'select',
        'choices' => notomag_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_banner_category_meta]',
    array(
        'default' => $notomag_default['enable_banner_category_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_banner_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'notomag'),
        'section' => 'main_banner_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_banner_number_of_category]',
    array(
        'default' => $notomag_default['select_banner_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[select_banner_number_of_category]',
    array(
        'label' => __('Number of Category', 'notomag'),
        'section' => 'main_banner_post',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'notomag_options[banner_category_label]',
    array(
        'default' => $notomag_default['banner_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[banner_category_label]',
    array(
        'label' => __('Category Label', 'notomag'),
        'section' => 'main_banner_post',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_banner_category_color]',
    array(
        'default' => $notomag_default['select_banner_category_color'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_banner_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'notomag'),
        'section' => 'main_banner_post',
        'type' => 'select',
        'choices' => notomag_category_color(),
    )
);