<?php
$wp_customize->add_section(
   'header_style_options' ,
    array(
        'title' => __( 'Header Layout', 'notomag' ),
        'panel' => 'header_options_panel',
    )
);


$wp_customize->add_setting(
    'notomag_options[select_header_layout_style]',
    array(
        'default'           => $notomag_default['select_header_layout_style'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'notomag_sanitize_radio'
    )
);

$wp_customize->add_control(
    new NotoMag_Custom_Radio_Image_Control(
        $wp_customize,
        'notomag_options[select_header_layout_style]',
        array(
            'label'         => esc_html__( 'Select Header Layout', 'notomag' ),
            'section'       => 'header_style_options',
            'choices'       => notomag_get_header_layout(),
        )
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_header_advertisement]',
    array(
        'default'           => $notomag_default['enable_header_advertisement'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_header_advertisement]',
    array(
        'label'    => __( 'Enable Header Advertisement', 'notomag' ),
        'section'     => 'header_style_options',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'notomag_options[header_advert_image]',
    array(
        'default' => $notomag_default['header_advert_image'],
        'sanitize_callback' => 'notomag_sanitize_image',
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'notomag_options[header_advert_image]',
        array(
            'label' => __('Upload Banner Advertisement', 'notomag'),
            'section' => 'header_style_options',
            'active_callback' => 'notomag_header_advertisement',

        )
    )
);


$wp_customize->add_setting(
    'notomag_options[header_advert_image_url]',
    array(
        'default'           => $notomag_default['header_advert_image_url'],
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control(
    'notomag_options[header_advert_image_url]',
    array(
        'label'    => __( 'Banner Advertisement URL', 'notomag' ),
        'section'  => 'header_style_options',
        'type'     => 'text',
        'active_callback' => 'notomag_header_advertisement',

    )
);