<?php
/**
 * All settings related to footer recommended post.
 *
 * @package NotoMag
 */
$wp_customize->add_section(
    'grid_list',
    array(
        'title' => esc_html__('Grid List Section', 'notomag'),
        'panel' => 'front_page_theme_options_panel',
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_grid_list]',
    array(
        'default' => $notomag_default['enable_grid_list'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_grid_list]',
    array(
        'label' => esc_html__('Enable Grid List', 'notomag'),
        'section' => 'grid_list',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[grid_list_title]',
    array(
        'default' => $notomag_default['grid_list_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[grid_list_title]',
    array(
        'label' => __('Section Title', 'notomag'),
        'section' => 'grid_list',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_section_seperator_grid_list_1',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    new NotoMag_Seperator_Control(
        $wp_customize,
        'notomag_section_seperator_grid_list_1',
        array(
            'label' => esc_html__('Grid List Column - 1', 'notomag'),
            'settings' => 'notomag_section_seperator_grid_list_1',
            'section' => 'grid_list',
        )
    )
);
$wp_customize->add_setting(
    'notomag_options[grid_list_category_1]',
    array(
        'default' => $notomag_default['grid_list_category_1'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new NotoMag_Dropdown_Taxonomies_Control(
        $wp_customize,
        'notomag_options[grid_list_category_1]',
        array(
            'label' => __('Choose Column - 1 Category', 'notomag'),
            'description' => __('Leave Empty if you don\'t want the posts to be category specific', 'notomag'),
            'section' => 'grid_list',
        )
    )
);
$wp_customize->add_setting(
    'notomag_options[grid_list_block_offset]',
    array(
        'default' => $notomag_default['grid_list_block_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[grid_list_block_offset]',
    array(
        'label' => __('Post Offset', 'notomag'),
        'section' => 'grid_list',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'notomag_section_seperator_grid_list_2',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    new NotoMag_Seperator_Control(
        $wp_customize,
        'notomag_section_seperator_grid_list_2',
        array(
            'label' => esc_html__('Grid List Column - 2', 'notomag'),
            'settings' => 'notomag_section_seperator_grid_list_2',
            'section' => 'grid_list',
        )
    )
);
$wp_customize->add_setting(
    'notomag_options[grid_list_inner_title]',
    array(
        'default' => $notomag_default['grid_list_inner_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[grid_list_inner_title]',
    array(
        'label' => __('Inner Column Title', 'notomag'),
        'section' => 'grid_list',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[grid_list_category_2]',
    array(
        'default' => $notomag_default['grid_list_category_2'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new NotoMag_Dropdown_Taxonomies_Control(
        $wp_customize,
        'notomag_options[grid_list_category_2]',
        array(
            'label' => __('Choose Column - 2 Category', 'notomag'),
            'description' => __('Leave Empty if you don\'t want the posts to be category specific', 'notomag'),
            'section' => 'grid_list',
        )
    )
);
$wp_customize->add_setting(
    'notomag_options[grid_list_block_offset_2]',
    array(
        'default' => $notomag_default['grid_list_block_offset_2'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[grid_list_block_offset_2]',
    array(
        'label' => __('Post Offset', 'notomag'),
        'section' => 'grid_list',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'notomag_options[grid_list_more_category_text]',
    array(
        'default' => $notomag_default['grid_list_more_category_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[grid_list_more_category_text]',
    array(
        'label' => __('Redirect to Category Page Text', 'notomag'),
        'section' => 'grid_list',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_section_seperator_grid_list_meta',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    new NotoMag_Seperator_Control(
        $wp_customize,
        'notomag_section_seperator_grid_list_meta',
        array(
            'label' => esc_html__('Grid List Meta Option', 'notomag'),
            'settings' => 'notomag_section_seperator_grid_list_meta',
            'section' => 'grid_list',
        )
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_grid_list_author_meta]',
    array(
        'default' => $notomag_default['enable_grid_list_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_grid_list_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'notomag'),
        'section' => 'grid_list',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_grid_list_author_meta]',
    array(
        'default' => $notomag_default['select_grid_list_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_grid_list_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'notomag'),
        'section' => 'grid_list',
        'type' => 'select',
        'choices' => notomag_author_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[grid_list_author_meta_title]',
    array(
        'default' => $notomag_default['grid_list_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[grid_list_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'notomag'),
        'section' => 'grid_list',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_grid_list_date_meta]',
    array(
        'default' => $notomag_default['enable_grid_list_date_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_grid_list_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'notomag'),
        'section' => 'grid_list',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_grid_list_date]',
    array(
        'default' => $notomag_default['select_grid_list_date'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_grid_list_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'notomag'),
        'section' => 'grid_list',
        'type' => 'select',
        'choices' => notomag_date_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[select_grid_list_date_meta_title]',
    array(
        'default' => $notomag_default['select_grid_list_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[select_grid_list_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'notomag'),
        'section' => 'grid_list',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_grid_list_date_format]',
    array(
        'default' => $notomag_default['select_grid_list_date_format'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_grid_list_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'notomag'),
        'section' => 'grid_list',
        'type' => 'select',
        'choices' => notomag_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_grid_list_category_meta]',
    array(
        'default' => $notomag_default['enable_grid_list_category_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_grid_list_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'notomag'),
        'section' => 'grid_list',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_grid_list_number_of_category]',
    array(
        'default' => $notomag_default['select_grid_list_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[select_grid_list_number_of_category]',
    array(
        'label' => __('Number of Category', 'notomag'),
        'section' => 'grid_list',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'notomag_options[grid_list_category_label]',
    array(
        'default' => $notomag_default['grid_list_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[grid_list_category_label]',
    array(
        'label' => __('Category Label', 'notomag'),
        'section' => 'grid_list',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_grid_list_category_color]',
    array(
        'default' => $notomag_default['select_grid_list_category_color'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_grid_list_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'notomag'),
        'section' => 'grid_list',
        'type' => 'select',
        'choices' => notomag_category_color(),
    )
);
