<?php
// footer widget Options.
$wp_customize->add_section(
    'footer_widget_section',
    array(
        'title' => __('Footer Widget Options', 'notomag'),
        'panel' => 'footer_options_panel',
    )
);



/*Enable Footer Nav*/
$wp_customize->add_setting(
    'notomag_options[enable_footer_widget]',
    array(
        'default'           => $notomag_default['enable_footer_widget'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_footer_widget]',
    array(
        'label'       => __( 'Show Footer widgetarea', 'notomag' ),
        'section'     => 'footer_widget_section',
        'type'     => 'checkbox',
    )
);

// Option to choose footer column layout.
$wp_customize->add_setting(
	'notomag_options[footer_column_layout]',
	array(
		'default'           => $notomag_default['footer_column_layout'],
		'sanitize_callback' => 'notomag_sanitize_radio',
	)
);
$wp_customize->add_control(
	new NotoMag_Custom_Radio_Image_Control(
		$wp_customize,
		'notomag_options[footer_column_layout]',
		array(
			'label'       => __( 'Footer Column Layout', 'notomag' ),
			'description' => __( 'Some footer widgetareas will not be used based on the footer column layout chosen. Also make sure to insert at least one widget on the respective widgetarea for it to display.', 'notomag' ),
			'section'     => 'footer_widget_section',
			'choices'     => notomag_get_footer_layouts(),
			'priority'    => 40,
		)
	)
);
