<?php
$wp_customize->add_section(
    'pagination_options',
    array(
        'title' => esc_html__( 'Pagination Options', 'notomag' ),
        'panel' => 'archive_options_panel',
    )
);


$wp_customize->add_setting(
    'notomag_options[select_pagination_style]',
    array(
        'default'           => $notomag_default['select_pagination_style'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_pagination_style]',
    array(
        'label'         => esc_html__( 'Select Pagination Style', 'notomag' ),
        'section'     => 'pagination_options',
        'type'        => 'select',
        'choices'       => notomag_pagination_style_choice(),

    )
);


$wp_customize->add_section(
    'excerpt_options',
    array(
        'title' => esc_html__( 'Excerpt Options', 'notomag' ),
        'panel' => 'archive_options_panel',
    )
);

$wp_customize->add_setting(
    'notomag_options[number_of_word_in_excerpt]',
    array(
        'default'           => $notomag_default['number_of_word_in_excerpt'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[number_of_word_in_excerpt]',
    array(
        'label'         => esc_html__( 'Number Of Excerpt Word', 'notomag' ),
        'section'     => 'excerpt_options',
        'type'        => 'number',

    )
);


$wp_customize->add_setting(
    'notomag_options[excerpt_posts_title_limit]',
    array(
        'default'           => $notomag_default['excerpt_posts_title_limit'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[excerpt_posts_title_limit]',
    array(
        'label'    => __( 'Excerpt Line Limit', 'notomag' ),
        'section'  => 'excerpt_options',
        'type'     => 'select',
        'choices'  => notomag_line_limit_choices(),
    )
);

$wp_customize->add_setting(
    'notomag_options[archive_excerpt_button_text]',
    array(
        'default'           => $notomag_default['archive_excerpt_button_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[archive_excerpt_button_text]',
    array(
        'label'    => __( 'Excerpt Button Text', 'notomag' ),
        'section'  => 'excerpt_options',
        'type'     => 'text',
    )
);