<?php
/**
 * All settings related to archive.
 *
 * @package NotoMag
 */
$wp_customize->add_section(
	'archive_options',
	array(
		'title' => esc_html__( 'Archive Options', 'notomag' ),
		'panel' => 'archive_options_panel',
	)
);

// Archive Layout.
$wp_customize->add_setting(
    'notomag_options[archive_layout]',
    array(
        'default'           => $notomag_default['archive_layout'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'notomag_sanitize_radio'
    )
);

$wp_customize->add_control(
    new NotoMag_Custom_Radio_Image_Control(
        $wp_customize,
        'notomag_options[archive_layout]',
        array(
            'label'         => esc_html__( 'Archive Layout', 'notomag' ),
            'section'       => 'archive_options',
            'choices'       => notomag_get_archive_layouts(),
        )
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_archive_featured_post]',
    array(
        'default'           => $notomag_default['enable_archive_featured_post'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_archive_featured_post]',
    array(
        'label'    => __( 'Enable Featured Post', 'notomag' ),
        'description' => __( 'After enabling, set \'Mark as Featured\' to \'Yes\' in the single post options to display the post in the top section of the relevant archive page.', 'notomag' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',

    )
);

$wp_customize->add_setting(
    'notomag_section_seperator_archive_1',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new NotoMag_Seperator_Control(
        $wp_customize,
        'notomag_section_seperator_archive_1',
        array(
            'label'         => esc_html__( 'Archive Meta Options', 'notomag' ),
            'settings' => 'notomag_section_seperator_archive_1',
            'section' => 'archive_options',
        )
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_archive_post_count]',
    array(
        'default'           => $notomag_default['enable_archive_post_count'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_archive_post_count]',
    array(
        'label'    => __( 'Enable Archive Post Count', 'notomag' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',

    )
);


$wp_customize->add_setting(
    'notomag_options[archive_posts_title_limit]',
    array(
        'default'           => $notomag_default['archive_posts_title_limit'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[archive_posts_title_limit]',
    array(
        'label'    => __( 'Title Line Limit', 'notomag' ),
        'section'  => 'archive_options',
        'type'     => 'select',
        'choices'  => notomag_line_limit_choices(),
    )
);


$wp_customize->add_setting(
    'notomag_options[enable_excerpt_on_archive_1]',
    array(
        'default'           => $notomag_default['enable_excerpt_on_archive_1'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_excerpt_on_archive_1]',
    array(
        'label'    => __( 'Enable Excerpt On Archive', 'notomag' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
        'active_callback' => 'notomag_is_archive_excerpt_callbac_1',

    )
);



$wp_customize->add_setting(
    'notomag_options[enable_excerpt_on_archive_2]',
    array(
        'default'           => $notomag_default['enable_excerpt_on_archive_2'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_excerpt_on_archive_2]',
    array(
        'label'    => __( 'Enable Excerpt On Archive', 'notomag' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
        'active_callback' => 'notomag_is_archive_excerpt_callbac_2',
        
    )
);


$wp_customize->add_setting(
    'notomag_options[enable_excerpt_on_archive_3]',
    array(
        'default'           => $notomag_default['enable_excerpt_on_archive_3'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_excerpt_on_archive_3]',
    array(
        'label'    => __( 'Enable Excerpt On Archive', 'notomag' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
        'active_callback' => 'notomag_is_archive_excerpt_callbac_3',
        
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_archive_author_meta]',
    array(
        'default'           => $notomag_default['enable_archive_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_archive_author_meta]',
    array(
        'label'       => esc_html__( 'Show Author Meta', 'notomag' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_author_meta]',
    array(
        'default'           => $notomag_default['select_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_author_meta]',
    array(
        'label'         => esc_html__( 'Author Meta Display Options', 'notomag' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'       => notomag_author_meta(),
        'active_callback' => 'notomag_is_archive_author_meta_enabled',


    )
);

$wp_customize->add_setting(
    'notomag_options[archive_author_meta_title]',
    array(
        'default'           => $notomag_default['archive_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[archive_author_meta_title]',
    array(
        'label'    => __( 'Author Meta Text', 'notomag' ),
        'section'  => 'archive_options',
        'type'     => 'text',
        'active_callback' => function ( $control ) {
            return (
                notomag_is_archive_author_meta_enabled( $control )
                &&
                notomag_archive_author_meta_title( $control )
            );
        },
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_archive_date_meta]',
    array(
        'default'           => $notomag_default['enable_archive_date_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_archive_date_meta]',
    array(
        'label'       => esc_html__( 'Show Date Meta', 'notomag' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_archive_date]',
    array(
        'default'           => $notomag_default['select_archive_date'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_archive_date]',
    array(
        'label'         => esc_html__( 'Date Meta Display Options', 'notomag' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'       => notomag_date_meta(),
        'active_callback' => 'notomag_is_archive_date_meta_enabled',

    )
);

$wp_customize->add_setting(
    'notomag_options[archive_date_meta_title]',
    array(
        'default'           => $notomag_default['archive_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[archive_date_meta_title]',
    array(
        'label'    => __( 'Date Meta Text', 'notomag' ),
        'section'  => 'archive_options',
        'type'     => 'text',
        'active_callback' => function ( $control ) {
            return (
                notomag_is_archive_date_meta_enabled( $control )
                &&
                notomag_archive_date_meta_title( $control )
            );
        },
    )
);

$wp_customize->add_setting(
    'notomag_options[select_date_format]',
    array(
        'default'           => $notomag_default['select_date_format'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_date_format]',
    array(
        'label'         => esc_html__( 'Select Date Format', 'notomag' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'  		=> notomag_get_date_formats(),
        'active_callback' => 'notomag_is_archive_date_meta_enabled',
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_category_meta]',
    array(
        'default'           => $notomag_default['enable_category_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_category_meta]',
    array(
        'label'       => esc_html__( 'Enable Category Meta', 'notomag' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'notomag_options[number_of_category_to_display]',
    array(
        'default' => $notomag_default['number_of_category_to_display'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[number_of_category_to_display]',
    array(
        'label' => __('Number of Category', 'notomag'),
        'section' => 'archive_options',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'notomag_options[archive_category_label]',
    array(
        'default'           => $notomag_default['archive_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[archive_category_label]',
    array(
        'label'    => __( 'Category Title', 'notomag' ),
        'section'  => 'archive_options',
        'type'     => 'text',
        'active_callback' => 'notomag_is_archive_category_meta_enabled',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_category_color]',
    array(
        'default'           => $notomag_default['select_category_color'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_category_color]',
    array(
        'label'         => esc_html__( 'Select Category Color', 'notomag' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'  		=> notomag_category_color(),
        'active_callback' => 'notomag_is_archive_category_meta_enabled',

    )
);

$wp_customize->add_setting(
    'notomag_options[enable_tag_meta]',
    array(
        'default'           => $notomag_default['enable_tag_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_tag_meta]',
    array(
        'label'       => esc_html__( 'Enable Tag Meta', 'notomag' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_comment_meta]',
    array(
        'default'           => $notomag_default['enable_comment_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_comment_meta]',
    array(
        'label'       => esc_html__( 'Enable Comment Meta', 'notomag' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'notomag_options[enable_read_time_meta]',
    array(
        'default'           => $notomag_default['enable_read_time_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_read_time_meta]',
    array(
        'label'       => esc_html__( 'Enable Read Time', 'notomag' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);
