<?php
/**
 * Default theme options.
 *
 * @package Mavix Medical
 */

if ( ! function_exists( 'mavix_medical_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
function mavix_medical_get_default_theme_options() {

	$mavix_medical_defaults = array();

	// Contact Details
	$mavix_medical_defaults['mavix_medical_show_contact_details'] 		= true;
	$mavix_medical_defaults['mavix_medical_address_one']				= esc_html__('214 West Arnold St','mavix-medical');
	$mavix_medical_defaults['mavix_medical_address_two']				= esc_html__('New York, NY 10002','mavix-medical');
	$mavix_medical_defaults['mavix_medical_phone_number']				= esc_html__('(007) 123 456 7890','mavix-medical');
	$mavix_medical_defaults['mavix_medical_opening_time']				= esc_html__('Mon-Fri 10:00am-7:30pm','mavix-medical');
	$mavix_medical_defaults['mavix_medical_email_id']					= esc_html__('info@example.com','mavix-medical');
	$mavix_medical_defaults['mavix_medical_support_text']				= esc_html__('24 X 7 online support','mavix-medical');

	// Menu
	$mavix_medical_defaults['mavix_medical_show_menu_button'] 			= true;
	$mavix_medical_defaults['mavix_medical_menu_button_text']			= esc_html__('Apply Now','mavix-medical');
	$mavix_medical_defaults['mavix_medical_menu_button_url']			= esc_url('#','mavix-medical');

	//General Section
	$mavix_medical_defaults['readmore_text']					= esc_html__('Read More','mavix-medical');
	$mavix_medical_defaults['your_latest_posts_title']			= esc_html__('Blog','mavix-medical');
	$mavix_medical_defaults['excerpt_length']					= 10;
	$mavix_medical_defaults['layout_options_blog']				= 'no-sidebar';
	$mavix_medical_defaults['layout_options_archive']			= 'no-sidebar';
	$mavix_medical_defaults['layout_options_page']				= 'no-sidebar';	
	$mavix_medical_defaults['layout_options_single']			= 'right-sidebar';	

	//Footer section 		
	$mavix_medical_defaults['copyright_text']					= esc_html__( 'Copyright &copy; All rights reserved.', 'mavix-medical' );

	// Pass through filter.
	$mavix_medical_defaults = apply_filters( 'mavix_medical_filter_default_theme_options', $mavix_medical_defaults );
	return $mavix_medical_defaults;
}

endif;

/**
*  Get theme options
*/
if ( ! function_exists( 'mavix_medical_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function mavix_medical_get_option( $key ) {

		$mavix_medical_default_options = mavix_medical_get_default_theme_options();
		if ( empty( $key ) ) {
			return;
		}

		$mavix_medical_theme_options = (array)get_theme_mod( 'theme_options' );
		$mavix_medical_theme_options = wp_parse_args( $mavix_medical_theme_options, $mavix_medical_default_options );

		$value = null;

		if ( isset( $mavix_medical_theme_options[ $key ] ) ) {
			$value = $mavix_medical_theme_options[ $key ];
		}

		return $value;

	}

endif;