<?php
/**
 * Default theme options.
 *
 * @package Mavix Charity
 */

if ( ! function_exists( 'mavix_charity_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
function mavix_charity_get_default_theme_options() {

	$mavix_charity_defaults = array();

	// Contact Details
	$mavix_charity_defaults['mavix_charity_show_contact_details'] 		= true;
	$mavix_charity_defaults['mavix_charity_address_one']				= esc_html__('214 West Arnold St','mavix-charity');
	$mavix_charity_defaults['mavix_charity_address_two']				= esc_html__('New York, NY 10002','mavix-charity');
	$mavix_charity_defaults['mavix_charity_phone_number']				= esc_html__('(007) 123 456 7890','mavix-charity');
	$mavix_charity_defaults['mavix_charity_opening_time']				= esc_html__('Mon-Fri 10:00am-7:30pm','mavix-charity');
	$mavix_charity_defaults['mavix_charity_email_id']					= esc_html__('info@example.com','mavix-charity');
	$mavix_charity_defaults['mavix_charity_support_text']				= esc_html__('24 X 7 online support','mavix-charity');

	// Menu
	$mavix_charity_defaults['mavix_charity_show_menu_button'] 			= true;
	$mavix_charity_defaults['mavix_charity_menu_button_text']			= esc_html__('Donate Now','mavix-charity');
	$mavix_charity_defaults['mavix_charity_menu_button_url']			= esc_url('#','mavix-charity');

	//General Section
	$mavix_charity_defaults['readmore_text']					= esc_html__('Read More','mavix-charity');
	$mavix_charity_defaults['your_latest_posts_title']			= esc_html__('Blog','mavix-charity');
	$mavix_charity_defaults['excerpt_length']					= 10;
	$mavix_charity_defaults['layout_options_blog']				= 'no-sidebar';
	$mavix_charity_defaults['layout_options_archive']			= 'no-sidebar';
	$mavix_charity_defaults['layout_options_page']				= 'no-sidebar';	
	$mavix_charity_defaults['layout_options_single']			= 'right-sidebar';	

	//Footer section 		
	$mavix_charity_defaults['copyright_text']					= esc_html__( 'Copyright &copy; All rights reserved.', 'mavix-charity' );

	// Pass through filter.
	$mavix_charity_defaults = apply_filters( 'mavix_charity_filter_default_theme_options', $mavix_charity_defaults );
	return $mavix_charity_defaults;
}

endif;

/**
*  Get theme options
*/
if ( ! function_exists( 'mavix_charity_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function mavix_charity_get_option( $key ) {

		$mavix_charity_default_options = mavix_charity_get_default_theme_options();
		if ( empty( $key ) ) {
			return;
		}

		$mavix_charity_theme_options = (array)get_theme_mod( 'theme_options' );
		$mavix_charity_theme_options = wp_parse_args( $mavix_charity_theme_options, $mavix_charity_default_options );

		$value = null;

		if ( isset( $mavix_charity_theme_options[ $key ] ) ) {
			$value = $mavix_charity_theme_options[ $key ];
		}

		return $value;

	}

endif;