<?php
/**
 * Partial template for archive posts entry category.
 *
 * @package Matina Blogmentor
 *
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// return if post are not from default post type.
if ( 'post' != get_post_type() ) {
    return;
}

/**
 * matina_before_archive_entry_category hook
 *
 * @since 1.0.0
 */
do_action( 'matina_before_archive_entry_category' );

/* translators: used between list items, there is a space after the comma */
$archive_layout = get_theme_mod( 'matina_archive_layout', 'layout-default' );

/* translators: 1: list of categories. */
if ( 'layout-two' == $archive_layout ) {
    $categories_list = get_the_category_list();
    echo '<span class="cat-links">'. wp_kses_post( $categories_list ) .'</span>';
} else {
    $categories_list = get_the_category_list( esc_html__( ', ', 'matina-blogmentor' ) ); // WPCS: XSS OK.
    echo '<span class="cat-links">'. wp_kses_post( $categories_list ) .'</span>';
}
?>
    
<?php
/**
 * matina_after_archive_entry_category hook
 *
 * @since 1.0.0
 */
do_action( 'matina_after_archive_entry_category' );