<?php
/**
 * Template part for displaying slider section
 *
 * @package Manufacturing Hub
 * @subpackage manufacturing_hub
 */

$manufacturing_hub_static_image = get_template_directory_uri() . '/assets/images/slider-img.png';
$manufacturing_hub_static_image1 = get_template_directory_uri() . '/assets/images/post-img1.png';
?>
<?php if (get_theme_mod('manufacturing_hub_slider_arrows', true) != '') : ?>
  <div id="slider" class="mb-md-0 mb-3">
    <div id="owl-carousel" class="main-sliders owl-carousel">
      <?php
      $manufacturing_hub_slide_pages = array();
      for ($manufacturing_hub_count = 1; $manufacturing_hub_count <= 4; $manufacturing_hub_count++) {
          $manufacturing_hub_mod = intval(get_theme_mod('manufacturing_hub_slider_page' . $manufacturing_hub_count, 0));
          if ($manufacturing_hub_mod > 0) {
              $manufacturing_hub_slide_pages[] = $manufacturing_hub_mod;
          }
      }
      if (!empty($manufacturing_hub_slide_pages)) :
          $manufacturing_hub_args = array(
              'post_type' => 'page',
              'post__in' => $manufacturing_hub_slide_pages,
              'orderby' => 'post__in'
          );
          $manufacturing_hub_query = new WP_Query($manufacturing_hub_args);
          if ($manufacturing_hub_query->have_posts()) :
              while ($manufacturing_hub_query->have_posts()) : $manufacturing_hub_query->the_post(); ?>
                  <div class="item">
                      <div class="slider-border">
                          <?php if (has_post_thumbnail()) { ?>
                              <img src="<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'full')); ?>" alt="<?php the_title_attribute(); ?>" />
                          <?php } else { ?>
                              <img src="<?php echo esc_url($manufacturing_hub_static_image); ?>" alt="<?php esc_attr_e('Default Image', 'manufacturing-hub'); ?>" />
                          <?php } ?>
                      </div>
                      <div class="carousel-caption">
                          <div class="inner_carousel">
                            <?php if ( get_theme_mod('manufacturing_hub_show_slider_title', true) ) : ?>
                              <h1 class="my-2">
                                <a href="<?php the_permalink(); ?>" class="text-capitalize">
                                  <?php
                                    $manufacturing_hub_title = get_the_title();
                                    $manufacturing_hub_words = explode(' ', $manufacturing_hub_title);
                                    $manufacturing_hub_first_two = array_slice($manufacturing_hub_words, 0, 2);
                                    $manufacturing_hub_rest = array_slice($manufacturing_hub_words, 2);

                                    echo '<span class="font-light">' . esc_html(implode(' ', $manufacturing_hub_first_two)) . '</span>';
                                    if (!empty($manufacturing_hub_rest)) {
                                      echo ' <span class="font-bold">' . esc_html(implode(' ', $manufacturing_hub_rest)) . '</span>';
                                    }
                                  ?>
                                </a>
                              </h1>
                            <?php endif; ?>
                            <?php if (get_theme_mod('manufacturing_hub_show_slider_content', true)) : ?>
                              <p class="mt-3 slider-content"><?php echo wp_trim_words( get_the_content(),15 );?></p>
                            <?php endif; ?>
                            <div class="more-btn mt-lg-4 mt-md-4 mt-3">
                              <?php 
                                  // Get the button text and link from the theme settings.
                                  $manufacturing_hub_btn_text1 = get_theme_mod('manufacturing_hub_btn_text1', __('Explore More', 'manufacturing-hub'));
                                  $manufacturing_hub_btn_link1 = get_theme_mod('manufacturing_hub_btn_link1', '');

                                  // Fallback to the permalink if no link is provided.
                                  $Manufacturing_Hub_Button_link = !empty($manufacturing_hub_btn_link1) ? $manufacturing_hub_btn_link1 : get_permalink();

                                  if (!empty($manufacturing_hub_btn_text1)) { ?>
                                      <a href="<?php echo esc_url($Manufacturing_Hub_Button_link); ?>" target="_blank" class="text-capitalizen slider-btn1"><span class="pe-lg-3 pe-2"><?php echo esc_html($manufacturing_hub_btn_text1); ?></span><i class="fa-solid fa-arrow-right"></i><span class="screen-reader-text"><?php echo esc_html($manufacturing_hub_btn_text1); ?></span></a>
                              <?php } ?>
                            </div>
                            <?php $manufacturing_hub_short_heading = get_theme_mod('manufacturing_hub_slider_short_heading', '');
                            if (!empty($manufacturing_hub_short_heading)) { ?>
                                <p class="slidetop-text my-3"><?php echo esc_html($manufacturing_hub_short_heading); ?></p>
                            <?php } ?>
                            <div class="rating-col">
                              <div class="row rating-box">
                                  <div class="col-lg-4 col-md-4 col-6 align-self-center px-0 position-relative">
                                    <?php 
                                    $manufacturing_hub_selected_category = get_theme_mod('manufacturing_hub_about_catData', 'select');
                                    if ($manufacturing_hub_selected_category != 'select') { ?>
                                      <div class="abt-cat">
                                        <div class="owl-carousel m-0">
                                          <?php
                                          $manufacturing_hub_abtpage_query = new WP_Query(array(
                                              'category_name' => esc_attr($manufacturing_hub_selected_category),
                                              'posts_per_page' => -1,
                                          ));
                                          if ($manufacturing_hub_abtpage_query->have_posts()) :
                                              while ($manufacturing_hub_abtpage_query->have_posts()) : $manufacturing_hub_abtpage_query->the_post(); ?>
                                                  <div class="abt-imagebox">
                                                      <?php if (has_post_thumbnail()) { ?>
                                                          <img src="<?php the_post_thumbnail_url(); ?>" alt="<?php the_title_attribute(); ?>" />
                                                      <?php } else { ?>
                                                          <img src="<?php echo esc_url($manufacturing_hub_static_image1); ?>" alt="<?php esc_attr_e('Default image', 'manufacturing-hub'); ?>" />
                                                      <?php } ?>
                                                  </div>
                                              <?php endwhile;
                                              wp_reset_postdata();
                                          else : ?>
                                              <p><?php esc_html_e('No posts found in this category.', 'manufacturing-hub'); ?></p>
                                          <?php endif; ?>
                                        </div>
                                      </div>
                                    <?php } ?>
                                  </div>
                                  <div class="col-lg-8 col-md-8 col-6 align-self-center">
                                    <?php 
                                    $manufacturing_hub_star_rating = get_theme_mod('manufacturing_hub_star_rating'); 
                                    if ($manufacturing_hub_star_rating) { ?>
                                      <div class="star-rating">
                                        <span class="rate-text"><?php echo esc_html($manufacturing_hub_star_rating); ?></span>
                                      </div>
                                    <?php } ?>
                                  </div>
                              </div>
                            </div>
                          </div>
                      </div>
                  </div>
              <?php endwhile;
              wp_reset_postdata();
          else : ?>
              <div class="no-postfound"><?php esc_html_e('No slides found.', 'manufacturing-hub'); ?></div>
          <?php endif;
      endif; ?>
    </div>
    <div class="slider-bottom">
      <div class="container">
        <?php if (get_theme_mod('manufacturing_hub_tab_heading1') != '' || get_theme_mod('manufacturing_hub_tab_heading2') != '' || get_theme_mod('manufacturing_hub_tab_heading3') != '') : ?>
            <div class="row">
              <?php for ($manufacturing_hub_i = 1; $manufacturing_hub_i <= 3; $manufacturing_hub_i++) : ?>
                  <?php if (get_theme_mod('manufacturing_hub_tab_heading' . $manufacturing_hub_i) != '') : ?>
                      <div class="col-lg-4 col-md-4"> <!-- Column -->
                          <div class="tab-details d-flex align-self-center justify-content-center align-items-center">
                              <?php
                              $manufacturing_hub_icon_class = get_theme_mod('manufacturing_hub_tab_icon' . $manufacturing_hub_i);
                              if (!$manufacturing_hub_icon_class) {
                                  $manufacturing_hub_icon_class = 'fas fa-check'; // Default icon
                              }
                              ?>
                              <i class="me-2 <?php echo esc_attr($manufacturing_hub_icon_class); ?>"></i>
                              <h3 class="m-0"><?php echo esc_html(get_theme_mod('manufacturing_hub_tab_heading' . $manufacturing_hub_i)); ?></h3>
                          </div>
                      </div>
                  <?php endif; ?>
              <?php endfor; ?>
            </div>
          <?php endif; ?>
      </div>
    </div>
  </div>
<?php endif; ?>