<?php
/*
* Display Logo and contact details
*/
?>
<div class="main-header">
  <div class="headerbox">
    <div class="menubox">
      <div class="container">
        <div class="row">
          <div class="col-lg-3 col-md-4 logo-col align-self-center">
            <div class="logo my-lg-2 my-3">
              <?php if( has_custom_logo() ) manufacturing_hub_the_custom_logo(); ?>
              <?php if(get_theme_mod('manufacturing_hub_site_title',true) == 1){ ?>
                <?php if (is_front_page() && is_home()) : ?>
                  <h1 class="text-capitalize">
                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                  </h1> 
                <?php else : ?>
                  <p class="text-capitalize site-title mb-1">
                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                  </p>
                <?php endif; ?>
              <?php }?>
              <?php $manufacturing_hub_description = get_bloginfo( 'description', 'display' );
              if ( $manufacturing_hub_description || is_customize_preview() ) : ?>
                <?php if(get_theme_mod('manufacturing_hub_site_tagline',false)){ ?>
                  <p class="site-description mb-0"><?php echo esc_html($manufacturing_hub_description); ?></p>
                <?php }?>
              <?php endif; ?>
            </div>
          </div>
          <div class="col-lg-6 col-md-4 align-self-center">
            <?php get_template_part('template-parts/navigation/site-nav'); ?>
          </div>
          <div class="col-lg-3 col-md-4 btn-col align-self-center">
            <div class="call">
              <?php if( get_theme_mod( 'manufacturing_hub_about_call_text' ) || get_theme_mod( 'manufacturing_hub_about_call' ) ) { ?>
                <div class="main-abt-contact-box">
                  <p class="call-text mb-0"><?php echo esc_html( get_theme_mod('manufacturing_hub_about_call_text','Contact Us') ); ?></p>
                  <div class="about-call-icon"><i class="fas fa-phone-volume ps-3"></i></div>
                  <p class="call-simplep mb-0">
                    <a href="tel:<?php echo esc_attr(get_theme_mod('manufacturing_hub_about_call')); ?>">
                      <?php echo esc_html(get_theme_mod('manufacturing_hub_about_call', '+01123456789')); ?>
                    </a>
                  </p>
                </div>
              <?php } ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>