<?php
/**
 * Custom typography options for this theme
 *
 * @package Local Business Directory
 */

function local_business_directory_output_custom_font_css() {
    $local_business_directory_font_choice = get_theme_mod( 'local_business_directory_font_family', 'default' );

    if ( $local_business_directory_font_choice === 'default' ) {
        return;
    }

    $local_business_directory_font_map = array(
        'bad_script'       => '"Bad Script", cursive',
        'roboto'           => '"Roboto", sans-serif',
        'playfair_display' => '"Playfair Display", serif',
        'open_sans'        => '"Open Sans", sans-serif',
        'lobster'          => '"Lobster", cursive',
        'merriweather'     => '"Merriweather", serif',
        'oswald'           => '"Oswald", sans-serif',
        'raleway'          => '"Raleway", sans-serif',
    );

    $local_business_directory_font_family = isset( $local_business_directory_font_map[ $local_business_directory_font_choice ] ) ? $local_business_directory_font_map[ $local_business_directory_font_choice ] : $local_business_directory_font_map['pt_sans'];

    $local_business_directory_custom_css = "
        body,
        h1, h2, h3, h4, h5, h6,
        p, a, span, div,
        .site, .entry-content, .main-navigation, .widget,
        input, textarea, button, .menu, .site-title, .site-description {
            font-family: {$local_business_directory_font_family} !important;
        }
    ";

    wp_add_inline_style( 'local-business-directory-google-fonts', $local_business_directory_custom_css );
}
add_action( 'wp_enqueue_scripts', 'local_business_directory_output_custom_font_css', 20 );


function local_business_directory_sanitize_font_family( $local_business_directory_input ) {
    $local_business_directory_valid = array(
        'default', 'bad_script', 'roboto',
        'playfair_display', 'open_sans', 'lobster', 'merriweather', 'oswald', 'raleway'
    );
    return in_array( $local_business_directory_input, $local_business_directory_valid ) ? $local_business_directory_input : 'default';
}

function local_business_directory_enqueue_selected_google_font() {
    $local_business_directory_font_choice = get_theme_mod( 'local_business_directory_font_family', 'default' );

    $local_business_directory_font_links = array(
        'bad_script'       => 'https://fonts.googleapis.com/css2?family=Bad+Script&display=swap',
        'roboto'           => 'https://fonts.googleapis.com/css2?family=Roboto&display=swap',
        'playfair_display' => 'https://fonts.googleapis.com/css2?family=Playfair+Display&display=swap',
        'open_sans'        => 'https://fonts.googleapis.com/css2?family=Open+Sans&display=swap',
        'lobster'          => 'https://fonts.googleapis.com/css2?family=Lobster&display=swap',
        'merriweather'     => 'https://fonts.googleapis.com/css2?family=Merriweather&display=swap',
        'oswald'           => 'https://fonts.googleapis.com/css2?family=Oswald&display=swap',
        'raleway'          => 'https://fonts.googleapis.com/css2?family=Raleway&display=swap',
    );

    if ( isset( $local_business_directory_font_links[ $local_business_directory_font_choice ] ) ) {
        wp_enqueue_style( 'local-business-directory-dynamic-font', $local_business_directory_font_links[ $local_business_directory_font_choice ], array(), null );
    }
}
add_action( 'wp_enqueue_scripts', 'local_business_directory_enqueue_selected_google_font' );