<?php
/**
 * Local Business Directory Theme Customizer
 *
 * @package Local Business Directory
 */

function Local_Business_Directory_Customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'Local_Business_Directory_Customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'Local_Business_Directory_Customize_partial_blogdescription',
			)
		);
	}

	/*
    * Theme Options Panel
    */
	$wp_customize->add_panel('local_business_directory_panel', array(
		'priority' => 25,
		'capability' => 'edit_theme_options',
		'title' => __('Local Business Directory Theme Options', 'local-business-directory'),
	));

	/*
	* Customizer main header section
	*/

	$wp_customize->add_setting(
		'local_business_directory_site_title_text',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_site_title_text',
		array(
			'label'       => __('Enable Title', 'local-business-directory'),
			'description' => __('Enable or Disable Title from the site', 'local-business-directory'),
			'section'     => 'title_tagline',
			'type'        => 'checkbox',
		)
	);

	$wp_customize->add_setting(
		'local_business_directory_site_tagline_text',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 0,
			'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_site_tagline_text',
		array(
			'label'       => __('Enable Tagline', 'local-business-directory'),
			'description' => __('Enable or Disable Tagline from the site', 'local-business-directory'),
			'section'     => 'title_tagline',
			'type'        => 'checkbox',
		)
	);

		$wp_customize->add_setting(
		'local_business_directory_logo_width',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '150',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_logo_width',
		array(
			'label'       => __('Logo Width in PX', 'local-business-directory'),
			'section'     => 'title_tagline',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 100,
	             'max' => 300,
	             'step' => 1,
	         ),
		)
	);

	/* WooCommerce custom settings */

	$wp_customize->add_section('woocommerce_custom_settings', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('WooCommerce Custom Settings', 'local-business-directory'),
		'panel'       => 'woocommerce',
	));

	$wp_customize->add_setting(
		'local_business_directory_per_columns',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '3',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_per_columns',
		array(
			'label'       => __('Product Per Single Row', 'local-business-directory'),
			'section'     => 'woocommerce_custom_settings',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 1,
	             'max' => 4,
	             'step' => 1,
	         ),
		)
	);

	$wp_customize->add_setting(
		'local_business_directory_product_per_page',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '6',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_product_per_page',
		array(
			'label'       => __('Product Per One Page', 'local-business-directory'),
			'section'     => 'woocommerce_custom_settings',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 1,
	             'max' => 12,
	             'step' => 1,
	         ),
		)
	);

	/*Related Products Enable Option*/
	$wp_customize->add_setting(
		'local_business_directory_enable_related_product',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_enable_related_product',
		array(
			'label'       => __('Enable Related Product', 'local-business-directory'),
			'description' => __('Checked to show Related Product', 'local-business-directory'),
			'section'     => 'woocommerce_custom_settings',
			'type'        => 'checkbox',
		)
	);

	$wp_customize->add_setting(
		'custom_related_products_number',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '3',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'custom_related_products_number',
		array(
			'label'       => __('Related Product Count', 'local-business-directory'),
			'section'     => 'woocommerce_custom_settings',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 1,
	             'max' => 20,
	             'step' => 1,
	         ),
		)
	);

	$wp_customize->add_setting(
		'custom_related_products_number_per_row',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '3',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'custom_related_products_number_per_row',
		array(
			'label'       => __('Related Product Per Row', 'local-business-directory'),
			'section'     => 'woocommerce_custom_settings',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 1,
	             'max' => 4,
	             'step' => 1,
	         ),
		)
	);

	/*Archive Product layout*/
	$wp_customize->add_setting('local_business_directory_archive_product_layout',array(
        'default' => 'layout-1',
        'sanitize_callback' => 'local_business_directory_sanitize_choices'
	));
	$wp_customize->add_control('local_business_directory_archive_product_layout',array(
        'type' => 'select',
        'label' => esc_html__('Archive Product Layout','local-business-directory'),
        'section' => 'woocommerce_custom_settings',
        'choices' => array(
            'layout-1' => esc_html__('Sidebar On Right','local-business-directory'),
            'layout-2' => esc_html__('Sidebar On Left','local-business-directory'),
			'layout-3' => esc_html__('Full Width Layout','local-business-directory')
        ),
	) );

	/*Single Product layout*/
	$wp_customize->add_setting('local_business_directory_single_product_layout',array(
        'default' => 'layout-1',
        'sanitize_callback' => 'local_business_directory_sanitize_choices'
	));
	$wp_customize->add_control('local_business_directory_single_product_layout',array(
        'type' => 'select',
        'label' => esc_html__('Single Product Layout','local-business-directory'),
        'section' => 'woocommerce_custom_settings',
        'choices' => array(
            'layout-1' => esc_html__('Sidebar On Right','local-business-directory'),
            'layout-2' => esc_html__('Sidebar On Left','local-business-directory'),
			'layout-3' => esc_html__('Full Width Layout','local-business-directory')
        ),
	) );

	$wp_customize->add_setting('local_business_directory_woocommerce_product_sale',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
        'default'           => 'Right',
        'sanitize_callback' => 'local_business_directory_sanitize_choices'
    ));
    $wp_customize->add_control('local_business_directory_woocommerce_product_sale',array(
        'label'       => esc_html__( 'Woocommerce Product Sale Positions','local-business-directory' ),
        'type' => 'select',
        'section' => 'woocommerce_custom_settings',
        'choices' => array(
            'Right' => __('Right','local-business-directory'),
            'Left' => __('Left','local-business-directory'),
            'Center' => __('Center','local-business-directory')
        ),
    ) );

	/*Additional Options*/
	$wp_customize->add_section('local_business_directory_additional_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Additional Options', 'local-business-directory'),
		'panel'       => 'local_business_directory_panel',
	));

	/*Main Slider Enable Option*/
	$wp_customize->add_setting(
		'local_business_directory_enable_preloader',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 0,
			'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_enable_preloader',
		array(
			'label'       => __('Enable Preloader', 'local-business-directory'),
			'description' => __('Checked to show preloader', 'local-business-directory'),
			'section'     => 'local_business_directory_additional_section',
			'type'        => 'checkbox',
		)
	);

	/*Breadcrumbs Enable Option*/
	$wp_customize->add_setting(
		'local_business_directory_enable_breadcrumbs',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_enable_breadcrumbs',
		array(
			'label'       => __('Enable Breadcrumbs', 'local-business-directory'),
			'description' => __('Checked to show Breadcrumbs', 'local-business-directory'),
			'section'     => 'local_business_directory_additional_section',
			'type'        => 'checkbox',
		)
	);

	/*Post layout*/
	$wp_customize->add_setting('local_business_directory_archive_layout',array(
        'default' => 'layout-1',
        'sanitize_callback' => 'local_business_directory_sanitize_choices'
	));
	$wp_customize->add_control('local_business_directory_archive_layout',array(
        'type' => 'select',
        'label' => esc_html__('Posts Layout','local-business-directory'),
        'section' => 'local_business_directory_additional_section',
        'choices' => array(
            'layout-1' => esc_html__('Sidebar On Right','local-business-directory'),
            'layout-2' => esc_html__('Sidebar On Left','local-business-directory'),
			'layout-3' => esc_html__('Full Width Layout','local-business-directory')
        ),
	) );

	/*single post layout*/
	$wp_customize->add_setting('local_business_directory_post_layout',array(
        'default' => 'layout-1',
        'sanitize_callback' => 'local_business_directory_sanitize_choices'
	));
	$wp_customize->add_control('local_business_directory_post_layout',array(
        'type' => 'select',
        'label' => esc_html__('Single Post Layout','local-business-directory'),
        'section' => 'local_business_directory_additional_section',
        'choices' => array(
            'layout-1' => esc_html__('Sidebar On Right','local-business-directory'),
            'layout-2' => esc_html__('Sidebar On Left','local-business-directory'),
			'layout-3' => esc_html__('Full Width Layout','local-business-directory')
        ),
	) );

	/*single page layout*/
	$wp_customize->add_setting('local_business_directory_page_layout',array(
        'default' => 'layout-1',
        'sanitize_callback' => 'local_business_directory_sanitize_choices'
	));
	$wp_customize->add_control('local_business_directory_page_layout',array(
        'type' => 'select',
        'label' => esc_html__('Single Page Layout','local-business-directory'),
        'section' => 'local_business_directory_additional_section',
        'choices' => array(
            'layout-1' => esc_html__('Sidebar On Right','local-business-directory'),
            'layout-2' => esc_html__('Sidebar On Left','local-business-directory'),
			'layout-3' => esc_html__('Full Width Layout','local-business-directory')
        ),
	) );

	/*Archive Post Options*/
	$wp_customize->add_section('local_business_directory_blog_post_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Blog Page Options', 'local-business-directory'),
		'panel'       => 'local_business_directory_panel',
	));

	$wp_customize->add_setting('local_business_directory_enable_blog_post_title',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
	));
	$wp_customize->add_control('local_business_directory_enable_blog_post_title',array(
		'label'       => __('Enable Blog Post Title', 'local-business-directory'),
		'description' => __('Checked To Show Blog Post Title', 'local-business-directory'),
		'section'     => 'local_business_directory_blog_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('local_business_directory_enable_blog_post_meta',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
	));
	$wp_customize->add_control('local_business_directory_enable_blog_post_meta',array(
		'label'       => __('Enable Blog Post Meta', 'local-business-directory'),
		'description' => __('Checked To Show Blog Post Meta Feilds', 'local-business-directory'),
		'section'     => 'local_business_directory_blog_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('local_business_directory_enable_blog_post_tags',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
	));
	$wp_customize->add_control('local_business_directory_enable_blog_post_tags',array(
		'label'       => __('Enable Blog Post Tags', 'local-business-directory'),
		'description' => __('Checked To Show Blog Post Tags', 'local-business-directory'),
		'section'     => 'local_business_directory_blog_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('local_business_directory_enable_blog_post_image',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
	));
	$wp_customize->add_control('local_business_directory_enable_blog_post_image',array(
		'label'       => __('Enable Blog Post Image', 'local-business-directory'),
		'description' => __('Checked To Show Blog Post Image', 'local-business-directory'),
		'section'     => 'local_business_directory_blog_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('local_business_directory_enable_blog_post_content',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
	));
	$wp_customize->add_control('local_business_directory_enable_blog_post_content',array(
		'label'       => __('Enable Blog Post Content', 'local-business-directory'),
		'description' => __('Checked To Show Blog Post Content', 'local-business-directory'),
		'section'     => 'local_business_directory_blog_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('local_business_directory_enable_blog_post_button',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
	));
	$wp_customize->add_control('local_business_directory_enable_blog_post_button',array(
		'label'       => __('Enable Blog Post Read More Button', 'local-business-directory'),
		'description' => __('Checked To Show Blog Post Read More Button', 'local-business-directory'),
		'section'     => 'local_business_directory_blog_post_section',
		'type'        => 'checkbox',
	));

	/*Blog post Content layout*/
	$wp_customize->add_setting('local_business_directory_blog_Post_content_layout',array(
        'default' => 'Left',
        'sanitize_callback' => 'local_business_directory_sanitize_choices'
	));
	$wp_customize->add_control('local_business_directory_blog_Post_content_layout',array(
        'type' => 'select',
        'label' => esc_html__('Blog Post Content Layout','local-business-directory'),
        'section' => 'local_business_directory_blog_post_section',
        'choices' => array(
            'Left' => esc_html__('Left','local-business-directory'),
            'Center' => esc_html__('Center','local-business-directory'),
            'Right' => esc_html__('Right','local-business-directory')
        ),
	) );

	/*Excerpt*/
    $wp_customize->add_setting(
		'local_business_directory_excerpt_limit',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '25',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_excerpt_limit',
		array(
			'label'       => __('Excerpt Limit', 'local-business-directory'),
			'section'     => 'local_business_directory_blog_post_section',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 2,
	             'max' => 50,
	             'step' => 2,
	         ),
		)
	);

	/*Archive Button Text*/
	$wp_customize->add_setting(
		'local_business_directory_read_more_text',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 'Continue Reading....',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_read_more_text',
		array(
			'label'       => __('Edit Button Text ', 'local-business-directory'),
			'section'     => 'local_business_directory_blog_post_section',
			'type'        => 'text',
		)
	);

	/*Single Post Options*/
	$wp_customize->add_section('local_business_directory_single_post_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Single Post Options', 'local-business-directory'),
		'panel'       => 'local_business_directory_panel',
	));

	$wp_customize->add_setting('local_business_directory_enable_single_blog_post_title',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
	));
	$wp_customize->add_control('local_business_directory_enable_single_blog_post_title',array(
		'label'       => __('Enable Single Post Title', 'local-business-directory'),
		'description' => __('Checked To Show Single Blog Post Title', 'local-business-directory'),
		'section'     => 'local_business_directory_single_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('local_business_directory_enable_single_blog_post_meta',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
	));
	$wp_customize->add_control('local_business_directory_enable_single_blog_post_meta',array(
		'label'       => __('Enable Single Post Meta', 'local-business-directory'),
		'description' => __('Checked To Show Single Blog Post Meta Feilds', 'local-business-directory'),
		'section'     => 'local_business_directory_single_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('local_business_directory_enable_single_blog_post_tags',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
	));
	$wp_customize->add_control('local_business_directory_enable_single_blog_post_tags',array(
		'label'       => __('Enable Single Post Tags', 'local-business-directory'),
		'description' => __('Checked To Show Single Blog Post Tags', 'local-business-directory'),
		'section'     => 'local_business_directory_single_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('local_business_directory_enable_single_post_image',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
	));
	$wp_customize->add_control('local_business_directory_enable_single_post_image',array(
		'label'       => __('Enable Single Post Image', 'local-business-directory'),
		'description' => __('Checked To Show Single Post Image', 'local-business-directory'),
		'section'     => 'local_business_directory_single_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('local_business_directory_enable_single_blog_post_content',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
	));
	$wp_customize->add_control('local_business_directory_enable_single_blog_post_content',array(
		'label'       => __('Enable Single Post Content', 'local-business-directory'),
		'description' => __('Checked To Show Single Blog Post Content', 'local-business-directory'),
		'section'     => 'local_business_directory_single_post_section',
		'type'        => 'checkbox',
	));

	/*Related Post Enable Option*/
	$wp_customize->add_setting(
		'local_business_directory_enable_related_post',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_enable_related_post',
		array(
			'label'       => __('Enable Related Post', 'local-business-directory'),
			'description' => __('Checked to show Related Post', 'local-business-directory'),
			'section'     => 'local_business_directory_single_post_section',
			'type'        => 'checkbox',
		)
	);

	/*Related post Edit Text*/
	$wp_customize->add_setting(
		'local_business_directory_related_post_text',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 'Related Post',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_related_post_text',
		array(
			'label'       => __('Edit Related Post Text ', 'local-business-directory'),
			'section'     => 'local_business_directory_single_post_section',
			'type'        => 'text',
		)
	);	

	/*Related Post Per Page*/
	$wp_customize->add_setting(
		'local_business_directory_related_post_count',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '3',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_related_post_count',
		array(
			'label'       => __('Related Post Count', 'local-business-directory'),
			'section'     => 'local_business_directory_single_post_section',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 1,
	             'max' => 9,
	             'step' => 1,
	         ),
		)
	);

	/*
	* Customizer Global COlor
	*/

	/*Global Color Options*/
	$wp_customize->add_section('local_business_directory_global_color_section', array(
		'priority'       => 1,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Global Color Options', 'local-business-directory'),
		'panel'       => 'local_business_directory_panel',
	));

	$wp_customize->add_setting( 'local_business_directory_primary_color',
		array(
		'default'           => '#F84C4C',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
		)
	);
	$wp_customize->add_control( 
		new WP_Customize_Color_Control( 
		$wp_customize, 
		'local_business_directory_primary_color',
		array(
			'label'      => esc_html__( 'Primary Color', 'local-business-directory' ),
			'section'    => 'local_business_directory_global_color_section',
			'settings'   => 'local_business_directory_primary_color',
		) ) 
	);

	/*Typography Options*/
	$wp_customize->add_section( 'local_business_directory_typography_section', array(
		'panel'       => 'local_business_directory_panel',
        'title'    => __( 'Typography Options', 'local-business-directory' ),
        'priority' => 2,
    ) );

    $wp_customize->add_setting( 'local_business_directory_font_family', array(
		'default'           => 'default',
		'sanitize_callback' => 'local_business_directory_sanitize_font_family',
	) );
	
	$wp_customize->add_control( 'local_business_directory_font_family', array(
		'label'    => __( 'Global Font Family', 'local-business-directory' ),
		'section'  => 'local_business_directory_typography_section',
		'type'     => 'select',
		'choices'  => array(
			'default'          => __( 'Default (Theme Font)', 'local-business-directory' ),
			'bad_script'       => 'Bad Script',
			'roboto'           => 'Roboto',
			'playfair_display' => 'Playfair Display',
			'open_sans'        => 'Open Sans',
			'lobster'          => 'Lobster',
			'merriweather'     => 'Merriweather',
			'oswald'           => 'Oswald',
			'raleway'          => 'Raleway',
		),
	) );

/*
	* Customizer main header section
	*/
	/*Main Header Options*/
	$wp_customize->add_section('local_business_directory_header_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Main Header Options', 'local-business-directory'),
		'panel'       => 'local_business_directory_panel',
	));

	/*Main Header Button Text*/
	$wp_customize->add_setting(
		'local_business_directory_header_button_text',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 'ADD LISTING',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_header_button_text',
		array(
			'label'       => __('Edit Button Text ', 'local-business-directory'),
			'section'     => 'local_business_directory_header_section',
			'type'        => 'text',
		)
	);

	/*Main Header Button Link*/
	$wp_customize->add_setting(
		'local_business_directory_header_button_link',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '#',
			'sanitize_callback' => 'esc_url_raw',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_header_button_link',
		array(
			'label'       => __('Edit Button Link ', 'local-business-directory'),
			'section'     => 'local_business_directory_header_section',
			'type'        => 'url',
		)
	);

	/*
	* Customizer project section
	*/
	/*=========================================
	slider Section
	=========================================*/

	$wp_customize->add_section(
		'local_business_directory_slider_section', array(
			'title' => esc_html__( 'Our Slider Category Section', 'local-business-directory' ),
			'priority' => 6,
			'panel' => 'local_business_directory_panel',
		)
	);

	// Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'local_business_directory_slider_show_hide' , 
			array(
			'default' => true,
			'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	$wp_customize->add_control(
	'local_business_directory_slider_show_hide', 
		array(
			'label'	      => esc_html__( 'Hide / Show Section', 'local-business-directory' ),
			'section'     => 'local_business_directory_slider_section',
			'settings'    => 'local_business_directory_slider_show_hide',
			'type'        => 'checkbox'
		) 
	);

	$categories = get_categories();
	$offer_cat = array();
	$offer_cat[''] = __('Select', 'local-business-directory'); // Default "Select" option

	foreach($categories as $category){
	    $offer_cat[$category->slug] = $category->name;
	}

	$wp_customize->add_setting(
	    'local_business_directory_slider_section_category',
	    array(
	        'default' => 'uncategorized',
	        'sanitize_callback' => 'local_business_directory_sanitize_choices',
	    )
	);
	$wp_customize->add_control(
	    'local_business_directory_slider_section_category',
	    array(
	        'type' => 'select',
	        'choices' => $offer_cat,
	        'label' => __('Select Category','local-business-directory'),
	        'section' => 'local_business_directory_slider_section',
	    )
	);

    // Setting for number of posts to show
    $wp_customize->add_setting('local_business_directory_slider_posts_to_show', array(
        'default'           => 4, // Default number of posts to show
        'sanitize_callback' => 'absint', // Sanitization callback
    ));

    // Add control for number of posts to show
    $wp_customize->add_control('local_business_directory_slider_posts_to_show', array(
        'label'       => __('Number of Post to Show', 'local-business-directory'),
        'section'     => 'local_business_directory_slider_section',
        'priority'    => 10,
        'type'        => 'number',
        'input_attrs' => array(
            'step' => 1,
            'min'  => 0,
            'max'  => 50,
        ),
    ));

	/*=========================================
	Popular Listing Section
	=========================================*/
	$wp_customize->add_section( 
		'local_business_directory_properties_section' , 
		array(
	        'title'      => __( 'Our Popular Listing Section', 'local-business-directory' ),
	        'priority' => 7,
	        'panel' => 'local_business_directory_panel',
    	) 
    );

    // Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'local_business_directory_courses_setting' , 
			array(
			'default' => true,
			'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	$wp_customize->add_control(
	'local_business_directory_courses_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Section', 'local-business-directory' ),
			'section'     => 'local_business_directory_properties_section',
			'settings'    => 'local_business_directory_courses_setting',
			'type'        => 'checkbox'
		) 
	);

    $wp_customize->add_setting(
    	'local_business_directory_offer_section_text',
    	array(
	        'default'   => '',
	        'sanitize_callback' => 'sanitize_text_field'
    	)
    );
    $wp_customize->add_control(
    	'local_business_directory_offer_section_text',
    	array(
	        'label' => __('Section Small Title','local-business-directory'),
	        'section'   => 'local_business_directory_properties_section',
	        'type'      => 'text'
    	)
    );

    $wp_customize->add_setting(
    	'local_business_directory_offer_section_tittle',
    	array(
	        'default'   => '',
	        'sanitize_callback' => 'sanitize_text_field'
    	)
    );
    $wp_customize->add_control(
    	'local_business_directory_offer_section_tittle',
    	array(
	        'label' => __('Section Title','local-business-directory'),
	        'section'   => 'local_business_directory_properties_section',
	        'type'      => 'text'
    	)
    );

    $categories = get_categories();
    $cats = array();
    $i = 0;
    $offer_cat[]= 'select';
    foreach($categories as $category){
        if($i==0){
            $default = $category->slug;
            $i++;
        }
        $offer_cat[$category->slug] = $category->name;
    }

    $wp_customize->add_setting(
    	'local_business_directory_offer_section_category',
    	array(
	        'default'   => 'Slider',
	        'sanitize_callback' => 'local_business_directory_sanitize_choices',
    	)
    );
    $wp_customize->add_control(
    	'local_business_directory_offer_section_category',
    	array(
	        'type'    => 'select',
	        'choices' => $offer_cat,
	        'label' => __('Select Category','local-business-directory'),
	        'section' => 'local_business_directory_properties_section',
    	)
    );

   // Setting for number of posts to show
    $wp_customize->add_setting('local_business_directory_posts_to_show', array(
        'default'           => 3, // Default number of posts to show
        'sanitize_callback' => 'absint', // Sanitization callback
    ));

    // Add control for number of posts to show
    $wp_customize->add_control('local_business_directory_posts_to_show', array(
        'label'       => __('Number of Popular Posts to Show', 'local-business-directory'),
        'section'     => 'local_business_directory_properties_section',
        'type'        => 'number',
        'input_attrs' => array(
            'step' => 1,
            'min'  => 0,
            'max'  => 50,
        ),
    ));

    // Get the number of posts to show
    $local_business_directory_posts_to_show = get_theme_mod('local_business_directory_posts_to_show', 3);
    
    // Loop to create settings and controls for each post's price and star rating
    for ($local_business_directory_i = 1; $local_business_directory_i <= $local_business_directory_posts_to_show; $local_business_directory_i++) {

		$wp_customize->add_setting( 'local_business_directory_banner_image_select' . $local_business_directory_i, array(
		    'default'           => '',
		    'sanitize_callback' => 'esc_url_raw',
		) );

		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'local_business_directory_banner_image_select' . $local_business_directory_i, array(
		    'label'   => __('Select Listing Owner Image for Post ', 'local-business-directory') . ' ' . $local_business_directory_i,
		    'section' => 'local_business_directory_properties_section',
		) ) );

    	$wp_customize->add_setting('local_business_directory_home_location' . $local_business_directory_i, array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control('local_business_directory_home_location' . $local_business_directory_i, array(
            'label'    => __('Add Location for Post ', 'local-business-directory') . $local_business_directory_i,
            'section'  => 'local_business_directory_properties_section',
            'type'     => 'text',
        ));


        $wp_customize->add_setting('local_business_directory_post_phone_no' . $local_business_directory_i, array(
            'default' => '',
            'sanitize_callback' => 'local_business_directory_sanitize_phone_number'
        ));
        $wp_customize->add_control('local_business_directory_post_phone_no' . $local_business_directory_i, array(
            'label'    => __('Add Phone No for Post ', 'local-business-directory') . $local_business_directory_i,
            'section'  => 'local_business_directory_properties_section',
            'type'     => 'text',
        ));

        $wp_customize->add_setting('local_business_directory_courses_prices' . $local_business_directory_i, array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control('local_business_directory_courses_prices' . $local_business_directory_i, array(
            'label'    => __('Add Price for Post ', 'local-business-directory') . $local_business_directory_i,
            'section'  => 'local_business_directory_properties_section',
            'type'     => 'text',
        ));

		$wp_customize->add_setting('local_business_directory_product_section_btn_link1' . $local_business_directory_i,array(
			'default'=> '#',
			'sanitize_callback'	=> 'esc_url_raw'
		));
		$wp_customize->add_control('local_business_directory_product_section_btn_link1' . $local_business_directory_i,array(
			'label'	=> esc_html__('Add Media Gallery URL ','local-business-directory') . $local_business_directory_i,
			'section'=> 'local_business_directory_properties_section',
			'type'=> 'url'
		));

		$wp_customize->add_setting('local_business_directory_product_section_btn_link2' . $local_business_directory_i,array(
			'default'=> '#',
			'sanitize_callback'	=> 'esc_url_raw'
		));
		$wp_customize->add_control('local_business_directory_product_section_btn_link2' . $local_business_directory_i,array(
			'label'	=> esc_html__('Add Wishlist link ','local-business-directory') . $local_business_directory_i,
			'section'=> 'local_business_directory_properties_section',
			'type'=> 'url'
		));
		
        $wp_customize->add_setting('local_business_directory_star_rating' . $local_business_directory_i, array(
            'default'           => '4.5',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        $wp_customize->add_control('local_business_directory_star_rating' . $local_business_directory_i, array(
            'label'       => __('Add Rating for Post  ', 'local-business-directory') . $local_business_directory_i,
            'section'     => 'local_business_directory_properties_section',
            'type'        => 'text',
            'input_attrs' => array(
                'step' => 1,
                'min'  => 0,
                'max'  => 5,
            ),
        ));

    }


	/*
	* Customizer Footer Section
	*/
	/*Footer Options*/
	$wp_customize->add_section('local_business_directory_footer_section', array(
		'priority'       => 8,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Footer Options', 'local-business-directory'),
		'panel'       => 'local_business_directory_panel',
	));
	
	/*Footer Enable Option*/
	$wp_customize->add_setting(
		'local_business_directory_enable_footer',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
		)
	);
	$wp_customize->add_control(
		'local_business_directory_enable_footer',
		array(
			'label'       => __('Enable Footer', 'local-business-directory'),
			'description' => __('Checked to show Footer', 'local-business-directory'),
			'section'     => 'local_business_directory_footer_section',
			'type'        => 'checkbox',
		)
	);

	/*Footer bg image Option*/
	$wp_customize->add_setting('local_business_directory_footer_bg_image',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'local_business_directory_footer_bg_image',array(
        'label' => __('Footer Background Image','local-business-directory'),
        'section' => 'local_business_directory_footer_section',
        'priority' => 1,
    )));


	/*Footer Social Menu Option*/
	$wp_customize->add_setting(
		'local_business_directory_footer_social_menu',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_footer_social_menu',
		array(
			'label'       => __('Enable Footer Social Menu', 'local-business-directory'),
			'description' => __('Checked to show the footer social menu. Go to Dashboard >> Appearance >> Menus >> Create New Menu >> Add Custom Link >> Add Social Menu >> Checked Social Menu >> Save Menu.', 'local-business-directory'),
			'section'     => 'local_business_directory_footer_section',
			'type'        => 'checkbox',
		)
	);	

	/*Go To Top Option*/
	$wp_customize->add_setting(
		'local_business_directory_enable_go_to_top_option',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'local_business_directory_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_enable_go_to_top_option',
		array(
			'label'       => __('Enable Go To Top', 'local-business-directory'),
			'description' => __('Checked to enable Go To Top option.', 'local-business-directory'),
			'section'     => 'local_business_directory_footer_section',
			'type'        => 'checkbox',
		)
	);

	$wp_customize->add_setting('local_business_directory_go_to_top_position',array(
        'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 'Right',
        'sanitize_callback' => 'local_business_directory_sanitize_choices'
    ));
    $wp_customize->add_control('local_business_directory_go_to_top_position',array(
        'type' => 'select',
        'section' => 'local_business_directory_footer_section',
        'label' => esc_html__('Go To Top Positions','local-business-directory'),
        'choices' => array(
            'Right' => __('Right','local-business-directory'),
            'Left' => __('Left','local-business-directory'),
            'Center' => __('Center','local-business-directory')
        ),
    ) );

	/*Footer Copyright Text Enable*/
	$wp_customize->add_setting(
		'local_business_directory_copyright_option',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'local_business_directory_copyright_option',
		array(
			'label'       => __('Edit Copyright Text', 'local-business-directory'),
			'description' => __('Edit the Footer Copyright Section.', 'local-business-directory'),
			'section'     => 'local_business_directory_footer_section',
			'type'        => 'text',
		)
	);
}
add_action( 'customize_register', 'Local_Business_Directory_Customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function Local_Business_Directory_Customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function Local_Business_Directory_Customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function Local_Business_Directory_Customize_preview_js() {
	wp_enqueue_script( 'local-business-directory-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), LOCAL_BUSINESS_DIRECTORY_VERSION, true );
}
add_action( 'customize_preview_init', 'Local_Business_Directory_Customize_preview_js' );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Local_Business_Directory_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $local_business_directory_instance = null;

		if ( is_null( $local_business_directory_instance ) ) {
			$local_business_directory_instance = new self;
			$local_business_directory_instance->setup_actions();
		}

		return $local_business_directory_instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $local_business_directory_manager
	 * @return void
	*/
	public function sections( $local_business_directory_manager ) {
		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/revolution/inc/section-pro.php' );

		// Register custom section types.
		$local_business_directory_manager->register_section_type( 'Local_Business_Directory_Customize_Section_Pro' );

		// Register sections.
		$local_business_directory_manager->add_section( new Local_Business_Directory_Customize_Section_Pro( $local_business_directory_manager,'local_business_directory_go_pro', array(
			'priority'   => 1,
			'title'    => esc_html__( 'Local Business Directory Pro', 'local-business-directory' ),
			'pro_text' => esc_html__( 'Buy Pro', 'local-business-directory' ),
			'pro_url'    => esc_url( LOCAL_BUSINESS_DIRECTORY_BUY_NOW ),
		) )	);

	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'local-business-directory-customize-controls', trailingslashit( get_template_directory_uri() ) . '/revolution/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'local-business-directory-customize-controls', trailingslashit( get_template_directory_uri() ) . '/revolution/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Local_Business_Directory_Customize::get_instance();