<?php
/**
 * Template Name: Home Page
 */

get_header();
?>

<main id="primary">
  <?php 
      $local_business_directory_servicesec = get_theme_mod('local_business_directory_slider_show_hide', 1);
      if ($local_business_directory_servicesec == 1) : 
      ?>
      <section id="slider-section">
        <div class="container-fluid"> 
          <div class="owl-carousel owl-theme">
            <?php
            $local_business_directory_post_category = get_theme_mod('local_business_directory_slider_section_category','uncategorized');
            if ($local_business_directory_post_category) :
              $local_business_directory_category_id = term_exists($local_business_directory_post_category, '');
              if ($local_business_directory_category_id !== 0 && $local_business_directory_category_id !== null) :
                $local_business_directory_posts_to_show = get_theme_mod('local_business_directory_slider_posts_to_show', 4);
                $local_business_directory_page_query = new WP_Query(array(
                  'category_name' => esc_attr($local_business_directory_post_category),
                  'posts_per_page' => $local_business_directory_posts_to_show,
                ));

                $local_business_directory_post_count = 0;
                if ($local_business_directory_page_query->have_posts()) :
                  while ($local_business_directory_page_query->have_posts()) : $local_business_directory_page_query->the_post(); 
                    $local_business_directory_post_count++;
            ?>
                    <div class="item">
                      <div class="serv-box">
                          <div class="post-main-img">
                             <?php if (has_post_thumbnail()) : ?>
                                <img src="<?php echo esc_url(get_the_post_thumbnail_url(null, 'full')); ?>" alt="<?php the_title_attribute(); ?>" />
                              <?php else : ?>
                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/revolution/assets/images/blogs1.png" alt="Default Image" />
                              <?php endif; ?>
                              <div class="post-content">
                                  <h1>
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                  </h1>
                                   <p class="slider-content"><?php echo wp_trim_words(get_the_content(), 14); ?></p>
                                    <div class="main-cat-box">
                                      <div class="searching-area">
                                          <div class="search-cat-box">
                                            <form id="searchForm" action="<?php echo esc_url(home_url('/')); ?>" method="get">
                                              <div class="flex-row">
                                                  <div class="main-searh-col">
                                                    <input class="search-text" type="text" name="s" class="form-control" placeholder="<?php esc_attr_e('Where are you looking for', 'local-business-directory'); ?>">
                                                    <input type="hidden" name="post_type" value="service">
                                                    <input type="hidden" name="category" id="categoryInput" value="">
                                                  </div>
                                                  <!-- Product Category Dropdown -->
                                                  <div class="cat-col">
                                                      <button class="category-btn btn btn-secondary">
                                                          <?php esc_html_e('Category', 'local-business-directory'); ?> <i class="fas fa-chevron-down ps-3"></i>
                                                      </button>
                                                      <ul class="category-dropdown" style="display: none;">
                                                          <?php
                                                          $args = array(
                                                              'taxonomy'   => 'category',
                                                              'orderby'    => 'name',
                                                              'order'      => 'ASC',
                                                              'hide_empty' => 0,           
                                                              'parent'     => 0          
                                                          );
                                                          $post_categories = get_terms($args);

                                                          if (!empty($post_categories)) {
                                                              foreach ($post_categories as $product_category) {
                                                                  echo '<li><a href="' . esc_url(get_term_link($product_category)) . '" data-id="' . esc_attr($product_category->term_id) . '">' . esc_html($product_category->name) . '</a></li>';
                                                              }
                                                          } else {
                                                              echo '<li>' . esc_html__('No categories found.', 'local-business-directory') . '</li>';
                                                          }
                                                          ?>
                                                      </ul>
                                                  </div>
                                                  <div class="searchbtn align-self-center">
                                                    <button id="searchButton" class="btn btn-search w-100"><?php esc_html_e( 'Search', 'local-business-directory' ); ?></button>
                                                  </div>
                                              </div>
                                            </form>
                                          </div>
                                      </div>
                                    </div>
                                  <div class="serv-tags">
                                    <?php
                                      // Get and display the post tags (limit to 2).
                                      $local_business_directory_post_tags = get_the_tags();
                                      if ( $local_business_directory_post_tags ) {
                                        $local_business_directory_tag_count = 0;
                                        echo '<div class="post-tags">';
                                        echo '<strong class="tag-label">' . esc_html__( 'Popular Searches:', 'local-business-directory' ) . '</strong> '; // Translatable label

                                        foreach ( $local_business_directory_post_tags as $tag ) {
                                          if ( $local_business_directory_tag_count < 3 ) {
                                            echo '<a href="' . esc_url( get_tag_link( $tag->term_id ) ) . '" class="tag-link">' . esc_html( $tag->name ) . '</a>';
                                            $local_business_directory_tag_count++;
                                          } else {
                                            break;
                                          }
                                        }

                                        echo '</div>'; // Close post-tags div
                                      }
                                    ?>
                                  </div>
                              </div>
                          </div>
                      </div>
                    </div>
                  <?php endwhile; ?>
                  <?php wp_reset_postdata(); ?>
                <?php else : ?>
                  <div class="no-postfound"></div>
                <?php endif; ?>
              <?php endif; ?>
            <?php endif; ?>
          </div>
        </div>
      </section>
  <?php endif; ?>

   <?php
    // Get the courses setting.
    $local_business_directory_courses = get_theme_mod('local_business_directory_courses_setting', true);

    if ($local_business_directory_courses == '1') {
    ?>
    <section id="cat-list">
      <div class="container">
        <div class="text-start main-sec-title">
          <?php if (get_theme_mod('local_business_directory_offer_section_text')) { ?>
            <p class="serv-description"><?php echo esc_html(get_theme_mod('local_business_directory_offer_section_text')); ?></p>
          <?php } ?>
          <?php
            $local_business_directory_offer_title = get_theme_mod('local_business_directory_offer_section_tittle');
            if ($local_business_directory_offer_title) {
                $local_business_directory_words = explode(' ', $local_business_directory_offer_title);
                $local_business_directory_last_word = array_pop($local_business_directory_words);
                $local_business_directory_first_part = implode(' ', $local_business_directory_words);
                ?>
                <h2 class="my-2">
                    <?php echo esc_html($local_business_directory_first_part); ?> <span class="highlight-last-word"><?php echo esc_html($local_business_directory_last_word); ?></span>
                </h2>
          <?php } ?>
        </div>
        <div class="row">
            <div class="owl-carousel owl-theme offer-carousel">
              <?php
                // Get the selected post category and number of posts to show.
                $local_business_directory_post_category = get_theme_mod('local_business_directory_offer_section_category','Slider');
                $local_business_directory_posts_to_show = get_theme_mod('local_business_directory_posts_to_show', 3);

                if ($local_business_directory_post_category) {
                  // Query for posts in the selected category.
                  $local_business_directory_page_query = new WP_Query(array(
                    'category_name' => esc_html($local_business_directory_post_category),
                    'posts_per_page' => $local_business_directory_posts_to_show
                  ));

                  if ($local_business_directory_page_query->have_posts()) {
                    $local_business_directory_post_count = 0;

                    // Loop through the posts.
                    while ($local_business_directory_page_query->have_posts()) : $local_business_directory_page_query->the_post();
                      $local_business_directory_post_count++;
              ?>
                <div class="cat-inner-box">
                  <div class="post-main-img">
                    <?php
                      $local_business_directory_banner_key = 'local_business_directory_banner_image_select' . $local_business_directory_post_count;
                      $local_business_directory_banner_image = get_theme_mod( $local_business_directory_banner_key );
                    ?>

                    <?php if ( has_post_thumbnail() ) : ?>
                      <img src="<?php echo esc_url( get_the_post_thumbnail_url() ); ?>" alt="<?php the_title_attribute(); ?>" />
                    <?php else : ?>
                      <img src="<?php echo esc_url( get_template_directory_uri() . '/revolution/assets/images/slider.png' ); ?>" alt="<?php esc_attr_e( 'Default Thumbnail', 'local-business-directory' ); ?>" />
                    <?php endif; ?>

                    <?php if ( $local_business_directory_banner_image ) : ?>
                      <div class="for-sale-label">
                        <img src="<?php echo esc_url( $local_business_directory_banner_image ); ?>" alt="<?php esc_attr_e( 'Banner Image', 'local-business-directory' ); ?>" />
                      </div>
                    <?php endif; ?>
                  </div>
                  <div class="mainserv-content">
                      <div class="offer-box">
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        <p class="post-content"><?php echo wp_trim_words(get_the_content(), 8); ?></p>
                        <?php if ($local_business_directory_home_location = get_theme_mod('local_business_directory_home_location' . $local_business_directory_post_count)) { ?>
                            <p class="main-location mb-0"><i class="fas fa-map-marker-alt"></i><span class="location-text"><?php echo esc_html($local_business_directory_home_location); ?></span></p>
                        <?php } ?>
                        <?php
                            $local_business_directory_post_phone_no = get_theme_mod( 'local_business_directory_post_phone_no' . $local_business_directory_post_count );

                            if ( $local_business_directory_post_phone_no ) : ?>
                          <p class="main-location phone">
                            <i class="fas fa-phone-alt"></i>
                            <span class="location-text">
                              <a href="tel:<?php echo esc_attr( $local_business_directory_post_phone_no ); ?>">
                                <?php echo esc_html( $local_business_directory_post_phone_no ); ?>
                              </a>
                            </span>
                          </p>
                        <?php endif; ?>
                      </div>
                      <hr>
                      <div class="bottom-post">
                          <div class="main-price">
                              <?php if ($local_business_directory_price = get_theme_mod('local_business_directory_courses_prices' . $local_business_directory_post_count)) { ?>
                                  <p class="cours-price"><?php echo esc_html($local_business_directory_price); ?></p>
                              <?php } ?>
                          </div>
                          <div class="main-rating">
                            <div class="bottom-icons">
                                <?php
                                    // Dynamically build the link setting key
                                    $local_business_directory_btn_link_key1 = 'local_business_directory_product_section_btn_link1' . $local_business_directory_post_count;

                                    // Fetch the link from theme mod, use '#' as default
                                    $local_business_directory_product_btn_link1 = get_theme_mod( $local_business_directory_btn_link_key1, '#' );
                                ?>
                                <a class="viewall-btn mb-3" href="<?php echo esc_url( $local_business_directory_product_btn_link1 ); ?>" aria-label="<?php echo esc_attr__('View Images', 'local-business-directory'); ?>">
                                    <i class="fas fa-image"></i>
                                </a>

                                <?php
                                    // Dynamically build the link setting key
                                    $local_business_directory_btn_link_key2 = 'local_business_directory_product_section_btn_link2' . $local_business_directory_post_count;

                                    // Fetch the link from theme mod, use '#' as default
                                    $local_business_directory_product_btn_link2 = get_theme_mod( $local_business_directory_btn_link_key2, '#' );
                                ?>
                                <a class="viewall-btn" href="<?php echo esc_url( $local_business_directory_product_btn_link2 ); ?>" aria-label="<?php echo esc_attr__('View Wishlist', 'local-business-directory'); ?>">
                                    <i class="fas fa-heart"></i>
                                </a>

                                <?php 
                                    // Get the star rating
                                    $local_business_directory_star_rating = get_theme_mod('local_business_directory_star_rating' . $local_business_directory_post_count,'4.5'); 

                                    if ( $local_business_directory_star_rating !== '' ) { ?>
                                        <span class="star-rating">
                                            <span class="rate-text"><?php echo esc_html($local_business_directory_star_rating); ?></span> <i class="fas fa-star"></i>
                                        </span>
                                <?php } ?>
                            </div>
                          </div>
                      </div>
                  </div>
                </div>
              <?php endwhile;
              wp_reset_postdata(); // Reset post data after the custom query.
              } else {
                // Optionally display a message if no posts are found.
                echo '<div class="no-postfound">' . esc_html__('No found.', 'local-business-directory') . '</div>';
              }
            }
          ?>
          </div>
        </div>
      </div>
    </section>
    <?php 
    } // End of the if statement for courses.
  ?>

</main>
<?php
get_footer();
?>