<?php
/**
 * Jaida functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Jaida
 * @since Jaida 1.0
 */


if ( ! function_exists( 'jaida_support' ) ) :

	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * @since Jaida 1.0
	 *
	 * @return void
	 */
	function jaida_support() {

		// Enqueue editor styles.
		add_editor_style( 'style.css' );

		// Make theme available for translation.
		load_theme_textdomain( 'jaida' );
	}

endif;

add_action( 'after_setup_theme', 'jaida_support' );

if ( ! function_exists( 'jaida_styles' ) ) :

	/**
	 * Enqueue styles.
	 *
	 * @since Jaida 1.0
	 *
	 * @return void
	 */
	function jaida_styles() {

		// Register theme stylesheet.
		wp_register_style(
			'jaida-style',
			get_stylesheet_directory_uri() . '/style.css',
			array(),
			wp_get_theme()->get( 'Version' )
		);

		// Enqueue theme stylesheet.
		wp_enqueue_style( 'jaida-style' );

	}

endif;

add_action( 'wp_enqueue_scripts', 'jaida_styles' );
