<?php
    $trending_title       = iconic_blog_get_option( 'trending_title' );
    $trending_subtitle       = iconic_blog_get_option( 'trending_subtitle' );
    $trending_content_type     = iconic_blog_get_option( 'trending_content_type' );
    $enable_category     = iconic_blog_get_option( 'trending_category_enable' );
    $enable_content     = iconic_blog_get_option( 'trending_content_enable' );
    $enable_author     = iconic_blog_get_option( 'trending_author_enable' );
    $enable_posted_on     = iconic_blog_get_option( 'trending_posted_on_enable' );
    $number_of_trending_items  = iconic_blog_get_option( 'number_of_trending_items' );
    $trending_category = iconic_blog_get_option( 'trending_category' );
    $header_font_size = iconic_blog_get_option( 'trending_font_size');
    $number_of_trending_column = iconic_blog_get_option('number_of_trending_column');
    $content_align = iconic_blog_get_option('trending_content_align');
    $excerpt_length =iconic_blog_get_option( 'trending_excerpt_length');
    $enable_views =iconic_blog_get_option( 'trending_views_enable');
    $enable_readtime =iconic_blog_get_option( 'trending_readtime_enable');

    $see_more_txt     = iconic_blog_get_option( 'trending_see_all_txt' );
    $see_more_url     = iconic_blog_get_option( 'trending_see_all_url' );

    for( $i=1; $i<=$number_of_trending_items; $i++ ) :
        $trending_page_posts[] = absint(iconic_blog_get_option( 'trending_page_'.$i ) );
        $trending_post_posts[] = absint(iconic_blog_get_option( 'trending_post_'.$i ) );
    endfor;

?>  
<style>
    <?php if ($header_font_size != 0): ?>
        #trending .section-title{
            font-size:<?php echo esc_attr($header_font_size); ?>px;
        }
    <?php endif ?>
</style>
<?php if(!empty($trending_title) ):?>
    <div class="section-header">
        <?php if (!empty($trending_title)): ?>
            <div class="section-inner-header">
                <h2 class="section-title"><?php echo esc_html($trending_title);?></h2>
            </div>
        <?php endif; ?>
    </div>       
<?php endif;?> 
<div class="trending-wrapper col-<?php echo esc_attr($number_of_trending_column); ?>">
    <?php 
        $args = array (

            'posts_per_page' =>absint( $number_of_trending_items ),              
            'post_type' => 'post',
            'post_status' => 'publish',
            'paged' => 1,
            'ignore_sticky_posts' => true, 
            );
            if ( absint( $trending_category ) > 0 ) {
                $args['cat'] = absint( $trending_category );
            }
        $loop = new WP_Query($args);                        
        if ( $loop->have_posts() ) :
            $i=0;  
            while ($loop->have_posts()) : $loop->the_post(); $i++;?>      
            <?php $col_class='';
            if ($i%3==1) {
                 $col_class='full-width';
             } else{
                $col_class='half-width';
             } ?>  
                <article class=" <?php echo has_post_thumbnail() ? 'has-post-thumbnail' : 'no-post-thumbnail' ; ?>">
                    <div class="trending-item-wrapper solid-border">
                        <div class="post-featured-image">
                            <?php if (($enable_readtime==true)) { ?>
                                <span class="post-readtime"><i class="fa fa-clock"></i><?php echo iconic_blog_time_interval(); ?><?php esc_html_e( 'min', 'iconic-blog' ); ?></span>
                            <?php } ?>
                            <?php if (($enable_views==true)) { ?>
                                <span class="count-post-views"><i class="fa fa-eye"></i><?php echo iconic_blog_getPostViews( get_the_ID()); ?></span>    
                            <?php } ?>

                            <?php if (has_post_thumbnail()) : ?>
                            <div class="featured-image post-bg-image" style="background-image: url('<?php the_post_thumbnail_url();?>');">
                                <a href="<?php the_permalink();?>" class="post-thumbnail-link"></a>
                                <?php $homepage_video_url = get_post_meta( get_the_ID(), 'iconic-blog-video-url', true ); ?>
                                <?php if (!empty($homepage_video_url)): ?>
                                   <a href="<?php the_permalink();?>"> <div class="homepage-video-icon"><i class="fa fa-play"></i></div></a>
                                <?php endif ?>
                            </div><!-- .featured-image -->
                            <?php endif; ?>

                        </div>
                        
                        <div class="entry-container <?php echo esc_attr($content_align); ?>">
                            <?php if ( ($trending_content_type !== 'trending_page') && (($enable_category==true) || ($enable_readtime==true))) : ?>
                                <div class="entry-meta entry-cat">
                                    <?php if ($enable_category==true) {
                                        iconic_blog_entry_meta(); 
                                    } ?>
                                    
                                </div><!-- .entry-meta -->
                            <?php endif; ?>
                            <header class="entry-header">
                                <h2 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>
                            </header>
                            <?php if (($enable_content==true)) : ?>
                                <div class="entry-content">
                                    <?php 
                                        $excerpt = iconic_blog_the_excerpt( $excerpt_length );
                                        echo wp_kses_post( wpautop( $excerpt ) );
                                    ?>
                                </div><!-- .entry-content -->
                            <?php endif; ?> 
                            <?php if ((($enable_author==true) || ($enable_posted_on==true))) : ?>
                                <div class="entry-meta entry-footer solid-border">
                                    <?php 
                                        if (($enable_posted_on==true)) {
                                            iconic_blog_posted_on();
                                        } 
                                        if (($enable_author==true)) {
                                            iconic_blog_author();
                                        } ?>
                                        
                                </div><!-- .entry-meta -->
                            <?php endif; ?> 
                        </div><!-- .entry-container -->
                    </div>
                </article>

            <?php endwhile;?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>
</div>